/*
 * Decompiled with CFR 0.152.
 */
package xml.indent;

import beauty.BeautyPlugin;
import java.awt.Component;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import xml.indent.IndentingTransformerImpl;

public class XmlIndenterPlugin {
    private static final String XSL_TEXT_ELEMENT = "xsl:text";
    private static final String SVG_TEXT_ELEMENT = "text";
    private static final String SVG_TSPAN_ELEMENT = "tspan";
    private static final IndentingTransformerImpl TRANSFORMER = new IndentingTransformerImpl();

    public void start() {
        boolean settingModified;
        String modified = jEdit.getProperty((String)"xmlindenter.preserve-whitespace-element.modified");
        boolean bl = settingModified = modified != null;
        if (!settingModified) {
            jEdit.setProperty((String)"xmlindenter.preserve-whitespace-element.0", (String)XSL_TEXT_ELEMENT);
            jEdit.setProperty((String)"xmlindenter.preserve-whitespace-element.1", (String)SVG_TEXT_ELEMENT);
            jEdit.setProperty((String)"xmlindenter.preserve-whitespace-element.2", (String)SVG_TSPAN_ELEMENT);
        }
    }

    static void processException(Exception e, String message, Component component) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        Log.log((int)1, (Object)Thread.currentThread(), (Object)writer.toString());
        String msg = MessageFormat.format(jEdit.getProperty((String)"xmlindenter.message.error"), message, e.getMessage());
        JOptionPane.showMessageDialog(component, msg.toString());
    }

    static void showMessageDialog(String property, Component component) {
        String message = jEdit.getProperty((String)property);
        JOptionPane.showMessageDialog(component, message);
    }

    public static void toggleSplitAttributes(View view) {
        boolean split = jEdit.getBooleanProperty((String)"xmlindenter.splitAttributes", (boolean)false);
        jEdit.setBooleanProperty((String)"xmlindenter.splitAttributes", (!split ? 1 : 0) != 0);
        BeautyPlugin.beautify((Buffer)view.getBuffer(), (View)view, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void indentXml(View view) {
        Buffer buffer = view.getBuffer();
        boolean indentWithTabs = XmlIndenterPlugin.getIndentWithTabs(buffer);
        int indentAmount = XmlIndenterPlugin.getIndentAmount(indentWithTabs, buffer);
        buffer.writeLock();
        buffer.beginCompoundEdit();
        try {
            int caretPosition = view.getTextArea().getCaretPosition();
            String inputString = buffer.getText(0, buffer.getLength());
            String resultString = XmlIndenterPlugin.indent(inputString, indentAmount, indentWithTabs);
            buffer.remove(0, buffer.getLength());
            buffer.insert(0, resultString);
            if (caretPosition > resultString.length() - 1) {
                caretPosition = resultString.length() - 1;
            } else {
                char c = resultString.charAt(caretPosition);
                while (caretPosition < buffer.getLength() && c != '>' && c != '<') {
                    c = resultString.charAt(++caretPosition);
                }
                if (c == '>') {
                    ++caretPosition;
                }
            }
            if (caretPosition < 0) {
                caretPosition = 0;
            } else if (caretPosition > buffer.getLength() - 1) {
                caretPosition = buffer.getLength() - 1;
            }
            view.getTextArea().setCaretPosition(caretPosition);
        }
        catch (Exception e) {
            Log.log((int)9, IndentingTransformerImpl.class, (Object)e);
            String message = jEdit.getProperty((String)"xmlindenter.indent.message.failure");
            XmlIndenterPlugin.processException(e, message, (Component)view);
        }
        finally {
            if (buffer.insideCompoundEdit()) {
                buffer.endCompoundEdit();
            }
            buffer.writeUnlock();
        }
    }

    private static boolean getIndentWithTabs(Buffer buffer) {
        boolean tabSizeAppropriate = buffer.getTabSize() <= buffer.getIndentSize();
        return !buffer.getBooleanProperty("noTabs") && tabSizeAppropriate;
    }

    private static int getIndentAmount(boolean indentWithTabs, Buffer buffer) {
        if (indentWithTabs) {
            return buffer.getIndentSize() / buffer.getTabSize();
        }
        return buffer.getIndentSize();
    }

    protected static String indent(String inputString, int indentAmount, boolean indentWithTabs) throws Exception {
        List preserveWhitespaceList = XmlIndenterPlugin.getEnumeratedProperty("xmlindenter.preserve-whitespace-element");
        StringWriter writer = new StringWriter();
        TRANSFORMER.indentXml(inputString, writer, indentAmount, indentWithTabs, preserveWhitespaceList);
        String resultString = writer.toString();
        return resultString;
    }

    public static List getEnumeratedProperty(String key) {
        String value;
        ArrayList<String> values = new ArrayList<String>();
        int i = 0;
        while ((value = jEdit.getProperty((String)(key + "." + i))) != null) {
            values.add(value);
            ++i;
        }
        return values;
    }
}

