/*
 * Decompiled with CFR 0.152.
 */
package xml.indent;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;

public class PreserveWhitespaceOptionsPane
extends AbstractOptionPane {
    private JList elementList;
    private DefaultListModel elementListModel;
    private JButton add;
    private JButton remove;

    public PreserveWhitespaceOptionsPane() {
        super("xmlindenter");
    }

    protected void _init() {
        String element;
        this.setLayout(new BorderLayout());
        JLabel label = new JLabel(jEdit.getProperty((String)"options.xmlindenter.caption"));
        label.setBorder(new EmptyBorder(0, 0, 6, 0));
        this.add("North", label);
        this.elementListModel = new DefaultListModel();
        int i = 0;
        while ((element = jEdit.getProperty((String)("xmlindenter.preserve-whitespace-element." + i))) != null) {
            this.elementListModel.addElement(element);
            ++i;
        }
        this.elementList = new JList(this.elementListModel);
        this.add("Center", new JScrollPane(this.elementList));
        this.elementList.addListSelectionListener(new ListHandler());
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setBorder(new EmptyBorder(6, 0, 0, 0));
        this.add = new RolloverButton(GUIUtilities.loadIcon((String)"Plus.png"));
        this.add.setToolTipText(jEdit.getProperty((String)"options.xmlindenter.add"));
        this.add.addActionListener(new ActionHandler());
        buttons.add(this.add);
        this.remove = new RolloverButton(GUIUtilities.loadIcon((String)"Minus.png"));
        this.remove.setToolTipText(jEdit.getProperty((String)"options.xmlindenter.remove"));
        this.remove.addActionListener(new ActionHandler());
        buttons.add(this.remove);
        buttons.add(Box.createGlue());
        this.add("South", buttons);
        this.updateEnabled();
    }

    protected void _save() {
        int i;
        for (i = 0; i < this.elementListModel.getSize(); ++i) {
            String element = (String)this.elementListModel.getElementAt(i);
            jEdit.setProperty((String)("xmlindenter.preserve-whitespace-element." + i), (String)element);
        }
        jEdit.unsetProperty((String)("xmlindenter.preserve-whitespace-element." + i));
        jEdit.setProperty((String)"xmlindenter.preserve-whitespace-element.modified", (String)"true");
    }

    private void updateEnabled() {
        boolean selected = this.elementList.getSelectedValue() != null;
        this.remove.setEnabled(selected);
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            PreserveWhitespaceOptionsPane.this.updateEnabled();
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == PreserveWhitespaceOptionsPane.this.add) {
                String property = "options.xmlindenter.dialog";
                String name = GUIUtilities.input((Component)((Object)PreserveWhitespaceOptionsPane.this), (String)property, (Object)"");
                if (name == null || name.length() == 0) {
                    return;
                }
                PreserveWhitespaceOptionsPane.this.elementListModel.addElement(name);
            } else if (event.getSource() == PreserveWhitespaceOptionsPane.this.remove) {
                PreserveWhitespaceOptionsPane.this.elementListModel.removeElementAt(PreserveWhitespaceOptionsPane.this.elementList.getSelectedIndex());
                PreserveWhitespaceOptionsPane.this.updateEnabled();
            }
        }
    }
}

