/*
 * Decompiled with CFR 0.152.
 */
package xml.indent;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import xml.indent.IndentingTransformer;

public class IndentingTransformerImpl
extends IndentingTransformer {
    private List preserveWhitespaceList;
    private int indentAmount = 2;
    private char indentChar;
    private int indentLevel;
    private boolean isSameLine;
    private boolean isLastText;
    private boolean isMixedContent;
    private boolean preserveWhitespace;
    private String preserveWhitespaceElement;
    private StringBuffer buffer = new StringBuffer();

    public String indentXml(String xmlString, Writer outputWriter, int indentAmount, boolean indentWithTabs, List preserveWhitespaceList) throws IOException, SAXException {
        this.preserveWhitespaceList = preserveWhitespaceList;
        this.indentAmount = indentAmount;
        this.indentChar = indentWithTabs ? (char)9 : (char)32;
        this.indentLevel = 0;
        this.isSameLine = false;
        this.isLastText = false;
        this.isMixedContent = false;
        this.preserveWhitespace = false;
        this.preserveWhitespaceElement = null;
        this.buffer.setLength(0);
        return super.indentXml(xmlString, outputWriter);
    }

    @Override
    public Transformer getTransformer() {
        return null;
    }

    @Override
    public void startElement(String uri, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        this.flush();
        if (this.preserveWhitespaceList.contains(qualifiedName)) {
            this.preserveWhitespace = true;
            this.preserveWhitespaceElement = qualifiedName;
        }
        if (this.isLastText && !this.isMixedContent) {
            this.isMixedContent = true;
        }
        if (!this.isMixedContent) {
            this.indent(0);
        }
        super.startElement(uri, localName, qualifiedName, attributes);
        ++this.indentLevel;
        this.isSameLine = true;
    }

    @Override
    public void endElement(String uri, String localName, String qualifiedName) throws SAXException {
        this.flush();
        --this.indentLevel;
        if (!(this.isMixedContent || this.isSameLine || this.isLastText)) {
            this.indent(0);
        }
        super.endElement(uri, localName, qualifiedName);
        this.isLastText = false;
        this.isSameLine = false;
        this.isMixedContent = false;
        if (qualifiedName.equals(this.preserveWhitespaceElement)) {
            this.preserveWhitespace = false;
            this.preserveWhitespaceElement = null;
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.flush();
        this.indent(0);
        super.processingInstruction(target, data);
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        for (int i = start; i < start + length; ++i) {
            if (Character.isWhitespace(chars[i])) continue;
            this.isLastText = true;
        }
        if (this.preserveWhitespace) {
            this.isLastText = true;
        }
        this.buffer.append(chars, start, length);
    }

    @Override
    public void comment(char[] chars, int start, int len) throws SAXException {
        this.isLastText = true;
        this.flush();
        super.comment(chars, start, len);
        this.isLastText = false;
    }

    @Override
    protected void indent(int levelAdjustment) throws SAXException {
        int arraySize = (this.indentLevel + levelAdjustment) * this.indentAmount + 1;
        arraySize = arraySize <= 0 ? 1 : arraySize;
        char[] indent = new char[arraySize];
        indent[0] = 10;
        for (int i = 1; i < indent.length; ++i) {
            indent[i] = this.indentChar;
        }
        super.characters(indent, 0, indent.length);
    }

    public void flush() throws SAXException {
        int end = this.buffer.length();
        int start = 0;
        if (end != 0) {
            char[] array = new char[end];
            this.buffer.getChars(0, end, array, 0);
            if (!this.isLastText) {
                boolean stripNewLineFromStart = true;
                while (start < end && Character.isWhitespace(array[start])) {
                    if (Character.isSpaceChar(array[start]) || array[start] == '\t') {
                        ++start;
                        continue;
                    }
                    if (!stripNewLineFromStart) break;
                    ++start;
                    stripNewLineFromStart = false;
                }
                if (start < end && Character.isWhitespace(array[end - 1])) {
                    while (start < end && Character.isWhitespace(array[end - 1]) && (Character.isSpaceChar(array[end - 1]) || array[start] == '\t')) {
                        --end;
                    }
                }
                for (int i = start; i < end; ++i) {
                    if (array[i] != '\n') continue;
                    this.isSameLine = false;
                    break;
                }
            }
            super.characters(array, start, end - start);
            this.buffer.setLength(0);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startCDATA() throws SAXException {
        this.isLastText = true;
        this.flush();
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void setSystemId(String systemID) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    @Override
    public String getSystemId() {
        return null;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void setResult(Result result) throws IllegalArgumentException {
    }

    @Override
    public void ignorableWhitespace(char[] chars, int i, int i1) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void attributeDecl(String s, String s1, String s2, String s3, String s4) throws SAXException {
    }

    @Override
    public void endEntity(String s) throws SAXException {
    }

    @Override
    public void elementDecl(String s, String s1) throws SAXException {
    }

    @Override
    public void startDTD(String s, String s1, String s2) throws SAXException {
    }

    @Override
    public void externalEntityDecl(String s, String s1, String s2) throws SAXException {
    }

    @Override
    public void startEntity(String s) throws SAXException {
    }

    @Override
    public void internalEntityDecl(String s, String s1) throws SAXException {
    }
}

