/*
 * Decompiled with CFR 0.152.
 */
package xml.indent;

import java.io.IOException;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.sax.TransformerHandler;
import org.gjt.sp.jedit.jEdit;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.helpers.AttributesImpl;

public abstract class IndentingTransformer
implements TransformerHandler,
DeclHandler {
    private static final String ON_NEW_LINE = "onNewLine";
    private Writer writer;
    private String xml;
    private char[] chars;
    private boolean okToContinue = true;
    private boolean isClosingTag = false;
    private boolean isEmptyElement = false;
    private boolean isDocType = false;
    Pattern p = Pattern.compile("([<].*?)\\s", 32);

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.isDocType) {
                this.isDocType = false;
            } else {
                this.writer.write(ch, start, length);
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        try {
            this.writer.write("<!--");
            this.writer.write(ch, start, length);
            this.writer.write("-->");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.writer.write("<?");
            this.writer.write(target);
            this.writer.write(" ");
            this.writer.write(data);
            this.writer.write("?>");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            if (this.isClosingTag) {
                this.writer.write("</");
                this.writer.write(qName);
                this.writer.write(">");
                this.isClosingTag = false;
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            boolean spaceAtEnd;
            this.writer.write("<");
            boolean bl = spaceAtEnd = qName.charAt(qName.length() - 1) == ' ';
            if (spaceAtEnd) {
                this.writer.write(qName.substring(0, qName.length() - 1));
            } else {
                this.writer.write(qName);
            }
            boolean onNewLine = jEdit.getBooleanProperty((String)"xmlindenter.splitAttributes", (boolean)false);
            for (int i = 0; i < atts.getLength(); ++i) {
                int quote;
                String attributeQName = atts.getQName(i);
                String attributeValue = atts.getValue(i);
                boolean containsDoubleQuote = attributeValue.indexOf(34) != -1;
                int n = quote = containsDoubleQuote ? 39 : 34;
                if (onNewLine) {
                    this.indent(1);
                } else {
                    this.writer.write(32);
                }
                this.writer.write(attributeQName);
                this.writer.write(61);
                this.writer.write(quote);
                this.writer.write(attributeValue);
                this.writer.write(quote);
            }
            if (this.isEmptyElement) {
                if (spaceAtEnd) {
                    this.writer.write(" />");
                } else {
                    this.writer.write("/>");
                }
            } else {
                this.writer.write(">");
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    protected abstract void indent(int var1) throws SAXException;

    protected String indentXml(String xmlString, Writer outputWriter) throws IOException, SAXException {
        this.okToContinue = true;
        this.isClosingTag = false;
        this.isEmptyElement = false;
        this.isDocType = false;
        this.writer = outputWriter;
        this.xml = xmlString;
        this.chars = this.xml.toCharArray();
        int start = 0;
        int end = 0;
        while (this.okToContinue) {
            end = this.xml.indexOf(60, start);
            this.writeTextPrecedingLessThan(start, end);
            if (!this.okToContinue) continue;
            start = end;
            if (this.xml.startsWith("<!--", start)) {
                end = this.writeComment(start);
            } else if (this.xml.startsWith("<?", start)) {
                end = this.writeXmlDeclarationOrProcessingInstruction(start);
            } else if (this.xml.startsWith("<!", start)) {
                end = this.xml.startsWith("<![CDATA[", start) ? this.writeCData(start) : this.writeDocType(start);
            } else if (this.xml.startsWith("</", start)) {
                end = this.writeClosingTag(start);
            } else {
                if (Character.isWhitespace(this.chars[start + 1])) {
                    throw new SAXException("The content of elements must consist of well-formed character data or markup.");
                }
                end = this.writeElement(start);
            }
            start = end;
        }
        return outputWriter.toString();
    }

    private int writeCData(int start) throws IOException, SAXException {
        int end = this.xml.indexOf("]]>", start);
        this.writeRemaining(start, end);
        if (this.okToContinue) {
            this.startCDATA();
            this.writer.write(this.xml, start, (end += 3) - start);
            this.endCDATA();
        }
        return end;
    }

    private int writeElement(int start) throws IOException, SAXException {
        int end = this.getStartTagEnd(start);
        this.writeRemaining(start, end);
        if (this.okToContinue) {
            int offset = 1;
            while (Character.isWhitespace(this.chars[end - offset])) {
                ++offset;
            }
            boolean bl = this.isEmptyElement = this.chars[end - offset] == '/';
            if (this.isEmptyElement) {
                end -= offset;
            }
            AttributesImpl attributes = new AttributesImpl();
            String elementName = this.getElementNameAndPopulateAttributes(start, end, attributes);
            if (this.isEmptyElement && this.chars[end - 1] == ' ') {
                elementName = elementName + ' ';
            }
            this.startElement("", "", elementName, attributes);
            if (this.isEmptyElement) {
                this.endElement("", "", elementName);
                end = end + offset + 1;
                this.isEmptyElement = false;
            } else {
                ++end;
            }
        }
        return end;
    }

    private int getStartTagEnd(int start) {
        int end = -1;
        int index = start;
        while (index < this.chars.length && end == -1) {
            char aChar = this.chars[index];
            ++index;
            if (aChar == '\"') {
                while (this.chars[index] != '\"') {
                    ++index;
                }
                ++index;
                continue;
            }
            if (aChar == '\'') {
                while (this.chars[index] != '\'') {
                    ++index;
                }
                ++index;
                continue;
            }
            if (aChar != '>') continue;
            end = index - 1;
        }
        return end;
    }

    private String getElementNameAndPopulateAttributes(int start, int end, AttributesImpl attributes) throws SAXException {
        int nameEnd = -1;
        Matcher m = this.p.matcher(this.xml.substring(start, end));
        boolean found = m.find();
        if (found) {
            nameEnd = start + m.end();
        } else {
            nameEnd = this.xml.indexOf(32, start);
            if (nameEnd == -1 || nameEnd > end) {
                nameEnd = this.xml.indexOf(10, start);
            }
            if (nameEnd == -1 || nameEnd > end) {
                nameEnd = this.xml.indexOf(13, start);
            }
        }
        if (nameEnd == -1 || nameEnd > end) {
            nameEnd = end;
        } else if (nameEnd + 1 != end) {
            while (Character.isWhitespace(this.chars[nameEnd - 1])) {
                --nameEnd;
            }
            char[] elementChars = this.xml.substring(nameEnd, end).toCharArray();
            this.populateAttributes(elementChars, attributes);
        }
        StringBuffer elementName = new StringBuffer();
        int index = start + 1;
        while (!Character.isWhitespace(this.chars[index]) && this.chars[index] != '>' && this.chars[index] != '/') {
            elementName.append(this.chars[index++]);
        }
        return elementName.toString();
    }

    private void populateAttributes(char[] chars, AttributesImpl attributes) throws SAXException {
        StringBuffer qName = new StringBuffer();
        StringBuffer value = new StringBuffer();
        char quote = '\"';
        int i = 0;
        while (i < chars.length) {
            boolean attributeOnNewLine = false;
            qName.setLength(0);
            value.setLength(0);
            while (i < chars.length && Character.isWhitespace(chars[i])) {
                if (chars[i] == '\r' || chars[i] == '\n') {
                    attributeOnNewLine = true;
                }
                ++i;
            }
            if (i >= chars.length) continue;
            while (i < chars.length && chars[i] != '=') {
                qName.append(chars[i]);
                ++i;
            }
            ++i;
            while (i < chars.length && Character.isWhitespace(chars[i])) {
                ++i;
            }
            if (i < chars.length) {
                if (chars[i] != '\"' && chars[i] != '\'') {
                    throw new SAXException("value for attribute " + qName.toString().trim() + " must be in quotes");
                }
                quote = chars[i];
                ++i;
            }
            while (i < chars.length && chars[i] != quote) {
                value.append(chars[i]);
                ++i;
            }
            ++i;
            String type = attributeOnNewLine ? ON_NEW_LINE : "";
            attributes.addAttribute("", "", qName.toString().trim(), type, value.toString());
        }
    }

    private int writeClosingTag(int start) throws IOException, SAXException {
        int end = this.xml.indexOf(62, start);
        this.writeRemaining(start, end);
        if (this.okToContinue) {
            this.isClosingTag = true;
            this.endElement("", "", this.xml.substring(start + 2, end).trim());
            ++end;
        }
        return end;
    }

    private int writeDocType(int start) throws IOException {
        int end = this.xml.indexOf(62, start);
        int bracketStart = this.xml.indexOf(91, start);
        if (bracketStart != -1 && bracketStart < end) {
            int bracketEnd = this.xml.indexOf(93, bracketStart);
            end = this.xml.indexOf(62, bracketEnd);
        }
        this.writeRemaining(start, end);
        if (this.okToContinue) {
            this.writer.write("\n");
            int length = ++end - start;
            this.writer.write(this.xml, start, length);
            this.isDocType = true;
        }
        return end;
    }

    private int writeXmlDeclarationOrProcessingInstruction(int start) throws IOException, SAXException {
        int end = this.xml.startsWith("<?xml ", start) ? this.writeXmlDeclaration(start) : this.writeProcessingInstruction(start);
        return end;
    }

    private int writeProcessingInstruction(int start) throws IOException, SAXException {
        int end = this.xml.indexOf("?>", start);
        this.writeRemaining(start, end);
        if (this.okToContinue) {
            int targetEnd = this.xml.indexOf(32, start);
            String target = this.xml.substring(start + "<?".length(), targetEnd);
            String data = this.xml.substring(targetEnd + 1, end);
            this.processingInstruction(target, data);
            end += "?>".length();
        }
        return end;
    }

    private int writeXmlDeclaration(int start) throws IOException {
        int end = this.xml.indexOf("?>", start);
        this.writeRemaining(start, end);
        if (this.okToContinue) {
            int length = (end += "?>".length()) - start;
            this.writer.write(this.xml, start, length);
        }
        return end;
    }

    private int writeComment(int start) throws IOException, SAXException {
        int end = this.xml.indexOf("-->", start);
        this.writeRemaining(start, end);
        if (this.okToContinue) {
            int commentTextStart = start + "<!--".length();
            int commentTextLength = end - commentTextStart;
            this.comment(this.chars, commentTextStart, commentTextLength);
            end += "-->".length();
        }
        return end;
    }

    private void writeTextPrecedingLessThan(int start, int end) throws IOException, SAXException {
        this.writeRemaining(start, end);
        if (this.okToContinue && end > start) {
            int length = end - start;
            this.characters(this.chars, start, length);
        }
    }

    private void writeRemaining(int start, int end) throws IOException {
        if (end == -1) {
            int length = this.xml.length() - start;
            this.writer.write(this.xml, start, length);
            this.okToContinue = false;
        }
    }
}

