/*
 * Decompiled with CFR 0.152.
 */
package xml.hyperlinks;

import gatchan.jedit.hyperlinks.FallbackHyperlinkSource;
import gatchan.jedit.hyperlinks.Hyperlink;
import gatchan.jedit.hyperlinks.HyperlinkSource;
import gatchan.jedit.hyperlinks.jEditOpenFileHyperlink;
import gatchan.jedit.hyperlinks.url.URLHyperlinkSource;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import sidekick.IAsset;
import sidekick.util.SideKickElement;
import xml.CharSequenceReader;
import xml.ElementUtil;
import xml.PathUtilities;
import xml.Resolver;
import xml.XmlParsedData;
import xml.completion.ElementDecl;
import xml.completion.IDDecl;
import xml.hyperlinks.HTMLHyperlinkSource;
import xml.hyperlinks.jEditOpenFileAndGotoHyperlink;
import xml.parser.XmlTag;
import xml.parser.javacc.ParseException;
import xml.parser.javacc.XmlDocument;
import xml.parser.javacc.XmlParser;

public class XMLHyperlinkSource
implements HyperlinkSource {
    private static final Pattern noWSPattern = Pattern.compile("[^\\s]+");
    private static final Pattern nsURIPairsPattern = Pattern.compile("[^\\s]+\\s+([^\\s]+)");

    public Hyperlink getHyperlink(Buffer buffer, int offset) {
        View view = jEdit.getActiveView();
        XmlParsedData data = XmlParsedData.getParsedData(view, false);
        if (data == null) {
            return null;
        }
        IAsset asset = data.getAssetAtOffset(offset);
        if (asset == null) {
            Log.log((int)1, XMLHyperlinkSource.class, (Object)"no Sidekick asset here");
            return null;
        }
        if (asset instanceof XmlTag) {
            return this.getHyperlink(buffer, offset, data, (XmlTag)asset, false);
        }
        return null;
    }

    public Hyperlink getHyperlink(Buffer buffer, int offset, XmlParsedData data, XmlTag asset, boolean isHTML) {
        int wantedLine = buffer.getLineOfOffset(offset);
        int wantedLineOffset = buffer.getVirtualWidth(wantedLine, offset - buffer.getLineStartOffset(wantedLine));
        int max = buffer.getLength();
        int sA = asset.getStart().getOffset();
        int lA = asset.getEnd().getOffset() - sA;
        if (sA < 0 || sA > max) {
            return null;
        }
        if (lA < 0 || sA + lA > max) {
            return null;
        }
        CharSequence toParse = buffer.getSegment(sA, lA);
        int line = buffer.getLineOfOffset(sA);
        int col = buffer.getVirtualWidth(line, sA - buffer.getLineStartOffset(line) + 1);
        CharSequenceReader r = new CharSequenceReader(toParse);
        XmlParser parser = new XmlParser(r, line + 1, col);
        parser.setTabSize(buffer.getTabSize());
        try {
            XmlDocument.XmlElement startTag = parser.Tag();
            int end = sidekick.util.ElementUtil.createEndPosition((Buffer)buffer, (SideKickElement)startTag).getOffset();
            if (offset <= end) {
                XmlDocument.AttributeList al = ((XmlDocument.Tag)startTag).attributeList;
                if (al == null) {
                    return null;
                }
                for (XmlDocument.Attribute att : al.attributes) {
                    if (att.getValueStartLocation().line >= wantedLine + 1 && (att.getValueStartLocation().line != wantedLine + 1 || att.getValueStartLocation().column > wantedLineOffset) || att.getEndLocation().line <= wantedLine + 1 && (att.getEndLocation().line != wantedLine + 1 || att.getEndLocation().column <= wantedLineOffset)) continue;
                    return this.getHyperlinkForAttribute(buffer, offset, data, asset, att, isHTML);
                }
                return null;
            }
            return null;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public Hyperlink getHyperlinkForAttribute(Buffer buffer, int offset, XmlParsedData data, XmlTag sideKickTag, XmlDocument.Attribute att, boolean isHTML) {
        String value;
        String localName;
        String ns;
        if (sideKickTag.attributes == null) {
            return null;
        }
        int attIndex = sideKickTag.attributes.getIndex(att.name);
        if (attIndex < 0) {
            return null;
        }
        String tagNS = sideKickTag.namespace;
        String tagLocalName = sideKickTag.getLocalName();
        Hyperlink h = this.getHyperlinkForAttribute(buffer, offset, tagNS, tagLocalName, ns = sideKickTag.attributes.getURI(attIndex), localName = att.name.contains(":") ? sideKickTag.attributes.getLocalName(attIndex) : att.name, value = sideKickTag.attributes.getValue(attIndex), data, sideKickTag, att, isHTML);
        if (h == null) {
            ElementDecl eltDecl = data.getElementDecl(sideKickTag.getName(), offset);
            if (eltDecl != null) {
                ElementDecl.AttributeDecl attDecl = eltDecl.attributeHash.get(localName);
                if (attDecl == null) {
                    return null;
                }
                if ("IDREF".equals(attDecl.type)) {
                    return this.getHyperlinkForIDREF(buffer, data, value, att);
                }
                if ("anyURI".equals(attDecl.type)) {
                    String href = this.resolve(value, buffer, offset, data, sideKickTag, false);
                    if (href != null) {
                        return this.newJEditOpenFileHyperlink(buffer, att, href);
                    }
                } else if ("IDREFS".equals(attDecl.type)) {
                    return this.getHyperlinkForIDREFS(buffer, offset, data, value, att);
                }
                return null;
            }
        } else {
            return h;
        }
        return null;
    }

    public Hyperlink getHyperlinkForIDREF(Buffer buffer, XmlParsedData data, String id, XmlDocument.Attribute att) {
        IDDecl idDecl = data.getIDDecl(id);
        if (idDecl == null) {
            return null;
        }
        return this.newJEditOpenFileAndGotoHyperlink(buffer, att, idDecl.uri, idDecl.line, idDecl.column);
    }

    public Hyperlink getHyperlinkForIDREFS(Buffer buffer, int offset, XmlParsedData data, String attValue, XmlDocument.Attribute att) {
        int attStart = ElementUtil.createOffset(buffer, att.getValueStartLocation());
        ++attStart;
        Matcher m = noWSPattern.matcher(attValue);
        while (m.find()) {
            int st = m.start(0);
            int nd = m.end(0);
            if (attStart + st > offset || attStart + nd < offset) continue;
            IDDecl idDecl = data.getIDDecl(m.group(0));
            if (idDecl == null) {
                return null;
            }
            int start = attStart + st;
            int end = attStart + nd;
            int line = buffer.getLineOfOffset(start);
            return new jEditOpenFileAndGotoHyperlink(start, end, line, idDecl.uri, idDecl.line, idDecl.column);
        }
        return null;
    }

    public HTMLHyperlinkSource.IsHyperLink isHyperlink(Buffer buffer, int offset, String tagNS, String tagLocalName, String attNS, String attLocalName, String attValue, int attStart) {
        if ("http://www.w3.org/2001/XInclude".equals(tagNS) && "include".equals(tagLocalName) && "href".equals(attLocalName) || "http://www.w3.org/1999/xlink".equals(attNS) && "href".equals(attLocalName)) {
            return new HTMLHyperlinkSource.IsHyperLink(attStart, attStart + attValue.length(), attValue, null, true);
        }
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(attNS) && "noNamespaceSchemaLocation".equals(attLocalName) || "".equals(tagNS) && "ulink".equals(tagLocalName) && "url".equals(attLocalName)) {
            return new HTMLHyperlinkSource.IsHyperLink(attStart, attStart + attValue.length(), attValue, null, false);
        }
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(attNS) && "schemaLocation".equals(attLocalName)) {
            Matcher m = nsURIPairsPattern.matcher(attValue);
            while (m.find()) {
                int st = m.start(1);
                int nd = m.end(1);
                if (attStart + st > offset || attStart + nd < offset) continue;
                String href = m.group(1);
                if (href == null) {
                    href = m.group(1);
                }
                int start = attStart + st;
                int end = attStart + nd;
                return new HTMLHyperlinkSource.IsHyperLink(start, end, href, null, false);
            }
        }
        return null;
    }

    public Hyperlink getHyperlinkForAttribute(Buffer buffer, int offset, String tagNS, String tagLocalName, String attNS, String attLocalName, String attValue, XmlParsedData data, XmlTag tag, XmlDocument.Attribute att, boolean isHTML) {
        int attStart = ElementUtil.createOffset(buffer, att.getValueStartLocation()) + 1;
        HTMLHyperlinkSource.IsHyperLink h = this.isHyperlink(buffer, offset, tagNS, tagLocalName, attNS, attLocalName, attValue, attStart);
        if (h == null && isHTML) {
            h = HTMLHyperlinkSource.isHyperlinkAttribute(buffer, offset, tagLocalName, attLocalName, attStart, attValue);
        }
        if (h != null) {
            if (h.href.startsWith("#")) {
                Position found = this.getNamedAnchorLocation(buffer, data, h.href.substring(1));
                if (found != null) {
                    int attLine = buffer.getLineOfOffset(h.start);
                    int line = buffer.getLineOfOffset(found.getOffset());
                    int column = found.getOffset() - buffer.getLineStartOffset(line) + 1;
                    String href = buffer.getPath();
                    return new jEditOpenFileAndGotoHyperlink(h.start, h.end, attLine, href, line, column);
                }
            } else {
                String href = h.href;
                if (h.resolveAgainst != null) {
                    href = HTMLHyperlinkSource.resolveRelativeTo(href, tag.attributes.getValue(h.resolveAgainst));
                }
                if ((href = this.resolve(href, buffer, offset, data, tag, h.resolveAgainstXMLBase)) == null) {
                    return null;
                }
                int attLine = buffer.getLineOfOffset(h.start);
                return new jEditOpenFileHyperlink(h.start, h.end, attLine, href);
            }
        }
        return null;
    }

    private Position getNamedAnchorPosition(Buffer buffer, XmlParsedData data, DefaultMutableTreeNode node, String name) {
        IAsset elt = data.getAsset(node);
        if (elt instanceof XmlTag) {
            XmlTag tag = (XmlTag)elt;
            String idOrName = tag.attributes.getValue("xml:id");
            if (idOrName == null && (idOrName = tag.attributes.getValue("id")) == null && tag.getName().equals("a")) {
                idOrName = tag.attributes.getValue("name");
            }
            if (idOrName != null && name.equals(idOrName)) {
                return tag.getStart();
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                Position p = this.getNamedAnchorPosition(buffer, data, (DefaultMutableTreeNode)node.getChildAt(i), name);
                if (p == null) continue;
                return p;
            }
        }
        return null;
    }

    private Position getNamedAnchorLocation(Buffer buffer, XmlParsedData data, String name) {
        DefaultMutableTreeNode tn = data.root;
        DefaultMutableTreeNode docRoot = (DefaultMutableTreeNode)tn.getFirstChild();
        if (docRoot == null) {
            return null;
        }
        return this.getNamedAnchorPosition(buffer, data, docRoot, name);
    }

    public String resolve(String uri, Buffer buffer, int offset, XmlParsedData data, XmlTag tag, boolean useXmlBase) {
        String href = null;
        String base = PathUtilities.pathToURL(buffer.getPath());
        if (useXmlBase) {
            try {
                URI baseURI = URI.create(base);
                Object[] pathObjs = data.getObjectsTo(offset);
                for (int i = 1; i < pathObjs.length; ++i) {
                    XmlTag t = (XmlTag)((Object)pathObjs[i]);
                    String newBase = t.attributes.getValue("xml:base");
                    if (newBase == null) continue;
                    baseURI = baseURI.resolve(newBase);
                }
                if (!base.equals(baseURI.toString())) {
                    baseURI = baseURI.resolve("dummy");
                    base = baseURI.toString();
                }
            }
            catch (IllegalArgumentException e) {
                Log.log((int)7, XMLHyperlinkSource.class, (Object)"error resolving uri", (Throwable)e);
            }
        }
        try {
            href = Resolver.instance().resolveEntityToPath("", "", base, uri);
        }
        catch (IOException ioe) {
            Log.log((int)9, XMLHyperlinkSource.class, (Object)("error resolving href=" + uri), (Throwable)ioe);
        }
        return href;
    }

    public Hyperlink newJEditOpenFileHyperlink(Buffer buffer, XmlDocument.Attribute att, String href) {
        int start = ElementUtil.createOffset(buffer, att.getValueStartLocation());
        int end = ElementUtil.createOffset(buffer, att.getEndLocation());
        int line = buffer.getLineOfOffset(start);
        return new jEditOpenFileHyperlink(start, end, line, href);
    }

    public Hyperlink newJEditOpenFileAndGotoHyperlink(Buffer buffer, XmlDocument.Attribute att, String href, int gotoLine, int gotoCol) {
        int start = ElementUtil.createOffset(buffer, att.getValueStartLocation());
        int end = ElementUtil.createOffset(buffer, att.getEndLocation());
        int line = buffer.getLineOfOffset(start);
        return new jEditOpenFileAndGotoHyperlink(start, end, line, href, gotoLine, gotoCol);
    }

    public static HyperlinkSource create() {
        return new FallbackHyperlinkSource(Arrays.asList(new XMLHyperlinkSource(), new URLHyperlinkSource()));
    }
}

