/*
 * Decompiled with CFR 0.152.
 */
package xml.hyperlinks;

import gatchan.jedit.hyperlinks.FallbackHyperlinkSource;
import gatchan.jedit.hyperlinks.Hyperlink;
import gatchan.jedit.hyperlinks.HyperlinkSource;
import gatchan.jedit.hyperlinks.jEditOpenFileHyperlink;
import gatchan.jedit.hyperlinks.url.URLHyperlinkSource;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import sidekick.IAsset;
import sidekick.html.parser.html.HtmlDocument;
import sidekick.html.parser.html.HtmlVisitor;
import sidekick.util.Location;
import sidekick.util.SideKickAsset;
import sidekick.util.SideKickElement;
import xml.ElementUtil;
import xml.PathUtilities;
import xml.Resolver;
import xml.XmlParsedData;
import xml.completion.ElementDecl;
import xml.completion.IDDecl;
import xml.hyperlinks.XMLHyperlinkSource;
import xml.hyperlinks.jEditOpenFileAndGotoHyperlink;
import xml.parser.XmlTag;

public class HTMLHyperlinkSource
implements HyperlinkSource {
    private static final Pattern noWSPattern = Pattern.compile("[^\\s]+");
    private static final Map<String, Set<String>> uriAttributes = new HashMap<String, Set<String>>();
    private static final FoundException foundException;
    private XMLHyperlinkSource sourceForXML = new XMLHyperlinkSource();

    public Hyperlink getHyperlink(Buffer buffer, int offset) {
        View view = jEdit.getActiveView();
        XmlParsedData data = XmlParsedData.getParsedData(view, false);
        if (data == null) {
            return null;
        }
        IAsset asset = data.getAssetAtOffset(offset);
        if (asset == null) {
            Log.log((int)1, HTMLHyperlinkSource.class, (Object)"no Sidekick asset here");
            return null;
        }
        if (asset instanceof SideKickAsset) {
            HtmlDocument.Tag startTag;
            int wantedLine = buffer.getLineOfOffset(offset);
            int wantedLineOffset = buffer.getVirtualWidth(wantedLine, offset - buffer.getLineStartOffset(wantedLine));
            SideKickElement elt = ((SideKickAsset)asset).getElement();
            if (elt instanceof HtmlDocument.TagBlock) {
                startTag = ((HtmlDocument.TagBlock)elt).startTag;
            } else if (elt instanceof HtmlDocument.Tag) {
                startTag = (HtmlDocument.Tag)elt;
            } else {
                Log.log((int)7, HTMLHyperlinkSource.class, (Object)("unexpected asset type: " + elt.getClass() + ", please report"));
                Object startTag2 = null;
                return null;
            }
            int end = sidekick.util.ElementUtil.createEndPosition((Buffer)buffer, (SideKickElement)startTag).getOffset();
            if (offset <= end) {
                HtmlDocument.AttributeList al = startTag.attributeList;
                if (al == null) {
                    return null;
                }
                for (HtmlDocument.Attribute att : al.attributes) {
                    if (att.getValueStartLocation().line >= wantedLine + 1 && (att.getValueStartLocation().line != wantedLine + 1 || att.getValueStartLocation().column > wantedLineOffset) || att.getEndLocation().line <= wantedLine + 1 && (att.getEndLocation().line != wantedLine + 1 || att.getEndLocation().column <= wantedLineOffset)) continue;
                    return this.getHyperlinkForAttribute(buffer, offset, data, startTag, att);
                }
                return null;
            }
            return null;
        }
        if (asset instanceof XmlTag) {
            return this.sourceForXML.getHyperlink(buffer, offset, data, (XmlTag)asset, true);
        }
        Log.log((int)7, HTMLHyperlinkSource.class, (Object)("unexpected asset type: " + asset.getClass() + ", please report"));
        return null;
    }

    public Hyperlink getHyperlinkForAttribute(Buffer buffer, int offset, XmlParsedData data, HtmlDocument.Tag startTag, HtmlDocument.Attribute att) {
        boolean quoted;
        String tagLocalName = startTag.tagName;
        String localName = att.getName();
        String value = att.getValue();
        if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
            value = value.substring(1, value.length() - 1);
            quoted = true;
        } else {
            quoted = false;
        }
        Hyperlink h = this.getHyperlinkForAttribute(buffer, offset, tagLocalName, localName, value, data, startTag, att, quoted);
        if (h == null) {
            ElementDecl eltDecl = data.getElementDecl(localName, offset);
            if (eltDecl != null) {
                ElementDecl.AttributeDecl attDecl = eltDecl.attributeHash.get(localName);
                if (attDecl == null) {
                    return null;
                }
                if ("IDREF".equals(attDecl.type)) {
                    return this.getHyperlinkForIDREF(buffer, data, value, att, quoted);
                }
                if ("anyURI".equals(attDecl.type)) {
                    String href = this.resolve(value, buffer, offset, data);
                    if (href != null) {
                        return this.newJEditOpenFileHyperlink(buffer, att, href, quoted);
                    }
                } else if ("IDREFS".equals(attDecl.type)) {
                    return this.getHyperlinkForIDREFS(buffer, offset, data, value, att, quoted);
                }
                return null;
            }
        } else {
            return h;
        }
        return null;
    }

    public Hyperlink getHyperlinkForIDREF(Buffer buffer, XmlParsedData data, String id, HtmlDocument.Attribute att, boolean quoted) {
        IDDecl idDecl = data.getIDDecl(id);
        if (idDecl == null) {
            return null;
        }
        return this.newJEditOpenFileAndGotoHyperlink(buffer, att, idDecl.uri, idDecl.line, idDecl.column, quoted);
    }

    public Hyperlink getHyperlinkForIDREFS(Buffer buffer, int offset, XmlParsedData data, String attValue, HtmlDocument.Attribute att, boolean quoted) {
        int attStart = ElementUtil.createOffset(buffer, att.getValueStartLocation());
        if (quoted) {
            ++attStart;
        }
        Matcher m = noWSPattern.matcher(attValue);
        while (m.find()) {
            int st = m.start(0);
            int nd = m.end(0);
            if (attStart + st > offset || attStart + nd < offset) continue;
            IDDecl idDecl = data.getIDDecl(m.group(0));
            if (idDecl == null) {
                return null;
            }
            int start = attStart + st;
            int end = attStart + nd;
            int line = buffer.getLineOfOffset(start);
            return new jEditOpenFileAndGotoHyperlink(start, end, line, idDecl.uri, idDecl.line, idDecl.column);
        }
        return null;
    }

    public Hyperlink getHyperlinkForAttribute(Buffer buffer, int offset, String tagLocalName, String attLocalName, String attValue, XmlParsedData data, HtmlDocument.Tag tag, HtmlDocument.Attribute att, boolean quoted) {
        int attStart = ElementUtil.createOffset(buffer, att.getValueStartLocation()) + 1;
        IsHyperLink h = HTMLHyperlinkSource.isHyperlinkAttribute(buffer, offset, tagLocalName, attLocalName, attStart, attValue);
        if (h != null) {
            if (h.href.startsWith("#")) {
                Location found = this.getNamedAnchorLocation(data, h.href.substring(1));
                if (found != null) {
                    int attLine = buffer.getLineOfOffset(h.start);
                    int toffset = ElementUtil.createOffset(buffer, found);
                    int line = buffer.getLineOfOffset(toffset);
                    int column = toffset - buffer.getLineStartOffset(line);
                    String href = buffer.getPath();
                    return new jEditOpenFileAndGotoHyperlink(h.start, h.end, attLine, href, line, column);
                }
            } else {
                String href = h.href;
                if (h.resolveAgainst != null) {
                    href = HTMLHyperlinkSource.resolveRelativeTo(href, tag.getAttributeValue(h.resolveAgainst));
                }
                if ((href = this.resolve(href, buffer, offset, data)) == null) {
                    return null;
                }
                int attLine = buffer.getLineOfOffset(h.start);
                return new jEditOpenFileHyperlink(h.start, h.end, attLine, href);
            }
        }
        return null;
    }

    public static IsHyperLink isHyperlinkAttribute(Buffer buffer, int offset, String tagLocalName, String attLocalName, int attStart, String attValue) {
        if (uriAttributes.containsKey(tagLocalName) && uriAttributes.get(tagLocalName).contains(attLocalName)) {
            return new IsHyperLink(attStart, attStart + attValue.length(), attValue, null, false);
        }
        if ("object".equals(tagLocalName) && ("classid".equals(attLocalName) || "data".equals(attLocalName))) {
            return new IsHyperLink(attStart, attStart + attValue.length(), attValue, "codebase", false);
        }
        if ("object".equals(tagLocalName) && "archive".equals(attLocalName)) {
            Matcher m = noWSPattern.matcher(attValue);
            while (m.find()) {
                int st = m.start(0);
                int nd = m.end(0);
                if (attStart + st > offset || attStart + nd < offset) continue;
                String href = m.group(0);
                int start = attStart + st;
                int end = attStart + nd;
                return new IsHyperLink(start, end, href, "codebase", false);
            }
        }
        return null;
    }

    static String resolveRelativeTo(String href, String base) {
        if (base == null || "".equals(base)) {
            return href;
        }
        try {
            return URI.create(base).resolve(href).toString();
        }
        catch (IllegalArgumentException iae) {
            Log.log((int)7, HTMLHyperlinkSource.class, (Object)"error resolving against base", (Throwable)iae);
            return href;
        }
    }

    public String resolve(String uri, Buffer buffer, int offset, XmlParsedData data) {
        String href = null;
        String base = PathUtilities.pathToURL(buffer.getPath());
        HtmlDocument.TagBlock html = this.getHTML(data);
        if (html != null && html.body.size() > 0) {
            Iterator ith = html.body.iterator();
            block4: while (ith.hasNext()) {
                HtmlDocument.HtmlElement head = (HtmlDocument.HtmlElement)ith.next();
                if (!(head instanceof HtmlDocument.TagBlock)) continue;
                if (!"head".equalsIgnoreCase(((HtmlDocument.TagBlock)head).startTag.tagName)) break;
                Iterator it = ((HtmlDocument.TagBlock)head).body.iterator();
                while (it.hasNext()) {
                    HtmlDocument.HtmlElement e = (HtmlDocument.HtmlElement)it.next();
                    if (!(e instanceof HtmlDocument.Tag) || !"base".equalsIgnoreCase(((HtmlDocument.Tag)e).tagName)) continue;
                    String preBase = ((HtmlDocument.Tag)e).getAttributeValue("href");
                    try {
                        base = URI.create(preBase).resolve("dummy").toString();
                    }
                    catch (IllegalArgumentException iae) {
                        Log.log((int)7, XMLHyperlinkSource.class, (Object)"error resolving uri", (Throwable)iae);
                    }
                    break block4;
                }
                break block4;
            }
        }
        try {
            href = Resolver.instance().resolveEntityToPath("", "", base, uri);
        }
        catch (IOException ioe) {
            Log.log((int)9, XMLHyperlinkSource.class, (Object)("error resolving href=" + uri), (Throwable)ioe);
        }
        return href;
    }

    public Hyperlink newJEditOpenFileHyperlink(Buffer buffer, HtmlDocument.Attribute att, String href, boolean quoted) {
        int start = ElementUtil.createOffset(buffer, att.getValueStartLocation());
        int end = ElementUtil.createOffset(buffer, att.getEndLocation());
        if (quoted) {
            ++start;
            --end;
        }
        int line = buffer.getLineOfOffset(start);
        return new jEditOpenFileHyperlink(start, end, line, href);
    }

    public Hyperlink newJEditOpenFileAndGotoHyperlink(Buffer buffer, HtmlDocument.Attribute att, String href, int gotoLine, int gotoCol, boolean quoted) {
        int start = ElementUtil.createOffset(buffer, att.getValueStartLocation());
        int end = ElementUtil.createOffset(buffer, att.getEndLocation());
        if (quoted) {
            ++start;
            --end;
        }
        int line = buffer.getLineOfOffset(start);
        return new jEditOpenFileAndGotoHyperlink(start, end, line, href, gotoLine, gotoCol);
    }

    HtmlDocument.TagBlock getHTML(XmlParsedData data) {
        DefaultMutableTreeNode tn = data.root;
        DefaultMutableTreeNode docRoot = (DefaultMutableTreeNode)tn.getFirstChild();
        if (docRoot == null) {
            return null;
        }
        SideKickElement elt = ((SideKickAsset)data.getAsset(docRoot)).getElement();
        if (elt instanceof HtmlDocument.TagBlock) {
            return (HtmlDocument.TagBlock)elt;
        }
        return null;
    }

    public Location getNamedAnchorLocation(XmlParsedData data, String name) {
        HtmlDocument.TagBlock html = this.getHTML(data);
        if (html != null) {
            NamedAnchorVisitor v = new NamedAnchorVisitor(name);
            try {
                html.accept(v);
            }
            catch (FoundException e) {
                return v.foundLoc;
            }
        }
        return null;
    }

    public static HyperlinkSource create() {
        return new FallbackHyperlinkSource(Arrays.asList(new HTMLHyperlinkSource(), new URLHyperlinkSource()));
    }

    static {
        HashSet<String> h = new HashSet<String>();
        h.add("href");
        uriAttributes.put("a", h);
        uriAttributes.put("area", h);
        uriAttributes.put("link", h);
        h = new HashSet();
        h.add("longdesc");
        h.add("usemap");
        uriAttributes.put("img", h);
        h = new HashSet();
        h.add("cite");
        uriAttributes.put("q", h);
        uriAttributes.put("blockquote", h);
        uriAttributes.put("ins", h);
        uriAttributes.put("del", h);
        h = new HashSet();
        h.add("usemap");
        uriAttributes.put("input", h);
        uriAttributes.put("object", h);
        h = new HashSet();
        h.add("src");
        uriAttributes.put("script", h);
        foundException = new FoundException();
    }

    public static class IsHyperLink {
        public final int start;
        public final int end;
        public final String href;
        public final String resolveAgainst;
        public final boolean resolveAgainstXMLBase;

        public IsHyperLink(int start, int end, String href, String resolveAgainst, boolean resolveAgainstXMLBase) {
            this.start = start;
            this.end = end;
            this.href = href;
            this.resolveAgainst = resolveAgainst;
            this.resolveAgainstXMLBase = resolveAgainstXMLBase;
        }
    }

    private static final class NamedAnchorVisitor
    extends HtmlVisitor {
        private final String searchedAnchor;
        Location foundLoc;

        NamedAnchorVisitor(String searched) {
            this.searchedAnchor = searched;
            this.foundLoc = null;
        }

        @Override
        public void visit(HtmlDocument.Tag t) {
            String v = null;
            if ("a".equalsIgnoreCase(t.tagName)) {
                v = t.getAttributeValue("name");
            }
            if (v == null) {
                v = t.getAttributeValue("id");
            }
            if (this.searchedAnchor.equals(v)) {
                this.foundLoc = t.getStartLocation();
                throw foundException;
            }
        }
    }

    private static class FoundException
    extends RuntimeException {
        private FoundException() {
        }
    }
}

