/*
 * Decompiled with CFR 0.152.
 */
package xml.gui;

import eclipseicons.EclipseIconsPlugin;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import sidekick.SideKickParsedData;
import xml.XmlParsedData;

public class XmlModeToolBar
extends JPanel {
    private JComboBox choices;
    private JButton direction;
    private View view = null;
    private static ImageIcon upIcon = EclipseIconsPlugin.getIcon((String)"up.gif");
    private static ImageIcon downIcon = EclipseIconsPlugin.getIcon((String)"down.gif");
    private boolean down = true;

    public XmlModeToolBar(View view) {
        this.view = view;
        this.installComponents();
        this.installListeners();
    }

    private void installComponents() {
        SideKickParsedData data;
        this.choices = new JComboBox();
        this.choices.setEditable(false);
        JLabel sortLabel = new JLabel(jEdit.getProperty((String)"options.sidekick.xml.sortBy", (String)"Sort by:"));
        this.choices.addItem(jEdit.getProperty((String)"options.sidekick.xml.sortByName", (String)"Name"));
        this.choices.addItem(jEdit.getProperty((String)"options.sidekick.xml.sortByLine", (String)"Line"));
        this.choices.addItem(jEdit.getProperty((String)"options.sidekick.xml.sortByType", (String)"Type"));
        this.direction = new JButton();
        this.direction.setIcon(downIcon);
        this.direction.setToolTipText(jEdit.getProperty((String)"options.sidekick.xml.sortDirection", (String)"Sort direction"));
        this.add(sortLabel);
        this.add(this.choices);
        this.add(this.direction);
        if (this.view != null && (data = SideKickParsedData.getParsedData((View)this.view)) instanceof XmlParsedData) {
            int choice = ((XmlParsedData)data).getSortBy();
            this.choices.setSelectedIndex(choice);
        }
    }

    private void installListeners() {
        this.choices.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                XmlParsedData data;
                if (XmlModeToolBar.this.view != null && (data = (XmlParsedData)SideKickParsedData.getParsedData((View)XmlModeToolBar.this.view)) != null) {
                    data.setSortBy(XmlModeToolBar.this.choices.getSelectedIndex());
                    data.sort(XmlModeToolBar.this.view);
                }
            }
        });
        this.direction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                XmlParsedData data;
                if (XmlModeToolBar.this.view != null && (data = (XmlParsedData)SideKickParsedData.getParsedData((View)XmlModeToolBar.this.view)) != null) {
                    XmlModeToolBar.this.down = !XmlModeToolBar.this.down;
                    XmlModeToolBar.this.direction.setIcon(XmlModeToolBar.this.down ? downIcon : upIcon);
                    data.setSortDirection(XmlModeToolBar.this.down);
                    data.sort(XmlModeToolBar.this.view);
                }
            }
        });
    }
}

