/*
 * Decompiled with CFR 0.152.
 */
package xml.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import xml.gui.UsefulAction;

public class VFSFileTextField
extends JPanel {
    private static final String LAST_SOURCE = ".last-source";
    private View view;
    private String propertyPrefix;
    private JTextField sourceField;
    private JButton browseButton;
    private UsefulAction sourceSelectAction;
    private UsefulAction openFileAction;

    public VFSFileTextField(View view, String propertyPrefix) {
        super(new BorderLayout());
        this.view = view;
        this.propertyPrefix = propertyPrefix;
        this.sourceSelectAction = new SourceSelectAction(propertyPrefix);
        this.openFileAction = new OpenFileAction();
        this.add((Component)this.initSourceField(), "Center");
    }

    private JComponent initSourceField() {
        this.sourceField = new JTextField();
        InputMap im = this.sourceField.getInputMap(0);
        ActionMap am = this.sourceField.getActionMap();
        im.put(KeyStroke.getKeyStroke("ENTER"), "OpenFile");
        am.put("OpenFile", this.openFileAction);
        this.sourceField.setName(this.propertyPrefix + ".prompt");
        this.sourceField.setComponentPopupMenu(this.initMenu());
        String lastSource = jEdit.getProperty((String)(this.propertyPrefix + LAST_SOURCE));
        if (lastSource == null) {
            this.sourceField.setText(jEdit.getProperty((String)(this.propertyPrefix + ".browse.prompt")));
        } else {
            this.sourceField.setText(lastSource);
        }
        this.sourceField.addFocusListener(new FocusListener(){
            private String valueOnEnter;

            @Override
            public void focusGained(FocusEvent fe) {
                this.valueOnEnter = VFSFileTextField.this.sourceField.getText();
            }

            @Override
            public void focusLost(FocusEvent fe) {
                String valueOnExit = VFSFileTextField.this.sourceField.getText();
                if (!valueOnExit.equals(this.valueOnEnter)) {
                    VFSFileTextField.this.firePropertyChange("file", this.valueOnEnter, valueOnExit);
                }
            }
        });
        this.browseButton = this.sourceSelectAction.getButton();
        Box container = Box.createHorizontalBox();
        container.add(this.sourceField);
        container.add(Box.createHorizontalStrut(6));
        container.add(this.browseButton);
        return container;
    }

    private void chooseFile() {
        Container topLevelAncestor;
        String[] selections;
        String path = null;
        if (this.getFile() != null && !this.getFile().equals("")) {
            path = MiscUtilities.getParentOfPath((String)this.getFile());
        }
        if ((selections = (topLevelAncestor = this.getTopLevelAncestor()) != this.view && topLevelAncestor instanceof JFrame ? GUIUtilities.showVFSFileDialog((Frame)((JFrame)topLevelAncestor), (View)this.view, (String)path, (int)0, (boolean)false) : GUIUtilities.showVFSFileDialog((View)this.view, (String)path, (int)0, (boolean)false)) != null) {
            this.setFile(selections[0]);
        }
        if (topLevelAncestor instanceof JFrame) {
            ((JFrame)topLevelAncestor).toFront();
        }
    }

    public String getFile() {
        return this.sourceField.getText();
    }

    public void setFile(String file) {
        this.sourceField.setText(file);
        jEdit.setProperty((String)(this.propertyPrefix + LAST_SOURCE), (String)file);
        this.firePropertyChange("file", null, file);
    }

    public boolean isFileDefined() {
        return !this.getFile().equals(jEdit.getProperty((String)(this.propertyPrefix + ".browse.prompt")));
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.browseButton.setEnabled(enabled);
        this.sourceField.setEnabled(enabled);
    }

    private JPopupMenu initMenu() {
        Object[] actions = new UsefulAction[]{this.openFileAction, null, this.sourceSelectAction};
        return UsefulAction.initMenu(actions);
    }

    private void openFile() {
        String file = this.getFile();
        if (file != null && !file.equals(jEdit.getProperty((String)(this.propertyPrefix + ".browse.prompt")))) {
            jEdit.openFile((View)this.view, (String)file);
        }
    }

    private class OpenFileAction
    extends UsefulAction {
        OpenFileAction() {
            super("xml.gui.file.open");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VFSFileTextField.this.openFile();
        }
    }

    private class SourceSelectAction
    extends UsefulAction {
        SourceSelectAction(String propertyPrefix) {
            super(propertyPrefix + ".select");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VFSFileTextField.this.chooseFile();
        }
    }
}

