/*
 * Decompiled with CFR 0.152.
 */
package xml.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import xml.gui.PropertyUtil;
import xml.gui.UsefulAction;

public class VFSFileList
extends JPanel
implements ListSelectionListener {
    private static final String LAST_ITEMS = "last-items";
    private View view;
    private DefaultListModel itemsListModel;
    private JList itemsList;
    private String propertyPrefix;
    private UsefulAction addItemAction;
    private UsefulAction removeItemAction;
    private UsefulAction upAction;
    private UsefulAction downAction;
    private UsefulAction openFileAction;

    public VFSFileList(View view, String propertyPrefix) {
        this.view = view;
        this.propertyPrefix = propertyPrefix;
        this.addItemAction = new AddItemAction();
        this.removeItemAction = new RemoveItemAction();
        this.upAction = new MoveItemUpAction();
        this.downAction = new MoveItemDownAction();
        this.openFileAction = new OpenFileAction();
        this.itemsListModel = this.initItemListModel();
        this.itemsList = this.initItemList();
        JScrollPane editorComponent = new JScrollPane(this.itemsList);
        JToolBar toolBar = this.initToolBar();
        this.setLayout(new BorderLayout());
        this.add((Component)editorComponent, "Center");
        this.add((Component)toolBar, "East");
    }

    public String getSelectedItem() {
        int selectedIndex = this.itemsList.getSelectedIndex();
        if (selectedIndex == -1) {
            return null;
        }
        return this.getItem(selectedIndex);
    }

    public String getItem(int index) {
        if (index < 0 || index >= this.itemsListModel.size()) {
            throw new IllegalArgumentException("invalid index: " + index);
        }
        return (String)this.itemsListModel.get(index);
    }

    public Object[] getItems() {
        return this.itemsListModel.toArray();
    }

    public void setItems(String[] items) {
        this.itemsListModel.clear();
        for (int i = 0; i < items.length; ++i) {
            this.itemsListModel.add(i, items[i]);
        }
        this.storeItems();
    }

    public boolean itemsExist() {
        return this.itemsListModel.size() > 0;
    }

    public int getItemCount() {
        return this.itemsListModel.size();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.addItemAction.setEnabled(false);
            this.removeItemAction.setEnabled(false);
            this.itemsList.clearSelection();
            this.itemsList.setEnabled(false);
        } else {
            this.addItemAction.setEnabled(true);
            this.itemsList.setEnabled(true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        boolean selectionExists = this.itemsList.getSelectedIndex() != -1;
        this.removeItemAction.setEnabled(selectionExists);
        this.upAction.setEnabled(selectionExists && this.itemsListModel.getSize() > 1 && this.itemsList.getSelectedIndex() != 0);
        this.downAction.setEnabled(selectionExists && this.itemsListModel.getSize() > 1 && this.itemsList.getSelectedIndex() < this.itemsListModel.getSize() - 1);
    }

    private DefaultListModel initItemListModel() {
        DefaultListModel<String> itemsListModel = new DefaultListModel<String>();
        List<String> values = PropertyUtil.getEnumeratedProperty(this.propertyPrefix + LAST_ITEMS);
        Iterator<String> it = values.iterator();
        while (it.hasNext()) {
            itemsListModel.addElement(it.next());
        }
        return itemsListModel;
    }

    private JList initItemList() {
        JList list = new JList(this.itemsListModel);
        list.setName(this.propertyPrefix);
        list.getSelectionModel().setSelectionMode(0);
        list.getSelectionModel().addListSelectionListener(this);
        Object[] actions = new UsefulAction[]{this.openFileAction, null, this.upAction, this.downAction, null, this.addItemAction, this.removeItemAction};
        list.setComponentPopupMenu(UsefulAction.initMenu(actions));
        list.getInputMap(1).put(KeyStroke.getKeyStroke("ENTER"), "open-file");
        list.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "open-file");
        list.getActionMap().put("open-file", this.openFileAction);
        return list;
    }

    private JToolBar initToolBar() {
        this.upAction.setEnabled(false);
        this.downAction.setEnabled(false);
        this.removeItemAction.setEnabled(this.itemsExist());
        JToolBar toolBar = new JToolBar(1);
        toolBar.setFloatable(false);
        toolBar.add(this.addItemAction.getButton());
        toolBar.add(this.removeItemAction.getButton());
        toolBar.addSeparator();
        toolBar.add(this.upAction.getButton());
        toolBar.add(this.downAction.getButton());
        return toolBar;
    }

    private void storeItems() {
        List<Object> itemsList = Arrays.asList(this.itemsListModel.toArray());
        PropertyUtil.setEnumeratedProperty(this.propertyPrefix + LAST_ITEMS, itemsList);
    }

    private void openFile() {
        String file = this.getSelectedItem();
        if (file != null) {
            jEdit.openFile((View)this.view, (String)file);
        }
    }

    private class OpenFileAction
    extends UsefulAction {
        OpenFileAction() {
            super("xml.gui.file.open");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VFSFileList.this.openFile();
        }
    }

    private class MoveItemDownAction
    extends MoveItemAction {
        MoveItemDownAction() {
            super(VFSFileList.this.propertyPrefix + ".down", 1);
        }
    }

    private class MoveItemUpAction
    extends MoveItemAction {
        MoveItemUpAction() {
            super(VFSFileList.this.propertyPrefix + ".up", -1);
        }
    }

    private abstract class MoveItemAction
    extends UsefulAction {
        private int increment;

        MoveItemAction(String actionName, int increment) {
            super(actionName);
            this.increment = increment;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedIndex = VFSFileList.this.itemsList.getSelectedIndex();
            Object selected = VFSFileList.this.itemsListModel.get(selectedIndex);
            VFSFileList.this.itemsListModel.remove(selectedIndex);
            VFSFileList.this.itemsListModel.insertElementAt(selected, selectedIndex + this.increment);
            VFSFileList.this.itemsList.setSelectedIndex(selectedIndex + this.increment);
            VFSFileList.this.storeItems();
        }
    }

    private class RemoveItemAction
    extends UsefulAction {
        RemoveItemAction() {
            super(VFSFileList.this.propertyPrefix + ".remove");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = VFSFileList.this.itemsList.getSelectedIndex();
            if (index < 0) {
                return;
            }
            VFSFileList.this.itemsListModel.remove(index);
            if (VFSFileList.this.itemsListModel.getSize() > 0) {
                VFSFileList.this.itemsList.setSelectedIndex(0);
            } else {
                VFSFileList.this.removeItemAction.setEnabled(false);
            }
            VFSFileList.this.storeItems();
        }
    }

    private class AddItemAction
    extends UsefulAction {
        AddItemAction() {
            super(VFSFileList.this.propertyPrefix + ".add");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Container topLevelAncestor;
            String[] selections;
            String path = null;
            if (VFSFileList.this.itemsListModel.size() > 0) {
                path = MiscUtilities.getParentOfPath((String)VFSFileList.this.getItem(0));
            }
            if ((selections = VFSFileList.this.getTopLevelAncestor() != VFSFileList.this.view && VFSFileList.this.getTopLevelAncestor() instanceof JFrame ? GUIUtilities.showVFSFileDialog((Frame)((JFrame)VFSFileList.this.getTopLevelAncestor()), (View)VFSFileList.this.view, (String)path, (int)0, (boolean)false) : GUIUtilities.showVFSFileDialog((View)VFSFileList.this.view, (String)path, (int)0, (boolean)false)) != null) {
                VFSFileList.this.itemsListModel.addElement(selections[0]);
                if (VFSFileList.this.itemsList.getSelectedIndex() != -1 && VFSFileList.this.itemsListModel.getSize() > 1) {
                    VFSFileList.this.downAction.setEnabled(true);
                }
                VFSFileList.this.storeItems();
            }
            if ((topLevelAncestor = VFSFileList.this.getTopLevelAncestor()) instanceof JFrame) {
                ((JFrame)topLevelAncestor).toFront();
            }
        }
    }
}

