/*
 * Decompiled with CFR 0.152.
 */
package xml.gui;

import java.awt.Dimension;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.jEdit;

public abstract class UsefulAction
extends AbstractAction {
    private String actionType;

    public UsefulAction(String actionType) {
        this.actionType = actionType;
        String actionName = jEdit.getProperty((String)(actionType + ".name"));
        String shortcut = jEdit.getProperty((String)(actionType + ".shortcut"));
        String shortDescription = jEdit.getProperty((String)(actionType + ".short-desc"));
        String iconName = jEdit.getProperty((String)(actionType + ".small-icon"));
        shortDescription = shortcut != null ? shortDescription + " - " + shortcut : shortDescription;
        this.putValue("ActionCommandKey", actionType);
        this.putValue("Name", actionName);
        this.putValue("ShortDescription", shortDescription);
        if (iconName != null) {
            Icon icon;
            if (iconName.startsWith("/")) {
                URL u = this.getClass().getResource(iconName);
                icon = new ImageIcon(u);
            } else {
                icon = GUIUtilities.loadIcon((String)iconName);
            }
            this.putValue("SmallIcon", icon);
        }
    }

    public JButton getButton() {
        JButton button = new JButton(this);
        button.setText("");
        button.setName(this.actionType);
        Dimension dimension = this.getButtonDimension();
        button.setMinimumSize(dimension);
        button.setPreferredSize(dimension);
        button.setMaximumSize(dimension);
        return button;
    }

    public JRadioButton getRadioButton(String text) {
        JRadioButton button = new JRadioButton(this);
        button.setName(text);
        button.setText(jEdit.getProperty((String)text));
        return button;
    }

    protected Dimension getButtonDimension() {
        Dimension dimension = new Dimension(30, 30);
        return dimension;
    }

    public JMenuItem getMenuItem() {
        JMenuItem item = new JMenuItem(this);
        item.setIcon(null);
        return item;
    }

    public static JPopupMenu initMenu(Object[] actions) {
        JPopupMenu menu = new JPopupMenu();
        for (int i = 0; i < actions.length; ++i) {
            Object action = actions[i];
            if (action == null) {
                menu.addSeparator();
                continue;
            }
            menu.add(((UsefulAction)action).getMenuItem());
        }
        return menu;
    }
}

