/*
 * Decompiled with CFR 0.152.
 */
package xml.completion;

import java.util.List;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.Selection;
import sidekick.SideKickCompletion;
import xml.EditTagDialog;
import xml.NamespaceBindings;
import xml.XmlActions;
import xml.XmlListCellRenderer;
import xml.XmlParsedData;
import xml.completion.ElementDecl;
import xml.completion.EntityDecl;

public class XmlCompletion
extends SideKickCompletion {
    private NamespaceBindings namespaces;
    private NamespaceBindings namespacesToInsert;
    private XmlParsedData data;
    private String closingTag;

    public XmlCompletion(View view, List items, NamespaceBindings namespaces, NamespaceBindings namespacesToInsert, String txt, XmlParsedData data, String closingTag) {
        super(view, txt);
        this.items = items;
        this.data = data;
        this.closingTag = closingTag;
        this.namespaces = namespaces;
        this.namespacesToInsert = namespacesToInsert;
    }

    public ListCellRenderer getRenderer() {
        return XmlListCellRenderer.INSTANCE;
    }

    public int getTokenLength() {
        return this.text.length() + 1;
    }

    public void insert(int index) {
        this.insert((XmlListCellRenderer.WithLabel)this.get(index), '\n');
    }

    public boolean handleKeystroke(int index, char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case ' ': 
            case ';': 
            case '>': {
                break;
            }
            case '/': {
                if (jEdit.getBooleanProperty((String)"xml.close-complete")) {
                    XmlActions.completeClosingTag(this.view, true);
                    return false;
                }
            }
            default: {
                Macros.Recorder recorder = this.view.getMacroRecorder();
                if (recorder != null) {
                    recorder.recordInput(1, ch, false);
                }
                this.textArea.userInput(ch);
                return true;
            }
        }
        if (index != -1) {
            this.insert((XmlListCellRenderer.WithLabel)this.get(index), ch);
        } else if (ch == '>') {
            XmlActions.insertClosingTagKeyTyped(this.view);
        } else {
            this.textArea.userInput(ch);
        }
        return false;
    }

    private void insert(final XmlListCellRenderer.WithLabel<Object> wqn, char ch) {
        String insert;
        Object obj = wqn.element;
        Macros.Recorder recorder = this.view.getMacroRecorder();
        int caret = 0;
        if (obj instanceof XmlListCellRenderer.Comment) {
            insert = "!--  -->".substring(this.text.length());
            caret = 4;
        } else if (obj instanceof XmlListCellRenderer.CDATA) {
            insert = "![CDATA[]]>".substring(this.text.length());
            caret = 3;
        } else if (obj instanceof XmlListCellRenderer.ClosingTag) {
            insert = ("/" + this.closingTag + ">").substring(this.text.length());
            caret = 0;
        } else if (obj instanceof ElementDecl.AttributeDecl) {
            ElementDecl.AttributeDecl attrDecl = (ElementDecl.AttributeDecl)obj;
            StringBuilder buf = new StringBuilder();
            buf.append(NamespaceBindings.composeName(attrDecl.name, attrDecl.namespace, this.namespaces, this.namespacesToInsert, false).substring(this.text.length()));
            buf.append("=\"\"");
            caret = buf.length() - 1;
            this.namespacesToInsert.appendNamespaces(buf);
            caret = !this.namespacesToInsert.isEmpty() ? buf.length() - caret : 1;
            insert = buf.toString();
        } else if (obj instanceof ElementDecl) {
            final ElementDecl elementDecl = (ElementDecl)obj;
            boolean withEndOfTag = ch == '\n' || ch == '>';
            StringBuilder[] bufs = EditTagDialog.composeTag(this.data, elementDecl, this.namespaces, this.namespacesToInsert, withEndOfTag);
            bufs[0].replace(0, this.text.length(), "");
            if (withEndOfTag) {
                if (elementDecl.empty) {
                    caret = 0;
                    insert = bufs[0].toString();
                } else {
                    caret = bufs[1].length();
                    insert = bufs[0].toString() + bufs[1].toString();
                }
                if (ch == '\n' && jEdit.getBooleanProperty((String)"xml.tageditor.popupOnComplete")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int caret = XmlCompletion.this.textArea.getCaretPosition();
                            Selection s = XmlCompletion.this.textArea.getSelectionAtOffset(caret);
                            int start = s == null ? caret : s.getStart();
                            Selection.Range textSel = new Selection.Range(start - XmlCompletion.this.text.length() - 1, start);
                            XmlActions.showEditTagDialog(XmlCompletion.this.view, wqn.label, elementDecl, (Selection)textSel, XmlCompletion.this.namespaces, XmlCompletion.this.namespacesToInsert, !elementDecl.attributes.isEmpty());
                        }
                    });
                    return;
                }
            } else {
                bufs[0].append(ch);
                insert = bufs[0].toString();
                caret = 0;
            }
        } else if (obj instanceof EntityDecl) {
            EntityDecl entity = (EntityDecl)obj;
            insert = entity.name.substring(this.text.length()) + ";";
            caret = 0;
        } else {
            throw new IllegalArgumentException("What's this? " + obj.getClass());
        }
        if (recorder != null) {
            recorder.recordInput(insert, false);
        }
        this.textArea.setSelectedText(insert);
        if (caret != 0) {
            String code = "textArea.setCaretPosition(textArea.getCaretPosition() - " + caret + ");";
            if (recorder != null) {
                recorder.record(code);
            }
            BeanShell.eval((View)this.view, (NameSpace)BeanShell.getNameSpace(), (String)code);
        }
    }
}

