/*
 * Decompiled with CFR 0.152.
 */
package xml.completion;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.gjt.sp.util.StandardUtilities;
import xml.NamespaceBindings;
import xml.completion.CompletionInfo;

public class ElementDecl {
    public CompletionInfo completionInfo;
    public String name;
    public boolean empty;
    public boolean any;
    public List<AttributeDecl> attributes;
    public Map<String, AttributeDecl> attributeHash;
    public Set<String> content;
    public Map<String, ElementDecl> elementHash;

    public ElementDecl(CompletionInfo completionInfo, String name, String content) {
        this.completionInfo = completionInfo;
        this.name = name;
        if (content != null) {
            this.setContent(content);
        }
        this.attributes = new ArrayList<AttributeDecl>();
        this.attributeHash = new HashMap<String, AttributeDecl>();
    }

    private ElementDecl(CompletionInfo completionInfo, String name, boolean empty, boolean any, List<AttributeDecl> attributes, Map<String, AttributeDecl> attributeHash, Set<String> content) {
        this.completionInfo = completionInfo;
        this.name = name;
        this.empty = empty;
        this.any = any;
        this.attributes = attributes;
        this.attributeHash = attributeHash;
        this.content = content;
    }

    public boolean isAbstract() {
        return false;
    }

    public void setContent(String content) {
        if (content.equals("EMPTY")) {
            this.empty = true;
        } else if (content.equals("ANY")) {
            this.any = true;
        } else {
            this.content = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(content, "(?*+|,) \t\n");
            while (st.hasMoreTokens()) {
                String element = st.nextToken();
                if (element.equals("#PCDATA")) continue;
                this.content.add(element);
            }
        }
    }

    public List<ElementDecl> getChildElements() {
        ArrayList<ElementDecl> children = new ArrayList<ElementDecl>(100);
        if (this.any) {
            children.addAll(this.completionInfo.elements);
        } else {
            children.addAll(this.completionInfo.elementsAllowedAnywhere);
            if (this.content != null) {
                Iterator<String> iter = this.content.iterator();
                while (iter.hasNext()) {
                    ElementDecl decl = null;
                    String n = iter.next();
                    decl = this.elementHash == null ? this.completionInfo.elementHash.get(n) : this.elementHash.get(n);
                    if (decl == null) continue;
                    if (decl.isAbstract()) {
                        children.addAll(decl.findReplacements());
                        continue;
                    }
                    children.add(decl);
                }
            }
        }
        return children;
    }

    public List<ElementDecl> findReplacements() {
        return null;
    }

    public AttributeDecl getAttribute(String attrname) {
        return this.attributeHash.get(attrname);
    }

    public void addAttribute(AttributeDecl attribute) {
        this.attributeHash.put(attribute.name, attribute);
        for (int i = 0; i < this.attributes.size(); ++i) {
            AttributeDecl attr = this.attributes.get(i);
            if (attr.name.compareTo(attribute.name) <= 0) continue;
            this.attributes.add(i, attribute);
            return;
        }
        this.attributes.add(attribute);
    }

    public String getRequiredAttributesString(NamespaceBindings namespaces, NamespaceBindings namespacesToInsert) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.attributes.size(); ++i) {
            AttributeDecl attrDecl = this.attributes.get(i);
            if (!attrDecl.required) continue;
            buf.append(' ');
            buf.append(NamespaceBindings.composeName(attrDecl.name, attrDecl.namespace, namespaces, namespacesToInsert, false));
            buf.append("=\"");
            if (attrDecl.value != null) {
                buf.append(attrDecl.value);
            }
            buf.append('\"');
        }
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<element name=\"");
        buf.append(this.name);
        buf.append('\"');
        buf.append("\ncontent=\"");
        if (this.empty) {
            buf.append("EMPTY");
        } else if (this.content != null) {
            buf.append('(');
            Iterator<String> iter = this.content.iterator();
            while (iter.hasNext()) {
                buf.append((Object)iter.next());
                if (!iter.hasNext()) continue;
                buf.append('|');
            }
            buf.append(')');
        }
        buf.append('\"');
        if (this.attributes.size() == 0) {
            buf.append(" />");
        } else {
            buf.append(">\n");
            for (int i = 0; i < this.attributes.size(); ++i) {
                buf.append(this.attributes.get(i));
                buf.append('\n');
            }
            buf.append("</element>");
        }
        return buf.toString();
    }

    public static class Compare
    implements Comparator<ElementDecl> {
        @Override
        public int compare(ElementDecl obj1, ElementDecl obj2) {
            return StandardUtilities.compareStrings((String)obj1.name, (String)obj2.name, (boolean)true);
        }
    }

    public static class AttributeDecl {
        public String name;
        public String namespace;
        public String value;
        public ArrayList values;
        public String type;
        public boolean required;

        public AttributeDecl(String name, String namespace, String value, ArrayList<String> values, String type, boolean required) {
            this.name = name;
            this.namespace = namespace;
            this.value = value;
            this.values = values;
            this.type = type;
            this.required = required;
        }

        public AttributeDecl copy() {
            return new AttributeDecl(this.name, this.namespace, this.value, this.values == null ? null : new ArrayList<String>(this.values), this.type, this.required);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("<attribute name=\"");
            buf.append(this.name);
            buf.append('\"');
            if (this.value != null) {
                buf.append(" value=\"");
                buf.append(this.value);
                buf.append('\"');
            }
            buf.append(" type=\"");
            buf.append(this.type);
            buf.append('\"');
            if (this.required) {
                buf.append(" required=\"true\"");
            }
            buf.append(" />");
            return buf.toString();
        }
    }
}

