/*
 * Decompiled with CFR 0.152.
 */
package xml.completion;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.gjt.sp.jedit.jEdit;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import xml.Resolver;
import xml.completion.CompletionInfo;
import xml.completion.ElementDecl;
import xml.completion.EntityDecl;

public class CompletionInfoHandler
extends DefaultHandler2 {
    private CompletionInfo completionInfo = new CompletionInfo();
    private Locator loc;
    private ElementDecl element;

    public CompletionInfo getCompletionInfo() {
        return this.completionInfo;
    }

    @Override
    public void setDocumentLocator(Locator loc) {
        this.loc = loc;
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException {
        try {
            return Resolver.instance().resolveEntity(name, publicId, baseURI, systemId);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        if (sName.equals("dtd")) {
            CompletionInfo extendInfo;
            String infoURI;
            String extend = attrs.getValue("extend");
            if (extend != null && (infoURI = jEdit.getProperty((String)("mode." + extend + ".xml.completion-info"))) != null && (extendInfo = CompletionInfo.getCompletionInfoFromResource(infoURI)) != null) {
                this.completionInfo = (CompletionInfo)extendInfo.clone();
            }
        } else if (sName.equals("entity")) {
            this.addEntity(new EntityDecl(0, attrs.getValue("name"), attrs.getValue("value")));
        } else if (sName.equals("element")) {
            this.element = new ElementDecl(this.completionInfo, attrs.getValue("name"), attrs.getValue("content"));
            this.completionInfo.elements.add(this.element);
            this.completionInfo.elementHash.put(this.element.name, this.element);
            if ("true".equals(attrs.getValue("anywhere"))) {
                this.completionInfo.elementsAllowedAnywhere.add(this.element);
            }
        } else if (sName.equals("attribute")) {
            ArrayList<String> values;
            String name = attrs.getValue("name");
            String value = attrs.getValue("value");
            String type = attrs.getValue("type");
            if (type.startsWith("(")) {
                values = new ArrayList<String>();
                StringTokenizer st = new StringTokenizer(type.substring(1, type.length() - 1), "|");
                while (st.hasMoreTokens()) {
                    values.add(st.nextToken());
                }
            } else {
                values = null;
            }
            boolean required = "true".equals(attrs.getValue("required"));
            this.element.addAttribute(new ElementDecl.AttributeDecl(name, null, value, values, type, required));
        }
    }

    private void addEntity(EntityDecl entity) {
        this.completionInfo.entities.add(entity);
        if (entity.type == 0 && entity.value.length() == 1) {
            Character ch = new Character(entity.value.charAt(0));
            this.completionInfo.entityHash.put(entity.name, ch);
            this.completionInfo.entityHash.put(ch, entity.name);
        }
    }
}

