/*
 * Decompiled with CFR 0.152.
 */
package xml.completion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.xerces.parsers.SAXParser;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.xml.sax.SAXException;
import xml.completion.CompletionInfoHandler;
import xml.completion.ElementDecl;
import xml.completion.EntityDecl;

public class CompletionInfo {
    public ArrayList<ElementDecl> elements;
    public HashMap<String, ElementDecl> elementHash;
    public ArrayList<EntityDecl> entities;
    public HashMap entityHash;
    public ArrayList elementsAllowedAnywhere;
    public String namespace;
    public boolean nameConflict;
    private static HashMap<Pattern, String> globs;
    private static HashMap<String, CompletionInfo> completionInfoResources;
    private static HashMap<String, Object> completionInfoNamespaces;
    private static Object lock;

    public CompletionInfo() {
        this(new ArrayList<ElementDecl>(), new HashMap<String, ElementDecl>(), new ArrayList<EntityDecl>(), new HashMap(), new ArrayList());
        this.addEntity(0, "lt", "<");
        this.addEntity(0, "gt", ">");
        this.addEntity(0, "amp", "&");
        this.addEntity(0, "quot", "\"");
        this.addEntity(0, "apos", "'");
    }

    public CompletionInfo(ArrayList<ElementDecl> elements, HashMap<String, ElementDecl> elementHash, ArrayList<EntityDecl> entities, HashMap entityHash, ArrayList elementsAllowedAnywhere) {
        this.elements = elements;
        this.elementHash = elementHash;
        this.entities = entities;
        this.entityHash = entityHash;
        this.elementsAllowedAnywhere = elementsAllowedAnywhere;
    }

    public void addEntity(int type, String name, String value) {
        this.addEntity(new EntityDecl(type, name, value));
    }

    public void addEntity(int type, String name, String publicId, String systemId) {
        this.addEntity(new EntityDecl(type, name, publicId, systemId));
    }

    public void addEntity(EntityDecl entity) {
        this.entities.add(entity);
        if (entity.type == 0 && entity.value.length() == 1) {
            Character ch = new Character(entity.value.charAt(0));
            this.entityHash.put(entity.name, ch);
            this.entityHash.put(ch, entity.name);
        }
    }

    public void addElement(ElementDecl element) {
        this.elementHash.put(element.name, element);
        this.elements.add(element);
    }

    public void getAllElements(List<ElementDecl> out) {
        for (ElementDecl decl : this.elementHash.values()) {
            if (decl.isAbstract()) {
                List<ElementDecl> repls = decl.findReplacements();
                out.addAll(repls);
                continue;
            }
            out.add(decl);
        }
    }

    public ElementDecl getElementDeclLocal(String localName) {
        for (ElementDecl e : this.elements) {
            if (!localName.equals(e.name)) continue;
            return e;
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<element-list>\n\n");
        for (int i = 0; i < this.elements.size(); ++i) {
            buf.append(this.elements.get(i));
            buf.append('\n');
        }
        buf.append("\n</element-list>\n\n<entity-list>\n\n");
        buf.append("<!-- not implemented yet -->\n");
        buf.append("\n</entity-list>");
        return buf.toString();
    }

    public static CompletionInfo getCompletionInfoForBuffer(Buffer buffer) {
        CompletionInfo info;
        for (Pattern re : globs.keySet()) {
            Matcher m = re.matcher(buffer.getName());
            if (!m.matches()) continue;
            return CompletionInfo.getCompletionInfoFromResource(globs.get(re));
        }
        String resource = jEdit.getProperty((String)("mode." + buffer.getMode().getName() + ".xml.completion-info"));
        if (resource != null && (info = CompletionInfo.getCompletionInfoFromResource(resource)) != null) {
            return info;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompletionInfo getCompletionInfoForNamespace(String namespace) {
        Object object = lock;
        synchronized (object) {
            Object obj = completionInfoNamespaces.get(namespace);
            if (obj instanceof String) {
                CompletionInfo info = CompletionInfo.getCompletionInfoFromResource((String)obj);
                info.namespace = namespace;
                completionInfoNamespaces.put(namespace, info);
                return info;
            }
            return (CompletionInfo)obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompletionInfo getCompletionInfoFromResource(String resource) {
        Object object = lock;
        synchronized (object) {
            CompletionInfo info = completionInfoResources.get(resource);
            if (info != null) {
                return info;
            }
            Log.log((int)1, CompletionInfo.class, (Object)("Loading " + resource));
            CompletionInfoHandler handler = new CompletionInfoHandler();
            try {
                SAXParser parser = new SAXParser();
                parser.setFeature("http://apache.org/xml/features/validation/dynamic", true);
                parser.setFeature("http://xml.org/sax/features/use-entity-resolver2", true);
                parser.setErrorHandler(handler);
                parser.setEntityResolver(handler);
                parser.setContentHandler(handler);
                parser.parse(resource);
            }
            catch (SAXException se) {
                Exception e = se.getException();
                if (e == null) {
                    e = se;
                }
                Log.log((int)9, CompletionInfo.class, (Object)e);
            }
            catch (Exception e) {
                Log.log((int)9, CompletionInfo.class, (Object)e);
            }
            info = handler.getCompletionInfo();
            completionInfoResources.put(resource, info);
            return info;
        }
    }

    public Object clone() {
        return new CompletionInfo((ArrayList)this.elements.clone(), (HashMap)this.elementHash.clone(), (ArrayList)this.entities.clone(), (HashMap)this.entityHash.clone(), (ArrayList)this.elementsAllowedAnywhere.clone());
    }

    static {
        String namespace;
        String glob;
        completionInfoResources = new HashMap();
        globs = new HashMap();
        int i = 0;
        while ((glob = jEdit.getProperty((String)("xml.completion.glob." + i + ".key"))) != null) {
            String info = jEdit.getProperty((String)("xml.completion.glob." + i + ".value"));
            try {
                globs.put(Pattern.compile(StandardUtilities.globToRE((String)glob), 2), info);
            }
            catch (PatternSyntaxException pse) {
                Log.log((int)9, CompletionInfo.class, (Object)pse);
            }
            ++i;
        }
        completionInfoNamespaces = new HashMap();
        i = 0;
        while ((namespace = jEdit.getProperty((String)("xml.completion.namespace." + i + ".key"))) != null) {
            String info = jEdit.getProperty((String)("xml.completion.namespace." + i + ".value"));
            completionInfoNamespaces.put(namespace, info);
            ++i;
        }
        lock = new Object();
    }
}

