/*
 * Decompiled with CFR 0.152.
 */
package xml.completion;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.ref.Reference;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class AntCompleteTask
extends Task {
    private static final String BOOLEAN = "(true|false|on|off|yes|no)";
    private String TASKS;
    private String TYPES;
    private Hashtable visited = new Hashtable();
    private File output;

    public void setOutput(File output) {
        this.output = output;
    }

    public void execute() throws BuildException {
        if (this.output == null) {
            throw new BuildException("output attribute is required", this.getLocation());
        }
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.output), "UTF8"));
            }
            catch (UnsupportedEncodingException ue) {
                out = new PrintWriter(new FileWriter(this.output));
            }
            this.TASKS = this.getList(this.getProject().getTaskDefinitions().keys());
            this.TYPES = this.getList(this.getProject().getDataTypeDefinitions().keys());
            out.println("<element-list>");
            out.println("");
            this.printProjectDecl(out);
            this.printTargetDecl(out);
            Enumeration types = this.getProject().getDataTypeDefinitions().keys();
            while (types.hasMoreElements()) {
                String typeName = (String)types.nextElement();
                this.printElementDecl(out, typeName, (Class)this.getProject().getDataTypeDefinitions().get(typeName));
            }
            Enumeration tasks = this.getProject().getTaskDefinitions().keys();
            while (tasks.hasMoreElements()) {
                String taskName = (String)tasks.nextElement();
                this.printElementDecl(out, taskName, (Class)this.getProject().getTaskDefinitions().get(taskName));
            }
            out.println("");
            out.print("</element-list>");
        }
        catch (IOException ioe) {
            throw new BuildException("Error writing " + this.output.getAbsolutePath(), (Throwable)ioe, this.getLocation());
        }
        finally {
            if (out != null) {
                out.close();
            }
            this.visited.clear();
        }
    }

    private String getList(Enumeration e) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        while (e.hasMoreElements()) {
            if (!first) {
                sb.append('|');
            } else {
                first = false;
            }
            sb.append(e.nextElement().toString());
        }
        return sb.toString();
    }

    private void printElementOpen(PrintWriter out, String name, String content) {
        content = null == content ? "EMPTY" : '(' + content + ')';
        out.print("<element name=\"");
        out.print(name);
        out.println('\"');
        out.print("content=\"");
        out.print(content);
        out.println("\">");
    }

    private void printElementClose(PrintWriter out) {
        out.println("</element>");
    }

    private void printAttribute(PrintWriter out, String name, String type, boolean required) {
        out.print("<attribute name=\"");
        out.print(name);
        out.print("\" type=\"");
        out.print(type);
        out.print("\" ");
        if (required) {
            out.print("required=\"true\" ");
        }
        out.println("/>");
    }

    private void printProjectDecl(PrintWriter out) {
        this.visited.put("project", "");
        this.printElementOpen(out, "project", "target|" + this.TYPES + '|' + this.TASKS);
        this.printAttribute(out, "basedir", "CDATA", false);
        this.printAttribute(out, "default", "CDATA", true);
        this.printAttribute(out, "name", "CDATA", false);
        this.printElementClose(out);
    }

    private void printTargetDecl(PrintWriter out) {
        this.visited.put("target", "");
        this.printElementOpen(out, "target", this.TYPES + '|' + this.TASKS);
        this.printAttribute(out, "id", "ID", false);
        this.printAttribute(out, "name", "CDATA", true);
        this.printAttribute(out, "if", "CDATA", false);
        this.printAttribute(out, "unless", "CDATA", false);
        this.printAttribute(out, "depends", "CDATA", false);
        this.printAttribute(out, "description", "CDATA", false);
        this.printElementClose(out);
    }

    private void printElementDecl(PrintWriter out, String name, Class element) throws BuildException {
        int i;
        int count;
        if (this.visited.containsKey(name)) {
            return;
        }
        this.visited.put(name, "");
        if (org.apache.tools.ant.types.Reference.class.equals((Object)element)) {
            this.printElementOpen(out, name, null);
            this.printAttribute(out, "id", "ID", false);
            this.printAttribute(out, "refid", "IDREF", false);
            this.printElementClose(out);
            return;
        }
        IntrospectionHelper ih = null;
        try {
            ih = IntrospectionHelper.getHelper((Class)element);
        }
        catch (Throwable t) {
            return;
        }
        Vector<String> v = new Vector<String>();
        if (ih.supportsCharacters()) {
            v.addElement("");
        }
        if (TaskContainer.class.isAssignableFrom(element)) {
            v.addElement(this.TASKS);
        }
        Enumeration e = ih.getNestedElements();
        while (e.hasMoreElements()) {
            v.addElement((String)e.nextElement());
        }
        StringBuffer sb = null;
        String content = null;
        if (!v.isEmpty()) {
            sb = new StringBuffer();
            count = v.size();
            for (i = 0; i < count; ++i) {
                if (i != 0) {
                    sb.append("|");
                }
                sb.append(v.elementAt(i));
            }
            content = sb.toString();
        }
        this.printElementOpen(out, name, content);
        this.printAttribute(out, "id", "ID", false);
        e = ih.getAttributes();
        while (e.hasMoreElements()) {
            String attrName = (String)e.nextElement();
            if ("id".equals(attrName)) continue;
            String attrType = "CDATA";
            Class type = ih.getAttributeType(attrName);
            if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                attrType = BOOLEAN;
            } else if (Reference.class.isAssignableFrom(type)) {
                attrType = "IDREF";
            } else if (EnumeratedAttribute.class.isAssignableFrom(type)) {
                try {
                    EnumeratedAttribute ea = (EnumeratedAttribute)type.newInstance();
                    String[] values = ea.getValues();
                    if (values != null && values.length != 0 && this.areNmtokens(values)) {
                        sb = new StringBuffer("(");
                        for (int i2 = 0; i2 < values.length; ++i2) {
                            if (i2 != 0) {
                                sb.append("|");
                            }
                            sb.append(values[i2]);
                        }
                        sb.append(")");
                    }
                }
                catch (InstantiationException ie) {
                    attrType = "CDATA";
                }
                catch (IllegalAccessException ie) {
                    attrType = "CDATA";
                }
            }
            this.printAttribute(out, attrName, attrType, false);
        }
        this.printElementClose(out);
        count = v.size();
        for (i = 0; i < count; ++i) {
            String nestedName = (String)v.elementAt(i);
            if ("".equals(nestedName) || this.TASKS.equals(nestedName) || this.TYPES.equals(nestedName)) continue;
            this.printElementDecl(out, nestedName, ih.getElementType(nestedName));
        }
    }

    protected boolean isNmtoken(String s) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '-' || c == '_' || c == ':') continue;
            return false;
        }
        return true;
    }

    protected boolean areNmtokens(String[] s) {
        for (int i = 0; i < s.length; ++i) {
            if (this.isNmtoken(s[i])) continue;
            return false;
        }
        return true;
    }
}

