/*
 * Decompiled with CFR 0.152.
 */
package xml.cache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gjt.sp.jedit.Buffer;

public class CacheEntry {
    private final String path;
    private final Object key;
    private final Object value;
    private List<CacheEntry> related;
    private Set<Buffer> requestingBuffers;

    public CacheEntry(String path, Object key, Object value) {
        if (path == null) {
            throw new IllegalArgumentException("path may not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key may not be null");
        }
        this.path = path;
        this.key = key;
        this.value = value;
        this.related = new ArrayList<CacheEntry>();
        this.requestingBuffers = new HashSet<Buffer>();
    }

    public Set<Buffer> getRequestingBuffers() {
        return this.requestingBuffers;
    }

    public void addRequestingBuffer(Buffer b) {
        this.addRequestingBufferReq(new HashSet<CacheEntry>(), b);
    }

    private void addRequestingBufferReq(Set<CacheEntry> visited, Buffer b) {
        this.requestingBuffers.add(b);
        visited.add(this);
        for (CacheEntry en : this.related) {
            if (visited.contains(en)) continue;
            en.addRequestingBufferReq(visited, b);
        }
    }

    public List<CacheEntry> getRelated() {
        return this.related;
    }

    public Object getCachedItem() {
        return this.value;
    }

    public Object getKey() {
        return this.key;
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof CacheEntry)) {
            return false;
        }
        CacheEntry o = (CacheEntry)other;
        return o.path == this.path && o.key == this.key;
    }

    public int hashCode() {
        return 53 + this.path.hashCode() + this.key.hashCode() * 2013;
    }

    public String toString() {
        return "CacheEntry[" + this.path.toString() + "," + this.key.toString() + "=" + (this.value == null ? null : this.value.getClass()) + "]";
    }
}

