/*
 * Decompiled with CFR 0.152.
 */
package xml.cache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.buffer.BufferAdapter;
import org.gjt.sp.jedit.buffer.BufferListener;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import xml.PathUtilities;
import xml.cache.CacheEntry;

public final class Cache
extends BufferAdapter {
    private static final String DISABLE_PROP = "xml.cache.disable-cache";
    private static Cache instance;
    private Set<CacheEntry> entries = new HashSet<CacheEntry>();
    private boolean disabled = jEdit.getBooleanProperty((String)"xml.cache.disable-cache");

    private Cache() {
    }

    public static Cache instance() {
        if (instance == null) {
            instance = new Cache();
        }
        return instance;
    }

    public CacheEntry put(String path, Object key, Object value) {
        CacheEntry en;
        if (this.disabled) {
            return null;
        }
        String npath = PathUtilities.urlToPath(path);
        if (npath != path) {
            path = npath;
        }
        if (!this.entries.contains(en = new CacheEntry(path, key, value))) {
            this.entries.add(en);
        }
        return en;
    }

    public CacheEntry get(String path, Object key) {
        if (this.disabled) {
            return null;
        }
        String npath = PathUtilities.urlToPath(path);
        if (npath != path) {
            path = npath;
        }
        for (CacheEntry en : this.entries) {
            if (!en.getPath().equals(path) || !en.getKey().equals(key)) continue;
            return en;
        }
        return null;
    }

    public void contentInserted(JEditBuffer buffer, int startLine, int offset, int numLines, int length) {
        this.handleBufferContentChanged((Buffer)buffer);
    }

    public void contentRemoved(JEditBuffer buffer, int startLine, int offset, int numLines, int length) {
        this.handleBufferContentChanged((Buffer)buffer);
    }

    public void transactionComplete(JEditBuffer buffer) {
        this.handleBufferContentChanged((Buffer)buffer);
    }

    @EditBus.EBHandler
    public void handleBufferUpdate(BufferUpdate message) {
        if (BufferUpdate.CLOSED.equals(message.getWhat())) {
            this.invalidateCacheEntriesFromPath(message.getBuffer().getPath());
            this.invalidateCacheEntriesRequiredByBuffer(message.getBuffer());
            message.getBuffer().removeBufferListener((BufferListener)this);
        } else if (BufferUpdate.LOADED.equals(message.getWhat())) {
            this.invalidateCacheEntriesFromPath(message.getBuffer().getPath());
            message.getBuffer().addBufferListener((BufferListener)this);
        }
    }

    public void handleBufferContentChanged(Buffer buffer) {
        this.invalidateCacheEntriesFromPath(buffer.getPath());
    }

    private void invalidateCacheEntriesFromPath(String path) {
        ArrayList<CacheEntry> toRemove = new ArrayList<CacheEntry>();
        Iterator<CacheEntry> it = this.entries.iterator();
        while (it.hasNext()) {
            CacheEntry en = it.next();
            if (!en.getPath().equals(path)) continue;
            it.remove();
            toRemove.addAll(en.getRelated());
        }
        this.removeRelated(new HashSet<CacheEntry>(), toRemove);
    }

    private void invalidateCacheEntriesRequiredByBuffer(Buffer b) {
        ArrayList<CacheEntry> toRemove = new ArrayList<CacheEntry>();
        Iterator<CacheEntry> it = this.entries.iterator();
        while (it.hasNext()) {
            CacheEntry en = it.next();
            Set<Buffer> reqB = en.getRequestingBuffers();
            if (!reqB.contains(b)) continue;
            reqB.remove(b);
            if (!reqB.isEmpty()) continue;
            it.remove();
            toRemove.addAll(en.getRelated());
        }
        this.removeRelated(new HashSet<CacheEntry>(), toRemove);
    }

    private void removeRelated(Set<CacheEntry> removed, List<CacheEntry> toRemove) {
        for (CacheEntry ce : toRemove) {
            if (removed.contains(ce)) continue;
            this.entries.remove(ce);
            removed.add(ce);
            this.removeRelated(removed, ce.getRelated());
        }
    }

    public void start() {
        EditBus.addToBus((Object)((Object)this));
    }

    public void stop() {
        EditBus.removeFromBus((Object)((Object)this));
        for (Buffer b : jEdit.getBuffers()) {
            b.removeBufferListener((BufferListener)this);
        }
        this.entries.clear();
        instance = null;
    }

    public void clear() {
        this.entries.clear();
    }

    public void disable() {
        this.disabled = true;
        jEdit.setBooleanProperty((String)DISABLE_PROP, (boolean)true);
    }

    public void enable() {
        this.disabled = false;
        jEdit.unsetProperty((String)DISABLE_PROP);
    }
}

