/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ProgressObserver;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.ThreadUtilities;
import sidekick.SideKickPlugin;
import xml.Resolver;
import xml.SchemaMappingManager;
import xml.TemplatesManager;
import xml.XmlActions;
import xml.cache.Cache;
import xml.parser.XmlParser;
import xml.translate.TrangTranslator;

public class XmlPlugin
extends EBPlugin {
    private TagMouseHandler tagMouseHandler;

    public void start() {
        View view;
        Resolver.instance().init();
        Resolver.instance().propertiesChanged();
        XmlActions.propertiesChanged();
        this.tagMouseHandler = new TagMouseHandler();
        for (view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] panes = view.getEditPanes();
            for (int i = 0; i < panes.length; ++i) {
                panes[i].getTextArea().getPainter().addMouseListener((MouseListener)this.tagMouseHandler);
            }
        }
        SchemaMappingManager.initGlobalSchemaMapping(view);
        Cache.instance().start();
        EditPlugin templatesPlugin = jEdit.getPlugin((String)"templates.TemplatesPlugin", (boolean)false);
        if (templatesPlugin == null) {
            Log.log((int)3, XmlPlugin.class, (Object)"Templates plugin is not installed, so templates won't be copied");
        } else {
            Log.log((int)1, XmlPlugin.class, (Object)"Will install template files");
            ThreadUtilities.runInBackground((Task)new Task(){

                public String getLabel() {
                    return "XML: install template files";
                }

                public void _run() {
                    Log.log((int)1, XmlPlugin.class, (Object)"Will install template files");
                    TemplatesManager.installTemplates((ProgressObserver)this, XmlPlugin.this.getPluginJAR());
                }
            });
        }
    }

    public void stop() {
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            EditPane[] panes = view.getEditPanes();
            for (int i = 0; i < panes.length; ++i) {
                panes[i].getTextArea().getPainter().removeMouseListener((MouseListener)this.tagMouseHandler);
            }
        }
        Resolver.instance().save();
        Resolver.instance().uninit();
        TrangTranslator.stop();
        Cache.instance().stop();
    }

    public void handleMessage(EBMessage msg) {
        if (msg instanceof EditPaneUpdate) {
            EditPaneUpdate epu = (EditPaneUpdate)msg;
            EditPane editPane = epu.getEditPane();
            if (epu.getWhat() == EditPaneUpdate.CREATED) {
                editPane.getTextArea().getPainter().addMouseListener((MouseListener)this.tagMouseHandler);
            } else if (epu.getWhat() == EditPaneUpdate.DESTROYED) {
                editPane.getTextArea().getPainter().removeMouseListener((MouseListener)this.tagMouseHandler);
            }
        } else if (msg instanceof PropertiesChanged) {
            XmlActions.propertiesChanged();
            Resolver.instance().propertiesChanged();
        }
    }

    public static boolean isDelegated(JEditTextArea textArea) {
        return XmlPlugin.isDelegated((TextArea)textArea);
    }

    public static boolean isDelegated(TextArea textArea) {
        JEditBuffer buffer = textArea.getBuffer();
        ParserRuleSet rules = buffer.getRuleSetAtOffset(textArea.getCaretPosition());
        String rulesetName = rules.getSetName();
        String modeName = rules.getModeName();
        if (rulesetName != null && (rulesetName.startsWith("PHP") || rulesetName.equals("CDATA"))) {
            return true;
        }
        return jEdit.getProperty((String)("mode." + modeName + "." + "sidekick.parser")) == null;
    }

    static class TagMouseHandler
    extends MouseAdapter {
        TagMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (evt.getClickCount() == 2 && (OperatingSystem.isMacOS() && evt.isMetaDown() || !OperatingSystem.isMacOS() && evt.isControlDown())) {
                final View view = GUIUtilities.getView((Component)((Component)evt.getSource()));
                if (!(SideKickPlugin.getParserForBuffer((Buffer)view.getBuffer()) instanceof XmlParser)) {
                    return;
                }
                JEditTextArea textArea = view.getTextArea();
                textArea.setCaretPosition(textArea.xyToOffset(evt.getX(), evt.getY()));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        XmlActions.showEditTagDialog(view);
                    }
                });
            }
        }
    }
}

