/*
 * Decompiled with CFR 0.152.
 */
package xml;

import com.thaiopensource.xml.util.Name;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.util.StandardUtilities;
import sidekick.ExpansionModel;
import sidekick.IAsset;
import sidekick.SideKickParsedData;
import xml.NamespaceBindings;
import xml.completion.CompletionInfo;
import xml.completion.ElementDecl;
import xml.completion.EntityDecl;
import xml.completion.IDDecl;
import xml.parser.TagParser;
import xml.parser.XmlTag;

public class XmlParsedData
extends SideKickParsedData {
    public static final int SORT_BY_NAME = 0;
    public static final int SORT_BY_LINE = 1;
    public static final int SORT_BY_TYPE = 2;
    private static int sortBy = 1;
    protected static boolean sortDown = true;
    public boolean html;
    public boolean allNamespacesBindingsAtTop;
    private Map<String, CompletionInfo> mappings;
    public Map<String, IDDecl> ids;
    public List<EntityDecl> entities;
    public Map entityHash;

    public void setCompletionInfo(String namespace, CompletionInfo info) {
        if (namespace == null) {
            namespace = "";
        }
        this.mappings.put(namespace, info);
        if (info == null) {
            throw new UnsupportedOperationException("setCompletionInfo(" + namespace + ",null");
        }
        for (EntityDecl en : info.entities) {
            if (this.entityHash.containsKey(en.name)) continue;
            this.addEntity(en);
        }
    }

    public XmlParsedData(String fileName, boolean html) {
        super(fileName);
        this.html = html;
        this.mappings = new HashMap<String, CompletionInfo>();
        this.ids = new TreeMap<String, IDDecl>(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return StandardUtilities.compareStrings((String)s1, (String)s2, (boolean)false);
            }
        });
        this.allNamespacesBindingsAtTop = true;
        this.entities = new ArrayList<EntityDecl>();
        this.entityHash = new HashMap();
        this.setCompletionInfo("", this.getNoNamespaceCompletionInfo());
    }

    public CompletionInfo getNoNamespaceCompletionInfo() {
        CompletionInfo info = this.mappings.get("");
        if (info == null) {
            info = new CompletionInfo();
            this.mappings.put("", info);
        }
        return info;
    }

    public CompletionInfo getCompletionInfo(String ns) {
        return this.mappings.get(ns);
    }

    public ElementDecl getElementDecl(String name, int pos) {
        String localName;
        ElementDecl decl = null;
        String prefix = XmlParsedData.getElementNamePrefix(name);
        String string = localName = "".equals(prefix) ? name : name.substring(prefix.length() + 1);
        if (this.html) {
            decl = this.getElementDeclHTML(name, pos);
        } else {
            CompletionInfo info;
            TreePath path = null;
            NamespaceBindings bindings = null;
            if (this.allNamespacesBindingsAtTop) {
                bindings = this.getRootNamespaceBindings();
            } else {
                path = this.getTreePathForPosition(pos);
                bindings = this.getNamespaceBindings(path);
            }
            if (this.mappings.isEmpty()) {
                return null;
            }
            if (this.mappings.size() == 1) {
                info = this.mappings.values().iterator().next();
            } else {
                String NS = bindings.getNamespace(prefix);
                info = this.mappings.get(NS);
            }
            if (info != null) {
                if (info.nameConflict) {
                    DefaultMutableTreeNode parentNode;
                    XmlTag parentXmlTag;
                    if (path == null) {
                        path = this.getTreePathForPosition(pos);
                    }
                    decl = name.equals((parentXmlTag = (XmlTag)((Object)(parentNode = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject())).getName()) ? this.getElementDeclFromSideKick(parentNode, parentXmlTag) : null;
                } else {
                    decl = info.elementHash.containsKey(localName) ? info.elementHash.get(localName) : info.getElementDeclLocal(localName);
                }
            }
        }
        return decl;
    }

    private ElementDecl getElementDeclHTML(String name, int pos) {
        CompletionInfo info;
        if (this.html) {
            name = name.toLowerCase();
        }
        String prefix = XmlParsedData.getElementNamePrefix(name);
        if (this.mappings.isEmpty()) {
            return null;
        }
        if (this.mappings.size() == 1) {
            info = this.mappings.values().iterator().next();
        } else {
            String ns = this.getNamespaceForPrefix(prefix, pos);
            info = this.mappings.get(ns);
        }
        if (info == null) {
            return null;
        }
        String lName = XmlParsedData.getElementLocalName(name);
        ElementDecl decl = info.elementHash.get(lName);
        if (decl == null) {
            return null;
        }
        return decl;
    }

    private ElementDecl getElementDeclFromSideKick(DefaultMutableTreeNode node, XmlTag tag) {
        CompletionInfo info = this.mappings.get(tag.namespace);
        if (info == null) {
            return null;
        }
        String prefix = tag.getPrefix();
        String lName = tag.getLocalName();
        if (!info.nameConflict && info.elementHash != null) {
            return info.elementHash.get(lName);
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
        if (parentNode.getUserObject() instanceof XmlTag) {
            XmlTag parentTag = (XmlTag)((Object)parentNode.getUserObject());
            ElementDecl parentDecl = this.getElementDeclFromSideKick(parentNode, parentTag);
            if (parentDecl != null && parentDecl.elementHash != null && parentDecl.elementHash.containsKey(lName)) {
                return parentDecl.elementHash.get(lName);
            }
        } else if (info.elementHash != null) {
            return info.elementHash.get(lName);
        }
        return null;
    }

    public String getXPathForPosition(int pos) {
        TreePath path = this.getTreePathForPosition(pos);
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode tn = (DefaultMutableTreeNode)path.getLastPathComponent();
        TreeNode[] steps = tn.getPath();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)steps[0];
        StringBuilder xpath = new StringBuilder();
        if (steps.length == 1) {
            xpath = null;
        } else {
            int i;
            parent = (DefaultMutableTreeNode)steps[1];
            if (!(parent.getUserObject() instanceof XmlTag)) {
                return null;
            }
            HashMap<String, String> prefixToNS = new HashMap<String, String>();
            HashMap<String, String> nsToPrefix = new HashMap<String, String>();
            Name[] preXPath = new Name[steps.length - 2];
            int[] preXPathIndexes = new int[steps.length - 2];
            XmlTag curTag = (XmlTag)((Object)parent.getUserObject());
            String lname = curTag.getLocalName();
            String ns = curTag.namespace;
            StringBuilder prefix = new StringBuilder(curTag.getPrefix());
            assert (ns != null);
            Name rootName = new Name(ns, lname);
            prefixToNS.put(prefix.toString(), ns);
            nsToPrefix.put(ns, prefix.toString());
            for (i = 2; i < steps.length; ++i) {
                DefaultMutableTreeNode cur = (DefaultMutableTreeNode)steps[i];
                curTag = (XmlTag)((Object)cur.getUserObject());
                ns = curTag.namespace;
                lname = curTag.getLocalName();
                prefix = new StringBuilder(curTag.getPrefix());
                int jCur = parent.getIndex(cur);
                int cntChild = 0;
                for (int j = 0; j <= jCur; ++j) {
                    DefaultMutableTreeNode aChild = (DefaultMutableTreeNode)parent.getChildAt(j);
                    XmlTag aTag = (XmlTag)((Object)aChild.getUserObject());
                    if (!lname.equals(aTag.getLocalName()) || !ns.equals(aTag.namespace)) continue;
                    ++cntChild;
                }
                preXPath[i - 2] = new Name(ns, lname);
                preXPathIndexes[i - 2] = cntChild;
                if (!nsToPrefix.containsKey(ns)) {
                    if (prefixToNS.containsKey(prefix) && !((String)prefixToNS.get(prefix)).equals(ns)) {
                        int uniq = 0;
                        if ("".equals(prefix)) {
                            prefix.append(' ');
                        }
                        while (prefixToNS.containsKey(prefix.toString() + uniq)) {
                            ++uniq;
                        }
                        prefix.append(uniq);
                    }
                    prefixToNS.put(prefix.toString(), ns);
                    nsToPrefix.put(ns, prefix.toString());
                }
                parent = cur;
            }
            prefix = new StringBuilder((String)nsToPrefix.get(rootName.getNamespaceUri()));
            xpath.append('/');
            if (prefix.length() > 0) {
                xpath.append((CharSequence)prefix).append(':');
            }
            xpath.append(rootName.getLocalName());
            for (i = 0; i < preXPath.length; ++i) {
                prefix = new StringBuilder((String)nsToPrefix.get(preXPath[i].getNamespaceUri()));
                xpath.append('/');
                if (prefix.length() > 0) {
                    xpath.append((CharSequence)prefix).append(':');
                }
                xpath.append(preXPath[i].getLocalName());
                xpath.append('[').append(preXPathIndexes[i]).append(']');
            }
        }
        return xpath == null ? null : xpath.toString();
    }

    public List<ElementDecl> getAllowedElements(Buffer buffer, int pos) {
        IAsset asset = this.getAssetAtOffset(pos);
        LinkedList<ElementDecl> returnValue = new LinkedList<ElementDecl>();
        TagParser.Tag parentTag = null;
        try {
            parentTag = TagParser.findLastOpenTag(buffer.getText(0, pos), pos, this);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (parentTag == null) {
            for (CompletionInfo info : this.mappings.values()) {
                info.getAllElements(returnValue);
            }
        } else {
            ElementDecl parentDecl = null;
            parentDecl = this.getElementDecl(parentTag.tag, parentTag.start + 1);
            if (parentDecl != null) {
                returnValue.addAll(parentDecl.getChildElements());
            }
        }
        Collections.sort(returnValue, new ElementDecl.Compare());
        return returnValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<ElementDecl> getAllowedElements(Buffer buffer, int startPos, int endPos) {
        ArrayList<ElementDecl> returnValue = new ArrayList<ElementDecl>();
        CharSequence bufferText = buffer.getSegment(0, buffer.getLength());
        if (TagParser.isInsideTag(bufferText, startPos)) {
            return returnValue;
        }
        if (TagParser.isInsideTag(bufferText, endPos)) {
            return returnValue;
        }
        TagParser.Tag startParentTag = TagParser.findLastOpenTag(bufferText, startPos, this);
        TagParser.Tag endParentTag = TagParser.findLastOpenTag(bufferText, endPos, this);
        if (startParentTag == null) {
            if (endParentTag != null) return returnValue;
            for (CompletionInfo info : this.mappings.values()) {
                info.getAllElements(returnValue);
            }
        } else {
            if (endParentTag == null) {
                return returnValue;
            }
            ElementDecl startParentDecl = this.getElementDecl(startParentTag.tag, startParentTag.start + 1);
            ElementDecl endParentDecl = this.getElementDecl(endParentTag.tag, endParentTag.start + 1);
            if (startParentDecl == null) {
                return returnValue;
            }
            if (endParentDecl == null) {
                return returnValue;
            }
            returnValue.addAll(startParentDecl.getChildElements());
            returnValue.retainAll(endParentDecl.getChildElements());
        }
        Collections.sort(returnValue, new ElementDecl.Compare());
        return returnValue;
    }

    public NamespaceBindings getNamespaceBindings(int pos) {
        if (this.html) {
            return new NamespaceBindings();
        }
        if (this.allNamespacesBindingsAtTop) {
            return this.getRootNamespaceBindings();
        }
        TreePath path = this.getTreePathForPosition(pos);
        if (path == null) {
            return null;
        }
        return this.getNamespaceBindings(path);
    }

    private NamespaceBindings getNamespaceBindings(TreePath path) {
        NamespaceBindings bindings = new NamespaceBindings();
        if (path == null) {
            return bindings;
        }
        if (this.html) {
            return bindings;
        }
        Object[] pathObjs = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObjectPath();
        for (int i = 1; i < pathObjs.length; ++i) {
            XmlTag t = (XmlTag)((Object)pathObjs[i]);
            if (t.namespaceBindings == null) continue;
            bindings.putAll(t.namespaceBindings);
        }
        return bindings;
    }

    private NamespaceBindings getRootNamespaceBindings() {
        NamespaceBindings bindings;
        if (!this.html && this.root != null && this.root.getChildCount() > 0) {
            TreeNode node = this.root.getChildAt(0);
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)node;
            Object o = dmtn.getUserObject();
            if (o instanceof XmlTag) {
                bindings = ((XmlTag)((Object)o)).namespaceBindings;
                if (bindings == null) {
                    bindings = new NamespaceBindings();
                }
            } else {
                bindings = new NamespaceBindings();
            }
        } else {
            bindings = new NamespaceBindings();
        }
        return bindings;
    }

    private String getNamespaceForPrefix(String prefix, int pos) {
        if (this.html) {
            return null;
        }
        if (this.allNamespacesBindingsAtTop) {
            String ns;
            NamespaceBindings bindings = this.getRootNamespaceBindings();
            if (bindings != null && (ns = bindings.getNamespace(prefix)) != null) {
                return ns;
            }
        } else {
            TreePath path = this.getTreePathForPosition(pos);
            if (path == null) {
                return null;
            }
            Object[] pathObjs = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObjectPath();
            for (int i = pathObjs.length - 1; i > 0; --i) {
                String ns;
                XmlTag t = (XmlTag)((Object)pathObjs[i]);
                if (t.namespaceBindings == null || "".equals(ns = t.namespaceBindings.getNamespace(prefix))) continue;
                return ns;
            }
        }
        if ("".equals(prefix)) {
            return "";
        }
        return null;
    }

    public void done(View view) {
        this.sort(view);
    }

    public void setSortBy(int by) {
        switch (by) {
            case 0: 
            case 1: 
            case 2: {
                sortBy = by;
            }
        }
    }

    public int getSortBy() {
        return sortBy;
    }

    public void setSortDirection(boolean down) {
        sortDown = down;
    }

    public void sort(View view) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                XmlParsedData.this.sortChildren(XmlParsedData.this.root);
                XmlParsedData.this.tree.reload();
                XmlParsedData.this.expansionModel = XmlParsedData.this.createExpansionModel().getModel();
            }
        });
    }

    private void sortChildren(DefaultMutableTreeNode node) {
        ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            children.add((DefaultMutableTreeNode)en.nextElement());
        }
        Collections.sort(children, this.getSorter());
        node.removeAllChildren();
        for (DefaultMutableTreeNode child : children) {
            node.add(child);
            this.sortChildren(child);
        }
    }

    protected Comparator<DefaultMutableTreeNode> getSorter() {
        return new Comparator<DefaultMutableTreeNode>(){

            @Override
            public int compare(DefaultMutableTreeNode tna, DefaultMutableTreeNode tnb) {
                int sortBy = XmlParsedData.this.getSortBy();
                switch (sortBy) {
                    case 1: {
                        Integer my_line = new Integer(((XmlTag)((Object)tna.getUserObject())).getStart().getOffset());
                        Integer other_line = new Integer(((XmlTag)((Object)tnb.getUserObject())).getStart().getOffset());
                        return my_line.compareTo(other_line) * (sortDown ? 1 : -1);
                    }
                    case 2: {
                        String my_on = ((XmlTag)((Object)tna.getUserObject())).getName();
                        String other_on = ((XmlTag)((Object)tnb.getUserObject())).getName();
                        int comp = my_on.compareTo(other_on) * (sortDown ? 1 : -1);
                        return comp == 0 ? this.compareNames(tna, tnb) : comp;
                    }
                }
                return this.compareNames(tna, tnb);
            }

            private int compareNames(DefaultMutableTreeNode tna, DefaultMutableTreeNode tnb) {
                String my_name = ((XmlTag)((Object)tna.getUserObject())).getLongString();
                String other_name = ((XmlTag)((Object)tnb.getUserObject())).getLongString();
                return my_name.compareTo(other_name) * (sortDown ? 1 : -1);
            }
        };
    }

    protected ExpansionModel createExpansionModel() {
        ExpansionModel em = new ExpansionModel();
        em.add();
        em.add();
        if (this.root.getChildCount() != 0) {
            for (int i = 0; i < this.root.getChildAt(0).getChildCount(); ++i) {
                em.inc();
            }
        }
        return em;
    }

    public void addEntity(EntityDecl entity) {
        this.entities.add(entity);
        if (entity.type == 0 && entity.value.length() == 1) {
            Character ch = new Character(entity.value.charAt(0));
            this.entityHash.put(entity.name, ch);
            this.entityHash.put(ch, entity.name);
        }
    }

    public Object[] getObjectsTo(int pos) {
        TreePath path = this.getTreePathForPosition(pos);
        if (path == null) {
            return null;
        }
        Object[] pathObjs = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObjectPath();
        return pathObjs;
    }

    public IDDecl getIDDecl(String id) {
        return this.ids.get(id);
    }

    public List<IDDecl> getSortedIds() {
        ArrayList<IDDecl> idl = new ArrayList<IDDecl>(this.ids.values());
        return idl;
    }

    public static XmlParsedData getParsedData(View view, boolean signalError) {
        SideKickParsedData _data = SideKickParsedData.getParsedData((View)view);
        if (_data == null || !(_data instanceof XmlParsedData)) {
            if (signalError) {
                GUIUtilities.error((Component)view, (String)"xml-no-data", null);
            }
            return null;
        }
        return (XmlParsedData)_data;
    }

    public static String getElementNamePrefix(String name) {
        int index = name.indexOf(58);
        if (index == -1) {
            return "";
        }
        return name.substring(0, index);
    }

    public static String getElementLocalName(String name) {
        int index = name.indexOf(58);
        if (index == -1) {
            return name;
        }
        return name.substring(index + 1);
    }
}

