/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import xml.completion.ElementDecl;
import xml.completion.EntityDecl;
import xml.completion.IDDecl;

public class XmlListCellRenderer
extends JPanel
implements ListCellRenderer {
    public static final XmlListCellRenderer INSTANCE = new XmlListCellRenderer();
    public static final ImageIcon COMMENT_ICON = new ImageIcon(XmlListCellRenderer.class.getResource("/xml/Comment.png"));
    public static final ImageIcon CDATA_ICON = new ImageIcon(XmlListCellRenderer.class.getResource("/xml/CDATA.png"));
    public static final ImageIcon ELEMENT_ICON = new ImageIcon(XmlListCellRenderer.class.getResource("/xml/Element.png"));
    public static final ImageIcon EMPTY_ELEMENT_ICON = new ImageIcon(XmlListCellRenderer.class.getResource("/xml/EmptyElement.png"));
    public static final ImageIcon INTERNAL_ENTITY_ICON = new ImageIcon(XmlListCellRenderer.class.getResource("/xml/InternalEntity.png"));
    public static final ImageIcon EXTERNAL_ENTITY_ICON = new ImageIcon(XmlListCellRenderer.class.getResource("/xml/ExternalEntity.png"));
    public static final ImageIcon ID_ICON = new ImageIcon(XmlListCellRenderer.class.getResource("/xml/ID.png"));
    private DefaultListCellRenderer left = new DefaultListCellRenderer();
    private DefaultListCellRenderer right = new DefaultListCellRenderer();

    public XmlListCellRenderer() {
        this.setLayout(new BorderLayout());
        this.right.setHorizontalAlignment(11);
        this.add((Component)this.left, "Before");
        this.add((Component)this.right, "After");
    }

    public Component getListCellRendererComponent(JList list, Object obj, int index, boolean isSelected, boolean cellHasFocus) {
        this.left.getListCellRendererComponent((JList<?>)list, (Object)null, index, isSelected, cellHasFocus);
        this.right.getListCellRendererComponent((JList<?>)list, (Object)null, index, isSelected, cellHasFocus);
        this.setBackground(this.left.getBackground());
        this.setBorder(this.left.getBorder());
        this.left.setBorder(null);
        this.right.setBorder(null);
        WithLabel wqn = (WithLabel)obj;
        Object value = wqn.element;
        if (value instanceof Comment) {
            this.left.setIcon(COMMENT_ICON);
            this.left.setText("!--");
        } else if (value instanceof CDATA) {
            this.left.setIcon(CDATA_ICON);
            this.left.setText("![CDATA[");
        } else if (value instanceof ClosingTag) {
            this.left.setIcon(ELEMENT_ICON);
            this.left.setText("/" + ((ClosingTag)value).name);
        } else if (value instanceof ElementDecl) {
            ElementDecl element = (ElementDecl)value;
            this.left.setIcon(element.empty ? EMPTY_ELEMENT_ICON : ELEMENT_ICON);
            this.left.setText(wqn.label);
        } else if (value instanceof ElementDecl.AttributeDecl) {
            this.left.setText(wqn.label);
        } else if (value instanceof EntityDecl) {
            EntityDecl entity = (EntityDecl)value;
            this.left.setIcon(entity.type == 0 ? INTERNAL_ENTITY_ICON : EXTERNAL_ENTITY_ICON);
            String entityValue = entity.value;
            if (entityValue == null && (entityValue = entity.publicId) == null) {
                entityValue = entity.systemId;
            }
            if (entityValue == null) {
                this.right.setText("");
            } else {
                if (entityValue.length() > 60) {
                    entityValue = entityValue.substring(0, 30) + "..." + entityValue.substring(entityValue.length() - 20);
                }
                this.right.setText("    " + entityValue);
            }
            this.left.setText(entity.name);
        } else if (value instanceof IDDecl) {
            this.left.setIcon(ID_ICON);
            this.left.setText(value.toString());
        } else {
            this.left.setText(value.toString());
            this.left.setIcon(null);
        }
        return this;
    }

    public String getMainText() {
        return this.left.getText();
    }

    public String getValueText() {
        return this.right.getText();
    }

    @Override
    public void repaint() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    public static class WithLabel<Q> {
        public String label;
        public Q element;

        public WithLabel(Q element) {
            this(null, element);
        }

        public WithLabel(String qname, Q element) {
            this.label = qname;
            this.element = element;
        }
    }

    public static class CDATA {
    }

    public static class Comment {
    }

    public static class ClosingTag {
        public String name;

        public ClosingTag(String name) {
            this.name = name;
        }
    }
}

