/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListDataListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;
import sidekick.SideKickUpdate;
import xml.NamespaceBindings;
import xml.XmlActions;
import xml.XmlListCellRenderer;
import xml.XmlParsedData;
import xml.completion.ElementDecl;
import xml.completion.EntityDecl;
import xml.completion.IDDecl;
import xml.parser.TagParser;

public class XmlInsert
extends JPanel
implements EBComponent {
    private View view;
    private CaretHandler caretHandler;
    private List elements;
    private JList elementList;
    private JList entityList;
    private JList idList;
    private boolean html;
    private int delay;
    private Timer updateTimer;

    public XmlInsert(View view, boolean sideBySide) {
        this.view = view;
        this.setLayout(new GridLayout(sideBySide ? 1 : 3, sideBySide ? 3 : 1, 3, 3));
        JPanel elementPanel = new JPanel(new BorderLayout());
        elementPanel.add("North", new JLabel(jEdit.getProperty((String)"xml-insert.elements")));
        this.elementList = new JList();
        this.elementList.setName("elements");
        this.elementList.setCellRenderer(new XmlListCellRenderer());
        this.elementList.addMouseListener(new MouseHandler());
        this.elementList.setSelectionMode(0);
        elementPanel.add("Center", new JScrollPane(this.elementList));
        this.add(elementPanel);
        JPanel entityPanel = new JPanel(new BorderLayout());
        entityPanel.add("North", new JLabel(jEdit.getProperty((String)"xml-insert.entities")));
        this.entityList = new JList();
        this.entityList.setName("entities");
        this.entityList.setCellRenderer(new XmlListCellRenderer());
        this.entityList.addMouseListener(new MouseHandler());
        this.entityList.setSelectionMode(0);
        entityPanel.add("Center", new JScrollPane(this.entityList));
        this.add(entityPanel);
        JPanel idPanel = new JPanel(new BorderLayout());
        idPanel.add("North", new JLabel(jEdit.getProperty((String)"xml-insert.ids")));
        this.idList = new JList();
        this.idList.setName("ids");
        this.idList.setCellRenderer(new XmlListCellRenderer());
        this.idList.addMouseListener(new MouseHandler());
        this.idList.setSelectionMode(0);
        idPanel.add("Center", new JScrollPane(this.idList));
        this.add(idPanel);
        this.caretHandler = new CaretHandler();
        this.update();
        this.updateTimer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XmlInsert.this.updateTagList();
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        EditBus.addToBus((EBComponent)this);
        EditPane[] editPanes = this.view.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            JEditTextArea textArea = editPanes[i].getTextArea();
            textArea.addCaretListener((CaretListener)this.caretHandler);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus((EBComponent)this);
        EditPane[] editPanes = this.view.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            JEditTextArea textArea = editPanes[i].getTextArea();
            textArea.removeCaretListener((CaretListener)this.caretHandler);
        }
        this.updateTimer.stop();
    }

    public void handleMessage(EBMessage msg) {
        if (msg instanceof EditPaneUpdate) {
            EditPaneUpdate emsg = (EditPaneUpdate)msg;
            EditPane editPane = emsg.getEditPane();
            if (emsg.getWhat() == EditPaneUpdate.BUFFER_CHANGED && editPane == this.view.getEditPane()) {
                this.update();
            } else if (emsg.getWhat() == EditPaneUpdate.CREATED && editPane.getView() == this.view) {
                JEditTextArea textArea = editPane.getTextArea();
                textArea.addCaretListener((CaretListener)this.caretHandler);
            } else if (emsg.getWhat() == EditPaneUpdate.DESTROYED && editPane.getView() == this.view) {
                JEditTextArea textArea = editPane.getTextArea();
                textArea.removeCaretListener((CaretListener)this.caretHandler);
            } else if (emsg.getWhat() == EditPaneUpdate.BUFFER_CHANGED) {
                this.update();
            }
        } else if (msg instanceof BufferUpdate) {
            BufferUpdate bmsg = (BufferUpdate)msg;
            if ((bmsg.getWhat() == BufferUpdate.PROPERTIES_CHANGED || bmsg.getWhat() == BufferUpdate.LOADED) && bmsg.getBuffer() == this.view.getBuffer()) {
                this.update();
            }
        } else if (msg instanceof SideKickUpdate && ((SideKickUpdate)msg).getView() == this.view) {
            this.update();
        }
    }

    public static void openAndGo(View view, TextArea textArea, String uri, int gotoLine, int col) {
        Buffer buffer = jEdit.openFile((View)view, (String)uri);
        if (buffer == null) {
            return;
        }
        VFSManager.waitForRequests();
        int line = Math.min(buffer.getLineCount() - 1, gotoLine);
        int column = Math.min(buffer.getLineLength(line), col);
        int offset = buffer.getLineStartOffset(line) + column;
        try {
            textArea.setCaretPosition(offset);
        }
        catch (NullPointerException npe) {
            Log.log((int)9, XmlInsert.class, (Object)("FIXME : setCaretPosition(" + offset + ")"));
            Log.log((int)9, XmlInsert.class, (Object)npe);
        }
    }

    private void update() {
        XmlParsedData data = XmlParsedData.getParsedData(this.view, false);
        if (data == null) {
            this.setDeclaredEntities(null);
            this.setDeclaredIDs(null);
            this.html = false;
        } else {
            this.setDeclaredEntities(data.entities);
            this.setDeclaredIDs(data.getSortedIds());
            this.html = data.html;
        }
        this.updateTagList();
    }

    private void showNotParsedMessage() {
        this.setDeclaredElements(null);
        this.setDeclaredEntities(null);
        this.setDeclaredIDs(null);
    }

    private void setDeclaredElements(List elements) {
        this.elements = elements;
        if (elements == null) {
            DefaultListModel<XmlListCellRenderer.WithLabel<String>> model = new DefaultListModel<XmlListCellRenderer.WithLabel<String>>();
            model.addElement(new XmlListCellRenderer.WithLabel<String>("", jEdit.getProperty((String)"xml-insert.not-parsed")));
            this.elementList.setModel(model);
        } else {
            Rectangle cellBounds;
            ArrayListModel model = new ArrayListModel(elements);
            this.elementList.setModel(model);
            if (model.getSize() != 0 && (cellBounds = this.elementList.getCellBounds(0, 0)) != null) {
                this.elementList.setFixedCellHeight(cellBounds.height);
            }
        }
    }

    private void setDeclaredEntities(List<EntityDecl> entities) {
        if (entities == null) {
            DefaultListModel<XmlListCellRenderer.WithLabel<String>> model = new DefaultListModel<XmlListCellRenderer.WithLabel<String>>();
            model.addElement(new XmlListCellRenderer.WithLabel<String>(jEdit.getProperty((String)"xml-insert.not-parsed")));
            this.entityList.setModel(model);
        } else {
            Rectangle cellBounds;
            ArrayList<XmlListCellRenderer.WithLabel<EntityDecl>> nentities = new ArrayList<XmlListCellRenderer.WithLabel<EntityDecl>>(entities.size());
            for (EntityDecl e : entities) {
                nentities.add(new XmlListCellRenderer.WithLabel<EntityDecl>(e));
            }
            ArrayListModel model = new ArrayListModel(nentities);
            this.entityList.setModel(model);
            if (model.getSize() != 0 && (cellBounds = this.entityList.getCellBounds(0, 0)) != null) {
                this.entityList.setFixedCellHeight(cellBounds.height);
            }
        }
    }

    private void setDeclaredIDs(List<IDDecl> ids) {
        if (ids == null) {
            DefaultListModel<XmlListCellRenderer.WithLabel<String>> model = new DefaultListModel<XmlListCellRenderer.WithLabel<String>>();
            model.addElement(new XmlListCellRenderer.WithLabel<String>(jEdit.getProperty((String)"xml-insert.not-parsed")));
            this.idList.setModel(model);
        } else {
            Rectangle cellBounds;
            ArrayList<XmlListCellRenderer.WithLabel<IDDecl>> nids = new ArrayList<XmlListCellRenderer.WithLabel<IDDecl>>(ids.size());
            for (IDDecl id : ids) {
                nids.add(new XmlListCellRenderer.WithLabel<IDDecl>(id));
            }
            ArrayListModel model = new ArrayListModel(nids);
            this.idList.setModel(model);
            if (model.getSize() != 0 && (cellBounds = this.idList.getCellBounds(0, 0)) != null) {
                this.idList.setFixedCellHeight(cellBounds.height);
            }
        }
    }

    private void updateTagList() {
        Buffer buffer = this.view.getBuffer();
        XmlParsedData data = XmlParsedData.getParsedData(this.view, false);
        if (data != null) {
            Selection[] selection = this.view.getTextArea().getSelection();
            List<ElementDecl> l = selection.length > 0 ? data.getAllowedElements(buffer, selection[0].getStart(), selection[0].getEnd()) : data.getAllowedElements(buffer, this.view.getTextArea().getCaretPosition());
            ArrayList<XmlListCellRenderer.WithLabel<ElementDecl>> nl = new ArrayList<XmlListCellRenderer.WithLabel<ElementDecl>>(l.size());
            NamespaceBindings namespaces = data.getNamespaceBindings(this.view.getTextArea().getCaretPosition());
            NamespaceBindings localNamespacesToInsert = new NamespaceBindings();
            for (ElementDecl elementDecl : l) {
                String elementName;
                String elementNamespace = elementDecl.completionInfo.namespace;
                if (elementNamespace == null || "".equals(elementNamespace)) {
                    elementName = elementDecl.name;
                } else {
                    String pre = namespaces.getPrefix(elementNamespace);
                    if (pre == null) {
                        pre = localNamespacesToInsert.getPrefix(elementNamespace);
                    }
                    if (pre == null) {
                        pre = NamespaceBindings.generatePrefix(namespaces, localNamespacesToInsert);
                        localNamespacesToInsert.put(elementNamespace, pre);
                        elementName = pre + ":" + elementDecl.name;
                    } else {
                        elementName = "".equals(pre) ? elementDecl.name : pre + ":" + elementDecl.name;
                    }
                }
                nl.add(new XmlListCellRenderer.WithLabel<ElementDecl>(elementName, elementDecl));
            }
            this.setDeclaredElements(nl);
        } else {
            this.setDeclaredElements(null);
        }
    }

    private void updateTagListWithDelay() {
        if (this.updateTimer.isRunning()) {
            this.updateTimer.stop();
        }
        this.updateTimer.setInitialDelay(200);
        this.updateTimer.setRepeats(false);
        this.updateTimer.start();
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            Selection.Range insideTag = null;
            if (evt.getSource() == XmlInsert.this.elementList) {
                int index = XmlInsert.this.elementList.locationToIndex(evt.getPoint());
                if (index == -1) {
                    return;
                }
                EditPane editPane = XmlInsert.this.view.getEditPane();
                JEditTextArea textArea = editPane.getTextArea();
                Buffer buffer = editPane.getBuffer();
                XmlParsedData data = XmlParsedData.getParsedData(XmlInsert.this.view, true);
                if (data == null) {
                    return;
                }
                int pos = textArea.getCaretPosition();
                CharSequence text = buffer.getSegment(0, buffer.getLength());
                TagParser.Tag current = TagParser.getTagAtOffset(text, pos);
                if (current != null && current.start < pos && current.end >= pos) {
                    insideTag = new Selection.Range(current.start, current.end + 1);
                }
                XmlInsert.this.idList.setSelectedIndex(index);
                XmlListCellRenderer.WithLabel wqn = (XmlListCellRenderer.WithLabel)XmlInsert.this.elementList.getModel().getElementAt(index);
                Object obj = wqn.element;
                if (!(obj instanceof ElementDecl)) {
                    return;
                }
                ElementDecl element = (ElementDecl)obj;
                NamespaceBindings namespaces = data.getNamespaceBindings(pos);
                NamespaceBindings namespacesToInsert = new NamespaceBindings();
                XmlActions.showEditTagDialog(XmlInsert.this.view, wqn.label, element, (Selection)insideTag, namespaces, namespacesToInsert, !GUIUtilities.isPopupTrigger((MouseEvent)evt));
            } else if (evt.getSource() == XmlInsert.this.entityList) {
                int index = XmlInsert.this.entityList.locationToIndex(evt.getPoint());
                if (index == -1) {
                    return;
                }
                XmlListCellRenderer.WithLabel wl = (XmlListCellRenderer.WithLabel)XmlInsert.this.entityList.getModel().getElementAt(index);
                Object obj = wl.element;
                if (!(obj instanceof EntityDecl)) {
                    return;
                }
                EntityDecl entity = (EntityDecl)obj;
                JEditTextArea textArea = XmlInsert.this.view.getTextArea();
                textArea.setSelectedText("&" + entity.name + ";");
                textArea.requestFocus();
            } else if (evt.getSource() == XmlInsert.this.idList) {
                int index = XmlInsert.this.idList.locationToIndex(evt.getPoint());
                if (index == -1) {
                    return;
                }
                XmlInsert.this.idList.setSelectedIndex(index);
                XmlListCellRenderer.WithLabel wl = (XmlListCellRenderer.WithLabel)XmlInsert.this.idList.getModel().getElementAt(index);
                Object obj = wl.element;
                if (!(obj instanceof IDDecl)) {
                    return;
                }
                IDDecl id = (IDDecl)obj;
                JEditTextArea textArea = XmlInsert.this.view.getTextArea();
                if (GUIUtilities.isPopupTrigger((MouseEvent)evt)) {
                    XmlInsert.openAndGo(XmlInsert.this.view, (TextArea)textArea, id.uri, id.line, id.column);
                } else {
                    textArea.setSelectedText(id.id);
                }
                textArea.requestFocus();
            }
        }
    }

    class CaretHandler
    implements CaretListener {
        CaretHandler() {
        }

        @Override
        public void caretUpdate(CaretEvent evt) {
            if (evt.getSource() == XmlInsert.this.view.getTextArea()) {
                XmlInsert.this.updateTagListWithDelay();
            }
        }
    }

    static class ArrayListModel
    implements ListModel {
        List list;

        ArrayListModel(List list) {
            this.list = list;
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        public Object getElementAt(int index) {
            return this.list.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }
}

