/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.text.Segment;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.gui.StatusBar;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PositionChanging;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;
import sidekick.html.parser.html.HtmlDocument;
import sidekick.util.SideKickAsset;
import sidekick.util.SideKickElement;
import xml.DTDGenerator;
import xml.EditTagDialog;
import xml.NamespaceBindings;
import xml.XmlParsedData;
import xml.XmlPlugin;
import xml.completion.ElementDecl;
import xml.parser.TagParser;
import xml.parser.XmlTag;

public class XmlActions {
    private static Segment seg = new Segment();
    private static boolean closeCompletion;
    private static boolean closeCompletionOpen;
    private static boolean standaloneExtraSpace;
    static final String brackets = "[](){}";
    static final String xmlchars = "<>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showEditTagDialog(View view) {
        boolean empty;
        HashMap<String, Object> attributes;
        TagParser.Tag tag;
        XmlParsedData data;
        Buffer buffer;
        block25: {
            int caret;
            JEditTextArea textArea = view.getTextArea();
            if (XmlPlugin.isDelegated(textArea)) {
                view.getToolkit().beep();
                return;
            }
            buffer = view.getBuffer();
            data = XmlParsedData.getParsedData(view, true);
            if (data == null) {
                return;
            }
            CharSequence text = buffer.getSegment(0, buffer.getLength());
            tag = TagParser.getTagAtOffset(text, caret = textArea.getCaretPosition());
            if (tag == null || tag.type == 2) {
                view.getToolkit().beep();
                return;
            }
            attributes = new HashMap<String, Object>();
            String attributeName = null;
            boolean seenEquals = false;
            empty = false;
            char backslashSub = '\u007f';
            StreamTokenizer st = new StreamTokenizer(new StringReader(((Object)text.subSequence(tag.start + tag.tag.length() + 1, tag.end - 1)).toString().replace('\\', backslashSub)));
            st.resetSyntax();
            st.wordChars(33, 255);
            st.whitespaceChars(0, 32);
            st.quoteChar(34);
            st.quoteChar(39);
            st.ordinaryChar(47);
            st.ordinaryChar(61);
            Map entityHash = data.entityHash;
            try {
                while (true) {
                    switch (st.nextToken()) {
                        case -1: {
                            if (attributeName != null) {
                                attributes.put(attributeName, attributeName);
                            }
                            break block25;
                        }
                        case 61: {
                            seenEquals = true;
                            break;
                        }
                        case -3: {
                            if (attributeName == null) {
                                attributeName = data.html ? st.sval.toLowerCase() : st.sval;
                                break;
                            }
                        }
                        case 34: 
                        case 39: {
                            if (attributeName != null) {
                                if (seenEquals) {
                                    attributes.put(attributeName, XmlActions.entitiesToCharacters(st.sval.replace(backslashSub, '\\'), entityHash));
                                    seenEquals = false;
                                } else if (data.html) {
                                    attributes.put(attributeName, Boolean.TRUE);
                                }
                                attributeName = null;
                            }
                            break;
                        }
                        case 47: {
                            empty = true;
                        }
                    }
                }
            }
            catch (IOException io) {
                Log.log((int)9, XmlActions.class, (Object)"this shouldn't happen:", (Throwable)io);
            }
        }
        ElementDecl elementDecl = data.getElementDecl(tag.tag, tag.end + 1);
        if (elementDecl == null) {
            Object[] pp = new String[]{tag.tag};
            GUIUtilities.error((Component)view, (String)"xml-edit-tag.undefined-element", (Object[])pp);
            return;
        }
        NamespaceBindings namespaces = data.getNamespaceBindings(tag.start + 1);
        NamespaceBindings namespacesToInsert = new NamespaceBindings();
        for (String attrname : attributes.keySet()) {
            if (!attrname.startsWith("xmlns:")) continue;
            namespacesToInsert.put((String)attributes.get(attrname), attrname.substring(6));
        }
        EditTagDialog dialog = new EditTagDialog(view, tag.tag, elementDecl, attributes, empty, elementDecl.completionInfo.entityHash, data.getSortedIds(), data.html, namespaces, namespacesToInsert);
        String newTag = dialog.getNewTag();
        if (newTag != null) {
            try {
                buffer.beginCompoundEdit();
                buffer.remove(tag.start, tag.end - tag.start);
                buffer.insert(tag.start, newTag);
            }
            finally {
                buffer.endCompoundEdit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showEditTagDialog(View view, String elementName, ElementDecl elementDecl, Selection insideTag, NamespaceBindings namespaces, NamespaceBindings namespacesToInsert, boolean reallyShowEditTagDialog) {
        String closingTag;
        String newTag;
        Buffer buffer = view.getBuffer();
        XmlParsedData data = XmlParsedData.getParsedData(view, true);
        if (data == null) {
            return;
        }
        if (!reallyShowEditTagDialog) {
            StringBuilder[] openclose = EditTagDialog.composeTag(data, elementDecl, namespaces, namespacesToInsert, true);
            openclose[0].insert(0, '<');
            newTag = openclose[0].toString();
            closingTag = openclose[1].toString();
        } else {
            EditTagDialog dialog = new EditTagDialog(view, elementName, elementDecl, new HashMap<String, Object>(), elementDecl.empty, elementDecl.completionInfo.entityHash, data.getSortedIds(), data.html, namespaces, namespacesToInsert);
            newTag = dialog.getNewTag();
            closingTag = dialog.isEmpty() ? "" : "</" + elementName + ">";
        }
        if (newTag != null) {
            Selection[] selection;
            JEditTextArea textArea = view.getTextArea();
            if (insideTag != null) {
                textArea.setSelectedText(insideTag, "");
            }
            if ((selection = textArea.getSelection()).length > 0) {
                try {
                    buffer.beginCompoundEdit();
                    for (int i = 0; i < selection.length; ++i) {
                        buffer.insert(selection[i].getStart(), newTag);
                        buffer.insert(selection[i].getEnd(), closingTag);
                    }
                }
                finally {
                    buffer.endCompoundEdit();
                }
            } else {
                textArea.setSelectedText(newTag);
                int caret = textArea.getCaretPosition();
                textArea.setSelectedText(closingTag);
                textArea.setCaretPosition(caret);
            }
            textArea.selectNone();
            textArea.requestFocus();
        }
    }

    public static void insertClosingTag(View view) {
        JEditTextArea textArea = view.getTextArea();
        Buffer buffer = view.getBuffer();
        if (XmlPlugin.isDelegated(textArea) || !buffer.isEditable()) {
            view.getToolkit().beep();
            return;
        }
        XmlParsedData data = XmlParsedData.getParsedData(view, false);
        TagParser.Tag tag = TagParser.findLastOpenTag(buffer.getText(0, textArea.getCaretPosition()), textArea.getCaretPosition(), data);
        if (tag != null) {
            textArea.setSelectedText("</" + tag.tag + ">");
        } else {
            view.getToolkit().beep();
        }
    }

    public static void splitTag(TagParser.Tag tag, JEditTextArea textArea, CharSequence text) {
        View view = textArea.getView();
        textArea.setSelection((Selection)new Selection.Range(tag.start, tag.end));
        XmlParsedData data = XmlParsedData.getParsedData(view, true);
        Selection[] s = textArea.getSelection();
        if (s.length != 1) {
            return;
        }
        Selection sel = s[0];
        if (sel.getEnd() - sel.getStart() < 2) {
            return;
        }
        int line = textArea.getLineOfOffset(tag.start);
        int lineStartOffset = textArea.getLineStartOffset(line);
        int indentChars = 2 + sel.getStart() - lineStartOffset;
        StringBuffer indent = new StringBuffer("\n");
        for (int i = indentChars; i >= 0; --i) {
            indent.append(" ");
        }
        TreePath path = data.getTreePathForPosition(textArea.getCaretPosition());
        int count = path.getPathCount();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(count - 1);
        StringBuffer result = new StringBuffer();
        Object user_object = node.getUserObject();
        if (user_object instanceof XmlTag) {
            result.append('<');
            result.append(tag.tag);
            List<TagParser.Attr> attrs = TagParser.getAttrs(text, tag);
            count = attrs.size();
            if (count > 0) {
                result.append(' ');
            }
            for (int i = 0; i < count; ++i) {
                TagParser.Attr a = attrs.get(i);
                result.append(a.name).append(" = ").append(a.val);
                if (i >= count) continue;
                result.append(indent.toString());
            }
            result.append('>');
        } else if (user_object instanceof SideKickAsset) {
            SideKickElement element = ((SideKickAsset)user_object).getElement();
            if (element instanceof HtmlDocument.Tag) {
                HtmlDocument.Tag htmlTag = (HtmlDocument.Tag)element;
                result.append(htmlTag.tagStart);
                result.append(htmlTag.tagName);
                List<HtmlDocument.Attribute> attrs = ((HtmlDocument.Tag)element).attributeList.attributes;
                if (attrs.size() > 0) {
                    result.append(" ");
                }
                Iterator<HtmlDocument.Attribute> it = attrs.iterator();
                while (it.hasNext()) {
                    HtmlDocument.Attribute attr = it.next();
                    result.append(attr.name);
                    if (attr.hasValue) {
                        String value = attr.value;
                        if (!value.startsWith("\"")) {
                            value = "\"" + value;
                        }
                        if (!value.endsWith("\"")) {
                            value = value + "\"";
                        }
                        result.append(" = ").append(value);
                    }
                    if (!it.hasNext()) continue;
                    result.append(indent.toString());
                }
                result.append(htmlTag.tagEnd);
            }
        } else {
            return;
        }
        textArea.replaceSelection(result.toString());
    }

    public static void join(View view) {
        JEditTextArea textArea = view.getTextArea();
        Buffer buffer = view.getBuffer();
        int pos = textArea.getCaretPosition();
        CharSequence text = buffer.getSegment(0, buffer.getLength());
        TagParser.Tag tag = TagParser.getTagAtOffset(text, pos);
        if (tag == null) {
            return;
        }
        textArea.setSelection((Selection)new Selection.Range(tag.start, tag.end));
        XmlParsedData data = XmlParsedData.getParsedData(view, true);
        if (data == null) {
            return;
        }
        Selection[] s = textArea.getSelection();
        if (s.length != 1) {
            return;
        }
        Selection sel = s[0];
        if (sel.getEnd() - sel.getStart() < 2) {
            return;
        }
        int line = textArea.getLineOfOffset(tag.start);
        TreePath path = data.getTreePathForPosition(textArea.getCaretPosition());
        int count = path.getPathCount();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(count - 1);
        StringBuffer result = new StringBuffer();
        Object user_object = node.getUserObject();
        if (user_object instanceof XmlTag) {
            result.append('<');
            result.append(tag.tag);
            List<TagParser.Attr> attrs = TagParser.getAttrs(text, tag);
            for (TagParser.Attr a : attrs) {
                result.append(' ').append(a.name).append(" = ").append(a.val);
            }
            if (tag.type == 0) {
                result.append('/');
            }
            result.append('>');
        } else if (user_object instanceof SideKickAsset) {
            SideKickElement element = ((SideKickAsset)user_object).getElement();
            if (element instanceof HtmlDocument.Tag) {
                HtmlDocument.Tag htmlTag = (HtmlDocument.Tag)element;
                result.append(htmlTag.tagStart);
                result.append(htmlTag.tagName).append(" ");
                List<HtmlDocument.Attribute> attrs = ((HtmlDocument.Tag)element).attributeList.attributes;
                for (HtmlDocument.Attribute attr : attrs) {
                    result.append(attr.name);
                    if (!attr.hasValue) continue;
                    String value = attr.value;
                    if (!value.startsWith("\"")) {
                        value = "\"" + value;
                    }
                    if (!value.endsWith("\"")) {
                        value = value + "\"";
                    }
                    result.append(" = ").append(value);
                }
                result.append(htmlTag.tagEnd.replaceAll("\\s", ""));
            }
        } else {
            return;
        }
        textArea.replaceSelection(result.toString());
    }

    public static void split(View view) {
        JEditTextArea textArea = view.getTextArea();
        Buffer buffer = view.getBuffer();
        int pos = textArea.getCaretPosition();
        CharSequence text = buffer.getSegment(0, buffer.getLength());
        TagParser.Tag t = TagParser.getTagAtOffset(text, pos);
        if (t != null && t.end != pos) {
            XmlActions.splitTag(t, textArea, text);
            return;
        }
        if (XmlPlugin.isDelegated(textArea) || !buffer.isEditable()) {
            view.getToolkit().beep();
            return;
        }
        XmlParsedData data = XmlParsedData.getParsedData(view, true);
        if (data == null) {
            return;
        }
        TagParser.Tag tag = TagParser.findLastOpenTag(buffer.getText(0, textArea.getCaretPosition()), textArea.getCaretPosition(), data);
        if (tag != null) {
            Segment wsBefore = new Segment();
            pos = XmlActions.getPrevNonWhitespaceChar(buffer, tag.start - 1) + 1;
            buffer.getText(pos, tag.start - pos, wsBefore);
            Segment wsAfter = new Segment();
            pos = XmlActions.getNextNonWhitespaceChar(buffer, tag.end);
            pos = Math.min(pos, textArea.getCaretPosition());
            buffer.getText(tag.end, pos - tag.end, wsAfter);
            int lineStart = buffer.getLineStartOffset(buffer.getLineOfOffset(tag.start));
            String tagIndent = buffer.getText(lineStart, tag.start - lineStart);
            int crBeforeEndTag = XmlActions.countNewLines(wsAfter);
            int crAfterEndTag = XmlActions.countNewLines(wsBefore);
            StringBuffer insert = new StringBuffer();
            if (crBeforeEndTag > 0) {
                for (int i = 0; i < crBeforeEndTag; ++i) {
                    insert.append("\n");
                }
                insert.append(tagIndent);
            }
            insert.append("</" + tag.tag + ">");
            insert.append(wsBefore);
            insert.append("<" + tag.tag + ">");
            insert.append(wsAfter);
            textArea.setSelectedText(insert.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTags(Buffer buffer) {
        if (!buffer.isEditable()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        int off = 0;
        int len = buffer.getLength();
        long startTime = System.currentTimeMillis();
        int total = 0;
        try {
            buffer.beginCompoundEdit();
            CharSequence text = buffer.getSegment(off, len);
            int i = TagParser.indexOf(text, 60, 0);
            while (i != -1) {
                TagParser.Tag tag = TagParser.getTagAtOffset(text, i + 1);
                if (tag != null) {
                    int length = tag.end - tag.start;
                    buffer.remove(tag.start - total, length);
                    total += length;
                }
                ++i;
                i = TagParser.indexOf(text, 60, i);
            }
        }
        finally {
            buffer.endCompoundEdit();
        }
        long endTime = System.currentTimeMillis();
        Log.log((int)1, XmlActions.class, (Object)("removeTags time: " + (endTime - startTime) + " ms"));
    }

    public static void matchTag(JEditTextArea textArea) {
        int caretPos = textArea.getCaretPosition();
        for (int i = caretPos - 1; i < caretPos + 3; ++i) {
            try {
                String s = textArea.getText(i, 1);
                if (brackets.indexOf(s) <= -1) continue;
                textArea.goToMatchingBracket();
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        XmlActions.xmlMatchTag(textArea);
    }

    public static void xmlMatchTag(JEditTextArea textArea) {
        CharSequence text = textArea.getBuffer().getSegment(0, textArea.getBufferLength());
        int caret = textArea.getCaretPosition();
        textArea.setSelection((Selection)new Selection.Range(caret, caret));
        try {
            if (text.charAt(caret) == '<') {
                textArea.goToNextCharacter(false);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        TagParser.Tag tag = TagParser.getTagAtOffset(text, textArea.getCaretPosition());
        if (tag != null) {
            TagParser.Tag matchingTag = TagParser.getMatchingTag(text, tag);
            if (matchingTag != null) {
                EditBus.send((EBMessage)new PositionChanging((TextArea)textArea));
                textArea.setSelection((Selection)new Selection.Range(matchingTag.start, matchingTag.end));
                textArea.moveCaretPosition(matchingTag.end - 1);
            } else {
                textArea.getToolkit().beep();
            }
        }
    }

    public static void selectElement(JEditTextArea textArea) {
        int pos;
        int step = 2;
        CharSequence text = textArea.getBuffer().getSegment(0, textArea.getBufferLength());
        boolean isSel = textArea.getSelectionCount() == 1;
        int caret = isSel ? (pos = textArea.getSelection(0).getEnd()) : (pos = textArea.getCaretPosition());
        while (pos >= 0) {
            TagParser.Tag tag = TagParser.getTagAtOffset(text, pos);
            if (tag != null) {
                TagParser.Tag matchingTag = TagParser.getMatchingTag(text, tag);
                if (matchingTag != null && (tag.type == 1 && matchingTag.end >= caret || !isSel && tag.type == 2 && tag.end >= caret)) {
                    if (tag.start < matchingTag.end) {
                        textArea.setSelection((Selection)new Selection.Range(tag.start, matchingTag.end));
                        textArea.moveCaretPosition(matchingTag.end);
                        break;
                    }
                    textArea.setSelection((Selection)new Selection.Range(matchingTag.start, tag.end));
                    textArea.moveCaretPosition(matchingTag.start);
                    break;
                }
                if (!isSel && tag.type == 0) {
                    textArea.setSelection((Selection)new Selection.Range(tag.start, tag.end));
                    textArea.moveCaretPosition(tag.end);
                    break;
                }
                pos = matchingTag != null && matchingTag.start < tag.start ? matchingTag.start : tag.start;
            }
            pos -= 2;
        }
        if (pos <= 0) {
            textArea.selectBlock();
        }
    }

    public static TagParser.Tag selectTag(JEditTextArea textArea) {
        int pos;
        CharSequence text = textArea.getBuffer().getSegment(0, textArea.getBufferLength());
        TagParser.Tag t = TagParser.getTagAtOffset(text, pos = textArea.getCaretPosition());
        if (t == null) {
            return null;
        }
        textArea.setSelection((Selection)new Selection.Range(t.start, t.end));
        return t;
    }

    public static void selectBetweenTags(JEditTextArea textArea) {
        int pos;
        int step = 2;
        CharSequence text = textArea.getBuffer().getSegment(0, textArea.getBufferLength());
        boolean isSel = textArea.getSelectionCount() == 1;
        int caret = isSel ? (pos = textArea.getSelection(0).getEnd()) : (pos = textArea.getCaretPosition());
        while (pos >= 0) {
            TagParser.Tag tag = TagParser.getTagAtOffset(text, pos);
            if (tag != null) {
                TagParser.Tag matchingTag = TagParser.getMatchingTag(text, tag);
                if (tag.type == 1) {
                    if (matchingTag != null && (matchingTag.start > caret || !isSel && matchingTag.start == caret)) {
                        if (tag.start < matchingTag.end) {
                            textArea.setSelection((Selection)new Selection.Range(tag.end, matchingTag.start));
                            textArea.moveCaretPosition(matchingTag.start);
                            break;
                        }
                        textArea.setSelection((Selection)new Selection.Range(matchingTag.end, tag.start));
                        textArea.moveCaretPosition(matchingTag.end);
                        break;
                    }
                    pos = tag.start - 2;
                    continue;
                }
                pos = matchingTag != null && matchingTag.start < tag.start ? matchingTag.start : tag.start;
            }
            pos -= 2;
        }
        if (pos <= 0) {
            textArea.getToolkit().beep();
        }
    }

    public static void insertClosingTagKeyTyped(View view) {
        JEditTextArea textArea = view.getTextArea();
        Macros.Recorder recorder = view.getMacroRecorder();
        textArea.userInput('>');
        Buffer buffer = view.getBuffer();
        if (XmlPlugin.isDelegated(textArea) || !buffer.isEditable() || !closeCompletionOpen) {
            return;
        }
        XmlParsedData data = XmlParsedData.getParsedData(view, false);
        if (data == null) {
            return;
        }
        int caret = textArea.getCaretPosition();
        CharSequence text = buffer.getSegment(0, caret);
        TagParser.Tag tag = TagParser.getTagAtOffset(text, caret - 1);
        if (tag == null) {
            return;
        }
        ElementDecl decl = data.getElementDecl(tag.tag, tag.start + 1);
        if (tag.type == 0 || decl != null && decl.empty) {
            return;
        }
        tag = TagParser.findLastOpenTag(text, caret, data);
        if (tag != null) {
            String insert = "</" + tag.tag + ">";
            if (recorder != null) {
                recorder.recordInput(insert, false);
            }
            textArea.setSelectedText(insert);
            String code = "textArea.setCaretPosition(textArea.getCaretPosition() - " + insert.length() + ");";
            if (recorder != null) {
                recorder.record(code);
            }
            BeanShell.eval((View)view, (NameSpace)BeanShell.getNameSpace(), (String)code);
        }
    }

    public static void completeClosingTag(View view, boolean insertSlash) {
        JEditTextArea textArea = view.getTextArea();
        Macros.Recorder recorder = view.getMacroRecorder();
        if (insertSlash) {
            if (recorder != null) {
                recorder.recordInput(1, '/', false);
            }
            textArea.userInput('/');
        }
        JEditBuffer buffer = textArea.getBuffer();
        if (XmlPlugin.isDelegated(textArea)) {
            return;
        }
        XmlParsedData data = XmlParsedData.getParsedData(view, true);
        if (data == null) {
            return;
        }
        if (!buffer.isEditable() || !closeCompletion) {
            return;
        }
        int caret = textArea.getCaretPosition();
        if (caret == 1) {
            return;
        }
        CharSequence text = buffer.getSegment(0, buffer.getLength());
        if (text.charAt(caret - 2) != '<') {
            return;
        }
        if (TagParser.getTagAtOffset(text, caret) != null) {
            return;
        }
        TagParser.Tag tag = TagParser.findLastOpenTag(text, caret - 2, data);
        if (tag != null) {
            String insert = tag.tag + ">";
            if (recorder != null) {
                recorder.recordInput(insert, false);
            }
            textArea.setSelectedText(insert);
        }
    }

    public static String charactersToEntities(String s, Map hash) {
        String specialChars = "<>&\"\\";
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            Character c;
            String entity;
            char ch = s.charAt(i);
            if ((ch >= '\u007f' || "<>&\"\\".indexOf(ch) > -1) && (entity = (String)hash.get(c = new Character(ch))) != null) {
                buf.append('&');
                buf.append(entity);
                buf.append(';');
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static void charactersToEntities(View view) {
        Buffer buffer = view.getBuffer();
        JEditTextArea textArea = view.getTextArea();
        if (XmlPlugin.isDelegated(textArea) || !buffer.isEditable()) {
            view.getToolkit().beep();
            return;
        }
        XmlParsedData data = XmlParsedData.getParsedData(view, true);
        if (data == null) {
            return;
        }
        Map entityHash = data.entityHash;
        Selection[] selection = textArea.getSelection();
        for (int i = 0; i < selection.length; ++i) {
            String old = textArea.getSelectedText(selection[i]);
            textArea.setSelectedText(selection[i], XmlActions.charactersToEntities(old, entityHash));
        }
    }

    public static String entitiesToCharacters(String s, Map hash) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            String entityName;
            Character c;
            int index;
            char ch = s.charAt(i);
            if (ch == '&' && (index = s.indexOf(59, i)) != -1 && (c = (Character)hash.get(entityName = s.substring(i + 1, index))) != null) {
                buf.append(c.charValue());
                i = index;
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static void entitiesToCharacters(View view) {
        Buffer buffer = view.getBuffer();
        JEditTextArea textArea = view.getTextArea();
        if (XmlPlugin.isDelegated(textArea) || !buffer.isEditable()) {
            view.getToolkit().beep();
            return;
        }
        XmlParsedData data = XmlParsedData.getParsedData(view, true);
        if (data == null) {
            return;
        }
        Map entityHash = data.entityHash;
        Selection[] selection = textArea.getSelection();
        for (int i = 0; i < selection.length; ++i) {
            textArea.setSelectedText(selection[i], XmlActions.entitiesToCharacters(textArea.getSelectedText(selection[i]), entityHash));
        }
    }

    public static String getStandaloneEnd() {
        return standaloneExtraSpace ? " />" : "/>";
    }

    public static void generateDTD(View view) {
        JEditTextArea textArea = view.getTextArea();
        Buffer buffer = view.getBuffer();
        String text = buffer.getText(0, buffer.getLength());
        String encoding = buffer.getStringProperty("encoding");
        String dtd = DTDGenerator.write(view, text);
        StatusBar status = view.getStatus();
        if (dtd.trim().equals("")) {
            status.setMessageAndClear("Document produced an empty DTD");
        } else {
            Buffer newbuffer = jEdit.newFile((View)view);
            newbuffer.setMode("sgml");
            newbuffer.setStringProperty("encoding", encoding);
            newbuffer.insert(0, dtd);
            status.updateBufferStatus();
        }
    }

    public static void openSchema(View view) {
        Buffer buffer = view.getBuffer();
        String schemaURL = buffer.getStringProperty("xml.validation.schema");
        if (schemaURL == null) {
            schemaURL = buffer.getStringProperty("xml.validation.schema-auto");
        }
        if (schemaURL != null) {
            jEdit.openFile((View)view, (String)schemaURL);
        }
    }

    public static void copyXPath(View view) {
        XmlParsedData data = XmlParsedData.getParsedData(view, true);
        if (data == null) {
            view.getToolkit().beep();
            return;
        }
        JEditTextArea textArea = view.getTextArea();
        int pos = textArea.getCaretPosition();
        String xpath = data.getXPathForPosition(pos);
        if (xpath != null) {
            Registers.getRegister((char)'$').setTransferable((Transferable)new StringSelection(xpath));
        }
    }

    static void propertiesChanged() {
        closeCompletion = jEdit.getBooleanProperty((String)"xml.close-complete");
        if (closeCompletionOpen != jEdit.getBooleanProperty((String)"xml.close-complete-open")) {
            closeCompletionOpen = !closeCompletionOpen;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Class.forName("org.jedit.keymap.Keymap");
                        String shortcut = ">";
                        String actionName = closeCompletionOpen ? "xml-insert-closing-tag" : null;
                        Class<?> c = Class.forName("xml.JEdit5Support");
                        Method m = c.getDeclaredMethod("setShortcut", String.class, String.class);
                        m.invoke(null, actionName, shortcut);
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (Exception e) {
                        Log.log((int)7, XmlActions.class, (Object)"error setting shortcut to implement 'insert closing tag when opening tag is typed'", (Throwable)e);
                    }
                }
            });
        }
        standaloneExtraSpace = jEdit.getBooleanProperty((String)"xml.standalone-extra-space");
    }

    private static int getPrevNonWhitespaceChar(Buffer buf, int start) {
        int pos;
        Segment seg = new Segment(new char[1], 0, 1);
        for (pos = start; pos > 0; --pos) {
            buf.getText(pos, 1, seg);
            if (!Character.isWhitespace(seg.first())) break;
        }
        return pos;
    }

    private static int getNextNonWhitespaceChar(Buffer buf, int start) {
        int pos;
        Segment seg = new Segment(new char[1], 0, 1);
        for (pos = start; pos < buf.getLength(); ++pos) {
            buf.getText(pos, 1, seg);
            if (!Character.isWhitespace(seg.first())) break;
        }
        return pos;
    }

    private static int countNewLines(Segment seg) {
        int count = 0;
        for (int pos = seg.getBeginIndex(); pos < seg.getEndIndex(); ++pos) {
            if (seg.array[pos] != '\n') continue;
            ++count;
        }
        return count;
    }
}

