/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.gjt.sp.jedit.View;
import sidekick.ExpansionModel;
import sidekick.IAsset;
import xml.XmlParsedData;
import xml.parser.RenamedXmlTag;
import xml.parser.TldXmlTag;

public class TldXmlParsedData
extends XmlParsedData {
    public TldXmlParsedData(String filename, boolean html) {
        super(filename, html);
    }

    @Override
    public void done(View view) {
        Enumeration<TreeNode> children = this.root.children();
        while (children.hasMoreElements()) {
            this.processChild(children.nextElement());
        }
        this.tree.reload();
        this.sort(view);
    }

    private void processChild(TreeNode node) {
        IAsset asset = (IAsset)((DefaultMutableTreeNode)node).getUserObject();
        if (asset.getName().indexOf(":") == -1) {
            this.renameAsset(node, asset);
            Enumeration<? extends TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                this.processChild(children.nextElement());
            }
        }
    }

    private void renameAsset(TreeNode node, IAsset asset) {
        if (asset instanceof RenamedXmlTag && node instanceof DefaultMutableTreeNode) {
            Enumeration<? extends TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                TldXmlTag uo = (TldXmlTag)((Object)child.getUserObject());
                if (!"name".equals(uo.getName())) continue;
                ((RenamedXmlTag)asset).setNewName(uo.getCharacters());
                ((DefaultMutableTreeNode)node).setUserObject(asset);
            }
        }
    }

    @Override
    protected Comparator<DefaultMutableTreeNode> getSorter() {
        return new Comparator<DefaultMutableTreeNode>(){

            @Override
            public int compare(DefaultMutableTreeNode tna, DefaultMutableTreeNode tnb) {
                int sortBy = TldXmlParsedData.this.getSortBy();
                switch (sortBy) {
                    case 1: {
                        Integer my_line = new Integer(((TldXmlTag)((Object)tna.getUserObject())).getStart().getOffset());
                        Integer other_line = new Integer(((TldXmlTag)((Object)tnb.getUserObject())).getStart().getOffset());
                        return my_line.compareTo(other_line) * (XmlParsedData.sortDown ? 1 : -1);
                    }
                    case 2: {
                        String my_on = ((TldXmlTag)((Object)tna.getUserObject())).getName().toLowerCase();
                        String other_on = ((TldXmlTag)((Object)tnb.getUserObject())).getName().toLowerCase();
                        return my_on.compareTo(other_on) * (XmlParsedData.sortDown ? 1 : -1);
                    }
                }
                return this.compareNames(tna, tnb);
            }

            private int compareNames(DefaultMutableTreeNode tna, DefaultMutableTreeNode tnb) {
                String my_name = ((TldXmlTag)((Object)tna.getUserObject())).getShortString().toLowerCase();
                String other_name = ((TldXmlTag)((Object)tnb.getUserObject())).getShortString().toLowerCase();
                return my_name.compareTo(other_name) * (XmlParsedData.sortDown ? 1 : -1);
            }
        };
    }

    @Override
    protected ExpansionModel createExpansionModel() {
        ExpansionModel em = new ExpansionModel();
        em.add();
        em.add();
        for (int i = 0; i < this.root.getChildAt(0).getChildCount(); ++i) {
            em.inc();
        }
        return em;
    }
}

