/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ProgressObserver;
import templates.TemplatesPlugin;

public class TemplatesManager {
    private static final String TEMPLATES_SUBDIR = "XMLPlugin";
    private static final Pattern TEMPLATES_PATTERN = Pattern.compile("templates/(.+)");

    public static void installTemplates(ProgressObserver observer, PluginJAR me) {
        try {
            String templateDir = TemplatesPlugin.getTemplateDir();
            File templateSubDir = new File(templateDir, TEMPLATES_SUBDIR);
            if (!templateSubDir.exists()) {
                templateSubDir.mkdirs();
            }
            for (String template : me.getResources()) {
                Matcher m = TEMPLATES_PATTERN.matcher(template);
                if (!m.matches()) continue;
                Log.log((int)1, TemplatesManager.class, (Object)("installing template " + template));
                File templateFile = new File(templateDir, TEMPLATES_SUBDIR + File.separator + m.group(1));
                InputStream in = TemplatesManager.class.getClassLoader().getResourceAsStream(template);
                FileOutputStream out = new FileOutputStream(templateFile);
                boolean saved = IOUtilities.copyStream((ProgressObserver)observer, (InputStream)in, (OutputStream)out, (boolean)true);
                if (saved) continue;
                templateFile.delete();
                Log.log((int)7, TemplatesManager.class, (Object)("installing template " + template + " interrupted, giving up on rest templates"));
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TemplatesPlugin.refreshTemplates();
                }
            });
        }
        catch (IOException e) {
            Log.log((int)9, TemplatesManager.class, (Object)"unable to install xml templates", (Throwable)e);
        }
    }
}

