/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.awt.Component;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.StructureMatcher;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;
import sidekick.IAsset;
import sidekick.SideKickActions;
import xml.CharSequenceReader;
import xml.ElementUtil;
import xml.XmlParsedData;
import xml.XmlPlugin;
import xml.parser.javacc.ParseException;
import xml.parser.javacc.TagParser;
import xml.parser.javacc.XmlDocument;
import xml.parser.javacc.XmlParser;

public class SideKickTagHighlight
implements StructureMatcher {
    public StructureMatcher.Match getMatch(TextArea textArea) {
        long startTime = System.currentTimeMillis();
        if (XmlPlugin.isDelegated(textArea)) {
            return null;
        }
        int caret = textArea.getCaretPosition();
        XmlParsedData parsedData = XmlParsedData.getParsedData(((JEditTextArea)textArea).getView(), false);
        if (parsedData == null) {
            return null;
        }
        TagParser.Tag tag = null;
        IAsset asset = parsedData.getAssetAtOffset(caret);
        if (asset != null) {
            JEditBuffer b = textArea.getBuffer();
            int max = b.getLength();
            int sA = asset.getStart().getOffset();
            int lA = asset.getEnd().getOffset() - sA;
            if (sA < 0 || sA > max) {
                return null;
            }
            if (lA < 0 || sA + lA > max) {
                return null;
            }
            CharSequence toParse = b.getSegment(sA, lA);
            int line = b.getLineOfOffset(sA);
            int col = b.getVirtualWidth(line, sA - b.getLineStartOffset(line)) + 1;
            CharSequenceReader r = new CharSequenceReader(toParse);
            XmlParser parser = new XmlParser(r, line + 1, col);
            parser.setTabSize(b.getTabSize());
            try {
                XmlDocument.XmlElement startTag = parser.Tag();
                if (startTag instanceof XmlDocument.Tag && ((XmlDocument.Tag)startTag).emptyTag) {
                    return null;
                }
                int start = ElementUtil.createOffset((Buffer)textArea.getBuffer(), startTag.getStartLocation());
                int end = ElementUtil.createOffset((Buffer)textArea.getBuffer(), startTag.getEndLocation());
                tag = new TagParser.Tag(start, end);
                int startEndTag = start;
                for (int i = toParse.length() - 2; i > 0; --i) {
                    if (toParse.charAt(i) == '<') {
                        startEndTag = start + i;
                        break;
                    }
                    if (toParse.charAt(i) != '>') continue;
                    return null;
                }
                if (caret > end && caret < startEndTag) {
                    return null;
                }
                if (caret <= end) {
                    tag.start = startEndTag;
                    tag.end = start + toParse.length();
                }
                tag.startLine = textArea.getLineOfOffset(tag.start);
                tag.endLine = textArea.getLineOfOffset(tag.end);
                tag.matcher = this;
            }
            catch (ParseException pe) {
                Log.log((int)1, SideKickTagHighlight.class, (Object)"error parsing during matching tag highlight");
            }
        }
        Log.log((int)1, SideKickTagHighlight.class, (Object)("highlighting matching tag has taken " + (System.currentTimeMillis() - startTime) + "ms"));
        return tag;
    }

    public void selectMatch(TextArea textArea) {
        SideKickActions.selectAsset((View)GUIUtilities.getView((Component)textArea));
    }
}

