/*
 * Decompiled with CFR 0.152.
 */
package xml;

import common.gui.OkCancelButtons;
import ise.java.awt.KappaLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import xml.PathUtilities;
import xml.XmlPlugin;
import xml.parser.SchemaMapping;

public final class SchemaMappingManager {
    public static final String SCHEMA_MAPPING_PROP = "xml.schema-mapping";
    public static final String BUFFER_ENABLE_SCHEMA_MAPPING_PROP = "xml.enable-schema-mapping";
    public static final String ENABLE_SCHEMA_MAPPING_PROP = "buffer.xml.enable-schema-mapping";
    public static final String BUFFER_SCHEMA_PROP = "xml.validation.schema";
    public static final String BUFFER_AUTO_SCHEMA_PROP = "xml.validation.schema-auto";
    private static final String BUILT_IN_SCHEMA = "xml/dtds/schemas.xml";

    private SchemaMappingManager() {
    }

    public static void promptSchemaForBuffer(View view, Buffer buffer) {
        ChooseSchemaDialog choose;
        String oldSchema = buffer.getStringProperty(BUFFER_SCHEMA_PROP);
        String specificSchema = null;
        SchemaMapping lMapping = null;
        SchemaMapping gMapping = null;
        boolean schemasEnabled = SchemaMappingManager.isSchemaMappingEnabled(buffer);
        if (schemasEnabled) {
            specificSchema = MiscUtilities.constructPath((String)MiscUtilities.getParentOfPath((String)buffer.getPath()), (String)"schemas.xml");
            lMapping = SchemaMappingManager.getLocalSchemaMapping(buffer, new LoggingErrorHandler(jEdit.getProperty((String)"xml.local-schema")));
            gMapping = SchemaMappingManager.getGlobalSchemaMapping(new LoggingErrorHandler(jEdit.getProperty((String)"xml.global-schema")));
            String oldSchemaAuto = buffer.getStringProperty(BUFFER_AUTO_SCHEMA_PROP);
            if (oldSchema == null) {
                oldSchema = oldSchemaAuto;
            }
        }
        if ((choose = new ChooseSchemaDialog(view)).choose(buffer.getPath(), PathUtilities.urlToPath(oldSchema), true)) {
            String bufferURL = PathUtilities.pathToURL(buffer.getPath());
            URI schemaURL = choose.schemaURL;
            if (schemasEnabled) {
                if (lMapping == null) {
                    try {
                        lMapping = new SchemaMapping(new URI(PathUtilities.pathToURL(specificSchema)));
                        if (gMapping != null) {
                            lMapping.ensureIncluded(gMapping);
                        }
                    }
                    catch (URISyntaxException ue) {
                        Log.log((int)9, SchemaMappingManager.class, (Object)ue);
                    }
                }
                SchemaMapping.URIResourceRule newRule = new SchemaMapping.URIResourceRule(null, bufferURL, schemaURL.toString(), false);
                lMapping.updateMapping(newRule);
                try {
                    lMapping.toDocument(lMapping.getBaseURI().toString());
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog((Component)view, jEdit.getProperty((String)"xml-error-to-document.message", (Object[])new Object[]{ioe.getClass(), ioe.getMessage()}), jEdit.getProperty((String)"xml-error-to-document.title"), 0);
                    Buffer b = jEdit.newFile((View)view, (String)lMapping.getBaseURI().toString());
                    b.insert(0, lMapping.toString());
                    view.getEditPane().setBuffer(buffer);
                }
            } else {
                buffer.setProperty(BUFFER_SCHEMA_PROP, (Object)schemaURL);
            }
            view.getInputHandler().setRepeatCount(1);
            view.getInputHandler().invokeAction("sidekick-parse");
        }
    }

    public static void promptTypeIdForBuffer(View view, Buffer buffer) {
        String specificSchema = MiscUtilities.constructPath((String)MiscUtilities.getParentOfPath((String)buffer.getPath()), (String)"schemas.xml");
        URI specificSchemaURI = null;
        try {
            specificSchemaURI = new URI(PathUtilities.pathToURL(specificSchema));
        }
        catch (URISyntaxException mfue) {
            Log.log((int)9, SchemaMappingManager.class, (Object)mfue);
        }
        SchemaMapping lMapping = SchemaMappingManager.getLocalSchemaMapping(buffer, new LoggingErrorHandler(jEdit.getProperty((String)"xml.local-schema")));
        SchemaMapping gMapping = SchemaMappingManager.getGlobalSchemaMapping(new LoggingErrorHandler(jEdit.getProperty((String)"xml.global-schema")));
        SchemaMapping bMapping = SchemaMappingManager.getBuiltInSchemaMapping(new LoggingErrorHandler(jEdit.getProperty((String)"xml.builtin-schema")));
        HashMap<String, SchemaMapping> allTypeIds = new HashMap<String, SchemaMapping>();
        String oldTypeId = null;
        for (SchemaMapping m : Arrays.asList(lMapping, gMapping, bMapping)) {
            if (m == null) continue;
            for (SchemaMapping.TypeIdMapping tid : m.getTypeIds()) {
                allTypeIds.put(tid.getId(), m);
            }
            if (oldTypeId != null) continue;
            oldTypeId = m.getTypeIdForDocument(buffer.getPath());
        }
        Object[] tids = allTypeIds.keySet().toArray(new String[0]);
        if (tids.length == 0) {
            view.getToolkit().beep();
            view.getStatus().setMessage("xml.no-type-id.message");
            return;
        }
        String tid = (String)JOptionPane.showInputDialog((Component)view, jEdit.getProperty((String)"xml.choose-type-id.message"), jEdit.getProperty((String)"xml.choose-type-id.title"), 2, null, tids, oldTypeId == null ? tids[0] : oldTypeId);
        if (tid != null) {
            SchemaMapping tidMapping = (SchemaMapping)allTypeIds.get(tid);
            if (SchemaMappingManager.isSchemaMappingEnabled(buffer)) {
                if (lMapping == null) {
                    lMapping = new SchemaMapping(specificSchemaURI);
                    if (gMapping != null) {
                        lMapping.ensureIncluded(gMapping);
                    }
                }
                if (lMapping != tidMapping) {
                    lMapping.ensureIncluded(tidMapping);
                }
                String bufferURL = PathUtilities.pathToURL(buffer.getPath());
                SchemaMapping.URIResourceRule newRule = new SchemaMapping.URIResourceRule(null, bufferURL, tid, true);
                lMapping.updateMapping(newRule);
                try {
                    lMapping.toDocument(lMapping.getBaseURI().toString());
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog((Component)view, jEdit.getProperty((String)"xml-error-to-document.message", (Object[])new Object[]{ioe.getClass(), ioe.getMessage()}), jEdit.getProperty((String)"xml-error-to-document.title"), 0);
                    Buffer b = jEdit.newFile((View)view, (String)lMapping.getBaseURI().toString());
                    b.insert(0, lMapping.toString());
                    view.getEditPane().setBuffer(buffer);
                }
            } else {
                SchemaMapping.Result res = tidMapping.resolveTypeId(tid);
                if (res != null) {
                    String schemaURL = res.baseURI.resolve(res.target).toString();
                    buffer.setStringProperty(BUFFER_SCHEMA_PROP, schemaURL);
                }
            }
            view.getInputHandler().setRepeatCount(1);
            view.getInputHandler().invokeAction("sidekick-parse");
        }
    }

    public static SchemaMapping getGlobalSchemaMapping(ErrorHandler errorHandler) {
        String schemaURL = jEdit.getProperty((String)SCHEMA_MAPPING_PROP);
        SchemaMapping mapping = null;
        if (schemaURL != null) {
            Log.log((int)1, SchemaMappingManager.class, (Object)("global mapping=" + schemaURL));
            try {
                mapping = SchemaMapping.fromDocument(schemaURL, errorHandler);
            }
            catch (IOException e) {
                mapping = null;
                Log.log((int)9, SchemaMappingManager.class, (Object)("Error loading global schema mapping: '" + schemaURL + "'"), (Throwable)e);
            }
            catch (SAXException e) {
                mapping = null;
            }
        }
        return mapping;
    }

    public static SchemaMapping getBuiltInSchemaMapping(ErrorHandler errorHandler) {
        URL schemaURL = SchemaMappingManager.class.getClassLoader().getResource(BUILT_IN_SCHEMA);
        if (schemaURL == null) {
            throw new AssertionError((Object)"built-in schemas.xml cant be found !");
        }
        try {
            return SchemaMapping.fromDocument(schemaURL.toString(), errorHandler);
        }
        catch (IOException e) {
            Log.log((int)9, SchemaMappingManager.class, (Object)("Error loading local schema mapping : '" + schemaURL + "'"), (Throwable)e);
            return null;
        }
        catch (SAXException e) {
            return null;
        }
    }

    public static SchemaMapping getLocalSchemaMapping(Buffer buffer, ErrorHandler errorHandler) {
        SchemaMapping mapping;
        String specificSchema = MiscUtilities.constructPath((String)MiscUtilities.getParentOfPath((String)buffer.getPath()), (String)"schemas.xml");
        try {
            URI uriSpecificSchema = new URI(PathUtilities.pathToURL(specificSchema));
            if (SchemaMapping.resourceExists(uriSpecificSchema)) {
                String schemaURL = uriSpecificSchema.toString();
                mapping = SchemaMapping.fromDocument(schemaURL, errorHandler);
            } else {
                Log.log((int)1, SchemaMappingManager.class, (Object)("no schemas.xml in " + specificSchema));
                mapping = null;
            }
        }
        catch (URISyntaxException ue) {
            Log.log((int)9, SchemaMappingManager.class, (Object)("Error converting path for fromDocument : '" + specificSchema + "'"), (Throwable)ue);
            mapping = null;
        }
        catch (IOException e) {
            mapping = null;
            Log.log((int)9, SchemaMappingManager.class, (Object)("Error loading local schema mapping : '" + specificSchema + "'"), (Throwable)e);
        }
        catch (SAXException e) {
            mapping = null;
        }
        return mapping;
    }

    public static SchemaMapping getSchemaMappingForBuffer(Buffer buffer, ErrorHandler errorHandler) {
        SchemaMapping mapping = SchemaMappingManager.getLocalSchemaMapping(buffer, new LoggingErrorHandler(jEdit.getProperty((String)jEdit.getProperty((String)"xml.local-schema")), errorHandler));
        if (mapping == null) {
            mapping = SchemaMappingManager.getGlobalSchemaMapping(new LoggingErrorHandler(jEdit.getProperty((String)jEdit.getProperty((String)"xml.global-schema")), errorHandler));
        }
        if (mapping == null) {
            Log.log((int)1, SchemaMappingManager.class, (Object)"no settings => using built-in schema mapping file");
            mapping = SchemaMappingManager.getBuiltInSchemaMapping(new LoggingErrorHandler(jEdit.getProperty((String)jEdit.getProperty((String)"xml.builtin-schema")), errorHandler));
        }
        return mapping;
    }

    public static void initGlobalSchemaMapping(View view) {
        File schemas;
        jEdit.unsetProperty((String)SCHEMA_MAPPING_PROP);
        File home = EditPlugin.getPluginHome(XmlPlugin.class);
        if (home == null) {
            return;
        }
        if (!home.exists()) {
            Log.log((int)1, SchemaMappingManager.class, (Object)"creating settings directory");
            try {
                boolean created = home.mkdirs();
                if (!created) {
                    GUIUtilities.error((Component)view, (String)("unable to create settings directory: " + home), null);
                    return;
                }
            }
            catch (SecurityException se) {
                GUIUtilities.error((Component)view, (String)("unable to create settings directory (security exception): " + home), null);
                return;
            }
        }
        if (!(schemas = new File(home, "schemas.xml")).exists()) {
            SchemaMapping builtinMapping = SchemaMappingManager.getBuiltInSchemaMapping(new LoggingErrorHandler(jEdit.getProperty((String)"xml.builtin-schema")));
            SchemaMapping tmp = new SchemaMapping();
            tmp.ensureIncluded(builtinMapping);
            try {
                tmp.toDocument(schemas.toURI().toURL().toString());
            }
            catch (IOException ioe) {
                Log.log((int)9, SchemaMappingManager.class, (Object)"Unable to save default RelaxNG mappings", (Throwable)ioe);
                return;
            }
        }
        try {
            jEdit.setProperty((String)SCHEMA_MAPPING_PROP, (String)schemas.toURI().toURL().toString());
        }
        catch (MalformedURLException mfe) {
            Log.log((int)9, SchemaMappingManager.class, (Object)mfe);
        }
    }

    public static boolean isSchemaMappingEnabled(Buffer b) {
        return b.getBooleanProperty(BUFFER_ENABLE_SCHEMA_MAPPING_PROP);
    }

    public static class LoggingErrorHandler
    implements ErrorHandler {
        private String resourceName;
        private ErrorHandler errorHandler;

        public LoggingErrorHandler(String resourceName) {
        }

        public LoggingErrorHandler(String property, ErrorHandler errorHandler) {
            this.resourceName = this.resourceName;
            this.errorHandler = errorHandler;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            Log.log((int)7, SchemaMappingManager.class, (Object)jEdit.getProperty((String)"xml.SchemaMappingManager.error", (Object[])new Object[]{this.resourceName, exception.getSystemId(), exception.getLineNumber(), exception.getLocalizedMessage()}));
            if (this.errorHandler != null) {
                this.errorHandler.error(exception);
            }
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            Log.log((int)7, SchemaMappingManager.class, (Object)jEdit.getProperty((String)"xml.SchemaMappingManager.fatal-error", (Object[])new Object[]{this.resourceName, exception.getSystemId(), exception.getLineNumber(), exception.getLocalizedMessage()}));
            if (this.errorHandler != null) {
                this.errorHandler.fatalError(exception);
            }
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            Log.log((int)5, SchemaMappingManager.class, (Object)jEdit.getProperty((String)"xml.SchemaMappingManager.warning", (Object[])new Object[]{this.resourceName, exception.getSystemId(), exception.getLineNumber(), exception.getLocalizedMessage()}));
            if (this.errorHandler != null) {
                this.errorHandler.warning(exception);
            }
        }
    }

    static class ChooseSchemaDialog
    extends EnhancedDialog {
        private JCheckBox relative_cb;
        private JTextField path;
        private JTextField buffer_path;
        private JTextField relative_path;
        private boolean valid;
        URI schemaURL = null;
        boolean relative = false;
        boolean confirmed = false;

        ChooseSchemaDialog(final View view) {
            super((Frame)view, jEdit.getProperty((String)"xml.choose-schema.title"), true);
            JPanel panel = new JPanel((LayoutManager)new KappaLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            ActionListener relativize = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChooseSchemaDialog.this.relativize();
                }
            };
            JLabel buffer_label = new JLabel(jEdit.getProperty((String)"xml.choose-schema.buffer-path"));
            this.buffer_path = new JTextField(40);
            this.buffer_path.setEditable(false);
            this.buffer_path.setName("buffer_path");
            JLabel choose_label = new JLabel(jEdit.getProperty((String)"xml.choose-schema.message"));
            this.path = new HistoryTextField("xml.choose-schema", true);
            this.path.setName("path");
            this.path.setText("");
            this.path.setColumns(40);
            this.path.addActionListener(relativize);
            JButton browse = new JButton(jEdit.getProperty((String)"xml.choose-schema.browse"));
            browse.setMnemonic(66);
            browse.setName("browse");
            browse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    String[] paths = GUIUtilities.showVFSFileDialog((View)view, (String)ChooseSchemaDialog.this.path.getText(), (int)0, (boolean)false);
                    if (paths != null && paths.length > 0) {
                        ChooseSchemaDialog.this.path.setText(paths[0]);
                        ChooseSchemaDialog.this.relativize();
                    }
                }
            });
            this.relative_cb = new JCheckBox(jEdit.getProperty((String)"xml.choose-schema.relative"));
            this.relative_cb.addActionListener(relativize);
            this.relative_cb.setName("relative");
            this.relative_path = new JTextField(40);
            this.relative_path.setEditable(false);
            this.relative_path.setName("relative_path");
            OkCancelButtons okCancel = new OkCancelButtons((EnhancedDialog)this);
            panel.add("0, 0, 1, 1, W, w, 3", buffer_label);
            panel.add("1, 0, 6, 1, W, w, 3", this.buffer_path);
            panel.add("0, 1, 1, 1, 0,  , 0", KappaLayout.createVerticalStrut((int)11, (boolean)true));
            panel.add("0, 2, 8, 1, W, w, 3", choose_label);
            panel.add("0, 3, 7, 1, W, w, 3", this.path);
            panel.add("7, 3, 1, 1, W, w, 3", browse);
            panel.add("0, 4, 1, 1, 0,  , 0", KappaLayout.createVerticalStrut((int)33, (boolean)true));
            panel.add("0, 5, 6, 1, 0, w, 0", this.relative_cb);
            panel.add("0, 6, 5, 1, W, w, 3", this.relative_path);
            panel.add("0, 7, 1, 1, 0,  , 0", KappaLayout.createVerticalStrut((int)11, (boolean)true));
            panel.add("0, 8, 8, 1, 0, w, 0", (Component)okCancel);
            this.setContentPane(panel);
            this.pack();
        }

        void init(String buffer, String oldSchema, boolean relativeEnabled) {
            this.buffer_path.setText(buffer);
            if (oldSchema == null) {
                this.path.setText(MiscUtilities.getParentOfPath((String)buffer));
            } else {
                this.path.setText(oldSchema);
            }
            this.relative_cb.setSelected(false);
            this.relative_cb.setEnabled(relativeEnabled);
            this.relativize();
        }

        public boolean choose(String buffer, String oldSchema, boolean relativeEnabled) {
            this.confirmed = false;
            this.init(buffer, oldSchema, relativeEnabled);
            this.setVisible(true);
            return this.confirmed;
        }

        public void ok() {
            this.relativize();
            if (this.valid) {
                this.confirmed = true;
                this.setVisible(false);
            }
        }

        public void cancel() {
            this.confirmed = false;
            this.setVisible(false);
        }

        private void relativize() {
            this.relative = this.relative_cb.isSelected();
            try {
                this.schemaURL = new URI(PathUtilities.pathToURL(this.path.getText()));
                if (this.relative) {
                    String bufferURL = PathUtilities.pathToURL(MiscUtilities.getParentOfPath((String)this.buffer_path.getText()));
                    this.schemaURL = new URI(bufferURL).relativize(this.schemaURL);
                }
                this.path.setForeground(Color.BLACK);
                this.valid = true;
                this.relative_path.setText(this.schemaURL.toString());
            }
            catch (URISyntaxException ue) {
                Log.log((int)9, SchemaMappingManager.class, (Object)ue);
                this.path.setForeground(Color.RED);
                this.valid = false;
                this.relative_path.setText(ue.getMessage());
            }
        }
    }
}

