/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.xml.resolver.Catalog;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.VFSUpdate;
import org.gjt.sp.util.Log;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;
import xml.PathUtilities;
import xml.XmlPlugin;

public class Resolver
implements EntityResolver2,
LSResourceResolver {
    public static final String ASK = "ask";
    public static final String LOCAL = "local";
    public static final String ALWAYS = "always";
    public static final String[] MODES = new String[]{"ask", "local", "always"};
    private boolean loadedCache = false;
    private boolean loadedCatalogs = false;
    public static final String NETWORK_PROPS = "xml.general.network";
    public static final String MODE = "xml.general.network.mode";
    public static final String CACHE = "xml.general.network.cache";
    public static final String INTERNALCATALOG = "jeditresource:/XML.jar!/xml/dtds/catalog";
    private static String IGNORE = new String("IGNORE");
    private static Resolver singleton = null;
    private static String resourceDir;
    private EBComponent vfsUpdateHandler;
    private Catalog catalog = null;
    private HashMap<Entry, String> resourceCache;
    private Set<String> catalogFiles;

    void init() {
        this.vfsUpdateHandler = new VFSUpdateHandler();
        EditBus.addToBus((EBComponent)this.vfsUpdateHandler);
    }

    void uninit() {
        EditBus.removeFromBus((EBComponent)this.vfsUpdateHandler);
        singleton = null;
    }

    public void save() {
        if (this.loadedCache) {
            int systemCount = 0;
            int publicCount = 0;
            for (Entry entry : this.resourceCache.keySet()) {
                String uri = this.resourceCache.get(entry);
                if (uri == IGNORE || uri == null) continue;
                if (entry.type == 1) {
                    jEdit.setProperty((String)("xml.cache.public-id." + publicCount), (String)entry.id);
                    jEdit.setProperty((String)("xml.cache.public-id." + publicCount + ".uri"), (String)uri.toString());
                    ++publicCount;
                    continue;
                }
                jEdit.setProperty((String)("xml.cache.system-id." + systemCount), (String)entry.id);
                jEdit.setProperty((String)("xml.cache.system-id." + systemCount + ".uri"), (String)uri.toString());
                ++systemCount;
            }
            jEdit.unsetProperty((String)("xml.cache.public-id." + publicCount));
            jEdit.unsetProperty((String)("xml.cache.public-id." + publicCount + ".uri"));
            jEdit.unsetProperty((String)("xml.cache.system-id." + systemCount));
            jEdit.unsetProperty((String)("xml.cache.system-id." + systemCount + ".uri"));
        }
    }

    public static synchronized Resolver instance() {
        if (singleton == null) {
            jEdit.getPlugin((String)XmlPlugin.class.getName()).getPluginJAR().activatePlugin();
            singleton = new Resolver();
            singleton.init();
            singleton.load();
        }
        return singleton;
    }

    private Resolver() {
    }

    private synchronized void load() {
        String prop;
        if (!this.loadedCache) {
            String uri;
            String id;
            this.resourceCache = new HashMap();
            if (Resolver.isUsingCache()) {
                resourceDir = MiscUtilities.constructPath((String)jEdit.getSettingsDirectory(), (String)"dtds");
            }
            int i = 0;
            while ((id = jEdit.getProperty((String)(prop = "xml.cache.public-id." + i++))) != null) {
                uri = jEdit.getProperty((String)(prop + ".uri"));
                this.resourceCache.put(new Entry(1, id, uri), uri);
            }
            i = 0;
            while ((id = jEdit.getProperty((String)(prop = "xml.cache.system-id." + i++))) != null) {
                uri = jEdit.getProperty((String)(prop + ".uri"));
                Entry se = new Entry(0, id, uri);
                this.resourceCache.put(se, uri);
            }
            this.loadedCache = true;
        }
        if (!this.loadedCatalogs) {
            this.loadedCatalogs = true;
            this.catalog = new Catalog();
            this.catalog.getCatalogManager().setPreferPublic(true);
            this.catalog.getCatalogManager().ignoreMissingProperties(true);
            this.catalog.getCatalogManager().setVerbosity(2);
            this.catalog.setupReaders();
            this.catalogFiles = new HashSet<String>();
            this.catalogFiles.add(INTERNALCATALOG);
            try {
                this.catalog.loadSystemCatalogs();
                this.catalog.parseCatalog(INTERNALCATALOG);
            }
            catch (Exception ex1) {
                Log.log((int)9, Resolver.class, (Object)ex1);
            }
            int i = 0;
            String uri = null;
            while ((uri = jEdit.getProperty((String)(prop = "xml.catalog." + i++))) != null) {
                if (MiscUtilities.isURL((String)uri)) {
                    this.catalogFiles.add(uri);
                } else {
                    this.catalogFiles.add(MiscUtilities.resolveSymlinks((String)uri));
                }
                try {
                    this.catalog.parseCatalog(uri);
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                    Log.log((int)9, Resolver.class, (Object)ex2);
                }
                if (uri != null) continue;
            }
        }
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        try {
            InputSource is = this.resolveEntity(type, publicId, baseURI, systemId);
            if (is == null) {
                return null;
            }
            return new InputSourceAsLSInput(is);
        }
        catch (SAXException e) {
            throw new RuntimeException("Error loading resource " + systemId, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading resource " + systemId, e);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.resolveEntity(null, publicId, null, systemId);
    }

    public String resolveEntityToPath(String name, String publicId, String current, String systemId) throws IOException {
        String[] res = this.resolveEntityToPathInternal(name, publicId, current, systemId);
        if (res == null) {
            return null;
        }
        return res[1];
    }

    public String[] resolveEntityToPathInternal(String name, String publicId, String current, String systemId) throws IOException {
        if (publicId != null && publicId.length() == 0) {
            publicId = null;
        }
        if (systemId != null && systemId.length() == 0) {
            systemId = null;
        }
        String newSystemId = null;
        if (publicId == null && systemId == null) {
            return null;
        }
        String parent = current != null ? MiscUtilities.getParentOfPath((String)current) : null;
        if (publicId == null) {
            newSystemId = this.resolvePublicOrSystem(systemId, false);
        } else {
            newSystemId = this.resolvePublicOrSystem(publicId, true);
            if (newSystemId == null && systemId != null) {
                newSystemId = this.resolvePublicOrSystem(systemId, false);
            }
        }
        if (newSystemId == null) {
            if (systemId == null) {
                return null;
            }
            if (MiscUtilities.isURL((String)systemId)) {
                newSystemId = systemId;
            } else {
                if (new File(systemId).isAbsolute() || parent == null) {
                    newSystemId = systemId;
                } else {
                    systemId = newSystemId = parent + systemId;
                }
                if (!MiscUtilities.isURL((String)newSystemId)) {
                    try {
                        systemId = newSystemId = new File(newSystemId).toURI().toURL().toString();
                    }
                    catch (MalformedURLException mue) {
                        // empty catch block
                    }
                }
            }
        }
        if (newSystemId == null) {
            return null;
        }
        String lastChance = this.resolvePublicOrSystemFromCache(newSystemId, false);
        if (lastChance != null && lastChance != IGNORE) {
            newSystemId = lastChance;
        }
        return new String[]{systemId, newSystemId};
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String current, String systemId) throws SAXException, IOException {
        String[] sids = this.resolveEntityToPathInternal(name, publicId, current, systemId);
        if (sids == null) {
            return null;
        }
        return this.openEntity(name, publicId, current, sids[0], sids[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputSource openEntity(String name, String publicId, String current, String systemId, String newSystemId) throws SAXException, IOException {
        if (newSystemId == null) {
            return null;
        }
        Buffer buf = jEdit.getBuffer((String)PathUtilities.urlToPath(newSystemId));
        if (buf != null) {
            if (buf.isPerformingIO()) {
                VFSManager.waitForRequests();
            }
            InputSource source = new InputSource(publicId);
            source.setSystemId(systemId);
            try {
                buf.readLock();
                source.setCharacterStream(new StringReader(buf.getText(0, buf.getLength())));
            }
            finally {
                buf.readUnlock();
            }
            return source;
        }
        if (newSystemId.startsWith("file:") || newSystemId.startsWith("jar:file:") || newSystemId.startsWith("jeditresource:")) {
            if (newSystemId.startsWith("jeditresource:")) {
                systemId = newSystemId;
            }
            InputSource source = new InputSource(systemId);
            source.setPublicId(publicId);
            InputStream is = new URL(newSystemId).openStream();
            source.setByteStream(is);
            return source;
        }
        if (LOCAL.equals(Resolver.getNetworkMode())) {
            throw new IOException(jEdit.getProperty((String)"xml.network.error"));
        }
        final String _newSystemId = newSystemId;
        final VFS vfs = VFSManager.getVFSForPath((String)_newSystemId);
        final Object[] sessionArray = new Object[1];
        Runnable run = new Runnable(){

            @Override
            public void run() {
                View view = jEdit.getActiveView();
                if (Resolver.ALWAYS.equals(Resolver.getNetworkMode()) || Resolver.ASK.equals(Resolver.getNetworkMode()) && Resolver.this.showDownloadResourceDialog((Component)view, _newSystemId)) {
                    sessionArray[0] = vfs.createVFSSession(_newSystemId, (Component)view);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Object session = sessionArray[0];
        if (session != null) {
            InputSource source = new InputSource(systemId);
            source.setPublicId(publicId);
            if (Resolver.isUsingCache()) {
                File file;
                try {
                    file = Resolver.copyToLocalFile(session, vfs, newSystemId);
                }
                finally {
                    vfs._endVFSSession(session, null);
                }
                this.addUserResource(publicId, systemId, file.toURI().toURL().toString());
                source.setByteStream(new FileInputStream(file));
            } else {
                source.setByteStream(vfs._createInputStream(session, newSystemId, false, null));
            }
            return source;
        }
        throw new IOException(jEdit.getProperty((String)"xml.network.error"));
    }

    public void clearCache() {
        String prop;
        for (String obj : this.resourceCache.values()) {
            if (!(obj instanceof String)) continue;
            String file = PathUtilities.urlToPath(obj);
            Log.log((int)5, this.getClass(), (Object)("Deleting " + file));
            new File(file).delete();
        }
        int i = 0;
        while (jEdit.getProperty((String)(prop = "xml.cache.public-id." + i++)) != null) {
            jEdit.unsetProperty((String)prop);
            jEdit.unsetProperty((String)(prop + ".uri"));
        }
        i = 0;
        while (jEdit.getProperty((String)(prop = "xml.cache.system-id." + i++)) != null) {
            jEdit.unsetProperty((String)prop);
            jEdit.unsetProperty((String)(prop + ".uri"));
        }
        this.resourceCache.clear();
    }

    public synchronized void reloadCatalogs() {
        this.loadedCatalogs = false;
        this.load();
    }

    private String resolvePublicOrSystemFromCache(String id, boolean isPublic) {
        Entry e = new Entry(isPublic ? 1 : 0, id, null);
        String uri = this.resourceCache.get(e);
        return uri;
    }

    String resolvePublicOrSystem(String id, boolean isPublic) throws IOException {
        String uri = this.resolvePublicOrSystemFromCache(id, isPublic);
        if (uri == null) {
            if (isPublic) {
                return this.catalog.resolvePublic(id, null);
            }
            return this.catalog.resolveSystem(id);
        }
        if (uri == IGNORE) {
            return null;
        }
        return uri;
    }

    private static File copyToLocalFile(Object session, VFS vfs, String path) throws IOException {
        if (jEdit.getSettingsDirectory() == null) {
            return null;
        }
        File _resourceDir = new File(resourceDir);
        if (!_resourceDir.exists()) {
            _resourceDir.mkdir();
        }
        BufferedInputStream in = new BufferedInputStream(vfs._createInputStream(session, path, false, null));
        File localFile = File.createTempFile("cache", ".xml", _resourceDir);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(localFile));
        byte[] buf = new byte[4096];
        int count = 0;
        while ((count = in.read(buf)) != -1) {
            out.write(buf, 0, count);
        }
        out.close();
        return localFile;
    }

    private boolean showDownloadResourceDialog(Component comp, String systemId) {
        Entry e = new Entry(0, systemId, null);
        if (this.resourceCache.get(e) == IGNORE) {
            return false;
        }
        int result = GUIUtilities.confirm((Component)comp, (String)"xml.download-resource", (Object[])new String[]{systemId}, (int)0, (int)3);
        if (result == 0) {
            return true;
        }
        this.resourceCache.put(e, IGNORE);
        return false;
    }

    private void addUserResource(String publicId, String systemId, String url) {
        if (publicId != null) {
            Entry pe = new Entry(1, publicId, url);
            this.resourceCache.put(pe, url);
        }
        Entry se = new Entry(0, systemId, url);
        this.resourceCache.put(se, url);
    }

    public void propertiesChanged() {
        this.loadedCatalogs = false;
    }

    public static boolean isUsingCache() {
        if (jEdit.getSettingsDirectory() == null) {
            return false;
        }
        return jEdit.getBooleanProperty((String)CACHE);
    }

    public static void setUsingCache(boolean newCache) {
        jEdit.setBooleanProperty((String)CACHE, (boolean)newCache);
    }

    public static String getNetworkMode() {
        return jEdit.getProperty((String)MODE);
    }

    public static void setNetworkMode(String newMode) {
        if (!(LOCAL.equals(newMode) || ASK.equals(newMode) || ALWAYS.equals(newMode))) {
            newMode = ASK;
        }
        jEdit.setProperty((String)MODE, (String)newMode);
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return null;
    }

    public class VFSUpdateHandler
    implements EBComponent {
        public void handleMessage(EBMessage msg) {
            if (!Resolver.this.loadedCatalogs) {
                return;
            }
            if (msg instanceof VFSUpdate) {
                String path = ((VFSUpdate)msg).getPath();
                if (Resolver.this.catalogFiles.contains(path)) {
                    Resolver.this.loadedCatalogs = false;
                }
            }
        }
    }

    public static class Entry {
        public static final int SYSTEM = 0;
        public static final int PUBLIC = 1;
        public int type;
        public String id;
        public String uri;

        public Entry(int type, String id, String uri) {
            this.type = type;
            this.id = id;
            this.uri = uri;
        }

        public boolean equals(Object o) {
            if (o instanceof Entry) {
                Entry e = (Entry)o;
                return e.type == this.type && e.id.equals(this.id);
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            return "Resolver.Entry{" + (this.type == 0 ? "SYSTEM" : "PUBLIC") + ",id=" + this.id + ",uri=" + this.uri + "}";
        }
    }

    private static class InputSourceAsLSInput
    implements LSInput {
        private InputSource is;

        InputSourceAsLSInput(InputSource is) {
            this.is = is;
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public InputStream getByteStream() {
            return this.is.getByteStream();
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public Reader getCharacterStream() {
            return this.is.getCharacterStream();
        }

        @Override
        public String getEncoding() {
            return this.is.getEncoding();
        }

        @Override
        public String getPublicId() {
            return this.is.getPublicId();
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public String getSystemId() {
            return this.is.getSystemId();
        }

        @Override
        public void setBaseURI(String baseURI) {
            throw new UnsupportedOperationException("setBaseURI()");
        }

        @Override
        public void setByteStream(InputStream byteStream) {
            throw new UnsupportedOperationException("setByteStream()");
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
            throw new UnsupportedOperationException("setCertifiedText()");
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
            throw new UnsupportedOperationException("setCharacterStream()");
        }

        @Override
        public void setEncoding(String encoding) {
            throw new UnsupportedOperationException("setEncoding()");
        }

        @Override
        public void setPublicId(String publicId) {
            throw new UnsupportedOperationException("setPublicId()");
        }

        @Override
        public void setStringData(String stringData) {
            throw new UnsupportedOperationException("setStringData()");
        }

        @Override
        public void setSystemId(String systemId) {
            throw new UnsupportedOperationException("setSystemId()");
        }
    }
}

