/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.gjt.sp.util.Log;
import xml.SchemaMappingManager;

public final class PathUtilities {
    public static final Pattern windowsDrivePattern = Pattern.compile("[A-Z]:\\\\.*");
    public static final Pattern windowsUNCPattern = Pattern.compile("\\\\\\\\.*");
    public static final Pattern unixPattern = Pattern.compile("/.*");

    public static String pathToURL(String path) {
        if (windowsDrivePattern.matcher(path).matches() || windowsUNCPattern.matcher(path).matches() || unixPattern.matcher(path).matches()) {
            try {
                return new File(path).toURI().toURL().toString();
            }
            catch (MalformedURLException ue) {
                Log.log((int)9, PathUtilities.class, (Object)("strange URI (apos added) '" + path + "'"));
                Log.log((int)9, PathUtilities.class, (Object)ue);
                return path;
            }
        }
        return path;
    }

    public static String urlToPath(String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith("file:/")) {
            try {
                return new File(new URI(url)).getPath();
            }
            catch (URISyntaxException ue) {
                Log.log((int)9, SchemaMappingManager.class, (Object)("strange URI (apos added) '" + url + "'"));
                Log.log((int)9, SchemaMappingManager.class, (Object)ue);
                return url;
            }
        }
        return url;
    }
}

