/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.util.HashMap;
import java.util.Map;

public class NamespaceBindings {
    private HashMap<String, String> bindings;

    public NamespaceBindings() {
        this.bindings = new HashMap();
    }

    public NamespaceBindings(NamespaceBindings namespacesToInsert) {
        this.bindings = new HashMap<String, String>(namespacesToInsert.bindings);
    }

    public void put(String namespace, String prefix) {
        this.bindings.put(namespace, prefix);
    }

    public String getPrefix(String namespace) {
        return this.bindings.get(namespace);
    }

    public String getNamespace(String prefix) {
        for (Map.Entry<String, String> en : this.bindings.entrySet()) {
            if (!en.getValue().equals(prefix)) continue;
            return en.getKey();
        }
        return "";
    }

    public boolean containsNamespace(String namespace) {
        return this.bindings.containsKey(namespace);
    }

    public boolean containsPrefix(String prefix) {
        return this.bindings.containsValue(prefix);
    }

    public void appendNamespaces(StringBuilder buf) {
        if (this.bindings.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> en : this.bindings.entrySet()) {
            buf.append(' ');
            buf.append("xmlns:").append(en.getValue()).append("=\"").append(en.getKey()).append('\"');
        }
    }

    public void putAll(NamespaceBindings namespaceBindings) {
        this.bindings.putAll(namespaceBindings.bindings);
    }

    public boolean isEmpty() {
        return this.bindings.isEmpty();
    }

    public static String generatePrefix(NamespaceBindings ... namespaces) {
        int i = 0;
        while (true) {
            String pre = "ns" + i;
            boolean notSeen = true;
            for (NamespaceBindings namespace : namespaces) {
                if (!(notSeen &= !namespace.containsPrefix(pre))) break;
            }
            if (notSeen) {
                return pre;
            }
            ++i;
        }
    }

    public static String composeName(String localname, String ns, NamespaceBindings namespaces, NamespaceBindings namespacesToInsert, boolean emptyPrefixIsOK) {
        if (ns == null || "".equals(ns)) {
            return localname;
        }
        String pre = namespacesToInsert.getPrefix(ns);
        if (pre == null || !emptyPrefixIsOK && "".equals(pre)) {
            pre = namespaces.getPrefix(ns);
        }
        if (pre == null || !emptyPrefixIsOK && "".equals(pre)) {
            if ("http://www.w3.org/XML/1998/namespace".equals(ns)) {
                pre = "xml";
            } else {
                pre = NamespaceBindings.generatePrefix(namespaces, namespacesToInsert);
                namespacesToInsert.put(ns, pre);
            }
        }
        if ("".equals(pre)) {
            return localname;
        }
        return pre + ":" + localname;
    }
}

