/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;
import xml.NamespaceBindings;
import xml.XmlActions;
import xml.XmlParsedData;
import xml.completion.ElementDecl;
import xml.completion.IDDecl;

public class EditTagDialog
extends EnhancedDialog {
    private boolean html;
    private String elementName;
    private ElementDecl element;
    private Map entityHash;
    private JCheckBox empty;
    private List<Attribute> attributeModel;
    private JTable attributes;
    private JTextArea preview;
    private JButton ok;
    private JButton cancel;
    private String newTag;
    private boolean isOK;
    private NamespaceBindings namespaces;
    private NamespaceBindings namespacesToInsert;
    static ComboValueRenderer comboRenderer = new ComboValueRenderer();

    EditTagDialog(View view, String elementName, ElementDecl element, Map<String, Object> attributeValues, boolean elementEmpty, Map entityHash, List ids, boolean html, NamespaceBindings namespaces, NamespaceBindings namespacesToInsert) {
        super((Frame)view, jEdit.getProperty((String)"xml-edit-tag.title"), true);
        this.elementName = elementName;
        this.element = element;
        this.entityHash = entityHash;
        this.html = html;
        this.namespaces = namespaces;
        this.namespacesToInsert = namespacesToInsert;
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        JPanel top = new JPanel(new BorderLayout(6, 0));
        top.setBorder(new EmptyBorder(0, 0, 12, 0));
        top.add("West", new JLabel(jEdit.getProperty((String)"xml-edit-tag.element-name")));
        top.add("Center", new JLabel(element.name));
        this.empty = new JCheckBox(jEdit.getProperty((String)"xml-edit-tag.empty"));
        if (element.empty) {
            this.empty.setSelected(true);
            this.empty.setEnabled(false);
        } else {
            this.empty.setSelected(elementEmpty);
        }
        this.empty.addActionListener(new ActionHandler());
        top.add("East", this.empty);
        content.add("North", top);
        JPanel center = new JPanel(new BorderLayout());
        this.attributeModel = this.createAttributeModel(element.attributes, attributeValues, ids);
        this.attributes = new AttributeTable();
        this.attributes.setModel(new AttributeTableModel());
        this.attributes.setRowHeight(new JComboBox<String>(new String[]{"template"}).getPreferredSize().height);
        this.attributes.getTableHeader().setReorderingAllowed(false);
        this.attributes.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.attributes.setColumnSelectionAllowed(false);
        this.attributes.setRowSelectionAllowed(false);
        this.attributes.setCellSelectionEnabled(false);
        JScrollPane scroller = new JScrollPane(this.attributes);
        Dimension size = scroller.getPreferredSize();
        size.height = Math.min(size.width, 200);
        scroller.setPreferredSize(size);
        center.add("Center", scroller);
        JPanel previewPanel = new JPanel(new BorderLayout());
        previewPanel.setBorder(new EmptyBorder(12, 0, 0, 0));
        previewPanel.add("North", new JLabel(jEdit.getProperty((String)"xml-edit-tag.preview")));
        this.preview = new JTextArea(5, 5);
        this.preview.setLineWrap(true);
        this.preview.setWrapStyleWord(true);
        this.preview.setEditable(false);
        previewPanel.add("Center", new JScrollPane(this.preview));
        center.add("South", previewPanel);
        content.add("Center", center);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setBorder(new EmptyBorder(12, 0, 0, 0));
        buttons.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty((String)"common.ok"));
        buttons.add(this.ok);
        this.ok.addActionListener(new ActionHandler());
        this.getRootPane().setDefaultButton(this.ok);
        buttons.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty((String)"common.cancel"));
        buttons.add(this.cancel);
        this.cancel.addActionListener(new ActionHandler());
        buttons.add(this.cancel);
        buttons.add(Box.createGlue());
        content.add("South", buttons);
        this.updateTag();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo((Component)view);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditTagDialog.this.requestFocus();
            }
        });
        this.setVisible(true);
    }

    public void ok() {
        int row = this.attributes.getSelectedRow();
        int column = this.attributes.getSelectedColumn();
        if (row != -1 && column != -1 && this.attributes.getCellEditor(row, column) != null) {
            this.attributes.getCellEditor(row, column).stopCellEditing();
        }
        this.isOK = true;
        this.dispose();
    }

    public void cancel() {
        this.isOK = false;
        this.dispose();
    }

    public String getNewTag() {
        return this.isOK ? this.newTag : null;
    }

    public boolean isEmpty() {
        return this.empty.isSelected();
    }

    private ArrayList<Attribute> createAttributeModel(List declaredAttributes, Map<String, Object> attributeValues, List ids) {
        ArrayList<String> stringIDs = new ArrayList<String>(ids.size());
        for (int i = 0; i < ids.size(); ++i) {
            stringIDs.add(((IDDecl)ids.get((int)i)).id);
        }
        ArrayList<Attribute> attributeModel = new ArrayList<Attribute>();
        NamespaceBindings localNamespacesToInsert = new NamespaceBindings(this.namespacesToInsert);
        for (int i = 0; i < declaredAttributes.size(); ++i) {
            ArrayList<String> values;
            boolean set;
            ElementDecl.AttributeDecl attr = (ElementDecl.AttributeDecl)declaredAttributes.get(i);
            String attrName = NamespaceBindings.composeName(attr.name, attr.namespace, this.namespaces, localNamespacesToInsert, false);
            String value = (String)attributeValues.get(attrName);
            if (value == null) {
                set = false;
                value = attr.value;
            } else {
                set = true;
            }
            if (attr.required) {
                set = true;
            }
            if (attr.type.equals("IDREF") && stringIDs.size() > 0) {
                values = stringIDs;
                if (value == null) {
                    value = (String)stringIDs.get(0);
                }
            } else {
                values = attr.values;
                if (value == null && values != null && values.size() > 0) {
                    value = (String)values.get(0);
                }
            }
            attributeModel.add(new Attribute(set, attrName, attr.namespace, value, values, attr.type, attr.required));
        }
        Collections.sort(attributeModel, new AttributeCompare());
        return attributeModel;
    }

    private void updateTag() {
        int tagNameCase = TextUtilities.getStringCase((String)this.elementName);
        NamespaceBindings localNamespacesToInsert = new NamespaceBindings(this.namespacesToInsert);
        StringBuilder buf = new StringBuilder("<");
        buf.append(this.elementName);
        for (int i = 0; i < this.attributeModel.size(); ++i) {
            Attribute attr = this.attributeModel.get(i);
            if (!attr.set) continue;
            buf.append(' ');
            String attrName = attr.name;
            if (this.html) {
                switch (tagNameCase) {
                    case 2: {
                        attrName = attr.name.toUpperCase();
                        break;
                    }
                    case 1: {
                        attrName = attr.name.toLowerCase();
                        break;
                    }
                    case 3: {
                        attrName = TextUtilities.toTitleCase((String)attr.name);
                    }
                }
            } else {
                String prefix = XmlParsedData.getElementNamePrefix(attrName);
                if (!(attr.namespace == null || "".equals(attr.namespace) || "http://www.w3.org/XML/1998/namespace".equals(attr.namespace) || this.namespaces.containsNamespace(attr.namespace) || localNamespacesToInsert.containsNamespace(attr.namespace))) {
                    localNamespacesToInsert.put(attr.namespace, prefix);
                }
            }
            buf.append(attrName);
            if (this.html && attr.name.equals(attr.value.value)) continue;
            buf.append("=\"");
            if (attr.value.value != null) {
                buf.append(XmlActions.charactersToEntities(attr.value.value, this.entityHash));
            }
            buf.append("\"");
        }
        localNamespacesToInsert.appendNamespaces(buf);
        if (this.empty.isSelected() && !this.html) {
            buf.append("/");
        }
        buf.append(">");
        this.newTag = buf.toString();
        this.preview.setText(this.newTag);
    }

    public static StringBuilder[] composeTag(XmlParsedData data, ElementDecl elementDecl, NamespaceBindings namespaces, NamespaceBindings namespacesToInsert, boolean withEndOfTag) {
        StringBuilder buf = new StringBuilder();
        StringBuilder close = new StringBuilder();
        String ns = elementDecl.completionInfo.namespace;
        String elementName = NamespaceBindings.composeName(elementDecl.name, ns, namespaces, namespacesToInsert, true);
        buf.append(elementName);
        buf.append(elementDecl.getRequiredAttributesString(namespaces, namespacesToInsert));
        namespacesToInsert.appendNamespaces(buf);
        if (withEndOfTag) {
            if (elementDecl.empty) {
                if (data.html) {
                    buf.append(">");
                } else {
                    buf.append(XmlActions.getStandaloneEnd());
                }
            } else {
                buf.append(">");
                close.append("</").append(elementName).append(">");
            }
        }
        return new StringBuilder[]{buf, close};
    }

    static class ComboValueRenderer
    extends DefaultCellEditor
    implements TableCellRenderer {
        JComboBox editorCombo;
        JComboBox renderCombo;

        ComboValueRenderer() {
            this(new JComboBox());
        }

        ComboValueRenderer(JComboBox comboBox) {
            super(comboBox);
            this.editorCombo = comboBox;
            this.editorCombo.setEditable(true);
            this.renderCombo = new JComboBox();
            this.renderCombo.setEditable(true);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Attribute.Value _value = (Attribute.Value)value;
            this.editorCombo.setModel(new DefaultComboBoxModel<Object>(_value.values.toArray()));
            return super.getTableCellEditorComponent(table, _value.value, isSelected, row, column);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Attribute.Value _value = (Attribute.Value)value;
            this.renderCombo.setModel(new DefaultComboBoxModel<Object>(_value.values.toArray()));
            this.renderCombo.setSelectedItem(_value.value);
            return this.renderCombo;
        }
    }

    class AttributeTableModel
    extends AbstractTableModel {
        AttributeTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return EditTagDialog.this.attributeModel.size();
        }

        public Class getColumnClass(int col) {
            if (col == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return jEdit.getProperty((String)"xml-edit-tag.set");
                }
                case 1: {
                    return jEdit.getProperty((String)"xml-edit-tag.attribute");
                }
                case 2: {
                    return jEdit.getProperty((String)"xml-edit-tag.type");
                }
                case 3: {
                    return jEdit.getProperty((String)"xml-edit-tag.value");
                }
            }
            throw new InternalError();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 1 && col != 2;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Attribute attr = (Attribute)EditTagDialog.this.attributeModel.get(row);
            switch (col) {
                case 0: {
                    return new Boolean(attr.set);
                }
                case 1: {
                    return attr.name;
                }
                case 2: {
                    if (attr.required) {
                        if (attr.type.startsWith("(")) {
                            return jEdit.getProperty((String)"xml-edit-tag.required");
                        }
                        return attr.type + ", " + jEdit.getProperty((String)"xml-edit-tag.required");
                    }
                    if (attr.type.startsWith("(")) {
                        return "";
                    }
                    return attr.type;
                }
                case 3: {
                    if (attr.value.values != null) {
                        return attr.value;
                    }
                    return attr.value.value;
                }
            }
            throw new InternalError();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Attribute attr = (Attribute)EditTagDialog.this.attributeModel.get(row);
            switch (col) {
                case 0: {
                    if (attr.required) {
                        return;
                    }
                    attr.set = (Boolean)value;
                    break;
                }
                case 3: {
                    String sValue = value instanceof IDDecl ? ((IDDecl)value).id : value.toString();
                    if (this.equal(attr.value.value, sValue)) {
                        return;
                    }
                    attr.set = true;
                    attr.value.value = sValue;
                }
            }
            this.fireTableRowsUpdated(row, row);
            EditTagDialog.this.updateTag();
        }

        private boolean equal(String str1, String str2) {
            if (str1 == null || str1.length() == 0) {
                return str2 == null || str2.length() == 0;
            }
            if (str2 == null) {
                return false;
            }
            return str1.equals(str2);
        }
    }

    class AttributeTable
    extends JTable {
        AttributeTable() {
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            Object value = this.getModel().getValueAt(row, column);
            if (value instanceof Attribute.Value) {
                return comboRenderer;
            }
            return super.getCellEditor(row, column);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            Object value = this.getModel().getValueAt(row, column);
            if (value instanceof Attribute.Value) {
                return comboRenderer;
            }
            return super.getCellRenderer(row, column);
        }
    }

    static class AttributeCompare
    implements Comparator<Attribute> {
        AttributeCompare() {
        }

        @Override
        public int compare(Attribute attr1, Attribute attr2) {
            if (attr1.required && !attr2.required) {
                return -1;
            }
            if (!attr1.required && attr2.required) {
                return 1;
            }
            return StandardUtilities.compareStrings((String)attr1.name, (String)attr2.name, (boolean)true);
        }
    }

    static class Attribute {
        boolean set;
        String name;
        String namespace;
        Value value;
        String type;
        boolean required;

        Attribute(boolean set, String name, String namespace, String value, ArrayList values, String type, boolean required) {
            this.set = set;
            this.name = name;
            this.namespace = namespace;
            this.value = new Value(value, values);
            this.type = type;
            this.required = required;
        }

        static class Value {
            String value;
            ArrayList values;

            Value(String value, ArrayList values) {
                this.value = value;
                this.values = values;
            }

            public String toString() {
                return this.value;
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == EditTagDialog.this.empty) {
                EditTagDialog.this.updateTag();
            } else if (evt.getSource() == EditTagDialog.this.ok) {
                EditTagDialog.this.ok();
            } else if (evt.getSource() == EditTagDialog.this.cancel) {
                EditTagDialog.this.cancel();
            }
        }
    }
}

