/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.awt.Component;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.View;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DTDGenerator
extends DefaultHandler {
    protected static int MIN_ENUMERATION_INSTANCES = 10;
    protected static int MAX_ENUMERATION_VALUES = 20;
    protected static int MIN_ENUMERATION_RATIO = 3;
    protected static int MIN_FIXED = 5;
    protected static int MIN_ID_VALUES = 10;
    protected static int MAX_ID_VALUES = 100000;
    TreeMap<String, ElementDetails> elementList = new TreeMap();
    Stack<StackEntry> elementStack = new Stack();

    public static String write(View view, String xml) {
        DTDGenerator generator = new DTDGenerator();
        generator.parse(view, xml);
        return generator.printDTD();
    }

    public static String writeXSD(View view, String xml) {
        DTDGenerator generator = new DTDGenerator();
        generator.parse(view, xml);
        return generator.printDTD();
    }

    public static String writeRNG(View view, String xml) {
        DTDGenerator generator = new DTDGenerator();
        generator.parse(view, xml);
        return generator.printDTD();
    }

    private void parse(View view, String text) {
        try {
            InputSource is = new InputSource(new StringReader(text));
            XMLReader parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            parser.setContentHandler(this);
            parser.setEntityResolver(this);
            parser.parse(is);
        }
        catch (Exception err) {
            StringBuffer s = new StringBuffer("Failed while parsing text:\n");
            s.append(err.getMessage() + "\n");
            Macros.error((Component)view, (String)s.toString());
        }
    }

    private boolean isValidName(String s) {
        if (!this.isValidNMTOKEN(s)) {
            return false;
        }
        char c = s.charAt(0);
        return (c < '0' || c > '9') && c != '.' && c != '-';
    }

    private boolean isValidNMTOKEN(String s) {
        if (s.length() == 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.' || c == '_' || c == '-' || c == ':' || c > '\u0080') continue;
            return false;
        }
        return true;
    }

    private String printDTD() {
        StringBuffer s = new StringBuffer();
        for (String elementname : this.elementList.keySet()) {
            ElementDetails ed = this.elementList.get(elementname);
            TreeMap<String, ChildDetails> children = ed.children;
            Set<String> childKeys = children.keySet();
            if (childKeys.size() == 0 && !ed.hasCharacterContent) {
                s.append("<!ELEMENT " + elementname + " EMPTY >\n");
            }
            if (childKeys.size() == 0 && ed.hasCharacterContent) {
                s.append("<!ELEMENT " + elementname + " ( #PCDATA ) >\n");
            }
            if (childKeys.size() > 0 && !ed.hasCharacterContent) {
                s.append("<!ELEMENT " + elementname + " ( ");
                if (ed.sequenced) {
                    Enumeration<ChildDetails> c = ed.childseq.elements();
                    while (true) {
                        ChildDetails ch = c.nextElement();
                        s.append(ch.name);
                        if (ch.repeatable && !ch.optional) {
                            s.append("+");
                        }
                        if (ch.repeatable && ch.optional) {
                            s.append("*");
                        }
                        if (ch.optional && !ch.repeatable) {
                            s.append("?");
                        }
                        if (!c.hasMoreElements()) break;
                        s.append(", ");
                    }
                    s.append(" ) >\n");
                } else {
                    Iterator<String> c1 = childKeys.iterator();
                    while (c1.hasNext()) {
                        s.append(c1.next());
                        if (!c1.hasNext()) continue;
                        s.append(" | ");
                    }
                    s.append(" )* >\n");
                }
            }
            if (childKeys.size() > 0 && ed.hasCharacterContent) {
                s.append("<!ELEMENT " + elementname + " ( #PCDATA");
                Iterator<String> c2 = childKeys.iterator();
                while (c2.hasNext()) {
                    s.append(" | " + c2.next());
                }
                s.append(" )* >\n");
            }
            TreeMap<String, AttributeDetails> attlist = ed.attributes;
            boolean doneID = false;
            for (String attname : attlist.keySet()) {
                String tokentype;
                AttributeDetails ad = attlist.get(attname);
                boolean required = ad.occurrences == ed.occurrences;
                boolean isid = ad.allNames && !doneID && ad.unique && ad.occurrences >= MIN_ID_VALUES;
                boolean isfixed = required && ad.values.size() == 1 && ad.occurrences >= MIN_FIXED;
                boolean isenum = ad.allNMTOKENs && ad.occurrences >= MIN_ENUMERATION_INSTANCES && ad.values.size() <= ad.occurrences / MIN_ENUMERATION_RATIO && ad.values.size() <= MAX_ENUMERATION_VALUES;
                s.append("<!ATTLIST " + elementname + " " + attname + " ");
                String string = tokentype = ad.allNMTOKENs ? "NMTOKEN" : "CDATA";
                if (isid) {
                    s.append("ID");
                    doneID = true;
                } else if (isfixed) {
                    String val = ad.values.first();
                    s.append(tokentype + " #FIXED \"" + DTDGenerator.escape(val) + "\" >\n");
                } else if (isenum) {
                    s.append("( ");
                    Iterator<String> v = ad.values.iterator();
                    while (v.hasNext()) {
                        s.append(v.next());
                        if (!v.hasNext()) break;
                        s.append(" | ");
                    }
                    s.append(" )");
                } else {
                    s.append(tokentype);
                }
                if (isfixed) continue;
                if (required) {
                    s.append(" #REQUIRED >\n");
                    continue;
                }
                s.append(" #IMPLIED >\n");
            }
            s.append("\n");
        }
        return s.toString();
    }

    private static int escape(char[] ch, int start, int length, char[] out) {
        int o = 0;
        for (int i = start; i < start + length; ++i) {
            if (ch[i] == '<') {
                "&lt;".getChars(0, 4, out, o);
                o += 4;
                continue;
            }
            if (ch[i] == '>') {
                "&gt;".getChars(0, 4, out, o);
                o += 4;
                continue;
            }
            if (ch[i] == '&') {
                "&amp;".getChars(0, 5, out, o);
                o += 5;
                continue;
            }
            if (ch[i] == '\"') {
                "&#34;".getChars(0, 5, out, o);
                o += 5;
                continue;
            }
            if (ch[i] == '\'') {
                "&#39;".getChars(0, 5, out, o);
                o += 5;
                continue;
            }
            out[o++] = ch[i];
        }
        return o;
    }

    private static String escape(String in) {
        char[] dest = new char[in.length() * 8];
        int newlen = DTDGenerator.escape(in.toCharArray(), 0, in.length(), dest);
        return new String(dest, 0, newlen);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource dummy = new InputSource(new StringReader("<!-- -->"));
        dummy.setSystemId(systemId);
        dummy.setPublicId(publicId);
        return dummy;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        StackEntry se = new StackEntry();
        ElementDetails ed = this.elementList.get(name);
        if (ed == null) {
            ed = new ElementDetails(name);
            this.elementList.put(name, ed);
        }
        se.elementDetails = ed;
        se.sequenceNumber = -1;
        ++ed.occurrences;
        for (int a = 0; a < attributes.getLength(); ++a) {
            String attName = attributes.getQName(a);
            String val = attributes.getValue(a);
            AttributeDetails ad = ed.attributes.get(attName);
            if (ad == null) {
                ad = new AttributeDetails(attName);
                ed.attributes.put(attName, ad);
            }
            if (!ad.values.contains(val)) {
                ad.values.add(val);
                if (ad.allNames && !this.isValidName(val)) {
                    ad.allNames = false;
                }
                if (ad.allNMTOKENs && !this.isValidNMTOKEN(val)) {
                    ad.allNMTOKENs = false;
                }
                if (ad.unique && ad.allNames && ad.occurrences <= MAX_ID_VALUES) {
                    ad.values.add(val);
                } else if (ad.values.size() <= MAX_ENUMERATION_VALUES) {
                    ad.values.add(val);
                }
            } else {
                ad.unique = false;
            }
            ++ad.occurrences;
        }
        if (!this.elementStack.isEmpty()) {
            boolean isFirstInGroup;
            StackEntry parent = this.elementStack.peek();
            ElementDetails parentDetails = parent.elementDetails;
            int seq = parent.sequenceNumber;
            boolean bl = isFirstInGroup = parent.latestChild == null || !parent.latestChild.equals(name);
            if (isFirstInGroup) {
                ++seq;
                ++parent.sequenceNumber;
            }
            parent.latestChild = name;
            TreeMap<String, ChildDetails> children = parentDetails.children;
            ChildDetails c = children.get(name);
            if (c == null) {
                c = new ChildDetails();
                c.name = name;
                c.position = seq;
                c.repeatable = false;
                c.optional = false;
                children.put(name, c);
                parentDetails.childseq.addElement(c);
                if (parentDetails.occurrences != 1) {
                    c.optional = true;
                }
            } else {
                if (parentDetails.occurrences == 1 && isFirstInGroup) {
                    parentDetails.sequenced = false;
                }
                if (parentDetails.childseq.size() <= seq || !parentDetails.childseq.elementAt((int)seq).name.equals(name)) {
                    parentDetails.sequenced = false;
                }
            }
            if (!isFirstInGroup) {
                c.repeatable = true;
            }
        }
        this.elementStack.push(se);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        ElementDetails ed = this.elementList.get(name);
        if (ed.sequenced) {
            StackEntry se = this.elementStack.peek();
            int seq = se.sequenceNumber;
            for (int i = seq + 1; i < ed.childseq.size(); ++i) {
                ed.childseq.elementAt((int)i).optional = true;
            }
        }
        this.elementStack.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        ElementDetails ed = this.elementStack.peek().elementDetails;
        if (!ed.hasCharacterContent) {
            for (int i = start; i < start + length; ++i) {
                if (ch[i] <= ' ') continue;
                ed.hasCharacterContent = true;
                break;
            }
        }
    }

    private class StackEntry {
        ElementDetails elementDetails;
        int sequenceNumber;
        String latestChild;

        private StackEntry() {
        }
    }

    private class AttributeDetails {
        String name;
        int occurrences;
        boolean unique;
        TreeSet<String> values;
        boolean allNames;
        boolean allNMTOKENs;

        public AttributeDetails(String name) {
            this.name = name;
            this.occurrences = 0;
            this.unique = true;
            this.values = new TreeSet();
            this.allNames = true;
            this.allNMTOKENs = true;
        }
    }

    private class ChildDetails {
        String name;
        int position;
        boolean repeatable;
        boolean optional;

        private ChildDetails() {
        }
    }

    private class ElementDetails {
        String name;
        int occurrences;
        boolean hasCharacterContent;
        boolean sequenced;
        TreeMap<String, ChildDetails> children;
        Vector<ChildDetails> childseq;
        TreeMap<String, AttributeDetails> attributes;

        public ElementDetails(String name) {
            this.name = name;
            this.occurrences = 0;
            this.hasCharacterContent = false;
            this.sequenced = true;
            this.children = new TreeMap();
            this.childseq = new Vector();
            this.attributes = new TreeMap();
        }
    }
}

