/*
 * Decompiled with CFR 0.152.
 */
package sidekick.javascript;

import errorlist.DefaultErrorSource;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Stack;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.util.Log;
import sidekick.SideKickParsedData;
import sidekick.enhanced.SourceParser;

public class JavaScriptParser
extends SourceParser {
    Pattern pClassFunction = Pattern.compile("^((\\w+\\.)*[A-Z][\\w]*)\\s*=\\s*function");
    Pattern pMethodFunction = Pattern.compile("^([\\w+\\.]+\\w+)\\.([\\w]+)\\s*=\\s*function");
    Pattern pPrototypeFunction = Pattern.compile("^([\\w+\\.]+\\w+)\\.prototype\\.([\\w]+)\\s*=\\s*function");
    Pattern pAssignedFunction = Pattern.compile("^(\\w+)\\s*=\\s*function");
    Pattern pVarFunction = Pattern.compile("^var\\s+(\\w+)\\s*=\\s*function");
    Pattern pSimpleFunction = Pattern.compile("^function\\s+(\\w+)");
    Pattern pObject = Pattern.compile("^((\\w+\\.)*[A-Z][\\w]*)\\s*=[^\\{]*\\{");
    Pattern pVarObject = Pattern.compile("^var\\s+((\\w+\\.)*[A-Z][\\w]*)\\s*=[^\\{]*\\{");
    Pattern pObjectMethod = Pattern.compile("^(\\w+)\\s*:\\s*function");

    public JavaScriptParser() {
        super("javascript");
        this.LINE_COMMENT = "//";
        this.COMMENT = "Comments";
        this.MAIN = "(Window)";
        this.USE = "import";
    }

    protected void parseBuffer(Buffer buffer, DefaultErrorSource errorSource) {
        this.setStartLine(0);
        this.parseBuffer(buffer, buffer.getText(0, buffer.getLength()), errorSource);
    }

    public SideKickParsedData parse(Buffer buffer, String text, DefaultErrorSource errorSource) {
        this.data = new SideKickParsedData(buffer.getName());
        this.packages = new SourceParser.PackageMap((SourceParser)this, new SourceParser.PackageComparator((SourceParser)this));
        this.commentList = new ArrayList();
        this.parseBuffer(buffer, text, errorSource);
        this.completePackageAsset(this._end, this._lastLineNumber);
        Log.log((int)1, (Object)((Object)this), (Object)"parsing completed");
        this.buildTrees();
        Log.log((int)1, (Object)((Object)this), (Object)"tree built");
        return this.data;
    }

    protected void parseBuffer(Buffer buffer, String text, DefaultErrorSource errorSource) {
        Stack<String> funcstack = new Stack<String>();
        Stack<String> pkgstack = new Stack<String>();
        pkgstack.push(this.MAIN);
        boolean in_comment = false;
        int buflen = buffer.getLength();
        for (int lineNo = this.startLine; lineNo < this.startLine + this.getLineCount(text); ++lineNo) {
            this._start = buffer.createPosition(buffer.getLineStartOffset(lineNo));
            int _tmp = buffer.getLineEndOffset(lineNo);
            if (_tmp > buflen) {
                _tmp = buflen;
            }
            this._end = buffer.createPosition(_tmp);
            String line = buffer.getLineText(lineNo).trim();
            if (line.indexOf(this.LINE_COMMENT) == 0 || line.length() == 0) continue;
            if (in_comment && line.indexOf("*/") != -1) {
                in_comment = false;
                this.completeAsset(this._end);
            }
            if (in_comment) continue;
            String name = this.find(line, this.pClassFunction, 1);
            if (name != null) {
                if (!pkgstack.empty()) {
                    pkgstack.pop();
                }
                pkgstack.push(name);
                this.addPackageAsset(name, lineNo, this._start);
                this.addAsset(this.SUB_KEY, name, "(constructor)", lineNo, this._start);
                continue;
            }
            name = this.find(line, this.pObject, 1);
            if (name == null) {
                name = this.find(line, this.pVarObject, 1);
            }
            if (name != null) {
                if (!pkgstack.empty()) {
                    pkgstack.pop();
                }
                pkgstack.push(name);
                this.addPackageAsset(name, lineNo, this._start);
                this.addLineAsset(this.SUB_KEY, name, "(assignment)", lineNo, this._start, this._end);
                continue;
            }
            String[] names = this.find2(line, this.pPrototypeFunction);
            if (names == null) {
                names = this.find2(line, this.pMethodFunction);
            }
            if (names != null) {
                String pkgname = names[0];
                if (pkgstack.empty()) {
                    pkgstack.push(pkgname);
                    this.addPackageAsset(pkgname, lineNo, this._start);
                } else if (!pkgname.equals((String)pkgstack.peek())) {
                    pkgstack.pop();
                    pkgstack.push(pkgname);
                    this.addPackageAsset(pkgname, lineNo, this._start);
                }
                if (!funcstack.empty()) {
                    funcstack.pop();
                    this.completeAsset(this._start);
                }
                funcstack.push(names[1]);
                this.addAsset(this.SUB_KEY, names[0], names[1], lineNo, this._start);
                continue;
            }
            name = this.find(line, this.pAssignedFunction, 1);
            if (name == null) {
                name = this.find(line, this.pVarFunction, 1);
            }
            if (name == null) {
                name = this.find(line, this.pObjectMethod, 1);
            }
            if (name == null) {
                name = this.find(line, this.pSimpleFunction, 1);
            }
            if (name != null) {
                if (!funcstack.empty()) {
                    funcstack.pop();
                    this.completeAsset(this._start);
                }
                funcstack.push(name);
                this.addAsset(this.SUB_KEY, (String)pkgstack.peek(), name, lineNo, this._start);
                continue;
            }
            if (in_comment || line.indexOf("/*") == -1) continue;
            this.completeAsset(this._end);
            if (!funcstack.empty()) {
                name = (String)funcstack.peek();
            }
            if (name == null) {
                name = (String)pkgstack.peek();
            }
            if (name == null) {
                name = "(comment)";
            }
            in_comment = true;
            this.addCommentAsset(name, lineNo, this._start);
        }
    }

    private int getLineCount(CharSequence text) {
        if (text == null) {
            return 0;
        }
        BufferedReader br = new BufferedReader(new StringReader(((Object)text).toString()));
        String line = null;
        int count = 0;
        try {
            while ((line = br.readLine()) != null) {
                ++count;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }
}

