/*
 * Decompiled with CFR 0.152.
 */
package sidekick.html.parser.html;

import errorlist.DefaultErrorSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.jEdit;
import sidekick.SideKickParsedData;
import sidekick.css.CSS2SideKickParser;
import sidekick.ecmascript.EcmaScriptSideKickParser;
import sidekick.enhanced.PartialParser;
import sidekick.html.parser.html.HtmlDocument;
import sidekick.html.parser.html.HtmlVisitor;
import sidekick.javascript.JavaScriptParser;

public class HtmlTreeBuilder
extends HtmlVisitor {
    private DefaultMutableTreeNode root = null;
    private Stack stack = new Stack();
    private DefaultMutableTreeNode currentNode = null;
    private Buffer buffer = null;
    private DefaultErrorSource errorSource = null;
    private boolean showAll = true;

    public HtmlTreeBuilder(DefaultMutableTreeNode root) {
        this.root = root;
        this.currentNode = root;
    }

    public void setBuffer(Buffer buffer) {
        this.buffer = buffer;
    }

    public void setErrorSource(DefaultErrorSource errorSource) {
        this.errorSource = errorSource;
    }

    public void setShowAll(boolean b) {
        this.showAll = b;
    }

    @Override
    public void visit(HtmlDocument.Tag t) {
        if (this.showAll && !this.currentNode.getUserObject().equals(t) && t.toString() != null) {
            this.currentNode.add(new DefaultMutableTreeNode(t));
        }
    }

    @Override
    public void visit(HtmlDocument.EndTag t) {
    }

    @Override
    public void visit(HtmlDocument.Comment c) {
    }

    @Override
    public void visit(HtmlDocument.JspComment c) {
    }

    @Override
    public void visit(HtmlDocument.Text t) {
    }

    @Override
    public void visit(HtmlDocument.Newline n) {
    }

    @Override
    public void visit(HtmlDocument.Annotation a) {
    }

    @Override
    public void visit(HtmlDocument.TagBlock bl) {
        if (bl != null && bl.toString() != null) {
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(bl);
            this.currentNode.add(childNode);
            this.stack.push(this.currentNode);
            this.currentNode = childNode;
            if (bl.startTag.tagName.equalsIgnoreCase("style") && this.buffer != null) {
                String text = null;
                if (bl.body.getElementAt(0) != null) {
                    text = bl.body.getElementAt(0).toString();
                }
                if (text != null) {
                    CSS2SideKickParser cssparser = new CSS2SideKickParser();
                    cssparser.setLineOffset(bl.startTag.getEndLocation().line - 1);
                    cssparser.setColumnOffset(bl.startTag.getEndLocation().column);
                    SideKickParsedData data = cssparser.parse(this.buffer, text, this.errorSource);
                    ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>();
                    for (int i = 0; i < data.root.getChildCount(); ++i) {
                        children.add((DefaultMutableTreeNode)data.root.getChildAt(i));
                    }
                    for (DefaultMutableTreeNode child : children) {
                        data.root.remove(child);
                        this.currentNode.add(child);
                    }
                }
            } else if (bl.startTag.tagName.equalsIgnoreCase("script") && this.buffer != null) {
                String parser_name;
                String text = null;
                if (bl.body.getElementAt(0) != null) {
                    text = bl.body.getElementAt(0).toString();
                }
                if (text != null && ("ecmascript".equals(parser_name = jEdit.getProperty((String)"mode.javascript.sidekick.parser")) || "javascript".equals(parser_name))) {
                    PartialParser scriptparser = (PartialParser)("ecmascript".equals(parser_name) ? new EcmaScriptSideKickParser() : new JavaScriptParser());
                    scriptparser.setStartLine(bl.getStartLocation().line);
                    SideKickParsedData data = scriptparser.parse(this.buffer, text, this.errorSource);
                    ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>();
                    for (int i = 0; i < data.root.getChildCount(); ++i) {
                        children.add((DefaultMutableTreeNode)data.root.getChildAt(i));
                    }
                    for (DefaultMutableTreeNode child : children) {
                        data.root.remove(child);
                        this.currentNode.add(child);
                    }
                }
            } else {
                this.visit(bl.body);
            }
            this.currentNode = (DefaultMutableTreeNode)this.stack.pop();
        }
    }

    @Override
    public void visit(HtmlDocument.ElementSequence s) {
        if (s == null) {
            return;
        }
        Iterator iterator = s.iterator();
        while (iterator.hasNext()) {
            HtmlDocument.HtmlElement htmlElement = (HtmlDocument.HtmlElement)iterator.next();
            htmlElement.accept(this);
        }
    }

    @Override
    public void visit(HtmlDocument d) {
        if (d == null) {
            return;
        }
        this.start();
        this.visit(d.elements);
        this.finish();
    }

    @Override
    public void start() {
    }

    @Override
    public void finish() {
    }
}

