/*
 * Decompiled with CFR 0.152.
 */
package sidekick.html.parser.html;

import sidekick.html.parser.html.HtmlDocument;
import sidekick.html.parser.html.HtmlVisitor;

public class HtmlScrubber
extends HtmlVisitor {
    public static final int TAGS_UPCASE = 1;
    public static final int TAGS_DOWNCASE = 2;
    public static final int ATTR_UPCASE = 4;
    public static final int ATTR_DOWNCASE = 8;
    public static final int STRIP_QUOTES = 16;
    public static final int TRIM_SPACES = 32;
    public static final int DEFAULT_OPTIONS = 26;
    protected int flags;
    protected HtmlDocument.HtmlElement previousElement;
    protected boolean inPreBlock;

    public HtmlScrubber() {
        this(26);
    }

    public HtmlScrubber(int flags) {
        this.flags = flags;
    }

    private static boolean safeToUnquote(String qs) {
        int upperCount = 0;
        int lowerCount = 0;
        int idCount = 0;
        for (int i = 1; i < qs.length() - 1; ++i) {
            char c = qs.charAt(i);
            if (Character.isUnicodeIdentifierPart(c)) {
                ++idCount;
            }
            if (Character.isUpperCase(c)) {
                ++upperCount;
                continue;
            }
            if (!Character.isLowerCase(c)) continue;
            ++lowerCount;
        }
        return qs.length() - 2 > 0 && qs.length() - 2 == idCount && (upperCount == 0 || lowerCount == 0);
    }

    @Override
    public void start() {
        this.previousElement = null;
        this.inPreBlock = false;
    }

    @Override
    public void visit(HtmlDocument.Tag t) {
        if ((this.flags & 1) != 0) {
            t.tagName = t.tagName.toUpperCase();
        } else if ((this.flags & 2) != 0) {
            t.tagName = t.tagName.toLowerCase();
        }
        for (HtmlDocument.Attribute a : t.attributeList.attributes) {
            if ((this.flags & 4) != 0) {
                a.name = a.name.toUpperCase();
            } else if ((this.flags & 8) != 0) {
                a.name = a.name.toLowerCase();
            }
            if ((this.flags & 0x10) == 0 || !a.hasValue || (a.value.charAt(0) != '\'' || a.value.charAt(a.value.length() - 1) != '\'') && (a.value.charAt(0) != '\"' || a.value.charAt(a.value.length() - 1) != '\"') || !HtmlScrubber.safeToUnquote(a.value)) continue;
            a.value = a.value.substring(1, a.value.length() - 1);
        }
        this.previousElement = t;
    }

    @Override
    public void visit(HtmlDocument.EndTag t) {
        if ((this.flags & 1) != 0) {
            t.tagName = t.tagName.toUpperCase();
        } else if ((this.flags & 2) != 0) {
            t.tagName = t.tagName.toLowerCase();
        }
        this.previousElement = t;
    }

    @Override
    public void visit(HtmlDocument.Text t) {
        if ((this.flags & 0x20) != 0 && !this.inPreBlock && (this.previousElement instanceof HtmlDocument.Newline || this.previousElement instanceof HtmlDocument.Tag || this.previousElement instanceof HtmlDocument.EndTag || this.previousElement instanceof HtmlDocument.Comment)) {
            int i;
            for (i = 0; i < t.text.length() && (t.text.charAt(i) == ' ' || t.text.charAt(i) == '\t'); ++i) {
            }
            if (i > 0) {
                t.text = t.text.substring(i);
            }
        }
        this.previousElement = t;
    }

    @Override
    public void visit(HtmlDocument.Comment c) {
        this.previousElement = c;
    }

    @Override
    public void visit(HtmlDocument.Newline n) {
        this.previousElement = n;
    }

    @Override
    public void visit(HtmlDocument.Annotation a) {
        this.previousElement = a;
    }

    @Override
    public void visit(HtmlDocument.TagBlock bl) {
        if (bl.startTag.tagName.equalsIgnoreCase("PRE") || bl.startTag.tagName.equalsIgnoreCase("SCRIPT") || bl.startTag.tagName.equalsIgnoreCase("STYLE")) {
            this.inPreBlock = true;
            super.visit(bl);
            this.inPreBlock = false;
        } else {
            super.visit(bl);
        }
    }
}

