/*
 * Decompiled with CFR 0.152.
 */
package sidekick.html.parser.html;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sidekick.html.parser.html.HtmlDocument;
import sidekick.html.parser.html.HtmlDumper;
import sidekick.html.parser.html.HtmlParserConstants;
import sidekick.html.parser.html.HtmlParserTokenManager;
import sidekick.html.parser.html.ParseException;
import sidekick.html.parser.html.SimpleCharStream;
import sidekick.html.parser.html.Token;
import sidekick.util.Location;
import sidekick.util.ParseError;
import sidekick.util.Range;

public class HtmlParser
implements HtmlParserConstants {
    static String NL = System.getProperty("line.separator");
    private List<ParseError> parseErrors = new ArrayList<ParseError>();
    private Pattern pePattern = Pattern.compile("(.*?)(\\d+)(.*?)(\\d+)(.*?)");
    private Pattern attributePattern = Pattern.compile("([a-zA-Z0-9.-])*");
    public HtmlParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[13];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[4];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public void setLineSeparator(String ls) {
        NL = ls;
    }

    private static String getTokenText(Token first, Token cur) {
        StringBuffer sb = new StringBuffer();
        Token t = first;
        while (t != cur.next) {
            if (t.specialToken != null) {
                Token tt = t.specialToken;
                while (tt.specialToken != null) {
                    tt = tt.specialToken;
                }
                while (tt != null) {
                    sb.append(tt.image);
                    tt = tt.next;
                }
            }
            sb.append(t.image);
            t = t.next;
        }
        return sb.toString();
    }

    public HtmlParser(Reader in, int lineOffset, int columnOffset) {
        this(in);
        this.jj_input_stream.ReInit(in, lineOffset, columnOffset);
    }

    public static void main(String[] args) throws ParseException {
        HtmlParser parser = new HtmlParser(System.in);
        HtmlDocument doc = parser.HtmlDocument();
        doc.accept(new HtmlDumper(System.out));
        System.exit(0);
    }

    public void setTabSize(int size) {
        this.jj_input_stream.setTabSize(size);
    }

    public int getTabSize() {
        return this.jj_input_stream.getTabSize(0);
    }

    private void addException(ParseException pe) {
        Range range = this.getExceptionLocation(pe);
        this.parseErrors.add(new ParseError(pe.getMessage(), range));
        pe.printStackTrace();
    }

    public List<ParseError> getParseErrors() {
        System.out.println("getParserErrors, there are " + this.parseErrors.size() + " errors");
        return this.parseErrors;
    }

    private Range getExceptionLocation(ParseException pe) {
        Token t = pe.currentToken;
        if (t != null) {
            return new Range(new Location(t.next.beginLine - 1, t.next.beginColumn), new Location(t.next.endLine - 1, t.next.endColumn));
        }
        try {
            Matcher m = this.pePattern.matcher(pe.getMessage());
            if (m.matches()) {
                String ln = m.group(2);
                String cn = m.group(4);
                int line_number = -1;
                int column_number = 0;
                if (ln != null) {
                    line_number = Integer.parseInt(ln);
                }
                if (cn != null) {
                    column_number = Integer.parseInt(cn);
                }
                return line_number > -1 ? new Range(new Location(line_number - 1, column_number - 1), new Location(line_number - 1, column_number)) : null;
            }
            return new Range();
        }
        catch (Exception e) {
            return new Range();
        }
    }

    private boolean isProperAttribute(String s) {
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return true;
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return true;
        }
        if (s.startsWith("<%") && (s.endsWith("%>") || s.endsWith("%"))) {
            return true;
        }
        boolean rtn = this.attributePattern.matcher(s).matches();
        if (!rtn) {
            System.out.println("bad attribute: " + s);
        }
        return rtn;
    }

    public final HtmlDocument HtmlDocument() throws ParseException {
        HtmlDocument.ElementSequence s = this.ElementSequence();
        this.jj_consume_token(0);
        return new HtmlDocument(s);
    }

    public final HtmlDocument.ElementSequence ElementSequence() throws ParseException {
        HtmlDocument.ElementSequence s = new HtmlDocument.ElementSequence();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            HtmlDocument.HtmlElement h = this.Element();
            s.addElement(h);
        }
        return s;
    }

    public final HtmlDocument.HtmlElement Element() throws ParseException {
        if (this.jj_2_1(2)) {
            HtmlDocument.HtmlElement e = this.Tag();
            return e;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                HtmlDocument.HtmlElement e = this.EndTag();
                return e;
            }
            case 16: {
                HtmlDocument.Comment e = this.CommentTag();
                return e;
            }
            case 19: {
                HtmlDocument.Comment e = this.DeclTag();
                return e;
            }
        }
        this.jj_la1[1] = this.jj_gen;
        if (this.jj_2_2(2)) {
            HtmlDocument.HtmlElement e = this.ScriptBlock();
            return e;
        }
        if (this.jj_2_3(2)) {
            HtmlDocument.HtmlElement e = this.StyleBlock();
            return e;
        }
        if (this.jj_2_4(2)) {
            this.jj_consume_token(18);
            Token text = this.jj_consume_token(25);
            return new HtmlDocument.Text("<" + text.image);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                Token text = this.jj_consume_token(20);
                return new HtmlDocument.Text(text.image);
            }
            case 15: {
                this.jj_consume_token(15);
                return new HtmlDocument.Newline();
            }
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final HtmlDocument.Attribute Attribute() throws ParseException {
        Token t2 = null;
        try {
            HtmlDocument.Attribute a;
            Token t1 = this.jj_consume_token(27);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    this.jj_consume_token(30);
                    t2 = this.jj_consume_token(34);
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                }
            }
            if (t2 == null) {
                a = new HtmlDocument.Attribute(t1.image);
                a.setStartLocation(t1.beginLine, t1.beginColumn);
                a.setEndLocation(t1.endLine, t1.endColumn + 1);
            } else {
                a = new HtmlDocument.Attribute(t1.image, t2.image);
                a.setStartLocation(t1.beginLine, t1.beginColumn);
                a.setValueStartLocation(t2.beginLine, t2.beginColumn);
                a.setEndLocation(t2.endLine, t2.endColumn + 1);
                if (!this.isProperAttribute(t2.image)) {
                    ParseException e = new ParseException("Parse error at line " + t2.beginLine + ", column " + t2.beginColumn + ".  Attribute is improperly quoted.");
                    this.addException(e);
                }
            }
            return a;
        }
        catch (ParseException e) {
            this.addException(e);
            return null;
        }
    }

    public final HtmlDocument.AttributeList AttributeList() throws ParseException {
        HtmlDocument.AttributeList alist = new HtmlDocument.AttributeList();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 27: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            HtmlDocument.Attribute a = this.Attribute();
            alist.addAttribute(a);
        }
        return alist;
    }

    public final HtmlDocument.HtmlElement Tag() throws ParseException {
        Token firstToken = this.getToken(1);
        Token st = null;
        boolean isJspTag = false;
        try {
            Token et;
            st = this.jj_consume_token(18);
            Token t = this.jj_consume_token(24);
            HtmlDocument.AttributeList alist = this.AttributeList();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 28: {
                    et = this.jj_consume_token(28);
                    break;
                }
                case 29: {
                    et = this.jj_consume_token(29);
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            String tag_start = "<";
            String tag_name = "";
            if (st.image.startsWith("<") && st.image.endsWith(":")) {
                isJspTag = true;
                tag_start = "<";
                tag_name = st.image.substring(1) + t.image;
            } else {
                tag_name = t.image;
            }
            if (st.image.startsWith("<%")) {
                isJspTag = true;
            }
            HtmlDocument.Tag rtn_tag = new HtmlDocument.Tag(tag_start, tag_name, alist, et.image);
            if (et.kind == 29) {
                rtn_tag.setEmpty(true);
            }
            rtn_tag.setStartLocation(st.beginLine, st.beginColumn);
            rtn_tag.setEndLocation(et.endLine, et.endColumn + 1);
            rtn_tag.setIsJspTag(isJspTag);
            return rtn_tag;
        }
        catch (ParseException ex) {
            this.addException(ex);
            this.token_source.SwitchTo(0);
            String s = HtmlParser.getTokenText(firstToken, this.getNextToken());
            return new HtmlDocument.Text(s);
        }
    }

    public final String StyleBlockContents() throws ParseException {
        StringBuffer sb = new StringBuffer();
        Token t = null;
        try {
            block11: {
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 44: 
                        case 45: 
                        case 46: {
                            break;
                        }
                        default: {
                            this.jj_la1[6] = this.jj_gen;
                            break block11;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 44: {
                            t = this.jj_consume_token(44);
                            sb.append(t.image);
                            continue block10;
                        }
                        case 46: {
                            t = this.jj_consume_token(46);
                            sb.append(t.image);
                            continue block10;
                        }
                        case 45: {
                            t = this.jj_consume_token(45);
                            sb.append(t.image);
                            continue block10;
                        }
                    }
                    break;
                }
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            return sb.toString();
        }
        catch (ParseException e) {
            this.addException(e);
            throw new Error("Missing return statement in function");
        }
    }

    public final String ScriptBlockContents() throws ParseException {
        StringBuffer sb = new StringBuffer();
        Token t = null;
        try {
            block13: {
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 44: 
                        case 45: 
                        case 46: {
                            break;
                        }
                        default: {
                            this.jj_la1[8] = this.jj_gen;
                            break block13;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 44: {
                            t = this.jj_consume_token(44);
                            sb.append(t.image);
                            continue block10;
                        }
                        case 46: {
                            t = this.jj_consume_token(46);
                            sb.append(t.image);
                            continue block10;
                        }
                        case 45: {
                            t = this.jj_consume_token(45);
                            sb.append(t.image);
                            continue block10;
                        }
                    }
                    break;
                }
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            String contents = sb.toString();
            contents = contents.trim();
            if (contents.startsWith("<!--")) {
                contents = contents.substring(4);
            }
            if (contents.endsWith("//-->")) {
                contents = contents.substring(0, contents.length() - 5);
            }
            return contents.trim();
        }
        catch (ParseException e) {
            this.addException(e);
            throw new Error("Missing return statement in function");
        }
    }

    public final HtmlDocument.HtmlElement ScriptBlock() throws ParseException {
        Token firstToken = this.getToken(1);
        String contents = "";
        try {
            Token st = this.jj_consume_token(18);
            Token ts = this.jj_consume_token(22);
            HtmlDocument.AttributeList alist = this.AttributeList();
            Token est = this.jj_consume_token(28);
            this.token_source.SwitchTo(3);
            contents = this.ScriptBlockContents();
            Token et = this.jj_consume_token(42);
            HtmlDocument.Tag script = new HtmlDocument.Tag(ts.image, alist);
            script.setStartLocation(st.beginLine, st.beginColumn);
            script.setEndLocation(est.endLine, est.endColumn);
            HtmlDocument.EndTag endScript = new HtmlDocument.EndTag(ts.image);
            endScript.setStartLocation(et.beginLine, et.beginColumn);
            endScript.setEndLocation(et.endLine, et.endColumn);
            HtmlDocument.Text text = new HtmlDocument.Text(contents);
            HtmlDocument.ElementSequence seq = new HtmlDocument.ElementSequence();
            seq.addElement(text);
            HtmlDocument.TagBlock b = new HtmlDocument.TagBlock(script, seq, endScript);
            b.setStartLocation(st.beginLine, st.beginColumn);
            b.setEndLocation(et.endLine, et.endColumn + 1);
            return b;
        }
        catch (ParseException ex) {
            this.addException(ex);
            this.token_source.SwitchTo(0);
            String s = HtmlParser.getTokenText(firstToken, this.getNextToken());
            return new HtmlDocument.Text(s);
        }
    }

    public final HtmlDocument.HtmlElement StyleBlock() throws ParseException {
        Token firstToken = this.getToken(1);
        String contents = "";
        try {
            Token st = this.jj_consume_token(18);
            this.jj_consume_token(23);
            HtmlDocument.AttributeList alist = this.AttributeList();
            Token est = this.jj_consume_token(28);
            this.token_source.SwitchTo(2);
            contents = this.StyleBlockContents();
            Token et = this.jj_consume_token(43);
            HtmlDocument.Text text = new HtmlDocument.Text(contents);
            HtmlDocument.ElementSequence seq = new HtmlDocument.ElementSequence();
            seq.addElement(text);
            HtmlDocument.TagBlock b = new HtmlDocument.TagBlock("STYLE", alist, seq);
            b.setStartLocation(st.beginLine, st.beginColumn);
            b.setEndLocation(et.endLine, et.endColumn + 1);
            b.startTag.setStartLocation(st.beginLine, st.beginColumn);
            b.startTag.setEndLocation(est.endLine, est.endColumn + 1);
            return b;
        }
        catch (ParseException ex) {
            this.addException(ex);
            this.token_source.SwitchTo(0);
            String s = HtmlParser.getTokenText(firstToken, this.getNextToken());
            return new HtmlDocument.Text(s);
        }
    }

    public final HtmlDocument.HtmlElement EndTag() throws ParseException {
        Token firstToken = this.getToken(1);
        try {
            Token st = this.jj_consume_token(17);
            Token t = this.jj_consume_token(24);
            Token et = this.jj_consume_token(28);
            String tag_name = "";
            tag_name = st.image.startsWith("</") && st.image.endsWith(":") ? st.image.substring(2) + t.image : t.image;
            HtmlDocument.EndTag b = new HtmlDocument.EndTag(tag_name);
            b.setStartLocation(st.beginLine, st.beginColumn);
            b.setEndLocation(et.endLine, et.endColumn + 1);
            return b;
        }
        catch (ParseException ex) {
            this.addException(ex);
            this.token_source.SwitchTo(0);
            String s = HtmlParser.getTokenText(firstToken, this.getNextToken());
            return new HtmlDocument.Text(s);
        }
    }

    public final HtmlDocument.Comment CommentTag() throws ParseException {
        Token comment_end = null;
        StringBuffer s = new StringBuffer();
        try {
            Token comment_start;
            block15: {
                comment_start = this.jj_consume_token(16);
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 37: 
                        case 38: 
                        case 39: {
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            break block15;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 37: {
                            Token t = this.jj_consume_token(37);
                            s.append(t.image);
                            continue block14;
                        }
                        case 38: {
                            this.jj_consume_token(38);
                            s.append(NL);
                            continue block14;
                        }
                        case 39: {
                            Token t = this.jj_consume_token(39);
                            s.append(t.image);
                            continue block14;
                        }
                    }
                    break;
                }
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 0: {
                    this.jj_consume_token(0);
                    break;
                }
                case 36: {
                    comment_end = this.jj_consume_token(36);
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return new HtmlDocument.Comment(comment_start.image + s.toString() + (comment_end == null ? "" : comment_end.image));
        }
        catch (ParseException e) {
            this.addException(e);
            throw new Error("Missing return statement in function");
        }
    }

    public final HtmlDocument.Comment DeclTag() throws ParseException {
        try {
            this.jj_consume_token(19);
            Token t = this.jj_consume_token(40);
            this.jj_consume_token(41);
            return new HtmlDocument.Comment(t.image);
        }
        catch (ParseException e) {
            this.addException(e);
            throw new Error("Missing return statement in function");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(25);
    }

    private boolean jj_3_3() {
        return this.jj_3R_8();
    }

    private boolean jj_3R_7() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_8() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_6() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private boolean jj_3_2() {
        return this.jj_3R_7();
    }

    private boolean jj_3_1() {
        return this.jj_3R_6();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{2064384, 720896, 0x108000, 0x40000000, 0x8000000, 0x30000000, 0, 0, 0, 0, 0, 0, 1};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 28672, 28672, 28672, 28672, 224, 224, 16};
    }

    public HtmlParser(InputStream stream) {
        this(stream, null);
    }

    public HtmlParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new HtmlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public HtmlParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new HtmlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public HtmlParser(HtmlParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(HtmlParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[47];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 13; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 47; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 4; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        HtmlParser.jj_la1_init_0();
        HtmlParser.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

