/*
 * Decompiled with CFR 0.152.
 */
package sidekick.html.parser.html;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import sidekick.html.parser.html.HtmlDocument;
import sidekick.html.parser.html.HtmlVisitor;
import sidekick.html.parser.html.MarginWriter;
import sidekick.html.parser.html.TagBlockRenderer;

public class HtmlFormatter
extends HtmlVisitor {
    protected MarginWriter out;
    protected int rightMargin = 80;
    protected int indentSize = 2;
    protected String lineSeparator = System.getProperty("line.separator");
    protected static Set<String> tagsIndentBlock = new HashSet<String>(Arrays.asList("TABLE", "TR", "TD", "TH", "FORM", "HTML", "HEAD", "BODY", "SELECT"));
    protected static Set<String> tagsNewlineBefore = new HashSet<String>(Arrays.asList("P", "H1", "H2", "H3", "H4", "H5", "H6", "BR", "taglib"));
    protected static Set<String> tagsPreformatted = new HashSet<String>(Arrays.asList("PRE", "SCRIPT", "STYLE"));
    protected static Set<String> tagsTryMatch = new HashSet<String>(Arrays.asList("A", "TD", "TH", "TR", "I", "B", "EM", "FONT", "TT", "UL"));
    protected TagBlockRenderer blockRenderer = new TagBlockRenderer();
    protected HtmlDocument.HtmlElement previousElement;
    protected boolean inPreBlock;

    public HtmlFormatter() throws Exception {
        this.out = new MarginWriter();
        this.out.setRightMargin(this.rightMargin);
        this.out.setLineSeparator(this.lineSeparator);
    }

    public String toString() {
        return this.out.toString();
    }

    public void setRightMargin(int margin) {
        this.rightMargin = margin;
        this.out.setRightMargin(this.rightMargin);
    }

    public void setIndent(int indent) {
        this.indentSize = indent;
    }

    public void setLineSeparator(String ls) {
        this.lineSeparator = ls;
        this.out.setLineSeparator(this.lineSeparator);
    }

    @Override
    public void visit(HtmlDocument.TagBlock block) {
        int wasMargin = 0;
        boolean preformat = tagsPreformatted.contains(block.startTag.tagName.toUpperCase());
        if (tagsTryMatch.contains(block.startTag.tagName.toUpperCase())) {
            this.blockRenderer.start();
            this.blockRenderer.setTargetWidth(this.out.getRightMargin() - this.out.getLeftMargin());
            this.blockRenderer.visit(block);
            this.blockRenderer.finish();
            if (!this.blockRenderer.hasBlownTarget()) {
                if (preformat) {
                    this.out.print(this.blockRenderer.getString());
                } else {
                    this.out.printAutoWrap(this.blockRenderer.getString());
                }
                this.previousElement = block.endTag;
                return;
            }
        }
        boolean indent = tagsIndentBlock.contains(block.startTag.tagName.toUpperCase());
        if (preformat) {
            wasMargin = this.out.getLeftMargin();
            this.visit(block.startTag);
            this.out.setLeftMargin(0);
            this.inPreBlock = true;
            this.visit(block.body);
            this.inPreBlock = false;
            this.out.setLeftMargin(wasMargin);
            this.visit(block.endTag);
        } else if (indent) {
            this.out.printlnSoft();
            this.visit(block.startTag);
            this.out.printlnSoft();
            this.out.setLeftMargin(this.out.getLeftMargin() + this.indentSize);
            this.visit(block.body);
            this.out.setLeftMargin(this.out.getLeftMargin() - this.indentSize);
            this.out.printlnSoft();
            this.visit(block.endTag);
            this.out.printlnSoft();
            this.inPreBlock = false;
        } else {
            this.visit(block.startTag);
            this.visit(block.body);
            this.visit(block.endTag);
        }
    }

    @Override
    public void visit(HtmlDocument.Tag t) {
        String s = t.toString();
        if (tagsNewlineBefore.contains(t.tagName.toUpperCase()) || this.out.getCurPosition() + s.length() > this.out.getRightMargin()) {
            this.out.printlnSoft();
        }
        this.out.print(t.tagStart + t.tagName);
        int hanging = t.tagName.length() + 1;
        for (HtmlDocument.Attribute a : t.attributeList.attributes) {
            this.out.printAutoWrap(" " + a.toString(), hanging);
        }
        if (t.tagEnd.length() > 1 && !t.tagEnd.startsWith("/")) {
            this.out.print(" ");
        }
        this.out.print(t.tagEnd);
        this.previousElement = t;
    }

    @Override
    public void visit(HtmlDocument.EndTag t) {
        this.out.printAutoWrap(t.toString());
        if (tagsNewlineBefore.contains(t.tagName.toUpperCase())) {
            this.out.printlnSoft();
        }
        this.previousElement = t;
    }

    @Override
    public void visit(HtmlDocument.Comment c) {
        this.out.print(c.toString());
        this.previousElement = c;
    }

    @Override
    public void visit(HtmlDocument.Text t) {
        if (this.inPreBlock) {
            this.out.print(t.text);
        } else {
            int start = 0;
            while (start < t.text.length()) {
                int index = t.text.indexOf(32, start) + 1;
                if (index == 0) {
                    index = t.text.length();
                }
                this.out.printAutoWrap(t.text.substring(start, index));
                start = index;
            }
        }
        this.previousElement = t;
    }

    @Override
    public void visit(HtmlDocument.Newline n) {
        if (this.inPreBlock) {
            this.out.print(this.lineSeparator);
        } else if (this.previousElement instanceof HtmlDocument.Tag || this.previousElement instanceof HtmlDocument.EndTag || this.previousElement instanceof HtmlDocument.Comment || this.previousElement instanceof HtmlDocument.Newline) {
            this.out.printlnSoft();
        } else if (this.previousElement instanceof HtmlDocument.Text) {
            this.out.print(" ");
        }
        this.previousElement = n;
    }

    @Override
    public void start() {
        this.previousElement = null;
        this.inPreBlock = false;
    }

    @Override
    public void finish() {
    }
}

