/*
 * Decompiled with CFR 0.152.
 */
package sidekick.html.parser.html;

import java.io.OutputStream;
import java.io.PrintWriter;
import sidekick.html.parser.html.HtmlDocument;
import sidekick.html.parser.html.HtmlParser;
import sidekick.html.parser.html.HtmlVisitor;
import sidekick.html.parser.html.ParseException;

public class HtmlDebugDumper
extends HtmlVisitor {
    protected PrintWriter out;

    public HtmlDebugDumper(OutputStream os) {
        this.out = new PrintWriter(os);
    }

    @Override
    public void finish() {
        this.out.flush();
    }

    @Override
    public void visit(HtmlDocument.Tag t) {
        this.out.print("Tag(" + t + ")");
    }

    @Override
    public void visit(HtmlDocument.EndTag t) {
        this.out.print("Tag(" + t + ")");
    }

    @Override
    public void visit(HtmlDocument.Comment c) {
        this.out.print("Comment(" + c + ")");
    }

    @Override
    public void visit(HtmlDocument.Text t) {
        this.out.print(t);
    }

    @Override
    public void visit(HtmlDocument.Newline n) {
        this.out.println("-NL-");
    }

    @Override
    public void visit(HtmlDocument.Annotation a) {
        this.out.print(a);
    }

    @Override
    public void visit(HtmlDocument.TagBlock bl) {
        this.out.print("<BLOCK>");
        this.visit(bl.startTag);
        this.visit(bl.body);
        this.visit(bl.endTag);
        this.out.print("</BLOCK>");
    }

    public static void main(String[] args) throws ParseException {
        HtmlParser parser = new HtmlParser(System.in);
        HtmlDocument doc = parser.HtmlDocument();
        doc.accept(new HtmlDebugDumper(System.out));
    }
}

