/*
 * Decompiled with CFR 0.152.
 */
package sidekick.html.parser.html;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import sidekick.html.parser.html.HtmlDocument;
import sidekick.html.parser.html.HtmlDumper;
import sidekick.html.parser.html.HtmlParser;
import sidekick.html.parser.html.HtmlScrubber;
import sidekick.html.parser.html.HtmlVisitor;

public class HtmlCollector
extends HtmlVisitor {
    protected ElementStack tagStack = new ElementStack();
    protected ElementStack elements;
    protected boolean collected;
    protected static Set dontMatch = new HashSet<String>(Arrays.asList("AREA", "BASE", "BASEFONT", "BR", "COL", "HR", "IMG", "INPUT", "ISINDEX", "LINK", "META", "PARAM", "COMMAND", "EMBED", "KEYGEN", "SOURCE", "TRACK", "WBR"));

    protected int pushNode(HtmlDocument.HtmlElement e) {
        if (e != null) {
            this.elements.addElement(e);
        }
        return this.elements.size() - 1;
    }

    @Override
    public void visit(HtmlDocument.Comment c) {
        this.pushNode(c);
    }

    @Override
    public void visit(HtmlDocument.Text t) {
        this.pushNode(t);
    }

    @Override
    public void visit(HtmlDocument.Newline n) {
        this.pushNode(n);
    }

    @Override
    public void visit(HtmlDocument.Tag t) {
        if (t == null) {
            return;
        }
        TagStackEntry ts = new TagStackEntry();
        int index = this.pushNode(t);
        if (!t.emptyTag && !dontMatch.contains(t.tagName.toUpperCase())) {
            ts.tagName = t.tagName;
            ts.index = index;
            this.tagStack.addElement(ts);
        }
    }

    @Override
    public void visit(HtmlDocument.EndTag t) {
        int i;
        if (t == null) {
            return;
        }
        for (i = this.tagStack.size() - 1; i >= 0; --i) {
            TagStackEntry ts = (TagStackEntry)this.tagStack.elementAt(i);
            if (!t.tagName.equalsIgnoreCase(ts.tagName)) continue;
            HtmlDocument.ElementSequence blockElements = new HtmlDocument.ElementSequence(this.elements.size() - ts.index - 1);
            for (int j = ts.index + 1; j < this.elements.size(); ++j) {
                blockElements.addElement((HtmlDocument.HtmlElement)this.elements.elementAt(j));
            }
            HtmlDocument.Tag tag = (HtmlDocument.Tag)this.elements.elementAt(ts.index);
            HtmlDocument.TagBlock block = new HtmlDocument.TagBlock(tag, blockElements, t);
            block.setStartLocation(tag.getStartLocation());
            block.setEndLocation(t.getEndLocation());
            this.elements.popN(this.elements.size() - ts.index);
            this.elements.addElement(block);
            this.tagStack.popN(this.tagStack.size() - i);
            this.collected = true;
            break;
        }
        if (i < 0) {
            this.pushNode(t);
        }
    }

    @Override
    public void visit(HtmlDocument.TagBlock bl) {
        if (bl == null) {
            return;
        }
        HtmlCollector c = new HtmlCollector();
        c.start();
        c.visit(bl.body);
        c.finish();
        this.pushNode(bl);
    }

    @Override
    public void visit(HtmlDocument.ElementSequence s) {
        if (s == null) {
            return;
        }
        this.elements = new ElementStack(s.size());
        this.collected = false;
        Iterator iterator = s.iterator();
        while (iterator.hasNext()) {
            HtmlDocument.HtmlElement htmlElement = (HtmlDocument.HtmlElement)iterator.next();
            if (htmlElement == null) continue;
            htmlElement.accept(this);
        }
        if (this.collected) {
            s.setElements(this.elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        FileInputStream r = new FileInputStream(args[0]);
        try {
            HtmlDocument document = new HtmlParser(r).HtmlDocument();
            document.accept(new HtmlScrubber());
            document.accept(new HtmlCollector());
            document.accept(new HtmlDumper(System.out));
        }
        finally {
            ((InputStream)r).close();
        }
    }

    private static class ElementStack
    extends Vector {
        ElementStack() {
        }

        ElementStack(int n) {
            super(n);
        }

        public void popN(int n) {
            this.elementCount -= n;
        }
    }

    private static class TagStackEntry {
        String tagName;
        int index;

        private TagStackEntry() {
        }
    }
}

