/*
 * Decompiled with CFR 0.152.
 */
package sidekick.html;

import errorlist.DefaultErrorSource;
import java.io.StringReader;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import sidekick.SideKickParsedData;
import sidekick.html.HtmlSideKickParsedData;
import sidekick.html.parser.html.HtmlCollector;
import sidekick.html.parser.html.HtmlDocument;
import sidekick.html.parser.html.HtmlTreeBuilder;
import sidekick.util.ElementUtil;
import sidekick.util.ParseError;
import sidekick.util.Range;
import xml.parser.XmlParser;

public class HtmlParser
extends XmlParser
implements EBComponent {
    private View currentView = null;
    public static boolean showAll = true;

    public HtmlParser() {
        super("html");
    }

    @Override
    public void activate(EditPane editPane) {
        super.activate(editPane);
        this.currentView = editPane.getView();
        EditBus.addToBus((EBComponent)this);
    }

    @Override
    public void deactivate(EditPane editPane) {
        super.deactivate(editPane);
        EditBus.removeFromBus((EBComponent)this);
    }

    public void handleMessage(EBMessage msg) {
        if (msg instanceof PropertiesChanged) {
            this.parse();
        }
    }

    public void parse() {
        if (this.currentView != null) {
            this.parse(this.currentView.getBuffer(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SideKickParsedData parse(Buffer buffer, DefaultErrorSource errorSource) {
        String filename = buffer.getPath();
        HtmlSideKickParsedData parsedData = new HtmlSideKickParsedData(filename, buffer);
        DefaultMutableTreeNode root = parsedData.root;
        StringReader reader = new StringReader(buffer.getText(0, buffer.getLength()));
        HtmlTreeBuilder builder = null;
        try {
            sidekick.html.parser.html.HtmlParser parser = new sidekick.html.parser.html.HtmlParser(reader);
            parser.setTabSize(buffer.getTabSize());
            HtmlDocument document = parser.HtmlDocument();
            document.setShowBrackets(jEdit.getBooleanProperty((String)"options.sidekick.html.showBrackets", (boolean)true));
            document.setShowTagAttributes(jEdit.getBooleanProperty((String)"options.sidekick.html.showTagAttributes", (boolean)true));
            document.setShowCoreAttributes(jEdit.getBooleanProperty((String)"options.sidekick.html.showCoreAttributes", (boolean)true));
            document.setShowLangAttributes(jEdit.getBooleanProperty((String)"options.sidekick.html.showLangAttributes", (boolean)true));
            document.setShowScriptAttributes(jEdit.getBooleanProperty((String)"options.sidekick.html.showScriptAttributes", (boolean)true));
            document.setShowJspTags(jEdit.getBooleanProperty((String)"options.sidekick.html.showJspElements", (boolean)true));
            document.accept(new HtmlCollector());
            builder = new HtmlTreeBuilder(root);
            builder.setShowAll(jEdit.getBooleanProperty((String)"options.sidekick.html.showAllElements", (boolean)true));
            builder.setShowAll(showAll);
            builder.setBuffer(buffer);
            builder.setErrorSource(errorSource);
            document.accept(builder);
            ElementUtil.convert((Buffer)buffer, (DefaultMutableTreeNode)root);
            if (!buffer.isDirty() && errorSource != null) {
                List<ParseError> parseErrors = parser.getParseErrors();
                for (ParseError pe : parseErrors) {
                    String message = pe.message;
                    Range range = pe.range;
                    if (range.endLine != range.startLine) {
                        range.endColumn = range.startColumn;
                    }
                    errorSource.addError(0, filename, range.startLine, range.startColumn, range.endColumn, message);
                }
            }
        }
        catch (Exception e) {
            errorSource.addError(0, filename, 0, 0, 0, e.getMessage());
            e.printStackTrace();
        }
        finally {
            reader.close();
        }
        return parsedData;
    }
}

