/*
 * Decompiled with CFR 0.152.
 */
package sidekick.ecmascript.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.CharsetDecoder;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import java.util.StringTokenizer;

public class Util {
    private static final ByteBuffer copyBuffer = ByteBuffer.allocateDirect(16384);
    private static final DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);

    public static final String millisToNice(long millis) {
        long seconds = millis / 1000L;
        long sec = seconds % 3600L % 60L;
        long min = seconds % 3600L / 60L;
        long hour = seconds / 3600L;
        StringBuffer strbuf = new StringBuffer(60);
        strbuf.append(" [ ");
        if (hour > 0L) {
            strbuf.append(hour + " h ");
        }
        if (min > 0L) {
            strbuf.append(min + " min ");
        }
        if (sec > 0L) {
            strbuf.append(sec + " sec ");
        }
        strbuf.append(millis % 1000L + " millis");
        strbuf.append(" ]");
        return strbuf.toString();
    }

    public static final String[] tokenizeCommaSepString(String aString) {
        if (aString == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(aString, ",");
        String[] result = null;
        int n = tokenizer.countTokens();
        if (n > 0) {
            result = new String[n];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                result[i] = tokenizer.nextToken().trim();
                ++i;
            }
        }
        return result;
    }

    public static final String commonPrefix(String str1, String str2) {
        boolean done = false;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int n1 = str1.length();
        int n2 = str2.length();
        while (!done) {
            char c = str1.charAt(i);
            if (c == str2.charAt(i)) {
                buffer.append(c);
                if (++i != n1 && i != n2) continue;
                done = true;
                continue;
            }
            done = true;
        }
        return buffer.toString();
    }

    public static final String commonPathPrefix(String path1, String path2) {
        boolean done = false;
        StringBuffer buffer = new StringBuffer();
        StringTokenizer st1 = new StringTokenizer(path1, File.separator, true);
        StringTokenizer st2 = new StringTokenizer(path2, File.separator, true);
        boolean bl = done = !st1.hasMoreTokens() || !st2.hasMoreTokens();
        while (!done) {
            String p2;
            String p1 = st1.nextToken();
            if (p1.equals(p2 = st2.nextToken())) {
                buffer.append(p1);
                done = !st1.hasMoreTokens() || !st2.hasMoreTokens();
                continue;
            }
            done = true;
        }
        return buffer.length() > 0 ? buffer.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyFile(String srcFilename, String dstFilename) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        AbstractInterruptibleChannel ifc = null;
        AbstractInterruptibleChannel ofc = null;
        copyBuffer.clear();
        try {
            fis = new FileInputStream(srcFilename);
            ifc = fis.getChannel();
            fos = new FileOutputStream(dstFilename);
            ofc = fos.getChannel();
            int sz = (int)((FileChannel)ifc).size();
            for (int n = 0; n < sz; n += ((FileChannel)ofc).write(copyBuffer)) {
                if (((FileChannel)ifc).read(copyBuffer) < 0) {
                    break;
                }
                copyBuffer.flip();
                copyBuffer.compact();
            }
        }
        finally {
            try {
                if (ifc != null) {
                    ifc.close();
                } else if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException exc) {}
            try {
                if (ofc != null) {
                    ofc.close();
                } else if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException exc) {}
        }
    }

    public static final String getDateStamp() {
        String dateStamp = dateFormat.format(new Date());
        dateStamp = dateStamp.replace(' ', '_');
        dateStamp = dateStamp.replace(',', '_');
        dateStamp = dateStamp.replace('/', '-');
        dateStamp = dateStamp.replace(':', '-');
        return dateStamp;
    }

    public static final boolean isJavaIdentifier(String candidate) {
        if (candidate == null || candidate.length() == 0) {
            return false;
        }
        char c = candidate.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            return false;
        }
        int n = candidate.length();
        for (int i = 1; i < n; ++i) {
            c = candidate.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    public static final boolean isValidCompositeReference(String candidate) {
        if (candidate == null || candidate.length() == 0) {
            return false;
        }
        char c = candidate.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            return false;
        }
        int n = candidate.length();
        for (int i = 1; i < n; ++i) {
            c = candidate.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.') continue;
            return false;
        }
        return c != '.';
    }

    public static final boolean isWhitespace(String candidate) {
        int n = candidate.length();
        for (int i = 0; i < n; ++i) {
            char c = candidate.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static final boolean isLikelyIdentifier(String candidate) {
        int n = candidate.length();
        if (n < 3) {
            return false;
        }
        boolean hasLower = false;
        boolean hasUpper = false;
        boolean hasUnderscore = false;
        int nUpper = Character.isUpperCase(candidate.charAt(0)) ? 1 : 0;
        for (int i = 1; i < n; ++i) {
            char c = candidate.charAt(i);
            if (Character.isLowerCase(c)) {
                hasLower = true;
                continue;
            }
            if (Character.isUpperCase(c)) {
                hasUpper = true;
                ++nUpper;
                continue;
            }
            if (c != '_') continue;
            hasUnderscore = true;
        }
        return hasLower && hasUpper || hasUnderscore || nUpper == candidate.length();
    }

    public static String replaceString(String s, String sub, String with) {
        int c = 0;
        int i = s.indexOf(sub, c);
        if (i == -1) {
            return s;
        }
        StringBuffer buf = new StringBuffer(s.length() + with.length());
        do {
            buf.append(s.substring(c, i));
            buf.append(with);
        } while ((i = s.indexOf(sub, c = i + sub.length())) != -1);
        if (c < s.length()) {
            buf.append(s.substring(c, s.length()));
        }
        return buf.toString();
    }

    public static String replaceSeparatedString(String s, String sub, String with) {
        int c = 0;
        int i = s.indexOf(sub, c);
        if (i == -1) {
            return s;
        }
        StringBuffer buf = new StringBuffer(s.length() + with.length());
        int n = s.length();
        do {
            int endChar;
            buf.append(s.substring(c, i));
            int beginChar = i > 0 ? (int)s.charAt(i - 1) : -1;
            int m = i + sub.length();
            int n2 = endChar = m < n ? (int)s.charAt(m) : -1;
            if (!(beginChar != -1 && Character.isJavaIdentifierStart((char)beginChar) || endChar != -1 && Character.isJavaIdentifierPart((char)endChar))) {
                buf.append(with);
                continue;
            }
            buf.append(sub);
        } while ((i = s.indexOf(sub, c = i + sub.length())) != -1);
        if (c < s.length()) {
            buf.append(s.substring(c, s.length()));
        }
        return buf.toString();
    }

    public static boolean endsWith(String aString, String aSuffix) {
        if (aString == null) {
            return aSuffix == null;
        }
        if (aString.equals("")) {
            return aSuffix != null && aSuffix.equals("");
        }
        int index = aString.lastIndexOf(aSuffix);
        return index == aString.length() - aSuffix.length();
    }

    public static boolean hasWildcards(String filename) {
        return filename.indexOf(42) != -1 || filename.indexOf(63) != -1;
    }

    public static String wildCard2Pattern(String wildcard) {
        int n = wildcard.length();
        StringBuffer regexPatternBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = wildcard.charAt(i);
            if (c == '*') {
                regexPatternBuffer.append(".*");
                continue;
            }
            if (c == '?') {
                regexPatternBuffer.append('.');
                continue;
            }
            if (c == '.') {
                regexPatternBuffer.append("\\.");
                continue;
            }
            if (c == '$') {
                regexPatternBuffer.append("\\$");
                continue;
            }
            regexPatternBuffer.append(c);
        }
        return regexPatternBuffer.toString();
    }

    public static File resolveWebURL(String urlPath, String webroot, Map webmaps) {
        File result = null;
        for (String key : webmaps.keySet()) {
            if (!urlPath.startsWith(key)) continue;
            result = new File((String)webmaps.get(key) + urlPath.substring(key.length()));
            break;
        }
        if (result == null) {
            result = new File(webroot + urlPath);
        }
        return result;
    }

    public static CharBuffer readBytes(InputStream inputStream, CharsetDecoder decoder) throws IOException {
        byte[] buffer = new byte[1024];
        int b = inputStream.read();
        int i = 0;
        while (b != -1) {
            if (i == buffer.length) {
                byte[] grow = new byte[buffer.length * 2];
                System.arraycopy(buffer, 0, grow, 0, buffer.length);
                buffer = grow;
            }
            buffer[i++] = (byte)b;
            b = inputStream.read();
        }
        return decoder.decode(ByteBuffer.wrap(buffer, 0, i));
    }

    public static String escape2Html(String plainString) {
        if (plainString == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int n = plainString.length();
        boolean spaceState = false;
        int nlState = 0;
        block8: for (int i = 0; i < n; ++i) {
            char c = plainString.charAt(i);
            if (c == ' ') {
                if (nlState > 0) {
                    if (nlState == 1) {
                        sb.append('\n');
                    } else {
                        sb.append("<p>");
                    }
                }
                nlState = 0;
                if (!spaceState) {
                    spaceState = true;
                    sb.append(c);
                    continue;
                }
                if (!spaceState) continue;
                spaceState = false;
                sb.append("&nbsp;");
                continue;
            }
            if (c == '\n') {
                if (nlState == 0) {
                    nlState = 1;
                    continue;
                }
                if (nlState != 1) continue;
                nlState = 2;
                continue;
            }
            if (nlState > 0) {
                if (nlState == 1) {
                    sb.append('\n');
                } else {
                    sb.append("<p>");
                }
            }
            nlState = 0;
            spaceState = false;
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block8;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block8;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    sb.append("&#039;");
                    continue block8;
                }
                case '\n': {
                    sb.append("<br>");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

