/*
 * Decompiled with CFR 0.152.
 */
package sidekick.ecmascript.parser;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.Position;
import sidekick.ecmascript.parser.ASTDoStatement;
import sidekick.ecmascript.parser.ASTEmptyStatement;
import sidekick.ecmascript.parser.ASTExpressionStatement;
import sidekick.ecmascript.parser.ASTForInStatement;
import sidekick.ecmascript.parser.ASTForStatement;
import sidekick.ecmascript.parser.ASTForVarInStatement;
import sidekick.ecmascript.parser.ASTForVarStatement;
import sidekick.ecmascript.parser.ASTIfStatement;
import sidekick.ecmascript.parser.ASTVariableStatement;
import sidekick.ecmascript.parser.ASTWhileStatement;
import sidekick.ecmascript.parser.ASTWithStatement;
import sidekick.ecmascript.parser.Comment;
import sidekick.ecmascript.parser.EcmaScript;
import sidekick.ecmascript.parser.EcmaScriptConstants;
import sidekick.ecmascript.parser.EcmaScriptTreeConstants;
import sidekick.ecmascript.parser.EcmaScriptVisitor;
import sidekick.ecmascript.parser.Node;
import sidekick.ecmascript.parser.Token;
import sidekick.util.Location;
import sidekick.util.SideKickElement;

public class SimpleNode
implements Node,
SideKickElement,
EcmaScriptConstants,
EcmaScriptTreeConstants {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected EcmaScript parser;
    private Location start = null;
    private Location end = null;
    private Position startPosition = null;
    private Position endPosition = null;
    private boolean visible = false;
    protected Token beginToken;
    protected Token endToken;
    protected boolean inserted = false;
    protected LinkedList<Comment> javadocComments;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(EcmaScript p, int i) {
        this(i);
        this.parser = p;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
        if (this.isVisible() && this.parent != null) {
            System.out.println("visible: " + this.toString());
            for (SimpleNode p = (SimpleNode)this.parent; p != null; p = (SimpleNode)p.jjtGetParent()) {
                p.setVisible(true);
            }
        }
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        if (this.children == null) {
            return null;
        }
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public boolean hasChildren() {
        return this.jjtGetNumChildren() > 0;
    }

    public List getChildren() {
        if (this.children != null) {
            return Arrays.asList(this.children);
        }
        return null;
    }

    @Override
    public Object jjtAccept(EcmaScriptVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(EcmaScriptVisitor visitor, Object data) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].jjtAccept(visitor, data);
            }
        }
        return data;
    }

    public void setStartLocation(Location loc) {
        this.start = loc;
    }

    public Location getStartLocation() {
        if (this.start == null) {
            this.start = new Location();
        }
        return this.start;
    }

    public void setEndLocation(Location loc) {
        this.end = loc;
    }

    public Location getEndLocation() {
        if (this.end == null) {
            this.end = new Location();
        }
        return this.end;
    }

    public void setStartPosition(Position s) {
        this.startPosition = s;
    }

    public Position getStartPosition() {
        return this.startPosition;
    }

    public void setEndPosition(Position s) {
        this.endPosition = s;
    }

    public Position getEndPosition() {
        return this.endPosition;
    }

    public boolean isVisible() {
        boolean b = System.getProperty("sidekick.ecmascript.general.allNodes", "false").startsWith("t");
        return b ? b : this.visible;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public void insertChild(Node n, int i) {
        if (this.children == null) {
            throw new IllegalStateException("no children insertion not possible");
        }
        if (i > this.children.length || i < 0) {
            throw new IndexOutOfBoundsException();
        }
        Node[] c = new Node[this.children.length + 1];
        if (i > 0) {
            System.arraycopy(this.children, 0, c, 0, i);
        }
        c[i] = n;
        if (i < this.children.length) {
            System.arraycopy(this.children, i, c, i + 1, this.children.length - i);
        }
        this.children = c;
    }

    public Node getPrevSibling() {
        if (this.parent == null) {
            return null;
        }
        SimpleNode parentSNode = (SimpleNode)this.parent;
        int i = 0;
        for (i = 0; i < parentSNode.children.length && parentSNode.children[i] != this; ++i) {
        }
        if (i == 0) {
            return null;
        }
        return parentSNode.children[i - 1];
    }

    public Node getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        SimpleNode parentSNode = (SimpleNode)this.parent;
        int i = 0;
        for (i = 0; i < parentSNode.children.length && parentSNode.children[i] != this; ++i) {
        }
        if (i == parentSNode.children.length - 1) {
            return null;
        }
        return parentSNode.children[i + 1];
    }

    public void setChild(Node n, int i) {
        this.children[i] = n;
        n.jjtSetParent(this);
    }

    public int getChildIndex(Node n) {
        int i = 0;
        for (i = 0; i < this.children.length && this.children[i] != n; ++i) {
        }
        return i == this.children.length ? -1 : i;
    }

    public void remove() {
        if (this.parent == null) {
            return;
        }
        SimpleNode parentSNode = (SimpleNode)this.parent;
        int i = 0;
        for (i = 0; i < parentSNode.children.length && parentSNode.children[i] != this; ++i) {
        }
        Node[] c = new Node[parentSNode.children.length - 1];
        if (i == 0) {
            System.arraycopy(parentSNode.children, 1, c, 0, parentSNode.children.length - 1);
        } else if (i == parentSNode.children.length - 1) {
            System.arraycopy(parentSNode.children, 0, c, 0, parentSNode.children.length - 1);
        } else {
            System.arraycopy(parentSNode.children, 0, c, 0, i);
            System.arraycopy(parentSNode.children, i + 1, c, i, parentSNode.children.length - i - 1);
        }
        parentSNode.children = c;
    }

    public void removeSafely() {
        this.removeSafely(false);
    }

    public void removeSafely(boolean ignoreSpecialTokens) {
        SimpleNode parentSNode = (SimpleNode)this.parent;
        boolean replace = false;
        if ((this instanceof ASTVariableStatement || this instanceof ASTExpressionStatement) && (parentSNode instanceof ASTIfStatement || parentSNode instanceof ASTWhileStatement || parentSNode instanceof ASTDoStatement || parentSNode instanceof ASTForStatement || parentSNode instanceof ASTForVarStatement || parentSNode instanceof ASTForInStatement || parentSNode instanceof ASTForVarInStatement || parentSNode instanceof ASTWithStatement)) {
            replace = true;
        }
        if (replace) {
            int index = parentSNode.getChildIndex(this);
            ASTEmptyStatement replacement = new ASTEmptyStatement(28);
            Token scToken = new Token();
            scToken.kind = 59;
            scToken.image = ";";
            scToken.specialToken = this.getBeginToken().specialToken;
            replacement.setBeginToken(scToken);
            replacement.setEndToken(scToken);
            replacement.setInserted(true);
            parentSNode.setChild(replacement, index);
        } else {
            Token nextBeginToken;
            Token specialTransfer;
            if (!ignoreSpecialTokens && (specialTransfer = this.getBeginToken().specialToken) != null && (nextBeginToken = this.getEndToken().next) != null) {
                SimpleNode.transferSpecial(specialTransfer, nextBeginToken);
            }
            this.remove();
        }
    }

    public static void transferSpecial(Token specialTransfer, Token nextBeginToken) {
        if (nextBeginToken.specialToken == null) {
            nextBeginToken.specialToken = specialTransfer;
        } else if (nextBeginToken.specialToken != specialTransfer) {
            Token endSpecial = nextBeginToken.specialToken;
            while (endSpecial.specialToken != null) {
                endSpecial = endSpecial.specialToken;
            }
            endSpecial.specialToken = specialTransfer;
        }
    }

    public String toString() {
        return EcmaScriptTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    public void setBeginToken(Token token) {
        this.beginToken = token;
    }

    public Token getBeginToken() {
        return this.beginToken;
    }

    public void setEndToken(Token token) {
        this.endToken = token;
    }

    public Token getEndToken() {
        return this.endToken;
    }

    public boolean inserted() {
        return this.inserted;
    }

    public void setInserted(boolean aFlag) {
        this.inserted = aFlag;
    }

    private void findComments() {
        this.javadocComments = new LinkedList();
        Token token = this.getBeginToken();
        Comment aComment = null;
        if (token != null) {
            Token specialToken = token.specialToken;
            while (specialToken != null) {
                aComment = null;
                if (specialToken.kind == 17) {
                    try {
                        aComment = new Comment(specialToken.image);
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                    if (aComment != null && aComment.isJavadoc()) {
                        this.javadocComments.add(aComment);
                    }
                }
                specialToken = specialToken.specialToken;
            }
        }
    }

    public Comment getComment() {
        if (this.javadocComments == null) {
            this.findComments();
        }
        return this.javadocComments.size() == 0 ? null : this.javadocComments.getFirst();
    }

    public List getComments() {
        if (this.javadocComments == null) {
            this.findComments();
        }
        return this.javadocComments;
    }
}

