/*
 * Decompiled with CFR 0.152.
 */
package sidekick.ecmascript.parser;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import sidekick.ecmascript.parser.ASTAllocationExpression;
import sidekick.ecmascript.parser.ASTArrayLiteral;
import sidekick.ecmascript.parser.ASTBlock;
import sidekick.ecmascript.parser.ASTBreakStatement;
import sidekick.ecmascript.parser.ASTCaseGroups;
import sidekick.ecmascript.parser.ASTCaseGuard;
import sidekick.ecmascript.parser.ASTCatchClause;
import sidekick.ecmascript.parser.ASTConditionalExpression;
import sidekick.ecmascript.parser.ASTContinueStatement;
import sidekick.ecmascript.parser.ASTDoStatement;
import sidekick.ecmascript.parser.ASTEmptyStatement;
import sidekick.ecmascript.parser.ASTExpressionList;
import sidekick.ecmascript.parser.ASTExpressionStatement;
import sidekick.ecmascript.parser.ASTFinallyClause;
import sidekick.ecmascript.parser.ASTForInStatement;
import sidekick.ecmascript.parser.ASTForStatement;
import sidekick.ecmascript.parser.ASTForVarInStatement;
import sidekick.ecmascript.parser.ASTForVarStatement;
import sidekick.ecmascript.parser.ASTFormalParameterList;
import sidekick.ecmascript.parser.ASTFunctionCallParameters;
import sidekick.ecmascript.parser.ASTFunctionDeclaration;
import sidekick.ecmascript.parser.ASTIdentifier;
import sidekick.ecmascript.parser.ASTIfStatement;
import sidekick.ecmascript.parser.ASTLiteral;
import sidekick.ecmascript.parser.ASTLiteralField;
import sidekick.ecmascript.parser.ASTObjectLiteral;
import sidekick.ecmascript.parser.ASTOperator;
import sidekick.ecmascript.parser.ASTParenExpression;
import sidekick.ecmascript.parser.ASTProgram;
import sidekick.ecmascript.parser.ASTPropertyIdentifierReference;
import sidekick.ecmascript.parser.ASTPropertyValueReference;
import sidekick.ecmascript.parser.ASTReturnStatement;
import sidekick.ecmascript.parser.ASTSwitchStatement;
import sidekick.ecmascript.parser.ASTThisReference;
import sidekick.ecmascript.parser.ASTThrowStatement;
import sidekick.ecmascript.parser.ASTTryStatement;
import sidekick.ecmascript.parser.ASTVariableDeclaration;
import sidekick.ecmascript.parser.ASTVariableDeclarationList;
import sidekick.ecmascript.parser.ASTVariableStatement;
import sidekick.ecmascript.parser.ASTWhileStatement;
import sidekick.ecmascript.parser.ASTWithStatement;
import sidekick.ecmascript.parser.EcmaScriptVisitorAdapter;
import sidekick.ecmascript.parser.SimpleNode;
import sidekick.ecmascript.parser.Token;

public class PrettyPrinter
extends EcmaScriptVisitorAdapter {
    public static final int PRETTY_PRINT = 0;
    public static final int PRESERVE_FORMATTING = 1;
    public static final int STRIP_COMMENTS = 2;
    public static final int STRIP_WHITESPACE = 4;
    public static final int STRIP_NEWLINES = 8;
    public static final int STRIP_ALL = 14;
    private Writer writer;
    private int style;
    private int line;
    private int column;
    private int level;
    private boolean separator;
    private static char[] BLANKS;
    private static char[] FEEDS;

    public PrettyPrinter(Writer writer) {
        this(writer, 1);
    }

    public PrettyPrinter(Writer writer, int style) {
        this.writer = writer;
        this.style = style;
    }

    protected void printIndentation(int lf, int blanks) {
        int n;
        if (lf > 0) {
            do {
                n = Math.min(lf, FEEDS.length);
                this.print(FEEDS, 0, n);
            } while ((lf -= n) > 0);
        }
        while (blanks > 0) {
            n = Math.min(blanks, BLANKS.length);
            this.print(BLANKS, 0, n);
            blanks -= n;
        }
    }

    protected void print(int c) {
        if (c == 10) {
            this.column = 0;
            ++this.line;
        } else {
            ++this.column;
        }
        try {
            this.writer.write(c);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected void print(char[] cbuf, int off, int len) {
        boolean col = false;
        for (int i = off + len - 1; i >= off; --i) {
            if (cbuf[i] != '\n') continue;
            ++this.line;
            if (col) continue;
            this.column = off + len - 1 - i;
            col = true;
        }
        if (!col) {
            this.column += len;
        }
        try {
            this.writer.write(cbuf, off, len);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected void print(String str) {
        int i = str.lastIndexOf(10);
        if (i >= 0) {
            this.column = str.length() - i + 1;
            do {
                ++this.line;
            } while ((i = str.lastIndexOf(10, i - 1)) >= 0);
        } else {
            this.column += str.length();
        }
        try {
            this.writer.write(str);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private Token invertSpecialTokenList(Token token) {
        Token y = null;
        Token x = token;
        while (x != null) {
            Token dummy = x;
            x = dummy.specialToken;
            dummy.specialToken = y;
            y = dummy;
        }
        return y;
    }

    protected void printToken(Token token) {
        boolean hadSeparator;
        token.specialToken = this.invertSpecialTokenList(token.specialToken);
        Token wsToken = token.specialToken;
        boolean bl = hadSeparator = wsToken != null;
        if ((this.style & 0xE) == 14) {
            if (!this.separator && hadSeparator) {
                this.print(32);
            }
            this.print(token.image);
            return;
        }
        boolean wroteSeparator = false;
        while (wsToken != null) {
            if (wsToken.kind == 17 || wsToken.kind == 16) {
                if ((this.style & 2) == 0) {
                    this.print(wsToken.image);
                    wroteSeparator = true;
                }
            } else if (wsToken.kind == 1) {
                if ((this.style & 4) == 0) {
                    this.print(wsToken.image);
                    wroteSeparator = true;
                }
            } else if ((this.style & 8) == 0) {
                this.print(wsToken.image);
                wroteSeparator = true;
            }
            wsToken = wsToken.specialToken;
        }
        if (!this.separator && !wroteSeparator && this.style != 1 && hadSeparator) {
            this.print(32);
        }
        this.print(token.image);
        token.specialToken = this.invertSpecialTokenList(token.specialToken);
    }

    @Override
    public Object visit(SimpleNode node, Object data) {
        throw new IllegalStateException("the visitor has been called with a simple node");
    }

    @Override
    public Object visit(ASTLiteral node, Object data) {
        Object literalValue = node.getValue();
        if (literalValue instanceof Map || literalValue instanceof List) {
            return super.visit(node, data);
        }
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            if (!this.separator) {
                this.print(32);
            }
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        return data;
    }

    @Override
    public Object visit(ASTIdentifier node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            if (!this.separator) {
                this.print(32);
            }
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        return data;
    }

    @Override
    public Object visit(ASTObjectLiteral node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        ++this.level;
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode literalFieldNode = (SimpleNode)node.jjtGetChild(i);
            if (this.style == 0 || node.inserted()) {
                this.printIndentation(1, this.level * 4);
                this.separator = true;
            }
            data = literalFieldNode.jjtAccept(this, data);
            if (i >= n - 1) continue;
            Token commaToken = literalFieldNode.getEndToken().next;
            if (commaToken == null) {
                this.print(44);
            } else if (this.style == 0 || node.inserted()) {
                this.print(commaToken.image);
            } else {
                this.printToken(commaToken);
            }
            this.separator = false;
        }
        --this.level;
        token = node.getEndToken();
        if (this.style == 0 || node.inserted()) {
            this.printIndentation(1, this.level * 4);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        return data;
    }

    @Override
    public Object visit(ASTLiteralField node, Object data) {
        SimpleNode keyNode = (SimpleNode)node.jjtGetChild(0);
        data = keyNode.jjtAccept(this, data);
        Token colonToken = keyNode.getEndToken().next;
        if (colonToken == null) {
            this.print(" :");
        } else if (this.style == 0 || node.inserted()) {
            this.print(colonToken.image);
        } else {
            this.printToken(colonToken);
        }
        this.separator = false;
        SimpleNode valueNode = (SimpleNode)node.jjtGetChild(1);
        return valueNode.jjtAccept(this, data);
    }

    @Override
    public Object visit(ASTArrayLiteral node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        ++this.level;
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode arrayElementNode = (SimpleNode)node.jjtGetChild(i);
            if (this.style == 0 || node.inserted()) {
                this.printIndentation(1, this.level * 4);
                this.separator = true;
            }
            data = arrayElementNode.jjtAccept(this, data);
            if (i >= n - 1) continue;
            Token commaToken = arrayElementNode.getEndToken().next;
            if (commaToken == null) {
                this.print(44);
            } else if (this.style == 0 || node.inserted()) {
                this.print(commaToken.image);
            } else {
                this.printToken(commaToken);
            }
            this.separator = false;
        }
        --this.level;
        token = node.getEndToken();
        if (this.style == 0 || node.inserted()) {
            this.printIndentation(1, this.level * 4);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        return data;
    }

    @Override
    public Object visit(ASTVariableStatement node, Object data) {
        Token varToken = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.printIndentation(2, this.level * 4);
            this.print(varToken.image);
        } else {
            this.printToken(varToken);
        }
        this.separator = false;
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode varDeclNode = (SimpleNode)node.jjtGetChild(i);
            data = varDeclNode.jjtAccept(this, data);
            if (i >= n - 1) continue;
            Token commaToken = varDeclNode.getEndToken().next;
            if (commaToken == null) {
                this.print(44);
            } else if (this.style == 0 || node.inserted()) {
                this.print(commaToken.image);
            } else {
                this.printToken(commaToken);
            }
            this.separator = false;
        }
        Token scToken = node.getEndToken();
        if (scToken != null && scToken.kind == 59) {
            if (this.style == 0 || node.inserted()) {
                this.print(scToken.image);
            } else {
                this.printToken(scToken);
            }
            this.separator = true;
        }
        return data;
    }

    @Override
    public Object visit(ASTExpressionStatement node, Object data) {
        if (this.style == 0 || node.inserted()) {
            if (this.getScope() instanceof ASTProgram) {
                this.printIndentation(2, this.level * 4);
            } else {
                this.printIndentation(1, this.level * 4);
            }
            this.separator = true;
        }
        data = super.visit(node, data);
        Token scToken = node.getEndToken();
        if (scToken != null && scToken.kind == 59) {
            if (this.style == 0 || node.inserted()) {
                this.print(scToken.image);
            } else {
                this.printToken(scToken);
            }
            this.separator = true;
        }
        return data;
    }

    @Override
    public Object visit(ASTThisReference node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        return data;
    }

    @Override
    public Object visit(ASTFunctionCallParameters node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode paramNode = (SimpleNode)node.jjtGetChild(i);
            data = paramNode.jjtAccept(this, data);
            if (i >= n - 1) continue;
            Token commaToken = paramNode.getEndToken().next;
            if (commaToken == null) {
                this.print(44);
            } else if (this.style == 0 || node.inserted()) {
                this.print(commaToken.image);
            } else {
                this.printToken(commaToken);
            }
            this.separator = false;
        }
        token = node.getEndToken();
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        return data;
    }

    @Override
    public Object visit(ASTPropertyValueReference node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        data = super.visit(node, data);
        token = node.getEndToken();
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        return data;
    }

    @Override
    public Object visit(ASTPropertyIdentifierReference node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        data = super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTAllocationExpression node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            if (!this.separator) {
                this.print(32);
            }
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        data = super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTOperator node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            if (!token.image.equals("++") && !token.image.equals("--")) {
                this.print(32);
            }
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = token.image.equals("++") || token.image.equals("--");
        return data;
    }

    @Override
    public Object visit(ASTConditionalExpression node, Object data) {
        SimpleNode condNode = (SimpleNode)node.jjtGetChild(0);
        data = condNode.jjtAccept(this, data);
        Token hookToken = condNode.getEndToken().next;
        if (hookToken == null) {
            this.print(32);
            this.print(63);
        } else if (this.style == 0 || node.inserted()) {
            this.print(32);
            this.print(hookToken.image);
        } else {
            this.printToken(hookToken);
        }
        this.separator = false;
        SimpleNode trueBranchNode = (SimpleNode)node.jjtGetChild(1);
        data = trueBranchNode.jjtAccept(this, data);
        Token colonToken = trueBranchNode.getEndToken().next;
        if (colonToken == null) {
            this.print(32);
            this.print(63);
        } else if (this.style == 0 || node.inserted()) {
            this.print(32);
            this.print(colonToken.image);
        } else {
            this.printToken(colonToken);
        }
        this.separator = false;
        SimpleNode falseBranchNode = (SimpleNode)node.jjtGetChild(2);
        data = falseBranchNode.jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTExpressionList node, Object data) {
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode paramNode = (SimpleNode)node.jjtGetChild(i);
            data = paramNode.jjtAccept(this, data);
            if (i >= n - 1) continue;
            Token commaToken = paramNode.getEndToken().next;
            if (commaToken == null) {
                this.print(44);
            } else if (this.style == 0 || node.inserted()) {
                this.print(commaToken.image);
            } else {
                this.printToken(commaToken);
            }
            this.separator = false;
        }
        return data;
    }

    @Override
    public Object visit(ASTBlock node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.print(32);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        ++this.level;
        data = super.visit(node, data);
        --this.level;
        token = node.getEndToken();
        if (this.style == 0 || node.inserted()) {
            this.printIndentation(1, this.level * 4);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        return data;
    }

    @Override
    public Object visit(ASTVariableDeclaration node, Object data) {
        SimpleNode identifierNode = (SimpleNode)node.jjtGetChild(0);
        data = identifierNode.jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 2) {
            Token assignToken = identifierNode.getEndToken().next;
            if (assignToken == null) {
                this.print(" =");
            } else if (this.style == 0 || node.inserted()) {
                this.print(32);
                this.print(assignToken.image);
            } else {
                this.printToken(assignToken);
            }
            this.separator = false;
            SimpleNode initializerNode = (SimpleNode)node.jjtGetChild(1);
            data = initializerNode.jjtAccept(this, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTVariableDeclarationList node, Object data) {
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode paramNode = (SimpleNode)node.jjtGetChild(i);
            data = paramNode.jjtAccept(this, data);
            if (i >= n - 1) continue;
            Token commaToken = paramNode.getEndToken().next;
            if (commaToken == null) {
                this.print(44);
            } else if (this.style == 0 || node.inserted()) {
                this.print(commaToken.image);
            } else {
                this.printToken(commaToken);
            }
            this.separator = false;
        }
        return data;
    }

    @Override
    public Object visit(ASTEmptyStatement node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.printIndentation(1, this.level * 4);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        return data;
    }

    @Override
    public Object visit(ASTFunctionDeclaration node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            if (!this.separator) {
                this.print(32);
            }
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTFormalParameterList node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode paramNode = (SimpleNode)node.jjtGetChild(i);
            data = paramNode.jjtAccept(this, data);
            if (i >= n - 1) continue;
            Token commaToken = paramNode.getEndToken().next;
            if (commaToken == null) {
                this.print(44);
            } else if (this.style == 0 || node.inserted()) {
                this.print(commaToken.image);
            } else {
                this.printToken(commaToken);
            }
            this.separator = false;
        }
        token = node.getEndToken();
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        return data;
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.printIndentation(2, this.level * 4);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        token = token.next;
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        SimpleNode condNode = (SimpleNode)node.jjtGetChild(0);
        data = condNode.jjtAccept(this, data);
        token = condNode.getEndToken().next;
        if (token == null) {
            this.print(41);
        } else if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        SimpleNode trueBranchNode = (SimpleNode)node.jjtGetChild(1);
        boolean single = false;
        if ((this.style == 0 || node.inserted()) && !(trueBranchNode instanceof ASTBlock)) {
            single = true;
            ++this.level;
        }
        data = trueBranchNode.jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 3) {
            token = trueBranchNode.getEndToken().next;
            if (token == null) {
                if (single) {
                    --this.level;
                } else {
                    this.print(32);
                }
                this.print("else");
            } else if (this.style == 0 || node.inserted()) {
                if (single) {
                    --this.level;
                } else {
                    this.print(32);
                }
                this.print(token.image);
            } else {
                this.printToken(token);
            }
            this.separator = false;
            SimpleNode falseBranchNode = (SimpleNode)node.jjtGetChild(2);
            boolean singleElse = false;
            if ((this.style == 0 || node.inserted()) && !(falseBranchNode instanceof ASTBlock)) {
                singleElse = true;
                ++this.level;
            }
            data = falseBranchNode.jjtAccept(this, data);
            if (singleElse) {
                --this.level;
            }
        } else if (single) {
            --this.level;
        }
        return data;
    }

    @Override
    public Object visit(ASTSwitchStatement node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.printIndentation(2, this.level * 4);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        token = token.next;
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        SimpleNode condNode = (SimpleNode)node.jjtGetChild(0);
        data = condNode.jjtAccept(this, data);
        token = condNode.getEndToken().next;
        if (token == null) {
            this.print(41);
        } else if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        SimpleNode groupsNode = (SimpleNode)node.jjtGetChild(1);
        data = groupsNode.jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTCaseGroups node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        ++this.level;
        if (this.style == 0 || node.inserted()) {
            this.printIndentation(1, this.level * 4);
        }
        data = super.visit(node, data);
        --this.level;
        token = node.getEndToken();
        if (this.style == 0 || node.inserted()) {
            this.printIndentation(1, this.level * 4);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        return data;
    }

    @Override
    public Object visit(ASTParenExpression node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        data = super.visit(node, data);
        token = node.getEndToken();
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        return data;
    }

    @Override
    public Object visit(ASTCaseGuard node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            if (!this.separator) {
                this.print(32);
            }
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        if (node.jjtGetNumChildren() > 0) {
            data = super.visit(node, data);
        }
        token = node.getEndToken();
        if (this.style == 0 || node.inserted()) {
            this.print(32);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        return data;
    }

    @Override
    public Object visit(ASTBreakStatement node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.printIndentation(1, this.level * 4);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        Token scToken = node.getEndToken();
        if (scToken != null && scToken.kind == 59) {
            if (this.style == 0 || node.inserted()) {
                this.print(scToken.image);
            } else {
                this.printToken(scToken);
            }
            this.separator = true;
        }
        return data;
    }

    @Override
    public Object visit(ASTReturnStatement node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.printIndentation(2, this.level * 4);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        data = super.visit(node, data);
        Token scToken = node.getEndToken();
        if (scToken != null && scToken.kind == 59) {
            if (this.style == 0 || node.inserted()) {
                this.print(scToken.image);
            } else {
                this.printToken(scToken);
            }
            this.separator = true;
        }
        return data;
    }

    @Override
    public Object visit(ASTWithStatement node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.printIndentation(2, this.level * 4);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        token = token.next;
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        SimpleNode exprNode = (SimpleNode)node.jjtGetChild(0);
        data = exprNode.jjtAccept(this, data);
        token = exprNode.getEndToken().next;
        if (token == null) {
            this.print(41);
        } else if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        SimpleNode stmtNode = (SimpleNode)node.jjtGetChild(1);
        data = stmtNode.jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTTryStatement node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.printIndentation(1, this.level * 4);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTCatchClause node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            if (!this.separator) {
                this.print(32);
            }
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        token = token.next;
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        SimpleNode identifierNode = (SimpleNode)node.jjtGetChild(0);
        data = identifierNode.jjtAccept(this, data);
        token = identifierNode.getEndToken().next;
        if (token == null) {
            this.print(41);
        } else if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        SimpleNode blockNode = (SimpleNode)node.jjtGetChild(1);
        data = blockNode.jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTFinallyClause node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            if (!this.separator) {
                this.print(32);
            }
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTThrowStatement node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.printIndentation(1, this.level * 4);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTContinueStatement node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.printIndentation(1, this.level * 4);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        Token scToken = node.getEndToken();
        if (scToken != null && scToken.kind == 59) {
            if (this.style == 0 || node.inserted()) {
                this.print(scToken.image);
            } else {
                this.printToken(scToken);
            }
            this.separator = true;
        }
        return data;
    }

    @Override
    public Object visit(ASTWhileStatement node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.printIndentation(2, this.level * 4);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        token = token.next;
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        SimpleNode codeNode = (SimpleNode)node.jjtGetChild(0);
        data = codeNode.jjtAccept(this, data);
        token = codeNode.getEndToken().next;
        if (token == null) {
            this.print(41);
        } else if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        SimpleNode stmtNode = (SimpleNode)node.jjtGetChild(1);
        data = stmtNode.jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTDoStatement node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.printIndentation(2, this.level * 4);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        SimpleNode stmtNode = (SimpleNode)node.jjtGetChild(0);
        data = stmtNode.jjtAccept(this, data);
        token = stmtNode.getEndToken().next;
        if (token == null) {
            this.print(" while");
        } else if (this.style == 0 || node.inserted()) {
            this.print(32);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        if (token != null) {
            token = token.next;
        }
        if (token == null) {
            this.print(40);
        } else if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        SimpleNode codeNode = (SimpleNode)node.jjtGetChild(1);
        data = codeNode.jjtAccept(this, data);
        token = codeNode.getEndToken().next;
        if (token == null) {
            this.print(41);
        } else if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        return data;
    }

    @Override
    public Object visit(ASTForStatement node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.printIndentation(2, this.level * 4);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        token = token.next;
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        SimpleNode initNode = (SimpleNode)node.jjtGetChild(0);
        data = initNode.jjtAccept(this, data);
        token = initNode.getEndToken().next;
        if (token == null) {
            this.print(59);
        } else if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        SimpleNode condNode = (SimpleNode)node.jjtGetChild(1);
        data = condNode.jjtAccept(this, data);
        token = condNode.getEndToken().next;
        if (token == null) {
            this.print(59);
        } else if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        SimpleNode incrNode = (SimpleNode)node.jjtGetChild(2);
        data = incrNode.jjtAccept(this, data);
        token = incrNode.getEndToken().next;
        if (token == null) {
            this.print(41);
        } else if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        SimpleNode stmtNode = (SimpleNode)node.jjtGetChild(3);
        data = stmtNode.jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTForVarStatement node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.printIndentation(2, this.level * 4);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        token = token.next;
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        token = token.next;
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        SimpleNode initNode = (SimpleNode)node.jjtGetChild(0);
        data = initNode.jjtAccept(this, data);
        token = initNode.getEndToken().next;
        if (token == null) {
            this.print(59);
        } else if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        SimpleNode condNode = (SimpleNode)node.jjtGetChild(1);
        data = condNode.jjtAccept(this, data);
        token = condNode.getEndToken().next;
        if (token == null) {
            this.print(59);
        } else if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        SimpleNode incrNode = (SimpleNode)node.jjtGetChild(2);
        data = incrNode.jjtAccept(this, data);
        token = incrNode.getEndToken().next;
        if (token == null) {
            this.print(41);
        } else if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        SimpleNode stmtNode = (SimpleNode)node.jjtGetChild(3);
        data = stmtNode.jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTForInStatement node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.printIndentation(2, this.level * 4);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        token = token.next;
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        SimpleNode exprNode = (SimpleNode)node.jjtGetChild(0);
        data = exprNode.jjtAccept(this, data);
        token = exprNode.getEndToken().next;
        if (token == null) {
            this.print(" in");
        } else if (this.style == 0 || node.inserted()) {
            this.print(32);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        exprNode = (SimpleNode)node.jjtGetChild(1);
        data = exprNode.jjtAccept(this, data);
        token = exprNode.getEndToken().next;
        if (token == null) {
            this.print(41);
        } else if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        SimpleNode stmtNode = (SimpleNode)node.jjtGetChild(2);
        data = stmtNode.jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTForVarInStatement node, Object data) {
        Token token = node.getBeginToken();
        if (this.style == 0 || node.inserted()) {
            this.printIndentation(2, this.level * 4);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        token = token.next;
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        token = token.next;
        if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        SimpleNode identifierNode = (SimpleNode)node.jjtGetChild(0);
        data = identifierNode.jjtAccept(this, data);
        SimpleNode initializerNode = (SimpleNode)node.jjtGetChild(1);
        data = initializerNode.jjtAccept(this, data);
        token = initializerNode.getEndToken().next;
        if (token == null) {
            this.print(" in");
        } else if (this.style == 0 || node.inserted()) {
            this.print(32);
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = false;
        SimpleNode exprNode = (SimpleNode)node.jjtGetChild(2);
        data = exprNode.jjtAccept(this, data);
        token = exprNode.getEndToken().next;
        if (token == null) {
            this.print(41);
        } else if (this.style == 0 || node.inserted()) {
            this.print(token.image);
        } else {
            this.printToken(token);
        }
        this.separator = true;
        SimpleNode stmtNode = (SimpleNode)node.jjtGetChild(3);
        data = stmtNode.jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTProgram node, Object data) {
        data = super.visit(node, data);
        return data;
    }

    static {
        int i;
        BLANKS = new char[128];
        FEEDS = new char[8];
        for (i = 0; i < FEEDS.length; ++i) {
            PrettyPrinter.FEEDS[i] = 10;
        }
        for (i = 0; i < BLANKS.length; ++i) {
            PrettyPrinter.BLANKS[i] = 32;
        }
    }
}

