/*
 * Decompiled with CFR 0.152.
 */
package sidekick.ecmascript.parser;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import sidekick.ecmascript.parser.ASTAssignmentExpression;
import sidekick.ecmascript.parser.ASTBlock;
import sidekick.ecmascript.parser.ASTCompositeReference;
import sidekick.ecmascript.parser.ASTExpressionStatement;
import sidekick.ecmascript.parser.ASTForVarInStatement;
import sidekick.ecmascript.parser.ASTForVarStatement;
import sidekick.ecmascript.parser.ASTFormalParameterList;
import sidekick.ecmascript.parser.ASTFunctionDeclaration;
import sidekick.ecmascript.parser.ASTIdentifier;
import sidekick.ecmascript.parser.ASTProgram;
import sidekick.ecmascript.parser.ASTRequireStatement;
import sidekick.ecmascript.parser.ASTVariableDeclaration;
import sidekick.ecmascript.parser.Comment;
import sidekick.ecmascript.parser.EcmaScriptVisitor;
import sidekick.ecmascript.parser.EcmaScriptVisitorAdapter;
import sidekick.ecmascript.parser.EcmaScriptVisitorDelegate;
import sidekick.ecmascript.parser.SimpleNode;

public class GlobalDeclCollector
extends EcmaScriptVisitorAdapter
implements EcmaScriptVisitor {
    private Set declarations;
    private LinkedList declarationNodes;
    private boolean collectForvarDeclarations;
    private LinkedList localDeclarations;
    private LinkedList loopDeclarations;

    public GlobalDeclCollector(Set declarations, LinkedList declarationNodes, EcmaScriptVisitorDelegate visitorDelegate) {
        super(visitorDelegate);
        this.declarations = declarations;
        this.declarationNodes = declarationNodes;
        this.localDeclarations = new LinkedList();
        this.loopDeclarations = new LinkedList();
    }

    public GlobalDeclCollector(Set declarations, LinkedList declarationNodes) {
        this(declarations, declarationNodes, null);
    }

    public GlobalDeclCollector(Set declarations) {
        this(declarations, null);
    }

    private boolean isLocal(String identifierName) {
        Map decls;
        ListIterator iter = this.loopDeclarations.listIterator(this.loopDeclarations.size());
        while (iter.hasPrevious()) {
            decls = (Map)iter.previous();
            if (!decls.containsKey(identifierName)) continue;
            return true;
        }
        iter = this.localDeclarations.listIterator(this.localDeclarations.size());
        while (iter.hasPrevious()) {
            decls = (Map)iter.previous();
            if (!decls.containsKey(identifierName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object visit(ASTVariableDeclaration node, Object data) {
        String name = ((ASTIdentifier)node.jjtGetChild(0)).getName();
        if (this.collectForvarDeclarations) {
            Map forvarDeclarations = (Map)this.loopDeclarations.getLast();
            if (!forvarDeclarations.containsKey(name)) {
                forvarDeclarations.put(name, name);
            }
        } else if (this.localDeclarations.size() > 0) {
            Map functionDecls = (Map)this.localDeclarations.getLast();
            if (!functionDecls.containsKey(name)) {
                functionDecls.put(name, name);
            }
        } else {
            this.declarations.add(name);
            if (this.declarationNodes != null) {
                this.declarationNodes.add(node);
            }
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTExpressionStatement node, Object data) {
        SimpleNode exprNode;
        if (node.jjtGetNumChildren() > 0 && (exprNode = (SimpleNode)node.jjtGetChild(0)) instanceof ASTAssignmentExpression && exprNode.jjtGetNumChildren() > 0) {
            Comment comment;
            String lhsName;
            SimpleNode lhsNode = (SimpleNode)exprNode.jjtGetChild(0);
            if (lhsNode instanceof ASTCompositeReference) {
                String compositeName;
                String firstRefPart = null;
                SimpleNode cNode = (SimpleNode)lhsNode.jjtGetChild(0);
                if (cNode instanceof ASTIdentifier) {
                    firstRefPart = ((ASTIdentifier)cNode).getName();
                }
                if (firstRefPart != null && !this.isLocal(firstRefPart) && (compositeName = ((ASTCompositeReference)lhsNode).getCompositeName()) != null) {
                    this.declarations.add(compositeName);
                    if (this.declarationNodes != null) {
                        this.declarationNodes.add(exprNode);
                    }
                }
            } else if (lhsNode instanceof ASTIdentifier && (lhsName = ((ASTIdentifier)lhsNode).getName()) != null && !this.isLocal(lhsName) && (comment = node.getComment()) != null && comment.containsTag("constructor")) {
                this.declarations.add(lhsName);
                if (this.declarationNodes != null) {
                    this.declarationNodes.add(exprNode);
                }
            }
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTForVarStatement node, Object data) {
        HashMap forvarDeclarations = new HashMap();
        this.loopDeclarations.add(forvarDeclarations);
        this.pre(node, data);
        this.collectForvarDeclarations = true;
        data = node.jjtGetChild(0).jjtAccept(this, data);
        this.collectForvarDeclarations = false;
        if (this.localDeclarations.size() > 0) {
            Map functionDecls = (Map)this.localDeclarations.getLast();
            for (String name : forvarDeclarations.keySet()) {
                if (functionDecls.containsKey(name)) continue;
                functionDecls.put(name, name);
            }
        }
        int n = node.jjtGetNumChildren();
        for (int i = 1; i < n; ++i) {
            data = node.jjtGetChild(i).jjtAccept(this, data);
        }
        this.loopDeclarations.removeLast();
        this.post(node, data);
        return data;
    }

    @Override
    public Object visit(ASTForVarInStatement node, Object data) {
        Map functionDecls;
        HashMap<String, String> forvarInDecls = new HashMap<String, String>();
        String forVarInName = ((ASTIdentifier)node.jjtGetChild(0)).getName();
        forvarInDecls.put(forVarInName, forVarInName);
        if (this.localDeclarations.size() > 0 && !(functionDecls = (Map)this.localDeclarations.getLast()).containsKey(forVarInName)) {
            functionDecls.put(forVarInName, forVarInName);
        }
        this.loopDeclarations.add(forvarInDecls);
        data = super.visit(node, data);
        this.loopDeclarations.removeLast();
        return data;
    }

    @Override
    public Object visit(ASTFunctionDeclaration node, Object data) {
        int index = 0;
        this.pre(node, data);
        if (node.jjtGetNumChildren() == 3) {
            SimpleNode firstChild = (SimpleNode)node.jjtGetChild(0);
            String name = null;
            name = firstChild instanceof ASTIdentifier ? ((ASTIdentifier)firstChild).getName() : ((ASTIdentifier)firstChild.jjtGetChild(1)).getName();
            if (this.getScope() instanceof ASTProgram) {
                this.declarations.add(name);
                if (this.declarationNodes != null) {
                    this.declarationNodes.add(node);
                }
            }
            data = node.jjtGetChild(0).jjtAccept(this, data);
            index = 1;
        }
        ASTFormalParameterList paramList = (ASTFormalParameterList)node.jjtGetChild(index);
        ASTBlock body = (ASTBlock)node.jjtGetChild(index + 1);
        HashMap<String, String> functionVars = new HashMap<String, String>();
        if (paramList.jjtGetNumChildren() > 0) {
            int n = paramList.jjtGetNumChildren();
            for (int i = 0; i < n; ++i) {
                ASTIdentifier param = (ASTIdentifier)paramList.jjtGetChild(i);
                String paramName = param.getName();
                functionVars.put(paramName, paramName);
            }
        }
        this.localDeclarations.add(functionVars);
        data = body.jjtAccept(this, data);
        node.setLocals(this.localDeclarations);
        this.localDeclarations.removeLast();
        this.post(node, data);
        return data;
    }

    public Object visit(ASTRequireStatement node, Object data) {
        return data;
    }
}

