/*
 * Decompiled with CFR 0.152.
 */
package sidekick.ecmascript.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sidekick.ecmascript.parser.Util;

public class Comment {
    private String comment;
    private ArrayList<Tag> tags;
    private ArrayList<String> lines;
    private String commentBody;
    private boolean isJavadoc;
    private boolean markedPlainText;
    private static Pattern detectPlaintextPattern = Pattern.compile("</?plaintext\\s*([^>]*)>");

    public Comment(String comment) throws Exception {
        this.comment = comment;
        this.tags = new ArrayList();
        this.lines = new ArrayList();
        this.isJavadoc = false;
        this.parse();
        String returnTag = this.getTag("return");
        if (returnTag != null && this.lines.size() == 0) {
            String[] rc = Comment.parseTypedDescription(returnTag);
            this.lines.add("Returns " + rc[1]);
        }
    }

    private int skipWS(int cursor) {
        char c = this.comment.charAt(cursor);
        while (Character.isWhitespace(c) && c != '\r' && c != '\n') {
            c = this.comment.charAt(++cursor);
        }
        return cursor;
    }

    private boolean isCommentEnd(int cursor) {
        return this.comment.charAt(cursor + 1) == '/' && this.comment.charAt(cursor) == '*' && this.comment.charAt(cursor - 1) != '\\';
    }

    private void parse() throws Exception {
        int cursor = 0;
        Tag lastTagObj = null;
        boolean seenTags = false;
        boolean startedBody = false;
        try {
            if (this.comment.charAt(cursor) != '/' || this.comment.charAt(cursor + 1) != '*') {
                throw new Exception("comment parser: comment string doesn't start with /* " + this.comment);
            }
            if (this.comment.charAt(cursor + 2) == '*') {
                this.isJavadoc = true;
                cursor += 3;
            } else {
                cursor += 2;
            }
            if (this.comment.startsWith("TEXT", cursor)) {
                cursor += 4;
                this.markedPlainText = true;
            } else if (this.comment.startsWith("HTML", cursor)) {
                cursor += 4;
            }
            if (this.comment.charAt(cursor) == '/') {
                return;
            }
            boolean done = false;
            boolean seenStar = false;
            StringBuffer leadingBuffer = null;
            while (!done) {
                char c = this.comment.charAt(cursor);
                seenStar = false;
                leadingBuffer = null;
                while (!this.isCommentEnd(cursor) && (Character.isWhitespace(c) && c != '\r' && c != '\n' || c == '*')) {
                    if (seenStar) {
                        if (leadingBuffer == null) {
                            leadingBuffer = new StringBuffer();
                        }
                        leadingBuffer.append(c);
                    } else if (c == '*') {
                        seenStar = true;
                    }
                    c = this.comment.charAt(++cursor);
                }
                if (this.isCommentEnd(cursor)) {
                    done = true;
                    continue;
                }
                if (c == '@') {
                    seenTags = true;
                    ++cursor;
                    c = this.comment.charAt(cursor = this.skipWS(cursor));
                    if (!Character.isJavaIdentifierStart(c)) {
                        throw new Exception("comment parser: identifier expected at position " + cursor + " in comment " + this.comment);
                    }
                    StringBuffer tag = new StringBuffer();
                    while (!this.isCommentEnd(cursor) && Character.isJavaIdentifierPart(c)) {
                        tag.append(c);
                        c = this.comment.charAt(++cursor);
                    }
                    if (this.isCommentEnd(cursor)) {
                        done = true;
                        continue;
                    }
                    cursor = this.skipWS(cursor);
                    c = this.comment.charAt(cursor);
                    StringBuffer line = new StringBuffer();
                    while (!this.isCommentEnd(cursor) && c != '\r' && c != '\n') {
                        line.append(c);
                        c = this.comment.charAt(++cursor);
                    }
                    if (tag.length() > 0) {
                        Tag tagObj = new Tag();
                        tagObj.key = tag.toString();
                        String cLine = line.toString().trim();
                        if (cLine.length() > 0) {
                            tagObj.value = cLine;
                        }
                        this.tags.add(tagObj);
                        lastTagObj = tagObj;
                    }
                    if (this.isCommentEnd(cursor)) {
                        done = true;
                        continue;
                    }
                    if (this.comment.charAt(++cursor) != '\n') continue;
                    ++cursor;
                    continue;
                }
                StringBuffer line = new StringBuffer();
                while (!this.isCommentEnd(cursor) && c != '\r' && c != '\n') {
                    line.append(c);
                    c = this.comment.charAt(++cursor);
                }
                if (!seenTags) {
                    String cLine;
                    String string = cLine = leadingBuffer != null ? leadingBuffer.toString() + line.toString() : line.toString();
                    if (startedBody) {
                        this.lines.add(cLine);
                    } else if (cLine.length() > 0) {
                        this.lines.add(cLine);
                        startedBody = true;
                    }
                } else if (line.length() > 0 && lastTagObj != null) {
                    lastTagObj.value = leadingBuffer != null ? lastTagObj.value + "\n" + leadingBuffer.toString() + line.toString() : lastTagObj.value + "\n" + line.toString();
                }
                if (this.isCommentEnd(cursor)) {
                    done = true;
                    continue;
                }
                if (this.comment.charAt(++cursor) != '\n') continue;
                ++cursor;
            }
        }
        catch (IndexOutOfBoundsException exc) {
            throw new Exception("comment parser: unexpected end in comment string: " + this.comment);
        }
    }

    public boolean isJavadoc() {
        return this.isJavadoc;
    }

    public List getLines() {
        return Collections.unmodifiableList(this.lines);
    }

    public String getCommentBody() {
        if (this.commentBody == null) {
            StringBuffer buffer = new StringBuffer();
            Iterator<String> iter = this.lines.iterator();
            boolean appended = false;
            while (iter.hasNext()) {
                String line = iter.next();
                if (appended) {
                    buffer.append('\n');
                } else {
                    appended = true;
                }
                buffer.append(line);
            }
            this.commentBody = buffer.toString();
        }
        return this.commentBody;
    }

    public String getFirstSentenceInCommentBody(int maxLength) {
        int ll;
        String cBody = this.getCommentBody();
        String result = null;
        int sentenceEndIndex = -1;
        boolean sawDot = false;
        int n = cBody.length();
        for (int i = 0; i < n && sentenceEndIndex == -1; ++i) {
            char c = cBody.charAt(i);
            if (c == '.') {
                sawDot = true;
                if (i != n - 1) continue;
                sentenceEndIndex = i;
                continue;
            }
            if (!sawDot) continue;
            sawDot = false;
            if (c != ' ' && c != '\r' && c != '<' && c != '\n' && c != '\t') continue;
            sentenceEndIndex = i - 1;
        }
        result = sentenceEndIndex != -1 ? cBody.substring(0, sentenceEndIndex + 1) : ((ll = Math.min(Math.max(maxLength, 3) - 3, cBody.length())) == cBody.length() ? cBody.substring(0, ll) : cBody.substring(0, ll) + "...");
        return result;
    }

    public String getHtmlifiedCommentBody() {
        String cBody = this.getCommentBody();
        if (this.markedPlainText) {
            return Util.escape2Html(cBody);
        }
        Matcher matcher = detectPlaintextPattern.matcher(cBody);
        int cursor = 0;
        boolean inPlainTextBlock = false;
        StringBuffer buffer = null;
        while (matcher.find()) {
            if (buffer == null) {
                buffer = new StringBuffer();
            }
            int n = matcher.start();
            if (!inPlainTextBlock && cBody.charAt(n + 1) == 'p') {
                if (cursor < n) {
                    buffer.append(cBody.substring(cursor, n));
                }
                inPlainTextBlock = true;
                String preAttr = matcher.group(1);
                if (preAttr != null) {
                    if ((preAttr = preAttr.trim()).length() > 0) {
                        buffer.append("<pre ");
                        buffer.append(preAttr);
                        buffer.append(">");
                    } else {
                        buffer.append("<pre>");
                    }
                } else {
                    buffer.append("<pre>");
                }
            } else if (inPlainTextBlock && cBody.charAt(n + 1) == '/') {
                block8: for (int i = cursor; i < n; ++i) {
                    char c = cBody.charAt(i);
                    switch (c) {
                        case '<': {
                            buffer.append("&lt;");
                            continue block8;
                        }
                        case '>': {
                            buffer.append("&gt;");
                            continue block8;
                        }
                        case '&': {
                            buffer.append("&amp;");
                            continue block8;
                        }
                        case '\"': {
                            buffer.append("&quot;");
                            continue block8;
                        }
                        case '\'': {
                            buffer.append("&#039;");
                            continue block8;
                        }
                        default: {
                            buffer.append(c);
                        }
                    }
                }
                inPlainTextBlock = false;
                buffer.append("</pre>");
            }
            cursor = matcher.end();
        }
        if (buffer != null && cursor < cBody.length()) {
            buffer.append(cBody.substring(cursor, cBody.length()));
        }
        return buffer == null ? cBody : buffer.toString();
    }

    public List<Tag> getTags() {
        return Collections.unmodifiableList(this.tags);
    }

    public String getTag(String key) {
        for (Tag tag : this.tags) {
            if (!tag.key.equals(key)) continue;
            return tag.value;
        }
        return null;
    }

    public List<String> getTags(String key) {
        LinkedList<String> result = new LinkedList<String>();
        for (Tag tag : this.tags) {
            if (!tag.key.equals(key)) continue;
            result.add(tag.value);
        }
        return result;
    }

    public List<Tag> getTags(Pattern pattern) {
        LinkedList<Tag> result = new LinkedList<Tag>();
        Iterator<Tag> iter = this.tags.iterator();
        Matcher matcher = null;
        while (iter.hasNext()) {
            Tag tag = iter.next();
            if (matcher == null) {
                matcher = pattern.matcher(tag.key);
            } else {
                matcher.reset(tag.key);
            }
            if (!matcher.matches()) continue;
            result.add(tag);
        }
        return result;
    }

    public boolean containsTag(String key) {
        for (Tag tag : this.tags) {
            if (!tag.key.equals(key)) continue;
            return true;
        }
        return false;
    }

    public String getOriginalSource() {
        return this.comment;
    }

    @Deprecated
    public String getHtmlifiedSource() {
        if (!this.isJavadoc) {
            return this.comment;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("/**\n");
        String lastLine = null;
        for (String line : this.lines) {
            if (line.length() > 0) {
                String typeSuggestion;
                int closeParenIndex;
                buffer.append(" * ");
                if (lastLine == null && line.startsWith("(") && (closeParenIndex = line.indexOf(41)) > 2 && Util.isJavaIdentifier(typeSuggestion = line.substring(1, closeParenIndex)) && closeParenIndex + 1 < line.length()) {
                    line = line.substring(closeParenIndex + 1).trim();
                }
                buffer.append(line);
                buffer.append('\n');
            } else if (lastLine != null && !lastLine.endsWith("<br>") && !lastLine.endsWith("<p>")) {
                buffer.append(" * <p>\n");
            }
            lastLine = line.toLowerCase();
        }
        buffer.append(" * \n");
        for (Tag tag : this.tags) {
            buffer.append(" * @");
            buffer.append(tag.key);
            if (tag.value != null) {
                buffer.append(" ");
                String line = tag.value;
                if (tag.key.equals("return")) {
                    String typeSuggestion;
                    int closeParenIndex;
                    if (line.startsWith("(") && (closeParenIndex = line.indexOf(41)) > 2 && Util.isJavaIdentifier(typeSuggestion = line.substring(1, closeParenIndex)) && closeParenIndex + 1 < line.length()) {
                        line = line.substring(closeParenIndex + 1).trim();
                    }
                } else if (tag.key.equals("param") && Comment.parseNamedTypedDescription(tag.value)[1] != null) {
                    int lparenIndex = line.indexOf(40);
                    int rparenIndex = line.indexOf(41);
                    line = line.substring(0, lparenIndex) + line.substring(rparenIndex + 1);
                }
                buffer.append(line);
            }
            buffer.append('\n');
        }
        buffer.append("*/");
        return buffer.toString();
    }

    public static String[] parseNamedTypedDescription(String tagValue) {
        Pattern pattern = Pattern.compile("(\\w+)(\\s+\\((\\w+)\\))?(.*)", 40);
        Matcher matcher = pattern.matcher(tagValue);
        String[] returnVal = new String[3];
        if (matcher.matches()) {
            returnVal[0] = matcher.group(1);
            returnVal[1] = matcher.group(3);
            returnVal[2] = matcher.group(4);
            if (returnVal[2] != null) {
                returnVal[2] = returnVal[2].trim();
            }
        }
        return returnVal;
    }

    public static String[] parseTypedDescription(String tagValue) {
        Pattern pattern = Pattern.compile("(\\(\\w+\\))?(.*)", 40);
        Matcher matcher = pattern.matcher(tagValue);
        String[] returnVal = new String[2];
        if (matcher.matches()) {
            returnVal[0] = matcher.group(1);
            returnVal[1] = matcher.group(2);
            if (returnVal[0] != null) {
                returnVal[0] = returnVal[0].substring(1, returnVal[0].length() - 1);
            }
            if (returnVal[1] != null) {
                returnVal[1] = returnVal[1].trim();
            }
        }
        return returnVal;
    }

    public String toString() {
        return "Comment[" + this.comment + "]";
    }

    public static void main(String[] args) {
        try {
            String commentStr = "/**\n* Here is a test for <plaintext>\n* hahah hahah < ahaha > ahaha\n*  aha \t \n*  </plaintext><plaintext></plaintext>\n * hoaoaoao\n * <plaintext> yeyeyey \n* hshshshs \t </plaintext> hahahahh uuuuu*/";
            Comment comment = new Comment(commentStr);
            System.out.println(comment.getHtmlifiedCommentBody());
            commentStr = "/**\n* Here is a test for <plaintext foo=bar tar klar=wahr>\n* hahah hahah < ahaha > ahaha\n*  aha \t \n*  </plaintext><plaintext></plaintext>\n * hoaoaoao\n * <plaintext> yeyeyey \n* hshshshs \t </plaintext> hahahahh uuuuu*/";
            comment = new Comment(commentStr);
            System.out.println(comment.getHtmlifiedCommentBody());
            commentStr = "/**\n* @return (Type) bla\n*/";
            comment = new Comment(commentStr);
            System.out.println(comment.getCommentBody());
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public static class Tag {
        public String key;
        public String value;

        public String toString() {
            return "@" + this.key + " " + this.value;
        }
    }
}

