/*
 * Decompiled with CFR 0.152.
 */
package sidekick.ecmascript.parser;

import sidekick.ecmascript.parser.EcmaScript;
import sidekick.ecmascript.parser.EcmaScriptVisitor;
import sidekick.ecmascript.parser.ParseException;
import sidekick.ecmascript.parser.SimpleNode;
import sidekick.ecmascript.parser.Token;

public class ASTLiteral
extends SimpleNode {
    public static final Object NULL = new Object();
    public static final Object REGEX = new Object();
    public static final Object HTML = new Object();
    protected String tokenImage;
    protected Object value;

    public ASTLiteral(int id) {
        super(id);
    }

    public ASTLiteral(EcmaScript p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(EcmaScriptVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public String getTokenImage() {
        return this.tokenImage;
    }

    public static String unescapedString(String image) {
        image = image.substring(1, image.length() - 1);
        int l = image.length();
        StringBuffer sb = new StringBuffer(l);
        for (int i = 0; i < l; ++i) {
            int c = image.charAt(i);
            if (c == 92 && i + 1 < l) {
                if ((c = image.charAt(++i)) == 110) {
                    c = 10;
                } else if (c == 98) {
                    c = 8;
                } else if (c == 102) {
                    c = 12;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 116) {
                    c = 9;
                } else if (c == 120 && l == 4) {
                    c = (char)(ASTLiteral.hexval(image.charAt(i + 1)) << 4 | ASTLiteral.hexval(image.charAt(i + 1)));
                    i += 2;
                } else if (c == 117) {
                    c = (char)(ASTLiteral.hexval(image.charAt(i + 1)) << 12 | ASTLiteral.hexval(image.charAt(i + 2)) << 8 | ASTLiteral.hexval(image.charAt(i + 3)) << 4 | ASTLiteral.hexval(image.charAt(i + 4)));
                    i += 4;
                } else if (c >= 48 && c <= 55 && l == 4) {
                    c = (char)ASTLiteral.octval(image.charAt(i));
                    if (image.length() > i && image.charAt(i + 1) >= '0' && image.charAt(i + 1) <= '7') {
                        c = (char)(c << 4 | ASTLiteral.octval(image.charAt(++i)));
                    }
                }
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String escapedString(String image, char quoteChar) {
        int l = image.length();
        StringBuffer sb = new StringBuffer(l);
        for (int i = 0; i < l; ++i) {
            char c = image.charAt(i);
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\b') {
                sb.append("\\b");
                continue;
            }
            if (c == '\f') {
                sb.append("\\f");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c == quoteChar) {
                sb.append("\\");
                sb.append(quoteChar);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void setStringValue(String image) throws ParseException {
        this.tokenImage = image;
        this.value = ASTLiteral.unescapedString(image);
    }

    public void setUnquotedStringValue(String valueStr) {
        this.value = valueStr;
        Token token = this.getBeginToken();
        char quoteChar = token.image.charAt(0);
        token.image = quoteChar == '\"' ? "\"" + ASTLiteral.escapedString(valueStr, quoteChar) + "\"" : "'" + ASTLiteral.escapedString(valueStr, quoteChar) + "'";
    }

    public void setRegexValue(String image) {
        this.tokenImage = image;
        this.value = REGEX;
    }

    public void setHtmlValue(String image) {
        this.tokenImage = image;
        this.value = HTML;
    }

    public void setDecimalValue(String image) {
        this.tokenImage = image;
        try {
            this.value = new Long(image);
        }
        catch (NumberFormatException e) {
            this.value = new Double(image);
        }
    }

    public void setHexValue(String image) {
        this.tokenImage = image;
        this.value = new Long(Long.parseLong(image.substring(2), 16));
    }

    public void setFloatingPointValue(String image) {
        this.tokenImage = image;
        this.value = new Double(image);
    }

    public void setBooleanValue(String image) {
        this.tokenImage = image;
        this.value = new Boolean(image);
    }

    public void setNullValue() {
        this.value = NULL;
    }

    @Override
    public String toString() {
        boolean b = System.getProperty("sidekick.ecmascript.general.allNodes", "false").startsWith("t");
        if (b) {
            return super.toString();
        }
        return "Literal[" + (this.value == null ? "" : this.value.toString()) + "]";
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            ASTLiteral other = (ASTLiteral)obj;
            boolean result = true;
            if (this.tokenImage != null) {
                result = this.tokenImage.equals(other.tokenImage);
            } else {
                boolean bl = result = other.tokenImage == null;
            }
            if (result) {
                result = this.value.equals(other.value);
            }
            return result;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = this.tokenImage != null ? 37 * result + this.tokenImage.hashCode() : 37 * result;
        result = this.value != null ? 37 * result + this.value.hashCode() : 37 * result;
        return result;
    }

    static final int hexval(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IllegalStateException("Illegal hex or unicode constant");
    }

    static final int octval(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IllegalStateException("Illegal octal constant");
    }
}

