/*
 * Decompiled with CFR 0.152.
 */
package sidekick.ecmascript;

import errorlist.DefaultErrorSource;
import java.io.StringReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import sidekick.SideKickParsedData;
import sidekick.SideKickParser;
import sidekick.ecmascript.parser.ASTProgram;
import sidekick.ecmascript.parser.EcmaScript;
import sidekick.ecmascript.parser.SimpleNode;
import sidekick.enhanced.PartialParser;
import sidekick.util.ElementUtil;
import sidekick.util.ParseError;
import sidekick.util.Range;

public class EcmaScriptSideKickParser
extends SideKickParser
implements PartialParser {
    private View currentView = null;
    public static boolean showAll = true;
    private int lineOffset = 0;
    Comparator nodeSorter = new Comparator(){

        public int compare(Object a, Object b) {
            return a.toString().compareToIgnoreCase(b.toString());
        }
    };

    public EcmaScriptSideKickParser() {
        super("ecmascript");
    }

    public void setStartLine(int offset) {
        if (offset > 0) {
            this.lineOffset = offset;
        }
    }

    public void parse() {
        if (this.currentView != null) {
            this.parse(this.currentView.getBuffer(), null);
        }
    }

    public SideKickParsedData parse(Buffer buffer, DefaultErrorSource errorSource) {
        this.setStartLine(0);
        return this.parse(buffer, buffer.getText(0, buffer.getLength()), errorSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SideKickParsedData parse(Buffer buffer, String text, DefaultErrorSource errorSource) {
        String filename = buffer.getPath();
        SideKickParsedData parsedData = new SideKickParsedData(buffer.getName());
        DefaultMutableTreeNode root = parsedData.root;
        StringReader reader = new StringReader(text);
        try {
            EcmaScript parser = new EcmaScript(reader);
            parser.setLineOffset(this.lineOffset);
            parser.setTabSize(buffer.getTabSize());
            ASTProgram ss = parser.Program();
            this.addTreeNodes(root, ss);
            ElementUtil.convert((Buffer)buffer, (DefaultMutableTreeNode)root);
            if (!buffer.isDirty() && errorSource != null) {
                List<ParseError> parseErrors = parser.getParseErrors();
                for (ParseError pe : parseErrors) {
                    String message = pe.message;
                    Range range = pe.range;
                    if (range.endLine != range.startLine) {
                        range.endColumn = range.startColumn;
                    }
                    errorSource.addError(0, filename, range.startLine, range.startColumn, range.endColumn, message);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            reader.close();
        }
        return parsedData;
    }

    private void addTreeNodes(DefaultMutableTreeNode root, SimpleNode ss) {
        if (ss != null && ss.hasChildren()) {
            Collections.sort(ss.getChildren(), this.nodeSorter);
            for (SimpleNode cssChild : ss.getChildren()) {
                if (cssChild == null || !cssChild.isVisible()) continue;
                DefaultMutableTreeNode dmtNode = new DefaultMutableTreeNode(cssChild);
                root.add(dmtNode);
                this.addTreeNodeChildren(dmtNode, cssChild);
            }
        }
    }

    private void addTreeNodeChildren(DefaultMutableTreeNode dmtNode, SimpleNode cssNode) {
        if (cssNode.hasChildren()) {
            for (SimpleNode cssChild : cssNode.getChildren()) {
                if (cssChild == null || !cssChild.isVisible()) continue;
                DefaultMutableTreeNode dmtChild = new DefaultMutableTreeNode(cssChild);
                dmtNode.add(dmtChild);
                this.addTreeNodeChildren(dmtChild, cssChild);
            }
        }
    }
}

