/*
 * Decompiled with CFR 0.152.
 */
package sidekick.css.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Position;
import org.gjt.sp.jedit.jEdit;
import sidekick.util.Location;
import sidekick.util.SideKickElement;

public class CSSNode
implements SideKickElement,
Comparable<CSSNode> {
    private String name = "";
    private List<CSSNode> children = new ArrayList<CSSNode>();
    private Location start = null;
    private Location end = null;
    private Position startPosition = null;
    private Position endPosition = null;

    public CSSNode() {
    }

    public CSSNode(String name) {
        this.name = name;
    }

    public void setName(String name) {
        if (name != null) {
            this.name = name;
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        String name = this.getName();
        if (jEdit.getBooleanProperty((String)"sidekick.css.showLineNums", (boolean)false)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getStartLocation().line).append(": ").append(name);
            name = sb.toString();
        }
        return name;
    }

    public void setStartLocation(Location loc) {
        this.start = loc;
    }

    public Location getStartLocation() {
        if (this.start == null) {
            this.start = new Location();
        }
        return this.start;
    }

    public void setEndLocation(Location loc) {
        this.end = loc;
    }

    public Location getEndLocation() {
        if (this.end == null) {
            this.end = new Location();
        }
        return this.end;
    }

    public void setStartPosition(Position s) {
        this.startPosition = s;
    }

    public Position getStartPosition() {
        return this.startPosition;
    }

    public void setEndPosition(Position s) {
        this.endPosition = s;
    }

    public Position getEndPosition() {
        return this.endPosition;
    }

    public void addChild(CSSNode child) {
        this.children.add(child);
    }

    public void addChildren(List<CSSNode> kids) {
        this.children.addAll(kids);
    }

    public List<CSSNode> getChildren() {
        Collections.sort(this.children);
        return this.children;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public boolean equals(Object o) {
        return this.getName().equals(o) && ((Object)this.getChildren()).equals(((CSSNode)o).getChildren());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public int compareTo(CSSNode node) {
        String your_name;
        String my_name = this.getName().toLowerCase();
        if (my_name.startsWith(".") || my_name.startsWith("#")) {
            my_name = my_name.substring(1);
        }
        if ((your_name = node.getName().toLowerCase()).startsWith(".") || your_name.startsWith("#")) {
            your_name = your_name.substring(1);
        }
        return my_name.compareTo(your_name);
    }
}

