/*
 * Decompiled with CFR 0.152.
 */
package sidekick.css.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.jEdit;
import sidekick.css.parser.CSS3ParserConstants;
import sidekick.css.parser.CSS3ParserTokenManager;
import sidekick.css.parser.CSSNode;
import sidekick.css.parser.ParseException;
import sidekick.css.parser.SimpleCharStream;
import sidekick.css.parser.Token;
import sidekick.css.parser.TokenMgrError;
import sidekick.util.Location;
import sidekick.util.ParseError;
import sidekick.util.Range;

public class CSS3Parser
implements CSS3ParserConstants {
    private List<ParseError> parseErrors = new ArrayList<ParseError>();
    private List<ParseError> parseWarnings = new ArrayList<ParseError>();
    private boolean proprietaryAsError = true;
    private static char[] hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private Pattern pePattern = Pattern.compile("(.*?)(\\d+)(.*?)(\\d+)(.*?)");
    static final String[] invalidProperties = new String[]{"alignment-adjust", "alignment-baseline", "backface-visibility", "baseline-shift", "bookmark-label", "bookmark-level", "bookmark-target", "border-image-outset", "border-image-repeat", "border-image-slice", "border-image-source", "border-image-width", "box-decoration-break", "box-flex-group", "box-lines", "color-profile", "column-fill", "crop", "dominant-baseline", "drop-initial-after-adjust", "drop-initial-after-align", "drop-initial-before-adjust", "drop-initial-before-align", "drop-initial-size", "drop-initial-value", "fit", "fit-position", "float-offset", "font-stretch", "font-size-adjust", "grid-columns", "grid-rows", "hanging-punctuation", "hyphenate-after", "hyphenate-before", "hyphenate-characters", "hyphenate-lines", "hyphenate-resource", "hyphens", "icon", "image-orientation", "image-resolution", "inline-box-align", "line-stacking", "line-stacking-ruby", "line-stacking-shift", "line-stacking-strategy", "mark", "mark-after", "mark-before", "marks", "marquee-direction", "marquee-play-count", "marquee-speed", "marquee-style", "move-to", "nav-down", "nav-index", "nav-left", "nav-right", "nav-up", "overflow-style", "page", "page-policy", "phonemes", "punctuation-trim", "rest", "rest-after", "rest-before", "rotation", "rotation-point", "ruby-align", "ruby-overhang", "ruby-position", "ruby-span", "size", "string-set", "target", "target-name", "target-new", "target-position", "text-align-last", "text-emphasis", "text-height", "text-outline", "text-wrap", "voice-balance", "voice-duration", "voice-pitch", "voice-pitch-range", "voice-rate", "voice-stress", "voice-volume"};
    public static final HashSet<String> unsupportedPropertyNames = new HashSet();
    public CSS3ParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[130];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public CSS3Parser(Reader in, int lineOffset, int columnOffset) {
        this(in);
        this.jj_input_stream.ReInit(in, lineOffset, columnOffset);
    }

    public void setTabSize(int size) {
        this.jj_input_stream.setTabSize(size);
    }

    public int getTabSize() {
        return this.jj_input_stream.getTabSize(0);
    }

    public void setProprietaryAsError(boolean b) {
        this.proprietaryAsError = b;
    }

    private void addException(ParseException pe) {
        Range range = this.getExceptionLocation(pe);
        this.parseErrors.add(new ParseError(pe.getMessage(), range));
        pe.printStackTrace();
    }

    private void addWarning(ParseError pe) {
        this.parseWarnings.add(pe);
    }

    public List<ParseError> getParseErrors() {
        return this.parseErrors;
    }

    public List<ParseError> getParseWarnings() {
        return this.parseWarnings;
    }

    private Range getExceptionLocation(ParseException pe) {
        Token t = pe.currentToken;
        if (t != null) {
            return new Range(new Location(t.next.beginLine, t.next.beginColumn - 1), new Location(t.next.endLine, t.next.endColumn));
        }
        try {
            Matcher m = this.pePattern.matcher(pe.getMessage());
            if (m.matches()) {
                String ln = m.group(2);
                String cn = m.group(4);
                int line_number = -1;
                int column_number = 0;
                if (ln != null) {
                    line_number = Integer.parseInt(ln);
                }
                if (cn != null) {
                    column_number = Integer.parseInt(cn);
                }
                return line_number > -1 ? new Range(new Location(line_number - 1, column_number - 1), new Location(line_number - 1, column_number)) : null;
            }
            return new Range();
        }
        catch (Exception e) {
            return new Range();
        }
    }

    public void error_skipto(int kind) {
        Token t = null;
        int i = 0;
        while (++i <= 100 && (t = this.getNextToken()) != null && t.kind != kind) {
        }
    }

    public Location getStartLocation(Token t) {
        if (t == null) {
            return new Location(0, 0);
        }
        return new Location(t.beginLine + 1, t.beginColumn);
    }

    public Location getEndLocation(Token t) {
        if (t == null) {
            return new Location(0, 0);
        }
        return new Location(t.endLine + 1, t.endColumn + 1);
    }

    public CSSNode createNode(Token t) {
        if (t == null) {
            return new CSSNode();
        }
        CSSNode node = new CSSNode(t.image);
        node.setStartLocation(this.getStartLocation(t));
        node.setEndLocation(this.getEndLocation(t));
        return node;
    }

    public boolean notNull(Object ... args) {
        for (Object o : args) {
            if (o != null) continue;
            return false;
        }
        return true;
    }

    public boolean isUnsupported(String propertyName) {
        return unsupportedPropertyNames.contains(propertyName);
    }

    public static void main(String[] args) {
        try {
            CSS3Parser parser = new CSS3Parser(System.in);
            parser.styleSheet();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final CSSNode styleSheet() throws ParseException {
        CSSNode rootNode = new CSSNode("style");
        CSSNode firstNode = null;
        CSSNode childNode = null;
        List<CSSNode> children = null;
        try {
            block36: {
                block26: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 96: 
                        case 97: {
                            break;
                        }
                        default: {
                            this.jj_la1[0] = this.jj_gen;
                            break block26;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 96: {
                            this.jj_consume_token(96);
                            break;
                        }
                        case 97: {
                            this.jj_consume_token(97);
                            break;
                        }
                        default: {
                            this.jj_la1[1] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.addException(new ParseException(jEdit.getProperty((String)"sidekick.css.parser.CSS3Parser.dont-html")));
                }
                block27: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 67: {
                            break;
                        }
                        default: {
                            this.jj_la1[2] = this.jj_gen;
                            break block27;
                        }
                    }
                    childNode = this.charset();
                    if (childNode == null) continue;
                    rootNode.addChild(childNode);
                    if (firstNode != null) continue;
                    firstNode = childNode;
                    rootNode.setStartLocation(firstNode.getStartLocation());
                }
                block28: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: 
                        case 22: 
                        case 23: {
                            break;
                        }
                        default: {
                            this.jj_la1[3] = this.jj_gen;
                            break block36;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            this.jj_consume_token(21);
                            continue block28;
                        }
                        case 22: {
                            this.jj_consume_token(22);
                            continue block28;
                        }
                        case 23: {
                            this.jj_consume_token(23);
                            continue block28;
                        }
                    }
                    break;
                }
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            block29: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 68: {
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        break block29;
                    }
                }
                childNode = this.importDeclaration();
                if (childNode != null) {
                    rootNode.addChild(childNode);
                    if (firstNode == null) {
                        firstNode = childNode;
                        rootNode.setStartLocation(firstNode.getStartLocation());
                    }
                }
                this.ignoreStatement();
            }
            block30: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 69: {
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                        break block30;
                    }
                }
                childNode = this.namespaceDeclaration();
                if (childNode != null) {
                    rootNode.addChild(childNode);
                    if (firstNode == null) {
                        firstNode = childNode;
                        rootNode.setStartLocation(firstNode.getStartLocation());
                    }
                }
                this.ignoreStatement();
            }
            children = this.afterImportDeclaration();
            if (children != null && children.size() > 0) {
                rootNode.setEndLocation(children.get(children.size() - 1).getEndLocation());
                rootNode.addChildren(children);
            }
            this.jj_consume_token(0);
        }
        catch (TokenMgrError err) {
            this.addException(new ParseException("Unrecognized token, " + err.getMessage()));
        }
        return rootNode;
    }

    public final CSSNode charset() throws ParseException {
        Token start = null;
        Token middle = null;
        Token end = null;
        CSSNode node = null;
        try {
            start = this.jj_consume_token(67);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(21);
            }
            middle = this.jj_consume_token(32);
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break block9;
                    }
                }
                this.jj_consume_token(21);
            }
            end = this.jj_consume_token(43);
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(37);
            return null;
        }
        if (this.notNull(start, middle, end)) {
            String name = start.image + " " + middle.image;
            node = new CSSNode(name);
            node.setStartLocation(this.getStartLocation(start));
            node.setEndLocation(this.getEndLocation(end));
        }
        return node;
    }

    public final List<CSSNode> afterImportDeclaration() throws ParseException {
        CSSNode node = null;
        ArrayList<CSSNode> list = new ArrayList<CSSNode>();
        String skip = null;
        try {
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 34: 
                    case 35: 
                    case 36: 
                    case 45: 
                    case 47: 
                    case 51: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 62: 
                    case 66: 
                    case 92: 
                    case 94: 
                    case 98: {
                        node = this.ruleSet();
                        if (node == null) break;
                        list.add(node);
                        break;
                    }
                    case 70: {
                        node = this.media();
                        if (node == null) break;
                        list.add(node);
                        break;
                    }
                    case 71: {
                        node = this.page();
                        if (node == null) break;
                        list.add(node);
                        break;
                    }
                    case 72: {
                        node = this.fontFace();
                        if (node == null) break;
                        list.add(node);
                        break;
                    }
                    case 73: {
                        node = this.preference();
                        if (node == null) break;
                        list.add(node);
                        break;
                    }
                    case 74: {
                        node = this.colorprofile();
                        if (node == null) break;
                        list.add(node);
                        break;
                    }
                    case 80: {
                        node = this.phoneticAlphabet();
                        if (node == null) break;
                        list.add(node);
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        skip = this.skipStatement();
                        if (skip != null && skip.length() != 0) break;
                        return list;
                    }
                }
                this.ignoreStatement();
            }
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(37);
            return null;
        }
    }

    public final void ignoreStatement() throws ParseException {
        block11: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: 
                case 23: 
                case 81: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block11;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    this.jj_consume_token(22);
                    break;
                }
                case 23: {
                    this.jj_consume_token(23);
                    break;
                }
                case 81: {
                    this.atRuleDeclaration();
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        continue block11;
                    }
                }
                this.jj_consume_token(21);
            }
            break;
        }
    }

    public final CSSNode namespaceDeclaration() throws ParseException {
        Token end;
        Token uri;
        Token ident;
        Token start;
        CSSNode node;
        block26: {
            node = null;
            start = null;
            ident = null;
            uri = null;
            end = null;
            try {
                start = this.jj_consume_token(69);
                block21: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[13] = this.jj_gen;
                            break block21;
                        }
                    }
                    this.jj_consume_token(21);
                }
                block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 34: {
                        ident = this.jj_consume_token(34);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 21: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[14] = this.jj_gen;
                                    break block4;
                                }
                            }
                            this.jj_consume_token(21);
                        }
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 32: {
                        uri = this.jj_consume_token(32);
                        break;
                    }
                    case 53: {
                        uri = this.jj_consume_token(53);
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block23: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[17] = this.jj_gen;
                            break block23;
                        }
                    }
                    this.jj_consume_token(21);
                }
                end = this.jj_consume_token(43);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[18] = this.jj_gen;
                            break block26;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            catch (ParseException e) {
                this.addException(e);
                this.error_skipto(43);
                return null;
            }
        }
        if (this.notNull(start, uri, end)) {
            String name = start.image + " " + (ident != null ? ident.image : "") + uri.image;
            node = new CSSNode(name);
            node.setStartLocation(this.getStartLocation(start));
            node.setEndLocation(this.getEndLocation(end));
        }
        return node;
    }

    public final CSSNode importDeclaration() throws ParseException {
        CSSNode node;
        Token end;
        Token uri;
        ArrayList<CSSNode> mediumList;
        Token start;
        block32: {
            start = null;
            CSSNode medium = null;
            mediumList = new ArrayList<CSSNode>();
            uri = null;
            end = null;
            node = null;
            try {
                start = this.jj_consume_token(68);
                block24: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[19] = this.jj_gen;
                            break block24;
                        }
                    }
                    this.jj_consume_token(21);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 32: {
                        uri = this.jj_consume_token(32);
                        break;
                    }
                    case 53: {
                        uri = this.jj_consume_token(53);
                        break;
                    }
                    default: {
                        this.jj_la1[20] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block25: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[21] = this.jj_gen;
                            break block25;
                        }
                    }
                    this.jj_consume_token(21);
                }
                block11 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 34: {
                        medium = this.medium();
                        if (medium != null) {
                            mediumList.add(medium);
                        }
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 29: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[22] = this.jj_gen;
                                    break block11;
                                }
                            }
                            this.jj_consume_token(29);
                            block27: while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 21: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[23] = this.jj_gen;
                                        break block27;
                                    }
                                }
                                this.jj_consume_token(21);
                            }
                            medium = this.medium();
                            if (medium == null) continue;
                            mediumList.add(medium);
                        }
                    }
                    default: {
                        this.jj_la1[24] = this.jj_gen;
                    }
                }
                end = this.jj_consume_token(43);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[25] = this.jj_gen;
                            break block32;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            catch (ParseException e) {
                this.addException(e);
                this.error_skipto(43);
                return null;
            }
        }
        if (this.notNull(start, end)) {
            StringBuilder sb = new StringBuilder();
            for (CSSNode m : mediumList) {
                sb.append(m).append(',');
            }
            String mediumNames = sb.substring(0, Math.max(0, sb.length() - 1));
            String name = start.image + (uri != null ? " " + uri.image : "") + (mediumNames.length() > 0 ? " " + mediumNames : "");
            node = new CSSNode(name);
            node.setStartLocation(this.getStartLocation(start));
            node.setEndLocation(this.getEndLocation(end));
        }
        return node;
    }

    public final CSSNode media() throws ParseException {
        Token end;
        ArrayList<CSSNode> mdeclList;
        ArrayList<CSSNode> mlist;
        Token mr;
        Token start;
        block53: {
            start = null;
            mr = null;
            CSSNode medium = null;
            mlist = new ArrayList<CSSNode>();
            CSSNode mdecl = null;
            mdeclList = new ArrayList<CSSNode>();
            CSSNode ruleset = null;
            end = null;
            try {
                start = this.jj_consume_token(70);
                block38: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[26] = this.jj_gen;
                            break block38;
                        }
                    }
                    this.jj_consume_token(21);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 52: {
                        mr = this.jj_consume_token(52);
                        block39: while (true) {
                            this.jj_consume_token(21);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 21: {
                                    continue block39;
                                }
                            }
                            break;
                        }
                        this.jj_la1[27] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[28] = this.jj_gen;
                    }
                }
                medium = this.medium();
                if (medium != null) {
                    mlist.add(medium);
                }
                block40: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 29: {
                            break;
                        }
                        default: {
                            this.jj_la1[29] = this.jj_gen;
                            break block40;
                        }
                    }
                    this.jj_consume_token(29);
                    block41: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[30] = this.jj_gen;
                                break block41;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                    medium = this.medium();
                    if (medium == null) continue;
                    mlist.add(medium);
                }
                block42: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 31: {
                            break;
                        }
                        default: {
                            this.jj_la1[31] = this.jj_gen;
                            break block42;
                        }
                    }
                    this.jj_consume_token(31);
                    block43: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[32] = this.jj_gen;
                                break block43;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                    this.jj_consume_token(50);
                    block44: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[33] = this.jj_gen;
                                break block44;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                    mdecl = this.mediadeclaration();
                    if (mdecl != null) {
                        mdeclList.add(mdecl);
                    }
                    this.jj_consume_token(49);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[34] = this.jj_gen;
                                continue block42;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                    break;
                }
                this.jj_consume_token(26);
                block46: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[35] = this.jj_gen;
                            break block46;
                        }
                    }
                    this.jj_consume_token(21);
                }
                block47: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 34: 
                        case 35: 
                        case 36: 
                        case 45: 
                        case 47: 
                        case 51: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 62: 
                        case 66: 
                        case 92: 
                        case 94: 
                        case 98: {
                            break;
                        }
                        default: {
                            this.jj_la1[36] = this.jj_gen;
                            break block47;
                        }
                    }
                    ruleset = this.ruleSet();
                }
                end = this.jj_consume_token(37);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[37] = this.jj_gen;
                            break block53;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            catch (ParseException e) {
                this.addException(e);
                this.error_skipto(37);
                return null;
            }
        }
        if (this.notNull(start, end)) {
            CSSNode node = new CSSNode(start.image);
            if (mr != null) {
                node.addChild(this.createNode(mr));
            }
            node.addChildren(mlist);
            node.addChildren(mdeclList);
            node.setStartLocation(this.getStartLocation(start));
            node.setEndLocation(this.getEndLocation(end));
            return node;
        }
        return null;
    }

    public final CSSNode medium() throws ParseException {
        Token t = null;
        t = this.jj_consume_token(34);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[38] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(21);
        }
        if (this.notNull(t)) {
            return this.createNode(t);
        }
        return null;
    }

    public final CSSNode unused_production_generic_syntax() throws ParseException {
        Token start = null;
        CSSNode term = null;
        Token end = null;
        try {
            start = this.jj_consume_token(50);
            block5: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[39] = this.jj_gen;
                        break block5;
                    }
                }
                this.jj_consume_token(21);
            }
            term = this.term();
            end = this.jj_consume_token(49);
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(49);
            return null;
        }
        if (this.notNull(start, term, end)) {
            CSSNode node = new CSSNode('[' + term.getName() + ']');
            node.addChildren(term.getChildren());
            node.setStartLocation(this.getStartLocation(start));
            node.setEndLocation(this.getEndLocation(end));
            return node;
        }
        return null;
    }

    public final CSSNode definition() throws ParseException {
        Token start = null;
        CSSNode term = null;
        Token end = null;
        try {
            start = this.jj_consume_token(45);
            block5: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[40] = this.jj_gen;
                        break block5;
                    }
                }
                this.jj_consume_token(21);
            }
            term = this.term();
            end = this.jj_consume_token(46);
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(46);
            return null;
        }
        if (this.notNull(start, term, end)) {
            CSSNode node = new CSSNode('[' + term.getName() + ']');
            node.addChildren(term.getChildren());
            node.setStartLocation(this.getStartLocation(start));
            node.setEndLocation(this.getEndLocation(end));
        }
        throw new Error("Missing return statement in function");
    }

    public final CSSNode page() throws ParseException {
        Token end;
        Token start;
        CSSNode node;
        block28: {
            node = new CSSNode();
            CSSNode child = null;
            List<CSSNode> contents = null;
            start = null;
            Token i = null;
            end = null;
            try {
                start = this.jj_consume_token(71);
                if (start != null) {
                    node.setName(start.image);
                }
                block20: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[41] = this.jj_gen;
                            break block20;
                        }
                    }
                    this.jj_consume_token(21);
                }
                block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 34: {
                        i = this.jj_consume_token(34);
                        if (i != null) {
                            node.setName(node.getName() + ' ' + i.image);
                        }
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 21: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[42] = this.jj_gen;
                                    break block4;
                                }
                            }
                            this.jj_consume_token(21);
                        }
                    }
                    default: {
                        this.jj_la1[43] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 51: {
                        child = this.pseudo_page();
                        if (child == null) break;
                        node.addChild(child);
                        break;
                    }
                    default: {
                        this.jj_la1[44] = this.jj_gen;
                    }
                }
                this.jj_consume_token(26);
                block22: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[45] = this.jj_gen;
                            break block22;
                        }
                    }
                    this.jj_consume_token(21);
                }
                contents = this.pageContent();
                if (contents != null) {
                    node.addChildren(contents);
                }
                end = this.jj_consume_token(37);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[46] = this.jj_gen;
                            break block28;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            catch (ParseException e) {
                this.addException(e);
                this.error_skipto(37);
                return null;
            }
        }
        if (this.notNull(start, end)) {
            node.setStartLocation(this.getStartLocation(start));
            node.setEndLocation(this.getEndLocation(end));
            return node;
        }
        return null;
    }

    public final List<CSSNode> pageContent() throws ParseException {
        CSSNode node = null;
        List<CSSNode> list = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    node = this.prefAtRule();
                    break;
                }
                default: {
                    this.jj_la1[47] = this.jj_gen;
                    list = this.declarations();
                    break;
                }
            }
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(37);
            return null;
        }
        if (node != null) {
            list = new ArrayList<CSSNode>();
            list.add(node);
            return list;
        }
        if (list != null) {
            return list;
        }
        return null;
    }

    public final CSSNode prefAtRule() throws ParseException {
        Token end;
        List<CSSNode> decls;
        Token start;
        block21: {
            start = null;
            decls = null;
            end = null;
            try {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 75: {
                        start = this.jj_consume_token(75);
                        break;
                    }
                    case 77: {
                        start = this.jj_consume_token(77);
                        break;
                    }
                    case 78: {
                        start = this.jj_consume_token(78);
                        break;
                    }
                    case 76: {
                        start = this.jj_consume_token(76);
                        break;
                    }
                    default: {
                        this.jj_la1[48] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block17: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[49] = this.jj_gen;
                            break block17;
                        }
                    }
                    this.jj_consume_token(21);
                }
                this.jj_consume_token(26);
                block18: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[50] = this.jj_gen;
                            break block18;
                        }
                    }
                    this.jj_consume_token(21);
                }
                decls = this.declarations();
                end = this.jj_consume_token(37);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[51] = this.jj_gen;
                            break block21;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            catch (ParseException e) {
                this.addException(e);
                this.error_skipto(37);
                return null;
            }
        }
        if (this.notNull(start, decls, end)) {
            CSSNode node = new CSSNode(start.image);
            node.addChildren(decls);
            node.setStartLocation(this.getStartLocation(start));
            node.setEndLocation(this.getEndLocation(end));
            return node;
        }
        return null;
    }

    public final CSSNode pseudo_page() throws ParseException {
        Token t;
        Token start;
        block7: {
            start = null;
            t = null;
            try {
                start = this.jj_consume_token(51);
                t = this.jj_consume_token(34);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[52] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            catch (ParseException e) {
                this.addException(e);
                return null;
            }
        }
        if (this.notNull(t)) {
            CSSNode node = new CSSNode(':' + t.image);
            node.setStartLocation(this.getStartLocation(start));
            node.setEndLocation(this.getEndLocation(start));
            return node;
        }
        return null;
    }

    public final CSSNode fontFace() throws ParseException {
        Token end;
        List<CSSNode> decls;
        Token start;
        block15: {
            start = null;
            decls = null;
            end = null;
            try {
                start = this.jj_consume_token(72);
                block11: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[53] = this.jj_gen;
                            break block11;
                        }
                    }
                    this.jj_consume_token(21);
                }
                this.jj_consume_token(26);
                block12: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[54] = this.jj_gen;
                            break block12;
                        }
                    }
                    this.jj_consume_token(21);
                }
                decls = this.declarations();
                end = this.jj_consume_token(37);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[55] = this.jj_gen;
                            break block15;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            catch (ParseException e) {
                this.addException(e);
                this.error_skipto(37);
                return null;
            }
        }
        if (this.notNull(start, decls, end)) {
            CSSNode node = new CSSNode(start.image);
            node.addChildren(decls);
            node.setStartLocation(this.getStartLocation(start));
            node.setEndLocation(this.getEndLocation(end));
            return node;
        }
        return null;
    }

    public final CSSNode colorprofile() throws ParseException {
        Token end;
        List<CSSNode> decls;
        Token start;
        block15: {
            start = null;
            decls = null;
            end = null;
            try {
                start = this.jj_consume_token(74);
                block11: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[56] = this.jj_gen;
                            break block11;
                        }
                    }
                    this.jj_consume_token(21);
                }
                this.jj_consume_token(26);
                block12: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[57] = this.jj_gen;
                            break block12;
                        }
                    }
                    this.jj_consume_token(21);
                }
                decls = this.declarations();
                end = this.jj_consume_token(37);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[58] = this.jj_gen;
                            break block15;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            catch (ParseException e) {
                this.addException(e);
                this.error_skipto(37);
                return null;
            }
        }
        if (this.notNull(start, decls, end)) {
            CSSNode node = new CSSNode(start.image);
            node.addChildren(decls);
            node.setStartLocation(this.getStartLocation(start));
            node.setEndLocation(this.getEndLocation(end));
            return node;
        }
        return null;
    }

    public final CSSNode preference() throws ParseException {
        Token end;
        List<CSSNode> decls;
        Token start;
        block15: {
            start = null;
            decls = null;
            end = null;
            try {
                start = this.jj_consume_token(73);
                block11: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[59] = this.jj_gen;
                            break block11;
                        }
                    }
                    this.jj_consume_token(21);
                }
                this.jj_consume_token(26);
                block12: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[60] = this.jj_gen;
                            break block12;
                        }
                    }
                    this.jj_consume_token(21);
                }
                decls = this.declarations();
                end = this.jj_consume_token(37);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[61] = this.jj_gen;
                            break block15;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            catch (ParseException e) {
                this.addException(e);
                this.error_skipto(37);
                return null;
            }
        }
        if (this.notNull(start, decls, end)) {
            CSSNode node = new CSSNode(start.image);
            node.addChildren(decls);
            node.setStartLocation(this.getStartLocation(start));
            node.setEndLocation(this.getEndLocation(end));
            return node;
        }
        return null;
    }

    public final CSSNode phoneticAlphabet() throws ParseException {
        Token start = null;
        Token middle = null;
        Token end = null;
        try {
            start = this.jj_consume_token(80);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[62] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(21);
            }
            middle = this.jj_consume_token(32);
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[63] = this.jj_gen;
                        break block9;
                    }
                }
                this.jj_consume_token(21);
            }
            end = this.jj_consume_token(43);
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(43);
            return null;
        }
        if (this.notNull(start, middle, end)) {
            StringBuilder name = new StringBuilder();
            name.append(start.image).append(' ').append(middle.image);
            CSSNode node = new CSSNode(name.toString());
            node.setStartLocation(this.getStartLocation(start));
            node.setEndLocation(this.getEndLocation(end));
            return node;
        }
        return null;
    }

    public final CSSNode atRuleDeclaration() throws ParseException {
        Token t = null;
        try {
            t = this.jj_consume_token(81);
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(37);
            return null;
        }
        if (this.notNull(t)) {
            return this.createNode(t);
        }
        return null;
    }

    public final char operator() throws ParseException {
        int op = 32;
        try {
            block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: 
                case 44: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 44: {
                            this.jj_consume_token(44);
                            op = 47;
                            break;
                        }
                        case 29: {
                            this.jj_consume_token(29);
                            op = 44;
                            break;
                        }
                        default: {
                            this.jj_la1[64] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[65] = this.jj_gen;
                                break block1;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                }
                default: {
                    this.jj_la1[66] = this.jj_gen;
                    break;
                }
            }
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(37);
            return (char)op;
        }
        return (char)op;
    }

    public final char combinator() throws ParseException {
        char connector = ' ';
        try {
            block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 27: 
                case 28: 
                case 30: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 27: {
                            this.jj_consume_token(27);
                            connector = '+';
                            break;
                        }
                        case 28: {
                            this.jj_consume_token(28);
                            connector = '>';
                            break;
                        }
                        case 30: {
                            this.jj_consume_token(30);
                            connector = '~';
                            break;
                        }
                        default: {
                            this.jj_la1[67] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[68] = this.jj_gen;
                                break block1;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                }
                case 21: {
                    block18: while (true) {
                        this.jj_consume_token(21);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                continue block18;
                            }
                        }
                        break;
                    }
                    this.jj_la1[69] = this.jj_gen;
                    connector = ' ';
                    break;
                }
                default: {
                    this.jj_la1[70] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(37);
            return connector;
        }
        return connector;
    }

    public final char unaryOperator() throws ParseException {
        char unary;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 42: {
                    this.jj_consume_token(42);
                    unary = '-';
                    break;
                }
                case 27: {
                    this.jj_consume_token(27);
                    unary = '+';
                    break;
                }
                default: {
                    this.jj_la1[71] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(37);
            return ' ';
        }
        return unary;
    }

    public final CSSNode property() throws ParseException {
        Token t;
        block8: {
            t = null;
            try {
                t = this.jj_consume_token(34);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[72] = this.jj_gen;
                            break block8;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            catch (ParseException e) {
                this.addException(e);
                this.error_skipto(37);
                return null;
            }
        }
        if (this.notNull(t)) {
            if (this.isUnsupported(t.image)) {
                Range range = new Range(new Location(t.next.beginLine, t.next.beginColumn - 1), new Location(t.next.endLine, t.next.endColumn));
                this.addWarning(new ParseError(t.image + " is not supported by most browsers.", range));
            }
            return this.createNode(t);
        }
        return null;
    }

    public final CSSNode ruleSet() throws ParseException {
        Token end;
        List<CSSNode> decls;
        ArrayList<CSSNode> selectors;
        block21: {
            CSSNode sel = null;
            selectors = new ArrayList<CSSNode>();
            decls = null;
            end = null;
            try {
                sel = this.selector();
                if (sel != null) {
                    selectors.add(sel);
                }
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 29: {
                            break;
                        }
                        default: {
                            this.jj_la1[73] = this.jj_gen;
                            break block14;
                        }
                    }
                    this.jj_consume_token(29);
                    block15: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[74] = this.jj_gen;
                                break block15;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                    sel = this.selector();
                    if (sel == null) continue;
                    selectors.add(sel);
                }
                this.jj_consume_token(26);
                block16: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[75] = this.jj_gen;
                            break block16;
                        }
                    }
                    this.jj_consume_token(21);
                }
                decls = this.declarations();
                end = this.jj_consume_token(37);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[76] = this.jj_gen;
                            break block21;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            catch (ParseException e) {
                this.addException(e);
                this.error_skipto(37);
                return null;
            }
        }
        if (selectors.size() > 0 && this.notNull(decls, end)) {
            StringBuilder sb = new StringBuilder();
            for (CSSNode s : selectors) {
                sb.append(s.getName()).append(',');
            }
            String name = sb.substring(0, Math.max(0, sb.length() - 1));
            CSSNode node = new CSSNode(name);
            node.addChildren(decls);
            node.setStartLocation(((CSSNode)selectors.get(0)).getStartLocation());
            node.setEndLocation(this.getEndLocation(end));
            return node;
        }
        return null;
    }

    public final List<CSSNode> declarations() throws ParseException {
        ArrayList<CSSNode> nodes;
        block17: {
            CSSNode node = null;
            nodes = new ArrayList<CSSNode>();
            try {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 34: {
                        node = this.declaration();
                        if (node == null) break;
                        nodes.add(node);
                        break;
                    }
                    default: {
                        this.jj_la1[77] = this.jj_gen;
                    }
                }
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 43: {
                            break;
                        }
                        default: {
                            this.jj_la1[78] = this.jj_gen;
                            break block17;
                        }
                    }
                    Token semi = this.jj_consume_token(43);
                    if (node != null) {
                        node.setEndLocation(this.getEndLocation(semi));
                    }
                    block15: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[79] = this.jj_gen;
                                break block15;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 34: {
                            node = this.declaration();
                            if (node == null) continue block14;
                            nodes.add(node);
                            continue block14;
                        }
                    }
                    this.jj_la1[80] = this.jj_gen;
                }
            }
            catch (ParseException e) {
                this.addException(e);
                this.error_skipto(37);
                return null;
            }
        }
        return nodes;
    }

    public final CSSNode selector() throws ParseException {
        ArrayList<Character> combs;
        ArrayList<CSSNode> nodes;
        CSSNode node;
        block9: {
            node = null;
            nodes = new ArrayList<CSSNode>();
            combs = new ArrayList<Character>();
            try {
                node = this.simple_selector();
                if (node != null) {
                    nodes.add(node);
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: 
                        case 27: 
                        case 28: 
                        case 30: {
                            break;
                        }
                        default: {
                            this.jj_la1[81] = this.jj_gen;
                            break block9;
                        }
                    }
                    char c = this.combinator();
                    combs.add(Character.valueOf(c));
                    node = this.simple_selector();
                    if (node == null) continue;
                    nodes.add(node);
                }
            }
            catch (ParseException e) {
                this.addException(e);
                this.error_skipto(37);
                return null;
            }
        }
        if (nodes.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < nodes.size(); ++i) {
                sb.append(((CSSNode)nodes.get(i)).getName());
                if (combs.size() >= i) continue;
                sb.append(combs.get(i));
            }
            node = new CSSNode(sb.toString());
            node.setStartLocation(((CSSNode)nodes.get(0)).getStartLocation());
            node.setEndLocation(((CSSNode)nodes.get(nodes.size() - 1)).getEndLocation());
            return node;
        }
        return null;
    }

    public final CSSNode externalSelector() throws ParseException {
        ArrayList<CSSNode> nodes;
        CSSNode node;
        block13: {
            node = null;
            nodes = new ArrayList<CSSNode>();
            try {
                node = this.simple_selector();
                if (node != null) {
                    nodes.add(node);
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[82] = this.jj_gen;
                            break block13;
                        }
                    }
                    block9: while (true) {
                        this.jj_consume_token(21);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                continue block9;
                            }
                        }
                        break;
                    }
                    this.jj_la1[83] = this.jj_gen;
                    node = this.simple_selector();
                    if (node == null) continue;
                    nodes.add(node);
                }
            }
            catch (ParseException e) {
                this.addException(e);
                this.error_skipto(37);
                return null;
            }
        }
        if (nodes.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (CSSNode n : nodes) {
                sb.append(n.getName()).append(' ');
            }
            node = new CSSNode();
            node.setName(sb.toString());
            node.setStartLocation(((CSSNode)nodes.get(0)).getStartLocation());
            node.setEndLocation(((CSSNode)nodes.get(nodes.size() - 1)).getEndLocation());
            return node;
        }
        return null;
    }

    public final CSSNode simple_selector() throws ParseException {
        CSSNode child = null;
        ArrayList<CSSNode> children = new ArrayList<CSSNode>();
        try {
            block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 34: 
                case 47: 
                case 98: {
                    child = this.element_name();
                    if (child != null) {
                        children.add(child);
                    }
                    block26: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 35: 
                            case 36: 
                            case 45: 
                            case 51: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 62: 
                            case 66: 
                            case 92: 
                            case 94: {
                                break;
                            }
                            default: {
                                this.jj_la1[84] = this.jj_gen;
                                break block1;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 35: 
                            case 36: {
                                child = this.hash();
                                if (child == null) continue block26;
                                children.add(child);
                                continue block26;
                            }
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 62: 
                            case 92: {
                                child = this._class();
                                if (child == null) continue block26;
                                children.add(child);
                                continue block26;
                            }
                            case 45: {
                                child = this.attrib();
                                if (child == null) continue block26;
                                children.add(child);
                                continue block26;
                            }
                            case 51: 
                            case 66: {
                                child = this.pseudo();
                                if (child == null) continue block26;
                                children.add(child);
                                continue block26;
                            }
                            case 94: {
                                child = this.negation();
                                if (child == null) continue block26;
                                children.add(child);
                                continue block26;
                            }
                        }
                        break;
                    }
                    this.jj_la1[85] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                case 35: 
                case 36: 
                case 45: 
                case 51: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 62: 
                case 66: 
                case 92: 
                case 94: {
                    block27: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 35: 
                            case 36: {
                                child = this.hash();
                                if (child == null) break;
                                children.add(child);
                                break;
                            }
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 62: 
                            case 92: {
                                child = this._class();
                                if (child == null) break;
                                children.add(child);
                                break;
                            }
                            case 45: {
                                child = this.attrib();
                                if (child == null) break;
                                children.add(child);
                                break;
                            }
                            case 51: 
                            case 66: {
                                child = this.pseudo();
                                if (child == null) break;
                                children.add(child);
                                break;
                            }
                            case 94: {
                                child = this.negation();
                                if (child == null) break;
                                children.add(child);
                                break;
                            }
                            default: {
                                this.jj_la1[86] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 35: 
                            case 36: 
                            case 45: 
                            case 51: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 62: 
                            case 66: 
                            case 92: 
                            case 94: {
                                continue block27;
                            }
                        }
                        break;
                    }
                    this.jj_la1[87] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[88] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(37);
            return null;
        }
        if (children.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (CSSNode c : children) {
                sb.append(c.getName()).append(' ');
            }
            CSSNode node = new CSSNode(sb.toString());
            node.setStartLocation(((CSSNode)children.get(0)).getStartLocation());
            node.setEndLocation(((CSSNode)children.get(children.size() - 1)).getEndLocation());
            return node;
        }
        return null;
    }

    public final CSSNode _class() throws ParseException {
        Token t = null;
        CSSNode node = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 92: {
                    t = this.jj_consume_token(92);
                    break;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 62: {
                    node = this.deprecated_class();
                    break;
                }
                default: {
                    this.jj_la1[89] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(37);
            return null;
        }
        if (this.notNull(t)) {
            return this.createNode(t);
        }
        if (this.notNull(node)) {
            return node;
        }
        return null;
    }

    public final CSSNode deprecated_class() throws ParseException {
        Token t = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 54: {
                    t = this.jj_consume_token(54);
                    break;
                }
                case 55: {
                    t = this.jj_consume_token(55);
                    break;
                }
                case 56: {
                    t = this.jj_consume_token(56);
                    break;
                }
                case 57: {
                    t = this.jj_consume_token(57);
                    break;
                }
                case 58: {
                    t = this.jj_consume_token(58);
                    break;
                }
                case 59: {
                    t = this.jj_consume_token(59);
                    break;
                }
                case 60: {
                    t = this.jj_consume_token(60);
                    break;
                }
                case 62: {
                    t = this.jj_consume_token(62);
                    break;
                }
                default: {
                    this.jj_la1[90] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(37);
            return null;
        }
        if (this.notNull(t)) {
            return this.createNode(t);
        }
        return null;
    }

    public final CSSNode element_name() throws ParseException {
        Token t1 = null;
        Token t2 = null;
        try {
            if (this.jj_2_1(2)) {
                block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 34: 
                    case 47: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 34: {
                                t1 = this.jj_consume_token(34);
                                break block1;
                            }
                            case 47: {
                                t1 = this.jj_consume_token(47);
                                break block1;
                            }
                        }
                        this.jj_la1[91] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[92] = this.jj_gen;
                    }
                }
                this.jj_consume_token(98);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 34: {
                    t2 = this.jj_consume_token(34);
                    break;
                }
                case 47: {
                    t2 = this.jj_consume_token(47);
                    break;
                }
                default: {
                    this.jj_la1[93] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(37);
            return null;
        }
        if (this.notNull(t2)) {
            StringBuilder sb = new StringBuilder();
            if (this.notNull(t1)) {
                sb.append(t1.image).append('|');
            }
            sb.append(t2.image);
            CSSNode node = new CSSNode(sb.toString());
            node.setStartLocation(t1 == null ? this.getStartLocation(t2) : this.getStartLocation(t1));
            node.setEndLocation(this.getEndLocation(t2));
            return node;
        }
        return null;
    }

    public final CSSNode attrib() throws ParseException {
        Token start = null;
        Token t1 = null;
        Token t2 = null;
        Token t3 = null;
        Token end = null;
        try {
            start = this.jj_consume_token(45);
            block29: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[94] = this.jj_gen;
                        break block29;
                    }
                }
                this.jj_consume_token(21);
            }
            t1 = this.jj_consume_token(34);
            block30: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[95] = this.jj_gen;
                        break block30;
                    }
                }
                this.jj_consume_token(21);
            }
            block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 24: 
                case 25: 
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 41: {
                            t2 = this.jj_consume_token(41);
                            break;
                        }
                        case 24: {
                            t2 = this.jj_consume_token(24);
                            break;
                        }
                        case 25: {
                            t2 = this.jj_consume_token(25);
                            break;
                        }
                        case 38: {
                            t2 = this.jj_consume_token(38);
                            break;
                        }
                        case 39: {
                            t2 = this.jj_consume_token(39);
                            break;
                        }
                        case 40: {
                            t2 = this.jj_consume_token(40);
                            break;
                        }
                        default: {
                            this.jj_la1[96] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    block31: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[97] = this.jj_gen;
                                break block31;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 34: {
                            t3 = this.jj_consume_token(34);
                            break;
                        }
                        case 32: {
                            t3 = this.jj_consume_token(32);
                            break;
                        }
                        default: {
                            this.jj_la1[98] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[99] = this.jj_gen;
                                break block7;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                }
                default: {
                    this.jj_la1[100] = this.jj_gen;
                }
            }
            end = this.jj_consume_token(46);
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(46);
            return null;
        }
        if (this.notNull(start, t1, t2, t3, end)) {
            CSSNode node = new CSSNode(t1.image + t2.image + t3.image);
            node.setStartLocation(this.getStartLocation(start));
            node.setEndLocation(this.getEndLocation(end));
            return node;
        }
        return null;
    }

    public final CSSNode negation() throws ParseException {
        Token start = null;
        CSSNode node = null;
        Token end = null;
        try {
            start = this.jj_consume_token(94);
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[101] = this.jj_gen;
                        break block16;
                    }
                }
                this.jj_consume_token(21);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 34: 
                case 47: 
                case 98: {
                    node = this.element_name();
                    break;
                }
                case 35: 
                case 36: {
                    node = this.hash();
                    break;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 62: 
                case 92: {
                    node = this._class();
                    break;
                }
                case 45: {
                    node = this.attrib();
                    break;
                }
                case 51: 
                case 66: {
                    node = this.pseudo();
                    break;
                }
                case 94: {
                    node = this.negation();
                    break;
                }
                default: {
                    this.jj_la1[102] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[103] = this.jj_gen;
                        break block17;
                    }
                }
                this.jj_consume_token(21);
            }
            end = this.jj_consume_token(49);
        }
        catch (ParseException e) {
            e.printStackTrace();
            this.error_skipto(49);
            this.addException(e);
            return null;
        }
        if (this.notNull(start, node, end)) {
            node = new CSSNode(start.image + node.getName());
            node.setStartLocation(this.getStartLocation(start));
            node.setEndLocation(this.getEndLocation(end));
            return node;
        }
        return null;
    }

    public final CSSNode pseudo() throws ParseException {
        Token p = null;
        Token c = null;
        Token i = null;
        Token f = null;
        Token n = null;
        CSSNode expr = null;
        Token end = null;
        try {
            block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 66: {
                    p = this.jj_consume_token(66);
                    i = this.jj_consume_token(34);
                    break;
                }
                case 51: {
                    c = this.jj_consume_token(51);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 34: {
                            i = this.jj_consume_token(34);
                            break block1;
                        }
                        case 93: 
                        case 95: {
                            block9 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 93: {
                                    f = this.jj_consume_token(93);
                                    block28: while (true) {
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 21: {
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[104] = this.jj_gen;
                                                break block28;
                                            }
                                        }
                                        this.jj_consume_token(21);
                                    }
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 64: {
                                            n = this.jj_consume_token(64);
                                            break;
                                        }
                                        case 34: {
                                            n = this.jj_consume_token(34);
                                            break;
                                        }
                                        case 32: {
                                            n = this.jj_consume_token(32);
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[105] = this.jj_gen;
                                            this.jj_consume_token(-1);
                                            throw new ParseException();
                                        }
                                    }
                                    while (true) {
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 21: {
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[106] = this.jj_gen;
                                                break block9;
                                            }
                                        }
                                        this.jj_consume_token(21);
                                    }
                                }
                                case 95: {
                                    f = this.jj_consume_token(95);
                                    block30: while (true) {
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 21: {
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[107] = this.jj_gen;
                                                break block30;
                                            }
                                        }
                                        this.jj_consume_token(21);
                                    }
                                    expr = this.expression();
                                    break;
                                }
                                default: {
                                    this.jj_la1[108] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            end = this.jj_consume_token(49);
                            break block1;
                        }
                    }
                    this.jj_la1[109] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[110] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(49);
            return null;
        }
        if (this.notNull(p, i)) {
            CSSNode node = new CSSNode(p.image + ' ' + i.image);
            node.setStartLocation(this.getStartLocation(p));
            node.setEndLocation(this.getEndLocation(i));
            return node;
        }
        if (this.notNull(c)) {
            if (this.notNull(i)) {
                CSSNode node = new CSSNode(':' + i.image);
                node.setStartLocation(this.getStartLocation(c));
                node.setEndLocation(this.getEndLocation(i));
                return node;
            }
            if (this.notNull(f)) {
                if (this.notNull(n)) {
                    CSSNode node = new CSSNode(f.image + ' ' + n.image);
                    node.setStartLocation(this.getStartLocation(f));
                    node.setEndLocation(this.getEndLocation(n));
                    return node;
                }
                if (this.notNull(expr)) {
                    CSSNode node = new CSSNode(f.image + ' ' + expr.getName());
                    node.setStartLocation(this.getStartLocation(f));
                    node.setEndLocation(expr.getEndLocation());
                    return node;
                }
            }
        }
        return null;
    }

    public final CSSNode hash() throws ParseException {
        Token t = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    t = this.jj_consume_token(35);
                    break;
                }
                case 36: {
                    t = this.jj_consume_token(36);
                    break;
                }
                default: {
                    this.jj_la1[111] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(37);
            return null;
        }
        if (this.notNull(t)) {
            return this.createNode(t);
        }
        return null;
    }

    public final CSSNode mediadeclaration() throws ParseException {
        CSSNode prop = null;
        CSSNode expr = null;
        CSSNode prio = null;
        try {
            prop = this.property();
            block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 51: {
                    this.jj_consume_token(51);
                    block11: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[112] = this.jj_gen;
                                break block11;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                    expr = this.expr();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 65: {
                            prio = this.prio();
                            break block1;
                        }
                    }
                    this.jj_la1[113] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[114] = this.jj_gen;
                    break;
                }
            }
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(37);
            return null;
        }
        if (this.notNull(prop)) {
            StringBuilder name = new StringBuilder();
            name.append(prop.getName());
            if (expr != null) {
                name.append(':').append(expr.getName());
            }
            if (prio != null) {
                name.append(' ').append(prio.getName());
            }
            CSSNode node = new CSSNode(name.toString());
            node.setStartLocation(prop.getStartLocation());
            if (prio != null) {
                node.setEndLocation(prio.getEndLocation());
            } else if (expr != null) {
                node.setEndLocation(expr.getEndLocation());
            } else {
                node.setEndLocation(prop.getEndLocation());
            }
            return node;
        }
        return null;
    }

    public final CSSNode declaration() throws ParseException {
        CSSNode node = null;
        CSSNode prop = null;
        CSSNode expr = null;
        CSSNode imp = null;
        try {
            prop = this.property();
            this.jj_consume_token(51);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[115] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(21);
            }
            expr = this.expr();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 65: {
                    imp = this.prio();
                    break;
                }
                default: {
                    this.jj_la1[116] = this.jj_gen;
                    break;
                }
            }
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(37);
            return null;
        }
        if (this.notNull(prop, expr)) {
            String name = prop.getName() + ": " + expr.getName();
            node = new CSSNode(name);
            node.setStartLocation(prop.getStartLocation());
            node.setEndLocation(imp == null ? expr.getEndLocation() : imp.getEndLocation());
        }
        return node;
    }

    public final CSSNode prio() throws ParseException {
        Token t;
        block7: {
            t = null;
            try {
                t = this.jj_consume_token(65);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[117] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            catch (ParseException e) {
                this.addException(e);
                this.error_skipto(37);
                return null;
            }
        }
        if (this.notNull(t)) {
            return this.createNode(t);
        }
        return null;
    }

    public final CSSNode expression() throws ParseException {
        Token t = null;
        try {
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        t = this.jj_consume_token(27);
                        break;
                    }
                    case 42: {
                        t = this.jj_consume_token(42);
                        break;
                    }
                    case 64: {
                        t = this.jj_consume_token(64);
                        break;
                    }
                    case 62: {
                        t = this.jj_consume_token(62);
                        break;
                    }
                    case 32: {
                        t = this.jj_consume_token(32);
                        break;
                    }
                    case 34: {
                        t = this.jj_consume_token(34);
                        break;
                    }
                    default: {
                        this.jj_la1[118] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block17: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[119] = this.jj_gen;
                            break block17;
                        }
                    }
                    this.jj_consume_token(21);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: 
                    case 32: 
                    case 34: 
                    case 42: 
                    case 62: 
                    case 64: {
                        continue block16;
                    }
                }
                break;
            }
            this.jj_la1[120] = this.jj_gen;
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(37);
            return null;
        }
        if (this.notNull(t)) {
            t.image = t.image.trim();
            return this.createNode(t);
        }
        return null;
    }

    public final CSSNode expr() throws ParseException {
        ArrayList<Character> ops;
        ArrayList<CSSNode> terms;
        block9: {
            terms = new ArrayList<CSSNode>();
            ops = new ArrayList<Character>();
            CSSNode term = null;
            try {
                term = this.term();
                if (term != null) {
                    terms.add(term);
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 27: 
                        case 29: 
                        case 32: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 42: 
                        case 44: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 91: 
                        case 95: {
                            break;
                        }
                        default: {
                            this.jj_la1[121] = this.jj_gen;
                            break block9;
                        }
                    }
                    char op = this.operator();
                    ops.add(Character.valueOf(op));
                    term = this.term();
                    if (term == null) continue;
                    terms.add(term);
                }
            }
            catch (ParseException e) {
                this.addException(e);
                this.error_skipto(37);
                return null;
            }
        }
        if (terms.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < terms.size(); ++i) {
                sb.append(((CSSNode)terms.get(i)).getName());
                if (i >= ops.size()) continue;
                sb.append(ops.get(i));
            }
            CSSNode node = new CSSNode(sb.toString());
            node.setStartLocation(((CSSNode)terms.get(0)).getStartLocation());
            node.setEndLocation(((CSSNode)terms.get(terms.size() - 1)).getEndLocation());
            return node;
        }
        return null;
    }

    public final CSSNode term() throws ParseException {
        CSSNode term = null;
        CSSNode func = null;
        CSSNode hex = null;
        Token t = null;
        try {
            block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 27: 
                case 42: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 95: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 27: 
                        case 42: {
                            char unary = this.unaryOperator();
                            break;
                        }
                        default: {
                            this.jj_la1[122] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 64: {
                            t = this.jj_consume_token(64);
                            break;
                        }
                        case 63: {
                            t = this.jj_consume_token(63);
                            break;
                        }
                        case 54: {
                            t = this.jj_consume_token(54);
                            break;
                        }
                        case 55: {
                            t = this.jj_consume_token(55);
                            break;
                        }
                        case 56: {
                            t = this.jj_consume_token(56);
                            break;
                        }
                        case 57: {
                            t = this.jj_consume_token(57);
                            break;
                        }
                        case 58: {
                            t = this.jj_consume_token(58);
                            break;
                        }
                        case 59: {
                            t = this.jj_consume_token(59);
                            break;
                        }
                        case 60: {
                            t = this.jj_consume_token(60);
                            break;
                        }
                        case 61: {
                            t = this.jj_consume_token(61);
                            break;
                        }
                        case 62: {
                            t = this.jj_consume_token(62);
                            break;
                        }
                        case 95: {
                            func = this.function();
                            break;
                        }
                        default: {
                            this.jj_la1[123] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[124] = this.jj_gen;
                                break block1;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                }
                case 32: 
                case 34: 
                case 35: 
                case 36: 
                case 53: 
                case 91: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 32: {
                            t = this.jj_consume_token(32);
                            break;
                        }
                        case 34: {
                            t = this.jj_consume_token(34);
                            break;
                        }
                        case 35: 
                        case 36: {
                            hex = this.hexcolor();
                            break;
                        }
                        case 53: {
                            t = this.jj_consume_token(53);
                            break;
                        }
                        case 91: {
                            t = this.jj_consume_token(91);
                            break;
                        }
                        default: {
                            this.jj_la1[125] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[126] = this.jj_gen;
                                break block1;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                }
                default: {
                    this.jj_la1[127] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(37);
            return null;
        }
        if (this.notNull(t)) {
            term = this.createNode(t);
        } else if (this.notNull(func)) {
            term = func;
        } else if (this.notNull(hex)) {
            term = hex;
        }
        return term;
    }

    public final CSSNode function() throws ParseException {
        CSSNode node = null;
        Token start = null;
        CSSNode expr = null;
        Token end = null;
        try {
            start = this.jj_consume_token(95);
            block5: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[128] = this.jj_gen;
                        break block5;
                    }
                }
                this.jj_consume_token(21);
            }
            expr = this.expr();
            end = this.jj_consume_token(49);
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(49);
            return null;
        }
        if (this.notNull(start, expr, end)) {
            node = new CSSNode(start.image);
            node.addChild(expr);
            node.setStartLocation(this.getStartLocation(start));
            node.setEndLocation(this.getEndLocation(end));
        }
        return node;
    }

    public final CSSNode hexcolor() throws ParseException {
        Token t = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    t = this.jj_consume_token(35);
                    break;
                }
                case 36: {
                    t = this.jj_consume_token(36);
                    break;
                }
                default: {
                    this.jj_la1[129] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException e) {
            this.addException(e);
            this.error_skipto(37);
            return null;
        }
        if (this.notNull(t)) {
            return this.createNode(t);
        }
        return null;
    }

    String skipStatement() throws ParseException {
        StringBuilder s = new StringBuilder();
        Token tok = this.getToken(0);
        boolean first = true;
        if (tok.image != null) {
            s.append(tok.image);
        }
        while (true) {
            try {
                tok = this.getToken(1);
                if (tok.kind == 0) {
                    if (!first) break;
                    return null;
                }
                s.append(tok.image);
                if (tok.kind == 26) {
                    this.getNextToken();
                    s.append(this.skip_to_matching_brace());
                    this.getNextToken();
                    tok = this.getToken(1);
                    break;
                }
                if (tok.kind == 37 || tok.kind == 43) {
                    this.getNextToken();
                    tok = this.getToken(1);
                    break;
                }
                this.getNextToken();
            }
            catch (TokenMgrError tokenerror) {
                try {
                    s.append(this.jj_input_stream.readChar());
                    continue;
                }
                catch (IOException ioex) {
                    return s.toString().trim();
                }
            }
            first = false;
        }
        while (tok.kind == 21) {
            this.getNextToken();
            tok = this.getToken(1);
        }
        String statement = s.toString().trim();
        return statement;
    }

    String skip_to_matching_brace() throws ParseException {
        StringBuilder s = new StringBuilder();
        int nesting = 1;
        while (true) {
            Token tok = this.getToken(1);
            if (tok.kind == 0) break;
            s.append(tok.image);
            if (tok.kind == 26) {
                ++nesting;
            } else if (tok.kind == 37 && --nesting == 0) break;
            this.getNextToken();
        }
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_86()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(98);
    }

    private boolean jj_3R_86() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(34)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(47)) {
                return true;
            }
        }
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0, 0, 0xE00000, 0xE00000, 0, 0, 0x200000, 0x200000, 0, 0xC00000, 0xC00000, 0x200000, 0x200000, 0x200000, 0, 0, 0x200000, 0x200000, 0x200000, 0, 0x200000, 0x20000000, 0x200000, 0, 0x200000, 0x200000, 0x200000, 0, 0x20000000, 0x200000, Integer.MIN_VALUE, 0x200000, 0x200000, 0x200000, 0x200000, 0, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0, 0, 0x200000, 0x200000, 0, 0, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x20000000, 0x200000, 0x20000000, 0x58000000, 0x200000, 0x200000, 1478492160, 0x8000000, 0x200000, 0x20000000, 0x200000, 0x200000, 0x200000, 0, 0, 0x200000, 0, 1478492160, 0x200000, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0x200000, 0x3000000, 0x200000, 0, 0x200000, 0x3000000, 0x200000, 0, 0x200000, 0x200000, 0, 0x200000, 0x200000, 0, 0, 0, 0, 0x200000, 0, 0, 0x200000, 0, 0x200000, 0x8000000, 0x200000, 0x8000000, 0x28000000, 0x8000000, 0, 0x200000, 0, 0x200000, 0x8000000, 0x200000, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1606983708, 0, 0, 0, 0, 0, 4, 0x200001, 0, 0, 0, 0x200001, 0, 0, 0, 4, 0, 0, 0, 0x100000, 0, 0, 0, 0, 0, 0, 0, 1606983708, 0, 0, 0, 0, 0, 0, 4, 524288, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4096, 0, 4096, 0, 0, 0, 0, 1024, 0, 0, 0, 0, 0, 4, 2048, 0, 4, 0, 0, 0, 1606950936, 1606950936, 1606950936, 1606950936, 1606983708, 1606418432, 1606418432, 32772, 32772, 32772, 0, 0, 960, 0, 5, 0, 960, 0, 1606983708, 0, 0, 5, 0, 0, 0, 4, 524288, 24, 0, 0, 524288, 0, 0, 0, 0x40000405, 0, 0x40000405, -2092003, 1024, -4194304, 0, 2097181, 0, -2096099, 0, 24};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 8, 0, 0, 16, 32, 0, 0, 1342244804, 131072, 131072, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x50000004, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30720, 30720, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x50000004, 0x50000004, 0x50000004, 0x50000004, 0x50000004, 0x10000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x50000004, 0, 0, 1, 0, 0, -1610612736, -1610612736, 4, 0, 0, 2, 0, 0, 2, 0, 1, 0, 1, -2013265919, 0, -2147483647, 0, 0x8000000, 0, -2013265919, 0, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{3, 3, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public CSS3Parser(InputStream stream) {
        this(stream, null);
    }

    public CSS3Parser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new CSS3ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 130; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 130; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public CSS3Parser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new CSS3ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 130; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 130; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public CSS3Parser(CSS3ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 130; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CSS3ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 130; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[99];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 130; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 99; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        for (String name : invalidProperties) {
            unsupportedPropertyNames.add(name);
        }
        CSS3Parser.jj_la1_init_0();
        CSS3Parser.jj_la1_init_1();
        CSS3Parser.jj_la1_init_2();
        CSS3Parser.jj_la1_init_3();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

