/*
 * Decompiled with CFR 0.152.
 */
package sidekick.css.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sidekick.css.parser.CSS2ParserConstants;
import sidekick.css.parser.CSS2ParserTokenManager;
import sidekick.css.parser.CSSNode;
import sidekick.css.parser.ParseException;
import sidekick.css.parser.SimpleCharStream;
import sidekick.css.parser.Token;
import sidekick.util.Location;
import sidekick.util.ParseError;
import sidekick.util.Range;

public class CSS2Parser
implements CSS2ParserConstants {
    private boolean _quiet = true;
    private int lineOffset = 0;
    private List<ParseError> parseErrors = new ArrayList<ParseError>();
    private boolean proprietaryAsError = true;
    public CSS2ParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[96];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[4];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public Location getStartLocation(Token t) {
        if (t == null) {
            return new Location(0 + this.lineOffset, 0);
        }
        return new Location(t.beginLine + this.lineOffset, t.beginColumn);
    }

    public Location getEndLocation(Token t) {
        if (t == null) {
            return new Location(0 + this.lineOffset, 0);
        }
        return new Location(t.endLine + this.lineOffset, t.endColumn);
    }

    public CSSNode createNode(Token t) {
        if (t == null) {
            return new CSSNode();
        }
        CSSNode node = new CSSNode(t.image);
        node.setStartLocation(this.getStartLocation(t));
        node.setEndLocation(this.getEndLocation(t));
        return node;
    }

    public void setLineOffset(int offset) {
        this.lineOffset = offset > 0 ? offset : 0;
    }

    public void setTabSize(int size) {
        this.jj_input_stream.setTabSize(size);
    }

    public int getTabSize() {
        return this.jj_input_stream.getTabSize(0);
    }

    public void setProprietaryAsError(boolean b) {
        this.proprietaryAsError = b;
    }

    private void addException(ParseException pe) {
        Token t = pe.currentToken;
        if (t != null && t.next != null && t.next.image.startsWith("<%")) {
            return;
        }
        Range range = this.getExceptionLocation(pe);
        this.parseErrors.add(new ParseError(pe.getMessage(), range));
    }

    public List<ParseError> getParseErrors() {
        return this.parseErrors;
    }

    private Range getExceptionLocation(ParseException pe) {
        Token t = pe.currentToken;
        if (t != null) {
            return new Range(new Location(t.next.beginLine + this.lineOffset, t.next.beginColumn), new Location(t.next.endLine + this.lineOffset, t.next.endColumn));
        }
        try {
            Pattern p = Pattern.compile("(.*?)(\\d+)(.*?)(\\d+)(.*?)");
            Matcher m = p.matcher(pe.getMessage());
            if (m.matches()) {
                String ln = m.group(2);
                String cn = m.group(4);
                int line_number = -1;
                int column_number = 0;
                if (ln != null) {
                    line_number = Integer.parseInt(ln);
                }
                if (cn != null) {
                    column_number = Integer.parseInt(cn);
                }
                return line_number > -1 ? new Range(new Location(line_number + this.lineOffset, column_number - 1), new Location(line_number + this.lineOffset, column_number)) : null;
            }
            return new Range();
        }
        catch (Exception e) {
            return new Range();
        }
    }

    public boolean notNull(Object ... args) {
        for (Object o : args) {
            if (o != null) continue;
            return false;
        }
        return true;
    }

    public final CSSNode styleSheet() throws ParseException {
        CSSNode node = new CSSNode("style");
        List<CSSNode> list = null;
        try {
            list = this.styleSheetRuleList();
            this.jj_consume_token(0);
        }
        catch (ParseException pe) {
            this.addException(pe);
        }
        if (this.notNull(list)) {
            node.addChildren(list);
        }
        return node;
    }

    public final List<CSSNode> styleSheetRuleList() throws ParseException {
        ArrayList<CSSNode> list;
        block66: {
            list = new ArrayList<CSSNode>();
            CSSNode n = null;
            try {
                block65: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 34: {
                            n = this.charsetRule();
                            if (n == null) break;
                            list.add(n);
                            break;
                        }
                        default: {
                            this.jj_la1[0] = this.jj_gen;
                        }
                    }
                    block55: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: 
                            case 26: 
                            case 27: {
                                break;
                            }
                            default: {
                                this.jj_la1[1] = this.jj_gen;
                                break block65;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                this.jj_consume_token(1);
                                continue block55;
                            }
                            case 26: {
                                this.jj_consume_token(26);
                                continue block55;
                            }
                            case 27: {
                                this.jj_consume_token(27);
                                continue block55;
                            }
                        }
                        break;
                    }
                    this.jj_la1[2] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                block56: while (this.jj_2_1(2)) {
                    n = this.importRule();
                    if (n != null) {
                        list.add(n);
                    }
                    block57: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: 
                            case 26: 
                            case 27: {
                                break;
                            }
                            default: {
                                this.jj_la1[3] = this.jj_gen;
                                continue block56;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                this.jj_consume_token(1);
                                continue block57;
                            }
                            case 26: {
                                this.jj_consume_token(26);
                                continue block57;
                            }
                            case 27: {
                                this.jj_consume_token(27);
                                continue block57;
                            }
                        }
                        break;
                    }
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                block58: while (this.jj_2_2(2)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 10: 
                        case 12: 
                        case 13: 
                        case 19: 
                        case 21: 
                        case 58: {
                            n = this.styleRule();
                            break;
                        }
                        case 32: {
                            n = this.mediaRule();
                            break;
                        }
                        case 31: {
                            n = this.pageRule();
                            break;
                        }
                        case 33: {
                            n = this.fontFaceRule();
                            break;
                        }
                        case 35: {
                            n = this.unknownRule();
                            break;
                        }
                        default: {
                            this.jj_la1[5] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    if (n != null) {
                        list.add(n);
                    }
                    block59: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: 
                            case 26: 
                            case 27: {
                                break;
                            }
                            default: {
                                this.jj_la1[6] = this.jj_gen;
                                continue block58;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                this.jj_consume_token(1);
                                continue block59;
                            }
                            case 26: {
                                this.jj_consume_token(26);
                                continue block59;
                            }
                            case 27: {
                                this.jj_consume_token(27);
                                continue block59;
                            }
                        }
                        break;
                    }
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                block60: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 10: 
                        case 12: 
                        case 13: 
                        case 19: 
                        case 21: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 35: 
                        case 58: {
                            break;
                        }
                        default: {
                            this.jj_la1[8] = this.jj_gen;
                            break block66;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 10: 
                        case 12: 
                        case 13: 
                        case 19: 
                        case 21: 
                        case 58: {
                            n = this.styleRule();
                            break;
                        }
                        case 32: {
                            n = this.mediaRule();
                            break;
                        }
                        case 31: {
                            n = this.pageRule();
                            break;
                        }
                        case 33: {
                            n = this.fontFaceRule();
                            break;
                        }
                        case 30: {
                            n = this.importRuleIgnored();
                            break;
                        }
                        case 35: {
                            n = this.unknownRule();
                            break;
                        }
                        default: {
                            this.jj_la1[9] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    if (n != null) {
                        list.add(n);
                    }
                    block61: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: 
                            case 26: 
                            case 27: {
                                break;
                            }
                            default: {
                                this.jj_la1[10] = this.jj_gen;
                                continue block60;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                this.jj_consume_token(1);
                                continue block61;
                            }
                            case 26: {
                                this.jj_consume_token(26);
                                continue block61;
                            }
                            case 27: {
                                this.jj_consume_token(27);
                                continue block61;
                            }
                        }
                        break;
                    }
                    break;
                }
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            catch (ParseException pe) {
                this.addException(pe);
            }
        }
        return list;
    }

    public final CSSNode styleSheetRuleSingle() throws ParseException {
        CSSNode n = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 34: {
                    n = this.charsetRule();
                    break;
                }
                case 30: {
                    n = this.importRule();
                    break;
                }
                case 10: 
                case 12: 
                case 13: 
                case 19: 
                case 21: 
                case 58: {
                    n = this.styleRule();
                    break;
                }
                case 32: {
                    n = this.mediaRule();
                    break;
                }
                case 31: {
                    n = this.pageRule();
                    break;
                }
                case 33: {
                    n = this.fontFaceRule();
                    break;
                }
                case 35: {
                    n = this.unknownRule();
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException pe) {
            this.addException(pe);
        }
        return n;
    }

    public final CSSNode charsetRule() throws ParseException {
        Token start = null;
        Token middle = null;
        Token end = null;
        CSSNode node = null;
        try {
            start = this.jj_consume_token(34);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(1);
            }
            middle = this.jj_consume_token(22);
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                        break block9;
                    }
                }
                this.jj_consume_token(1);
            }
            end = this.jj_consume_token(11);
        }
        catch (ParseException pe) {
            this.addException(pe);
            return null;
        }
        if (this.notNull(start, middle, end)) {
            String name = start.image + " " + middle.image;
            node = new CSSNode(name);
            node.setStartLocation(this.getStartLocation(start));
            node.setEndLocation(this.getEndLocation(end));
        }
        return node;
    }

    public final CSSNode unknownRule() throws ParseException {
        Token t = null;
        CSSNode node = null;
        try {
            t = this.jj_consume_token(35);
        }
        catch (ParseException pe) {
            this.addException(pe);
            return null;
        }
        if (this.notNull(t)) {
            node = new CSSNode(t.image);
            node.setStartLocation(this.getStartLocation(t));
            node.setEndLocation(this.getEndLocation(t));
        }
        return node;
    }

    public final CSSNode importRule() throws ParseException {
        Token start = null;
        CSSNode middle = null;
        Token uri = null;
        Token end = null;
        CSSNode node = null;
        try {
            start = this.jj_consume_token(30);
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        break block15;
                    }
                }
                this.jj_consume_token(1);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    uri = this.jj_consume_token(22);
                    break;
                }
                case 25: {
                    uri = this.jj_consume_token(25);
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                        break block16;
                    }
                }
                this.jj_consume_token(1);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 58: {
                    middle = this.mediaList();
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                }
            }
            end = this.jj_consume_token(11);
        }
        catch (ParseException pe) {
            this.addException(pe);
            return null;
        }
        if (this.notNull(start, end)) {
            String name = start.image + (uri != null ? " " + uri.image : "") + (middle != null ? " " + middle.getName() : "");
            node = new CSSNode(name);
            node.setStartLocation(this.getStartLocation(start));
            node.setEndLocation(this.getEndLocation(end));
        }
        return node;
    }

    public final CSSNode importRuleIgnored() throws ParseException {
        Token start = null;
        CSSNode middle = null;
        Token uri = null;
        Token end = null;
        CSSNode node = null;
        try {
            start = this.jj_consume_token(30);
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                        break block15;
                    }
                }
                this.jj_consume_token(1);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    uri = this.jj_consume_token(22);
                    break;
                }
                case 25: {
                    uri = this.jj_consume_token(25);
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                        break block16;
                    }
                }
                this.jj_consume_token(1);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 58: {
                    middle = this.mediaList();
                    break;
                }
                default: {
                    this.jj_la1[22] = this.jj_gen;
                }
            }
            end = this.jj_consume_token(11);
        }
        catch (ParseException pe) {
            this.addException(pe);
            return null;
        }
        if (this.notNull(start, end)) {
            String name = start.image + (uri != null ? " " + uri.image : "") + (middle != null ? " " + middle.getName() : "");
            node = new CSSNode(name);
            node.setStartLocation(this.getStartLocation(start));
            node.setEndLocation(this.getEndLocation(end));
        }
        return node;
    }

    public final CSSNode mediaRule() throws ParseException {
        Token start = null;
        CSSNode ml = null;
        List<CSSNode> mrl = null;
        Token end = null;
        CSSNode node = null;
        try {
            start = this.jj_consume_token(32);
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[23] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(1);
            }
            ml = this.mediaList();
            this.jj_consume_token(7);
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[24] = this.jj_gen;
                        break block12;
                    }
                }
                this.jj_consume_token(1);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: 
                case 12: 
                case 13: 
                case 19: 
                case 21: 
                case 31: 
                case 35: 
                case 58: {
                    mrl = this.mediaRuleList();
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                }
            }
            end = this.jj_consume_token(8);
        }
        catch (ParseException pe) {
            this.addException(pe);
            return null;
        }
        if (this.notNull(start, ml, end)) {
            String name = start.image + (ml != null ? " " + ml.getName() : "");
            node = new CSSNode(name);
            if (mrl != null) {
                node.addChildren(mrl);
            }
            node.setStartLocation(this.getStartLocation(start));
            node.setEndLocation(this.getEndLocation(end));
        }
        return node;
    }

    public final CSSNode mediaList() throws ParseException {
        CSSNode node;
        CSSNode b;
        CSSNode a;
        StringBuffer sb;
        block11: {
            sb = new StringBuffer();
            a = null;
            b = null;
            node = null;
            try {
                a = this.medium();
                sb.append(a.getName());
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 9: {
                            break;
                        }
                        default: {
                            this.jj_la1[26] = this.jj_gen;
                            break block11;
                        }
                    }
                    this.jj_consume_token(9);
                    sb.append(",");
                    block9: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                break;
                            }
                            default: {
                                this.jj_la1[27] = this.jj_gen;
                                break block9;
                            }
                        }
                        this.jj_consume_token(1);
                    }
                    b = this.medium();
                    if (b == null) continue;
                    sb.append(b.getName());
                }
            }
            catch (ParseException pe) {
                this.addException(pe);
                return null;
            }
        }
        if (this.notNull(a)) {
            node = new CSSNode(sb.toString());
            node.setStartLocation(a.getStartLocation());
            node.setEndLocation(b == null ? a.getEndLocation() : b.getEndLocation());
        }
        return node;
    }

    public final List<CSSNode> mediaRuleList() throws ParseException {
        ArrayList<CSSNode> list = new ArrayList<CSSNode>();
        CSSNode n = null;
        try {
            block13: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 12: 
                    case 13: 
                    case 19: 
                    case 21: 
                    case 58: {
                        n = this.styleRule();
                        break;
                    }
                    case 31: {
                        n = this.pageRule();
                        break;
                    }
                    case 35: {
                        n = this.unknownRule();
                        break;
                    }
                    default: {
                        this.jj_la1[28] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (n != null) {
                    list.add(n);
                }
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[29] = this.jj_gen;
                            break block14;
                        }
                    }
                    this.jj_consume_token(1);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 12: 
                    case 13: 
                    case 19: 
                    case 21: 
                    case 31: 
                    case 35: 
                    case 58: {
                        continue block13;
                    }
                }
                break;
            }
            this.jj_la1[30] = this.jj_gen;
        }
        catch (ParseException pe) {
            this.addException(pe);
        }
        return list;
    }

    public final CSSNode mediaRuleSingle() throws ParseException {
        CSSNode n = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: 
                case 12: 
                case 13: 
                case 19: 
                case 21: 
                case 58: {
                    n = this.styleRule();
                    break;
                }
                case 31: {
                    n = this.pageRule();
                    break;
                }
                case 35: {
                    n = this.unknownRule();
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException pe) {
            this.addException(pe);
        }
        return n;
    }

    public final CSSNode medium() throws ParseException {
        CSSNode node;
        Token t;
        block7: {
            t = null;
            node = null;
            try {
                t = this.jj_consume_token(58);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[32] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(1);
                }
            }
            catch (ParseException pe) {
                this.addException(pe);
                return null;
            }
        }
        if (t != null) {
            node = new CSSNode(t.image);
            node.setStartLocation(this.getStartLocation(t));
            node.setEndLocation(this.getEndLocation(t));
        }
        return node;
    }

    public final CSSNode pageRule() throws ParseException {
        Token start = null;
        Token ident = null;
        CSSNode pp = null;
        CSSNode decl = null;
        ArrayList<CSSNode> list = new ArrayList<CSSNode>();
        Token end = null;
        try {
            start = this.jj_consume_token(31);
            block36: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[33] = this.jj_gen;
                        break block36;
                    }
                }
                this.jj_consume_token(1);
            }
            block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: 
                case 58: {
                    if (this.jj_2_3(2)) {
                        ident = this.jj_consume_token(58);
                        pp = this.pseudoPage();
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 1: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[34] = this.jj_gen;
                                    break block4;
                                }
                            }
                            this.jj_consume_token(1);
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 58: {
                            this.jj_consume_token(58);
                            while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 1: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[35] = this.jj_gen;
                                        break block4;
                                    }
                                }
                                this.jj_consume_token(1);
                            }
                        }
                        case 12: {
                            pp = this.pseudoPage();
                            while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 1: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[36] = this.jj_gen;
                                        break block4;
                                    }
                                }
                                this.jj_consume_token(1);
                            }
                        }
                    }
                    this.jj_la1[37] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[38] = this.jj_gen;
                }
            }
            this.jj_consume_token(7);
            block40: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[39] = this.jj_gen;
                        break block40;
                    }
                }
                this.jj_consume_token(1);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 58: {
                    decl = this.declaration();
                    if (decl == null) break;
                    list.add(decl);
                    break;
                }
                default: {
                    this.jj_la1[40] = this.jj_gen;
                }
            }
            block41: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: {
                        break;
                    }
                    default: {
                        this.jj_la1[41] = this.jj_gen;
                        break block41;
                    }
                }
                this.jj_consume_token(11);
                block42: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[42] = this.jj_gen;
                            break block42;
                        }
                    }
                    this.jj_consume_token(1);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 58: {
                        decl = this.declaration();
                        if (decl == null) continue block41;
                        list.add(decl);
                        continue block41;
                    }
                }
                this.jj_la1[43] = this.jj_gen;
            }
            end = this.jj_consume_token(8);
        }
        catch (ParseException pe) {
            this.addException(pe);
            return null;
        }
        StringBuffer name = new StringBuffer();
        name.append(start.image);
        if (ident != null) {
            name.append(" ").append(ident.image);
        }
        if (pp != null) {
            name.append(" ").append(pp.getName());
        }
        CSSNode node = new CSSNode(name.toString());
        node.setStartLocation(this.getStartLocation(start));
        node.setEndLocation(this.getEndLocation(end));
        node.addChildren(list);
        return node;
    }

    public final CSSNode pseudoPage() throws ParseException {
        Token t = null;
        try {
            this.jj_consume_token(12);
            t = this.jj_consume_token(58);
        }
        catch (ParseException pe) {
            this.addException(pe);
        }
        CSSNode node = this.createNode(t);
        node.setName(":" + node.getName());
        return node;
    }

    public final CSSNode fontFaceRule() throws ParseException {
        Token start = null;
        CSSNode decl = null;
        ArrayList<CSSNode> list = new ArrayList<CSSNode>();
        Token end = null;
        try {
            start = this.jj_consume_token(33);
            block20: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[44] = this.jj_gen;
                        break block20;
                    }
                }
                this.jj_consume_token(1);
            }
            this.jj_consume_token(7);
            block21: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[45] = this.jj_gen;
                        break block21;
                    }
                }
                this.jj_consume_token(1);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 58: {
                    decl = this.declaration();
                    if (decl == null) break;
                    list.add(decl);
                    break;
                }
                default: {
                    this.jj_la1[46] = this.jj_gen;
                }
            }
            block22: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: {
                        break;
                    }
                    default: {
                        this.jj_la1[47] = this.jj_gen;
                        break block22;
                    }
                }
                this.jj_consume_token(11);
                block23: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[48] = this.jj_gen;
                            break block23;
                        }
                    }
                    this.jj_consume_token(1);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 58: {
                        decl = this.declaration();
                        if (decl == null) continue block22;
                        list.add(decl);
                        continue block22;
                    }
                }
                this.jj_la1[49] = this.jj_gen;
            }
            end = this.jj_consume_token(8);
        }
        catch (ParseException pe) {
            this.addException(pe);
            return null;
        }
        CSSNode node = new CSSNode(start.image);
        node.setStartLocation(this.getStartLocation(start));
        node.setEndLocation(this.getEndLocation(end));
        node.addChildren(list);
        return node;
    }

    public final CSSNode operator() throws ParseException {
        Token t = null;
        try {
            block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: {
                    t = this.jj_consume_token(14);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                break;
                            }
                            default: {
                                this.jj_la1[50] = this.jj_gen;
                                break block1;
                            }
                        }
                        this.jj_consume_token(1);
                    }
                }
                case 9: {
                    t = this.jj_consume_token(9);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                break;
                            }
                            default: {
                                this.jj_la1[51] = this.jj_gen;
                                break block1;
                            }
                        }
                        this.jj_consume_token(1);
                    }
                }
                default: {
                    this.jj_la1[52] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException pe) {
            this.addException(pe);
        }
        return this.createNode(t);
    }

    public final CSSNode combinator() throws ParseException {
        Token t = null;
        try {
            block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: {
                    t = this.jj_consume_token(15);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                break;
                            }
                            default: {
                                this.jj_la1[53] = this.jj_gen;
                                break block1;
                            }
                        }
                        this.jj_consume_token(1);
                    }
                }
                case 18: {
                    t = this.jj_consume_token(18);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                break;
                            }
                            default: {
                                this.jj_la1[54] = this.jj_gen;
                                break block1;
                            }
                        }
                        this.jj_consume_token(1);
                    }
                }
                case 1: {
                    this.jj_consume_token(1);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 15: 
                        case 18: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 15: {
                                    t = this.jj_consume_token(15);
                                    break;
                                }
                                case 18: {
                                    t = this.jj_consume_token(18);
                                    break;
                                }
                                default: {
                                    this.jj_la1[55] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 1: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[56] = this.jj_gen;
                                        break block1;
                                    }
                                }
                                this.jj_consume_token(1);
                            }
                        }
                    }
                    this.jj_la1[57] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[58] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException pe) {
            this.addException(pe);
        }
        return this.createNode(t);
    }

    public final CSSNode unaryOperator() throws ParseException {
        Token t = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: {
                    t = this.jj_consume_token(16);
                    break;
                }
                case 15: {
                    t = this.jj_consume_token(15);
                    break;
                }
                default: {
                    this.jj_la1[59] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException pe) {
            this.addException(pe);
        }
        return this.createNode(t);
    }

    public final CSSNode property() throws ParseException {
        Token t;
        block7: {
            t = null;
            try {
                t = this.jj_consume_token(58);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[60] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(1);
                }
            }
            catch (ParseException pe) {
                this.addException(pe);
            }
        }
        if (t != null && t.image.startsWith("-") && this.proprietaryAsError) {
            ParseException pe = new ParseException("Parse warning at line " + this.token.beginLine + ", column " + this.token.beginColumn + ".  Encountered: " + this.token.image + ", which is a proprietary property name.");
            this.addException(pe);
        }
        return this.createNode(t);
    }

    public final CSSNode styleRule() throws ParseException {
        CSSNode n = null;
        List<CSSNode> list = null;
        try {
            n = this.selectorList();
            this.jj_consume_token(7);
            block5: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[61] = this.jj_gen;
                        break block5;
                    }
                }
                this.jj_consume_token(1);
            }
            list = this.styleDeclaration();
            this.jj_consume_token(8);
        }
        catch (ParseException pe) {
            this.addException(pe);
        }
        if (n == null) {
            return null;
        }
        if (list != null) {
            n.addChildren(list);
        }
        return n;
    }

    public final CSSNode selectorList() throws ParseException {
        ArrayList<CSSNode> list;
        block15: {
            list = new ArrayList<CSSNode>();
            CSSNode n = null;
            try {
                n = this.selector();
                if (n != null) {
                    list.add(n);
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 9: {
                            break;
                        }
                        default: {
                            this.jj_la1[62] = this.jj_gen;
                            break block15;
                        }
                    }
                    this.jj_consume_token(9);
                    block9: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                break;
                            }
                            default: {
                                this.jj_la1[63] = this.jj_gen;
                                break block9;
                            }
                        }
                        this.jj_consume_token(1);
                    }
                    n = this.selector();
                    if (n == null) continue;
                    list.add(n);
                }
            }
            catch (ParseException pe) {
                this.addException(pe);
                return null;
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        CSSNode start = null;
        CSSNode end = null;
        StringBuffer sb = new StringBuffer();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            CSSNode node = (CSSNode)it.next();
            if (node == null) continue;
            if (start == null) {
                start = node;
            }
            end = node;
            sb.append(node.getName().trim());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        if (start == null) {
            return null;
        }
        CSSNode node = new CSSNode(sb.toString());
        node.setStartLocation(start.getStartLocation());
        node.setEndLocation(end.getEndLocation());
        return node;
    }

    public final CSSNode selector() throws ParseException {
        ArrayList<CSSNode> list;
        block11: {
            list = new ArrayList<CSSNode>();
            CSSNode n = null;
            try {
                n = this.simpleSelector();
                list.add(n);
                while (this.jj_2_4(2)) {
                    n = this.combinator();
                    list.add(n);
                    n = this.simpleSelector();
                    list.add(n);
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[64] = this.jj_gen;
                            break block11;
                        }
                    }
                    this.jj_consume_token(1);
                }
            }
            catch (ParseException pe) {
                this.addException(pe);
                return null;
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        CSSNode start = null;
        CSSNode end = null;
        StringBuffer sb = new StringBuffer();
        for (CSSNode node : list) {
            if (node == null) continue;
            if (start == null) {
                start = node;
            }
            end = node;
            sb.append(node.getName()).append(" ");
        }
        if (start == null) {
            return null;
        }
        CSSNode node = new CSSNode(sb.toString());
        node.setStartLocation(start.getStartLocation());
        node.setEndLocation(end.getEndLocation());
        return node;
    }

    public final CSSNode simpleSelector() throws ParseException {
        ArrayList<CSSNode> list = new ArrayList<CSSNode>();
        CSSNode n = null;
        try {
            block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: 
                case 58: {
                    n = this.elementName();
                    list.add(n);
                    block24: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 10: 
                            case 12: 
                            case 19: 
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[65] = this.jj_gen;
                                break block1;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                n = this.hash();
                                list.add(n);
                                continue block24;
                            }
                            case 10: {
                                n = this._class();
                                list.add(n);
                                continue block24;
                            }
                            case 19: {
                                n = this.attrib();
                                list.add(n);
                                continue block24;
                            }
                            case 12: {
                                n = this.pseudo();
                                list.add(n);
                                continue block24;
                            }
                        }
                        break;
                    }
                    this.jj_la1[66] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                case 10: 
                case 12: 
                case 19: 
                case 21: {
                    block25: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                n = this.hash();
                                list.add(n);
                                break;
                            }
                            case 10: {
                                n = this._class();
                                list.add(n);
                                break;
                            }
                            case 19: {
                                n = this.attrib();
                                list.add(n);
                                break;
                            }
                            case 12: {
                                n = this.pseudo();
                                list.add(n);
                                break;
                            }
                            default: {
                                this.jj_la1[67] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 10: 
                            case 12: 
                            case 19: 
                            case 21: {
                                continue block25;
                            }
                        }
                        break;
                    }
                    this.jj_la1[68] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[69] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException pe) {
            this.addException(pe);
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        CSSNode start = null;
        CSSNode end = null;
        StringBuffer sb = new StringBuffer();
        for (CSSNode node : list) {
            if (node == null || node.getName() == null) continue;
            if (start == null) {
                start = node;
            }
            sb.append(node.getName()).append(" ");
            end = node;
        }
        if (start == null) {
            return null;
        }
        CSSNode node = new CSSNode(sb.toString());
        node.setStartLocation(start.getStartLocation());
        node.setEndLocation(end.getEndLocation());
        return node;
    }

    public final CSSNode _class() throws ParseException {
        Token t = null;
        try {
            this.jj_consume_token(10);
            t = this.jj_consume_token(58);
        }
        catch (ParseException pe) {
            this.addException(pe);
            return null;
        }
        CSSNode node = this.createNode(t);
        node.setName("." + node.getName());
        return node;
    }

    public final CSSNode elementName() throws ParseException {
        Token t = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 58: {
                    t = this.jj_consume_token(58);
                    break;
                }
                case 13: {
                    t = this.jj_consume_token(13);
                    break;
                }
                default: {
                    this.jj_la1[70] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException pe) {
            this.addException(pe);
        }
        return this.createNode(t);
    }

    public final CSSNode attrib() throws ParseException {
        Token start = null;
        Token a = null;
        Token b = null;
        Token c = null;
        Token end = null;
        try {
            start = this.jj_consume_token(19);
            block26: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[71] = this.jj_gen;
                        break block26;
                    }
                }
                this.jj_consume_token(1);
            }
            a = this.jj_consume_token(58);
            block27: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[72] = this.jj_gen;
                        break block27;
                    }
                }
                this.jj_consume_token(1);
            }
            block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: 
                case 28: 
                case 29: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 17: {
                            b = this.jj_consume_token(17);
                            break;
                        }
                        case 28: {
                            b = this.jj_consume_token(28);
                            break;
                        }
                        case 29: {
                            b = this.jj_consume_token(29);
                            break;
                        }
                        default: {
                            this.jj_la1[73] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    block28: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                break;
                            }
                            default: {
                                this.jj_la1[74] = this.jj_gen;
                                break block28;
                            }
                        }
                        this.jj_consume_token(1);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 58: {
                            c = this.jj_consume_token(58);
                            break;
                        }
                        case 22: {
                            c = this.jj_consume_token(22);
                            break;
                        }
                        default: {
                            this.jj_la1[75] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                break;
                            }
                            default: {
                                this.jj_la1[76] = this.jj_gen;
                                break block7;
                            }
                        }
                        this.jj_consume_token(1);
                    }
                }
                default: {
                    this.jj_la1[77] = this.jj_gen;
                }
            }
            end = this.jj_consume_token(20);
        }
        catch (ParseException pe) {
            this.addException(pe);
            return null;
        }
        if (a != null) {
            StringBuffer name = new StringBuffer();
            name.append(a.image);
            if (b != null) {
                name.append(" ").append(b.image);
            }
            if (c != null) {
                name.append(" ").append(c.image);
            }
            CSSNode node = new CSSNode(name.toString());
            node.setStartLocation(this.getStartLocation(start));
            node.setEndLocation(this.getEndLocation(end));
            return node;
        }
        return null;
    }

    public final CSSNode pseudo() throws ParseException {
        Token start = null;
        Token ident = null;
        Token func = null;
        Token end = null;
        try {
            start = this.jj_consume_token(12);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 58: {
                    ident = this.jj_consume_token(58);
                    break;
                }
                case 57: {
                    func = this.jj_consume_token(57);
                    block12: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                break;
                            }
                            default: {
                                this.jj_la1[78] = this.jj_gen;
                                break block12;
                            }
                        }
                        this.jj_consume_token(1);
                    }
                    ident = this.jj_consume_token(58);
                    block13: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                break;
                            }
                            default: {
                                this.jj_la1[79] = this.jj_gen;
                                break block13;
                            }
                        }
                        this.jj_consume_token(1);
                    }
                    end = this.jj_consume_token(23);
                    break;
                }
                default: {
                    this.jj_la1[80] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (ParseException pe) {
            this.addException(pe);
            return null;
        }
        String name = ":" + (func != null ? func.image : "") + (ident != null ? ident.image : "");
        CSSNode node = new CSSNode(name);
        node.setStartLocation(this.getStartLocation(start));
        node.setEndLocation(end != null ? this.getEndLocation(end) : this.getEndLocation(ident));
        return node;
    }

    public final CSSNode hash() throws ParseException {
        Token t = null;
        try {
            t = this.jj_consume_token(21);
        }
        catch (ParseException pe) {
            this.addException(pe);
        }
        return this.createNode(t);
    }

    public final List<CSSNode> styleDeclaration() throws ParseException {
        ArrayList<CSSNode> list;
        block16: {
            list = new ArrayList<CSSNode>();
            CSSNode n = null;
            try {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 58: {
                        n = this.declaration();
                        list.add(n);
                        break;
                    }
                    default: {
                        this.jj_la1[81] = this.jj_gen;
                    }
                }
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 11: {
                            break;
                        }
                        default: {
                            this.jj_la1[82] = this.jj_gen;
                            break block16;
                        }
                    }
                    this.jj_consume_token(11);
                    block15: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                break;
                            }
                            default: {
                                this.jj_la1[83] = this.jj_gen;
                                break block15;
                            }
                        }
                        this.jj_consume_token(1);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 58: {
                            n = this.declaration();
                            list.add(n);
                            continue block14;
                        }
                    }
                    this.jj_la1[84] = this.jj_gen;
                }
            }
            catch (ParseException pe) {
                this.addException(pe);
            }
        }
        return list;
    }

    public final CSSNode declaration() throws ParseException {
        CSSNode prop = null;
        CSSNode expr = null;
        CSSNode prio = null;
        try {
            prop = this.property();
            this.jj_consume_token(12);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[85] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(1);
            }
            expr = this.expr();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: {
                    prio = this.prio();
                    break;
                }
                default: {
                    this.jj_la1[86] = this.jj_gen;
                    break;
                }
            }
        }
        catch (ParseException pe) {
            this.addException(pe);
            return null;
        }
        String name = prop.getName() + ": " + (expr != null ? expr.getName() : "") + (prio != null ? prio.getName() : "");
        CSSNode node = new CSSNode(name);
        node.setStartLocation(prop.getStartLocation());
        node.setEndLocation(prio != null ? prio.getEndLocation() : (expr != null ? expr.getEndLocation() : prop.getEndLocation()));
        return node;
    }

    public final CSSNode prio() throws ParseException {
        Token t;
        block6: {
            t = null;
            try {
                t = this.jj_consume_token(36);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[87] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(1);
                }
            }
            catch (ParseException pe) {
                this.addException(pe);
            }
        }
        return this.createNode(t);
    }

    public final CSSNode expr() throws ParseException {
        CSSNode node;
        StringBuffer sb;
        CSSNode nb;
        CSSNode na;
        block11: {
            na = null;
            CSSNode no = null;
            nb = null;
            sb = new StringBuffer();
            node = null;
            try {
                na = this.term();
                if (na != null) {
                    sb.append(na.getName());
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 9: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 21: 
                        case 22: 
                        case 25: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 61: {
                            break;
                        }
                        default: {
                            this.jj_la1[88] = this.jj_gen;
                            break block11;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 9: 
                        case 14: {
                            no = this.operator();
                            if (no == null) break;
                            sb.append(no.getName());
                            break;
                        }
                        default: {
                            this.jj_la1[89] = this.jj_gen;
                        }
                    }
                    if ((nb = this.term()) == null) continue;
                    sb.append(nb.getName());
                }
            }
            catch (ParseException pe) {
                this.addException(pe);
                return null;
            }
        }
        if (na != null) {
            node = new CSSNode(sb.toString());
            node.setStartLocation(na.getStartLocation());
            node.setEndLocation(nb != null ? nb.getEndLocation() : na.getEndLocation());
        }
        return node;
    }

    public final CSSNode term() throws ParseException {
        CSSNode nb;
        CSSNode na;
        Token b;
        Token a;
        CSSNode uo;
        block45: {
            uo = null;
            a = null;
            b = null;
            na = null;
            nb = null;
            try {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: 
                    case 16: {
                        uo = this.unaryOperator();
                        break;
                    }
                    default: {
                        this.jj_la1[90] = this.jj_gen;
                    }
                }
                block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 54: 
                    case 55: 
                    case 57: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 55: {
                                a = this.jj_consume_token(55);
                                break block4;
                            }
                            case 54: {
                                a = this.jj_consume_token(54);
                                break block4;
                            }
                            case 40: {
                                a = this.jj_consume_token(40);
                                break block4;
                            }
                            case 41: {
                                a = this.jj_consume_token(41);
                                break block4;
                            }
                            case 42: {
                                a = this.jj_consume_token(42);
                                break block4;
                            }
                            case 43: {
                                a = this.jj_consume_token(43);
                                break block4;
                            }
                            case 44: {
                                a = this.jj_consume_token(44);
                                break block4;
                            }
                            case 45: {
                                a = this.jj_consume_token(45);
                                break block4;
                            }
                            case 38: {
                                a = this.jj_consume_token(38);
                                break block4;
                            }
                            case 39: {
                                a = this.jj_consume_token(39);
                                break block4;
                            }
                            case 46: {
                                a = this.jj_consume_token(46);
                                break block4;
                            }
                            case 47: {
                                a = this.jj_consume_token(47);
                                break block4;
                            }
                            case 48: {
                                a = this.jj_consume_token(48);
                                break block4;
                            }
                            case 49: {
                                a = this.jj_consume_token(49);
                                break block4;
                            }
                            case 50: {
                                a = this.jj_consume_token(50);
                                break block4;
                            }
                            case 51: {
                                a = this.jj_consume_token(51);
                                break block4;
                            }
                            case 52: {
                                a = this.jj_consume_token(52);
                                break block4;
                            }
                            case 57: {
                                na = this.function();
                                break block4;
                            }
                        }
                        this.jj_la1[91] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    case 22: {
                        b = this.jj_consume_token(22);
                        break;
                    }
                    case 58: {
                        b = this.jj_consume_token(58);
                        break;
                    }
                    case 25: {
                        b = this.jj_consume_token(25);
                        break;
                    }
                    case 61: {
                        b = this.jj_consume_token(61);
                        break;
                    }
                    case 56: {
                        nb = this.rgb();
                        break;
                    }
                    case 21: {
                        nb = this.hexcolor();
                        break;
                    }
                    case 53: {
                        b = this.jj_consume_token(53);
                        break;
                    }
                    case 37: {
                        b = this.jj_consume_token(37);
                        break;
                    }
                    default: {
                        this.jj_la1[92] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            break;
                        }
                        default: {
                            this.jj_la1[93] = this.jj_gen;
                            break block45;
                        }
                    }
                    this.jj_consume_token(1);
                }
            }
            catch (ParseException pe) {
                this.addException(pe);
                return null;
            }
        }
        StringBuffer name = new StringBuffer();
        if (uo != null) {
            name.append(uo.getName());
        }
        if (a != null) {
            name.append(a.image);
        }
        if (na != null) {
            name.append(na.getName());
        }
        if (b != null) {
            name.append(b.image);
        }
        if (nb != null) {
            name.append(nb.getName());
        }
        CSSNode node = new CSSNode(name.toString());
        node.setStartLocation(uo != null ? uo.getStartLocation() : (a != null ? this.getStartLocation(a) : (b != null ? this.getStartLocation(b) : (nb != null ? nb.getStartLocation() : new Location()))));
        node.setEndLocation(nb != null ? nb.getEndLocation() : (b != null ? this.getEndLocation(b) : (na != null ? na.getEndLocation() : (a != null ? this.getEndLocation(a) : new Location()))));
        return node;
    }

    public final CSSNode function() throws ParseException {
        Token start = null;
        Token end = null;
        try {
            start = this.jj_consume_token(57);
            block5: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[94] = this.jj_gen;
                        break block5;
                    }
                }
                this.jj_consume_token(1);
            }
            this.expr();
            end = this.jj_consume_token(23);
        }
        catch (ParseException pe) {
            this.addException(pe);
            return null;
        }
        String name = start.image;
        if (name.endsWith("(")) {
            name = name.substring(0, name.length() - 2);
        }
        CSSNode node = new CSSNode(name);
        node.setStartLocation(this.getStartLocation(start));
        node.setEndLocation(this.getEndLocation(end));
        return node;
    }

    public final CSSNode rgb() throws ParseException {
        Token start = null;
        Token end = null;
        try {
            start = this.jj_consume_token(56);
            block5: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[95] = this.jj_gen;
                        break block5;
                    }
                }
                this.jj_consume_token(1);
            }
            this.expr();
            end = this.jj_consume_token(23);
        }
        catch (ParseException pe) {
            this.addException(pe);
            return null;
        }
        CSSNode node = new CSSNode("rgb");
        node.setStartLocation(this.getStartLocation(start));
        node.setEndLocation(this.getEndLocation(end));
        return node;
    }

    public final CSSNode hexcolor() throws ParseException {
        Token t = null;
        try {
            t = this.jj_consume_token(21);
        }
        catch (ParseException pe) {
            this.addException(pe);
        }
        return this.createNode(t);
    }

    void skipSelector() throws ParseException {
        Token t = this.getToken(1);
        while (t.kind != 9 && t.kind != 11 && t.kind != 7 && t.kind != 0) {
            this.getNextToken();
            t = this.getToken(1);
        }
    }

    String skip() throws ParseException {
        StringBuffer sb = new StringBuffer();
        int nesting = 0;
        Token t = this.getToken(0);
        if (t.image != null) {
            sb.append(t.image);
        }
        do {
            t = this.getNextToken();
            if (t.kind == 0) break;
            sb.append(t.image);
            if (t.kind == 7) {
                ++nesting;
                continue;
            }
            if (t.kind == 8) {
                --nesting;
                continue;
            }
            if (t.kind == 11 && nesting <= 0) break;
        } while (t.kind != 8 || nesting > 0);
        return sb.toString();
    }

    void error_skipblock() throws ParseException {
        Token t;
        int nesting = 0;
        do {
            t = this.getNextToken();
            if (t.kind == 7) {
                ++nesting;
                continue;
            }
            if (t.kind == 8) {
                --nesting;
                continue;
            }
            if (t.kind == 0) break;
        } while (t.kind != 8 || nesting > 0);
    }

    void error_skipdecl() throws ParseException {
        boolean nesting = false;
        Token t = this.getToken(1);
        if (t.kind == 7) {
            this.error_skipblock();
        } else {
            Token oldToken = t;
            while (t.kind != 11 && t.kind != 8 && t.kind != 0) {
                oldToken = t;
                t = this.getNextToken();
            }
            if (t.kind == 8) {
                this.token = oldToken;
            }
        }
    }

    void error_skipAtRule() throws ParseException {
        Token t = null;
        do {
            t = this.getNextToken();
        } while (t.kind != 11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    private boolean jj_3_4() {
        if (this.jj_3R_67()) {
            return true;
        }
        return this.jj_3R_68();
    }

    private boolean jj_3R_95() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_scan_token(58);
    }

    private boolean jj_3R_85() {
        Token xsp;
        if (this.jj_3R_68()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_4());
        this.jj_scanpos = xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(1));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_72() {
        Token xsp;
        if (this.jj_scan_token(33)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(1));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_64() {
        return this.jj_3R_73();
    }

    private boolean jj_3R_87() {
        return this.jj_scan_token(58);
    }

    private boolean jj_3R_70() {
        Token xsp;
        if (this.jj_scan_token(32)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(1));
        this.jj_scanpos = xsp;
        return this.jj_3R_80();
    }

    private boolean jj_3R_73() {
        return this.jj_scan_token(35);
    }

    private boolean jj_3R_93() {
        return this.jj_3R_97();
    }

    private boolean jj_3R_92() {
        return this.jj_3R_96();
    }

    private boolean jj_3R_91() {
        return this.jj_3R_95();
    }

    private boolean jj_3R_90() {
        return this.jj_3R_94();
    }

    private boolean jj_3R_84() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_90()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_91()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_92()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_93()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_102() {
        return this.jj_3R_97();
    }

    private boolean jj_3R_101() {
        return this.jj_3R_96();
    }

    private boolean jj_3R_100() {
        return this.jj_3R_95();
    }

    private boolean jj_3R_78() {
        Token xsp;
        if (this.jj_3R_84()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_84());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_99() {
        return this.jj_3R_94();
    }

    private boolean jj_3R_98() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_99()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_100()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_101()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_102()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_63() {
        return this.jj_3R_72();
    }

    private boolean jj_3R_82() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(15)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(18)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_66() {
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_96() {
        Token xsp;
        if (this.jj_scan_token(19)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(1));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(58);
    }

    private boolean jj_3R_76() {
        if (this.jj_scan_token(1)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_82()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_86() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_75() {
        Token xsp;
        if (this.jj_scan_token(18)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(1));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_77() {
        Token xsp;
        if (this.jj_3R_83()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_98());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_74() {
        Token xsp;
        if (this.jj_scan_token(15)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(1));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_94() {
        return this.jj_scan_token(21);
    }

    private boolean jj_3R_79() {
        Token xsp;
        if (this.jj_3R_85()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_86());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_62() {
        return this.jj_3R_71();
    }

    private boolean jj_3R_67() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_74()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_75()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_76()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_68() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_77()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_78()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_83() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(58)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(13)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_103() {
        return this.jj_scan_token(57);
    }

    private boolean jj_3R_61() {
        return this.jj_3R_70();
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(58)) {
            return true;
        }
        return this.jj_3R_66();
    }

    private boolean jj_3R_81() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_3()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_88()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_89()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_89() {
        return this.jj_3R_66();
    }

    private boolean jj_3R_88() {
        return this.jj_scan_token(58);
    }

    private boolean jj_3R_69() {
        if (this.jj_3R_79()) {
            return true;
        }
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_97() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(58)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_103()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_80() {
        return this.jj_3R_87();
    }

    private boolean jj_3R_71() {
        Token xsp;
        if (this.jj_scan_token(31)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(1));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_81()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_65() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(1)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(26)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(27)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_60() {
        return this.jj_3R_69();
    }

    private boolean jj_3_2() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_60()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_61()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_62()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_63()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_64()) {
                            return true;
                        }
                    }
                }
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_65());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_1() {
        return this.jj_3R_59();
    }

    private boolean jj_3R_59() {
        Token xsp;
        if (this.jj_scan_token(30)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(1));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_scan_token(22)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(25)) {
                return true;
            }
        }
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0xC000002, 0xC000002, 0xC000002, 0xC000002, -2144848896, 0xC000002, 0xC000002, -1071107072, -1071107072, 0xC000002, 0xC000002, -1071107072, 2, 2, 2, 0x2400000, 2, 0, 2, 0x2400000, 2, 0, 2, 2, -2144848896, 512, 2, -2144848896, 2, -2144848896, -2144848896, 2, 2, 2, 2, 2, 4096, 4096, 2, 0, 2048, 2, 0, 2, 2, 0, 2048, 2, 0, 2, 2, 16896, 2, 2, 294912, 2, 294912, 294914, 98304, 2, 2, 512, 2, 2, 2626560, 2626560, 2626560, 2626560, 2634752, 8192, 2, 2, 0x30020000, 2, 0x400000, 2, 0x30020000, 2, 2, 0, 0, 2048, 2, 0, 2, 0, 2, 39961088, 16896, 98304, 0, 0x2600000, 2, 2, 2};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{4, 0, 0, 0, 0, 0x400000B, 0, 0, 0x400000B, 0x400000B, 0, 0, 0x400000F, 0, 0, 0, 0, 0, 0x4000000, 0, 0, 0, 0x4000000, 0, 0, 0x4000008, 0, 0, 0x4000008, 0, 0x4000008, 0x4000008, 0, 0, 0, 0, 0, 0x4000000, 0x4000000, 0, 0x4000000, 0, 0, 0x4000000, 0, 0, 0x4000000, 0, 0, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0x4000000, 0, 0, 0, 0, 0x4000000, 0, 0, 0, 0, 0x6000000, 0x4000000, 0, 0, 0x4000000, 0, 16, 0, 671088608, 0, 0, 48234432, 671088608, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public CSS2Parser(InputStream stream) {
        this(stream, null);
    }

    public CSS2Parser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new CSS2ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 96; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 96; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public CSS2Parser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new CSS2ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 96; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 96; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public CSS2Parser(CSS2ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 96; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CSS2ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 96; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[80];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 96; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 80; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 4; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        CSS2Parser.jj_la1_init_0();
        CSS2Parser.jj_la1_init_1();
        CSS2Parser.jj_la1_init_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

