/*
 * Decompiled with CFR 0.152.
 */
package sidekick.css;

import errorlist.DefaultErrorSource;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import sidekick.SideKickCompletion;
import sidekick.SideKickParsedData;
import sidekick.SideKickParser;
import sidekick.css.CompletionRequest;
import sidekick.enhanced.SourceAsset;

public class CssSideKickParser
extends SideKickParser {
    Pattern selRe = Pattern.compile("((^|[}{])\\s*)+(.+?)(\\s*\\{)", 32);
    Pattern commentRe = Pattern.compile("\\s*\\/\\*.*?\\*\\/\\s*|\n", 32);
    String text;

    public CssSideKickParser() {
        super("css");
    }

    public SideKickParsedData parse(Buffer buffer, DefaultErrorSource errorSource) {
        SideKickParsedData data = new SideKickParsedData(buffer.getName());
        this.text = buffer.getText(0, buffer.getLength() - 1);
        Matcher selMatcher = this.selRe.matcher(this.text);
        while (selMatcher.find()) {
            int startPos = selMatcher.start() + selMatcher.group(1).length() + selMatcher.group(3).length();
            Matcher commentMatcher = this.commentRe.matcher(selMatcher.group(3));
            String[] tlc = commentMatcher.replaceAll(" ").trim().split("\\s*;\\s*");
            for (int i = 0; i < tlc.length; ++i) {
                SourceAsset asset;
                int endPos = selMatcher.end() + buffer.getText(selMatcher.end(), buffer.getLength() - 1 - selMatcher.end()).indexOf("}");
                if (endPos == -1) {
                    endPos = buffer.getLength() - 1;
                }
                SourceAsset iasset = asset = new SourceAsset(tlc[i], this.getLineNo(startPos), buffer.createPosition(startPos));
                iasset.setStart(buffer.createPosition(startPos));
                iasset.setEnd(buffer.createPosition(endPos));
                data.root.add(new DefaultMutableTreeNode(iasset));
            }
        }
        return data;
    }

    public int getLineNo(int start) {
        return this.text.substring(0, start).split("\n").length;
    }

    public boolean supportsCompletion() {
        return true;
    }

    public boolean canCompleteAnywhere() {
        return true;
    }

    public SideKickCompletion complete(EditPane editPane, int caret) {
        CompletionRequest cr = new CompletionRequest(editPane, caret);
        return cr.getSideKickCompletion();
    }
}

